/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.param;

import com.google.common.base.Preconditions;
import javax.swing.JComponent;
import org.dom4j.Element;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.AbstractParameterEditor;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.sha.earthquake.param.BackgroundRupParam;
import org.opensha.sha.earthquake.param.BackgroundRupType;
import org.opensha.sha.earthquake.param.GridCellSupersamplingParam;
import org.opensha.sha.earthquake.param.PointSourceDistanceCorrectionParam;
import org.opensha.sha.earthquake.util.GridCellSupersamplingSettings;
import org.opensha.sha.earthquake.util.GriddedSeismicitySettings;
import org.opensha.sha.faultSurface.utils.PointSourceDistanceCorrections;

public class GriddedSeismicitySettingsParam
extends AbstractParameter<GriddedSeismicitySettings>
implements ParameterChangeListener {
    public static final String NAME = "Gridded Seismicity Settings";
    private BackgroundRupParam surfTypeParam;
    private Editor editor;

    public GriddedSeismicitySettingsParam(GriddedSeismicitySettings value) {
        this(value, null);
    }

    public GriddedSeismicitySettingsParam(GriddedSeismicitySettings value, BackgroundRupParam surfTypeParam) {
        super(NAME, null, null, value);
        Preconditions.checkNotNull((Object)value, (Object)"Passed in settings value cannot be null");
        this.surfTypeParam = surfTypeParam;
        if (surfTypeParam != null && value != null) {
            Preconditions.checkState((surfTypeParam.getValue() == value.surfaceType ? 1 : 0) != 0, (String)"Passed in surface type param (%s) does not match the settings value (%s)", surfTypeParam.getValue(), (Object)((Object)value.surfaceType));
        }
        if (surfTypeParam != null) {
            surfTypeParam.addParameterChangeListener(this);
            this.addParameterChangeListener(this);
        }
    }

    @Override
    public ParameterEditor getEditor() {
        if (this.editor == null) {
            this.editor = new Editor(this);
        }
        return this.editor;
    }

    @Override
    public boolean isEditorBuilt() {
        return this.editor != null;
    }

    @Override
    public Object clone() {
        return new GriddedSeismicitySettingsParam((GriddedSeismicitySettings)this.value, this.surfTypeParam);
    }

    @Override
    protected boolean setIndividualParamValueFromXML(Element el) {
        return false;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameter() == this.surfTypeParam) {
            BackgroundRupType newSurfType = (BackgroundRupType)((Object)this.surfTypeParam.getValue());
            if (((GriddedSeismicitySettings)this.value).surfaceType != newSurfType) {
                this.setValue(((GriddedSeismicitySettings)this.value).forSurfaceType(newSurfType));
            }
        } else if (event.getParameter() == this) {
            GriddedSeismicitySettings value = (GriddedSeismicitySettings)this.getValue();
            if (value.surfaceType != this.surfTypeParam.getValue()) {
                this.surfTypeParam.setValue(value.surfaceType);
            }
        }
    }

    private static class Editor
    extends AbstractParameterEditor<GriddedSeismicitySettings>
    implements ParameterChangeListener {
        private ParameterList paramList;
        private ParameterListEditor paramEdit;
        private BackgroundRupParam surfTypeParam;
        private DoubleParameter minMagParam;
        private DoubleParameter pointSourceCutoffMagParam;
        private PointSourceDistanceCorrectionParam distCorrParam;
        private GridCellSupersamplingParam supersamplingParam;
        private boolean updating = false;

        public Editor(GriddedSeismicitySettingsParam param) {
            super(param);
        }

        @Override
        public boolean isParameterSupported(Parameter<GriddedSeismicitySettings> param) {
            return param != null && param.getValue() != null;
        }

        @Override
        public void setEnabled(boolean enabled) {
            if (this.paramEdit != null) {
                this.paramEdit.setEnabled(enabled);
            }
        }

        @Override
        protected JComponent buildWidget() {
            this.paramList = new ParameterList();
            Parameter param = this.getParameter();
            GriddedSeismicitySettings settings = (GriddedSeismicitySettings)param.getValue();
            if (param instanceof GriddedSeismicitySettingsParam && ((GriddedSeismicitySettingsParam)param).surfTypeParam != null) {
                this.surfTypeParam = ((GriddedSeismicitySettingsParam)param).surfTypeParam;
                Preconditions.checkState((this.surfTypeParam.getValue() == settings.surfaceType ? 1 : 0) != 0);
            } else {
                this.surfTypeParam = new BackgroundRupParam();
                this.paramList.addParameter(this.surfTypeParam);
            }
            this.surfTypeParam.addParameterChangeListener(this);
            this.minMagParam = new DoubleParameter("Minimum Gridded Magnitude", 0.0, 10.0);
            this.minMagParam.getConstraint().setNullAllowed(false);
            this.minMagParam.setInfo("Minimum magnitude for gridded seismicity; all ruptures below this magnitude will be skipped entirely.");
            this.minMagParam.addParameterChangeListener(this);
            this.paramList.addParameter(this.minMagParam);
            this.pointSourceCutoffMagParam = new DoubleParameter("Minimum Finite Magnitude", 0.0, 10.0);
            this.minMagParam.getConstraint().setNullAllowed(false);
            this.pointSourceCutoffMagParam.setInfo("Minimum magnitude for finite ruptures; all ruptures below this magnitude will be treated as point sources regardless of the surface type setting.");
            this.pointSourceCutoffMagParam.addParameterChangeListener(this);
            this.paramList.addParameter(this.pointSourceCutoffMagParam);
            this.distCorrParam = new PointSourceDistanceCorrectionParam();
            this.distCorrParam.addParameterChangeListener(this);
            this.paramList.addParameter(this.distCorrParam);
            this.supersamplingParam = new GridCellSupersamplingParam();
            this.supersamplingParam.addParameterChangeListener(this);
            this.paramList.addParameter(this.supersamplingParam);
            this.paramEdit = new ParameterListEditor(this.paramList);
            return this.updateWidget();
        }

        @Override
        protected synchronized JComponent updateWidget() {
            GriddedSeismicitySettings value = (GriddedSeismicitySettings)this.getValue();
            this.updating = true;
            this.surfTypeParam.setValue(value.surfaceType);
            this.minMagParam.setValue(value.minimumMagnitude);
            this.pointSourceCutoffMagParam.setValue(value.pointSourceMagnitudeCutoff);
            PointSourceDistanceCorrections corrType = PointSourceDistanceCorrections.forCorrections(value.distanceCorrections);
            Preconditions.checkNotNull((Object)corrType, (Object)"Passed in corrections are not of a standard type; editor not supported.");
            this.distCorrParam.setValue(corrType);
            this.supersamplingParam.setValue(value.supersamplingSettings);
            this.updating = false;
            this.paramEdit.refreshParamEditor();
            return this.paramEdit.getContents();
        }

        @Override
        public synchronized void parameterChange(ParameterChangeEvent event) {
            if (this.updating) {
                return;
            }
            Parameter source = event.getParameter();
            Parameter<GriddedSeismicitySettings> param = this.getParameter();
            GriddedSeismicitySettings value = (GriddedSeismicitySettings)this.getValue();
            if (source == this.surfTypeParam) {
                param.setValue(value.forSurfaceType((BackgroundRupType)((Object)this.surfTypeParam.getValue())));
            } else if (source == this.minMagParam) {
                param.setValue(value.forMinimumMagnitude((Double)this.minMagParam.getValue()));
            } else if (source == this.pointSourceCutoffMagParam) {
                param.setValue(value.forPointSourceMagCutoff((Double)this.pointSourceCutoffMagParam.getValue()));
            } else if (source == this.distCorrParam) {
                param.setValue(value.forDistanceCorrections((PointSourceDistanceCorrections)this.distCorrParam.getValue()));
            } else if (source == this.supersamplingParam) {
                param.setValue(value.forSupersamplingSettings((GridCellSupersamplingSettings)this.supersamplingParam.getValue()));
            }
        }
    }
}

