/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl;

import java.util.ArrayList;
import java.util.ListIterator;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurfaceWithSubsets;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class FaultRuptureSource
extends ProbEqkSource {
    private static String C = new String("FaultRuptureSource");
    private boolean D = false;
    protected String NAME = "Fault Rupture Source";
    protected double duration;
    private ArrayList<ProbEqkRupture> ruptureList;

    public FaultRuptureSource(double magnitude, RuptureSurface ruptureSurface, double rake, double probability) {
        this(magnitude, ruptureSurface, rake, probability, false);
    }

    public FaultRuptureSource(double magnitude, RuptureSurface ruptureSurface, double rake, double probability, boolean isPoisson) {
        this.isPoissonian = isPoisson;
        if (this.D) {
            System.out.println("mag: " + magnitude);
            System.out.println("rake: " + rake);
            System.out.println("probability: " + probability);
        }
        this.ruptureList = new ArrayList();
        ProbEqkRupture probEqkRupture = new ProbEqkRupture();
        probEqkRupture.setAveRake(rake);
        probEqkRupture.setRuptureSurface(ruptureSurface);
        probEqkRupture.setMag(magnitude);
        probEqkRupture.setProbability(probability);
        this.ruptureList.add(probEqkRupture);
    }

    @Override
    public RuptureSurface getSourceSurface() {
        return this.ruptureList.get(0).getRuptureSurface();
    }

    @Override
    public LocationList getAllSourceLocs() {
        LocationList locList = new LocationList();
        ListIterator it = ((AbstractEvenlyGriddedSurfaceWithSubsets)this.getSourceSurface()).getAllByRowsIterator();
        while (it.hasNext()) {
            locList.add((Location)it.next());
        }
        return locList;
    }

    public FaultRuptureSource(DiscretizedFunc magDist, RuptureSurface ruptureSurface, double rake, double duration) {
        this(magDist, ruptureSurface, rake, duration, true);
    }

    public FaultRuptureSource(DiscretizedFunc magDist, RuptureSurface ruptureSurface, double rake, double duration, boolean isPoisson) {
        this.isPoissonian = isPoisson;
        this.duration = duration;
        if (this.D) {
            System.out.println("rake: " + rake);
            System.out.println("duration: " + duration);
        }
        this.ruptureList = new ArrayList();
        for (int i = 0; i < magDist.size(); ++i) {
            double mag = magDist.getX(i);
            if (!(magDist.getY(i) > 0.0)) continue;
            double prob = this.isPoissonian ? 1.0 - Math.exp(-duration * magDist.getY(i)) : Math.min(1.0, magDist.getY(i) * duration);
            ProbEqkRupture probEqkRupture = new ProbEqkRupture();
            probEqkRupture.setAveRake(rake);
            probEqkRupture.setRuptureSurface(ruptureSurface);
            probEqkRupture.setMag(mag);
            probEqkRupture.setProbability(prob);
            this.ruptureList.add(probEqkRupture);
        }
    }

    public FaultRuptureSource(double prob, IncrementalMagFreqDist magDist, RuptureSurface ruptureSurface, double rake) {
        int i;
        this.isPoissonian = false;
        this.ruptureList = new ArrayList();
        double totRate = 0.0;
        for (i = 0; i < magDist.size(); ++i) {
            totRate += magDist.getY(i);
        }
        for (i = 0; i < magDist.size(); ++i) {
            double d;
            double mag = magDist.getX(i);
            double qkRate = magDist.getY(i);
            if (!(d > 0.0)) continue;
            double qkProb = qkRate * prob / totRate;
            ProbEqkRupture probEqkRupture = new ProbEqkRupture();
            probEqkRupture.setAveRake(rake);
            probEqkRupture.setRuptureSurface(ruptureSurface);
            probEqkRupture.setMag(mag);
            probEqkRupture.setProbability(qkProb);
            this.ruptureList.add(probEqkRupture);
        }
        if (this.D) {
            double totProb = 0.0;
            for (int i2 = 0; i2 < this.ruptureList.size(); ++i2) {
                totProb += this.getRupture(i2).getProbability();
            }
            System.out.println("input prob=" + prob + ", final tot prob=" + totProb + ", ratio=" + prob / totProb);
        }
    }

    public void setDuration(double newDuration) {
        if (!this.isPoissonian) {
            throw new RuntimeException(C + " Error - the setDuration method can only be used for the Poisson case");
        }
        for (int i = 0; i < this.ruptureList.size(); ++i) {
            ProbEqkRupture eqkRup = this.ruptureList.get(i);
            double oldProb = eqkRup.getProbability();
            double newProb = 1.0 - Math.pow(1.0 - oldProb, newDuration / this.duration);
            eqkRup.setProbability(newProb);
        }
        this.duration = newDuration;
    }

    @Override
    public int getNumRuptures() {
        return this.ruptureList.size();
    }

    @Override
    public ProbEqkRupture getRupture(int nthRupture) {
        return this.ruptureList.get(nthRupture);
    }

    @Override
    public double getMinDistance(Site site) {
        return this.getSourceSurface().getQuickDistance(site.getLocation());
    }

    public void setName(String name) {
        this.NAME = name;
    }

    @Override
    public String getName() {
        return this.NAME;
    }

    public void scaleRupRates(double value) {
        for (ProbEqkRupture rup : this.ruptureList) {
            double newMinusRT = value * Math.log(1.0 - rup.getProbability());
            rup.setProbability(1.0 - Math.exp(newMinusRT));
        }
    }

    public void scaleRupProbs(double value) {
        for (ProbEqkRupture rup : this.ruptureList) {
            double newRupProb = value * rup.getProbability();
            if (newRupProb <= 1.0) {
                rup.setProbability(newRupProb);
                continue;
            }
            throw new RuntimeException("Problem: value causes probability to exceed 1.0");
        }
    }
}

