/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.Frankel96;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.exceptions.FaultException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.earthquake.PointSource;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.Frankel96.Frankel96_CharEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.Frankel96.Frankel96_GR_EqkSource;
import org.opensha.sha.faultSurface.EvenlyGriddedSurfFromSimpleFaultData;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.FrankelGriddedSurface;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;

public class Frankel96_EqkRupForecast
extends AbstractERF {
    private static String C = new String("Frankel96_EqkRupForecast");
    private boolean D = false;
    public static String NAME = new String("USGS/CGS 1996 Cal. ERF");
    private double GRID_SPACING = 1.0;
    private double B_VALUE = 0.9;
    private double MAG_LOWER = 6.5;
    private double DELTA_MAG = 0.1;
    private String FAULT_CLASS_A = "A";
    private String FAULT_CLASS_B = "B";
    private String FAULTING_STYLE_SS = "SS";
    private String FAULTING_STYLE_R = "R";
    private String FAULTING_STYLE_N = "N";
    protected static final FaultException ERR = new FaultException(C + ": loadFaultTraces(): Missing metadata from trace, file bad format.");
    private static final String INPUT_FAULT_FILE_NAME = "/data/erf/frankel_1996/Frankel96_CAL_all.txt";
    private static final String INPUT_BACK_SEIS_FILE_NAME = "/data/erf/frankel_1996/CAagrid.asc";
    private ArrayList FrankelA_CharEqkSources;
    private ArrayList FrankelB_CharEqkSources;
    private ArrayList FrankelB_GR_EqkSources;
    private ArrayList FrankelBackgrSeisSources;
    private ArrayList allSources;
    private ArrayList inputFaultFileLines = null;
    private ArrayList inputBackSeisFileLines = null;
    public static final String FAULT_MODEL_NAME = new String("Fault Model");
    public static final String FAULT_MODEL_FRANKEL = new String("Frankel's");
    public static final String FAULT_MODEL_STIRLING = new String("Stirling's");
    ArrayList faultModelNamesStrings = new ArrayList();
    StringParameter faultModelParam;
    public static final String BACK_SEIS_NAME = new String("Background Seismicity");
    public static final String BACK_SEIS_INCLUDE = new String("Include");
    public static final String BACK_SEIS_EXCLUDE = new String("Exclude");
    public static final String BACK_SEIS_ONLY = new String("Only Background");
    ArrayList backSeisOptionsStrings = new ArrayList();
    StringParameter backSeisParam;
    private static final String FRAC_GR_PARAM_NAME = "GR Fraction on B Faults";
    private Double DEFAULT_FRAC_GR_VAL = 0.5;
    private static final String FRAC_GR_PARAM_UNITS = null;
    private static final String FRAC_GR_PARAM_INFO = "Fraction of moment-rate put into GR dist on class-B faults";
    private static final double FRAC_GR_PARAM_MIN = 0.0;
    private static final double FRAC_GR_PARAM_MAX = 1.0;
    DoubleParameter fracGR_Param;
    private static final String RUP_OFFSET_PARAM_NAME = "Rupture Offset";
    private Double DEFAULT_RUP_OFFSET_VAL = 10.0;
    private static final String RUP_OFFSET_PARAM_UNITS = "km";
    private static final String RUP_OFFSET_PARAM_INFO = "Length of offset for floating ruptures";
    private static final double RUP_OFFSET_PARAM_MIN = 1.0;
    private static final double RUP_OFFSET_PARAM_MAX = 100.0;
    DoubleParameter rupOffset_Param;

    public Frankel96_EqkRupForecast() {
        this.timeSpan = new TimeSpan("None", "Years");
        this.timeSpan.addParameterChangeListener(this);
        this.initAdjParams();
        this.faultModelParam.addParameterChangeListener(this);
        this.fracGR_Param.addParameterChangeListener(this);
        this.rupOffset_Param.addParameterChangeListener(this);
        this.backSeisParam.addParameterChangeListener(this);
        try {
            this.inputFaultFileLines = FileUtils.loadJarFile(INPUT_FAULT_FILE_NAME);
        }
        catch (FileNotFoundException e) {
            System.out.println(e.toString());
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
        try {
            this.inputBackSeisFileLines = FileUtils.loadJarFile(INPUT_BACK_SEIS_FILE_NAME);
        }
        catch (FileNotFoundException e) {
            System.out.println(e.toString());
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
        if (this.inputFaultFileLines == null) {
            throw new FaultException(C + "No data loaded from /data/erf/frankel_1996/Frankel96_CAL_all.txt. File may be empty or doesn't exist.");
        }
        if (this.inputBackSeisFileLines == null) {
            throw new FaultException(C + "No data loaded from /data/erf/frankel_1996/CAagrid.asc. File may be empty or doesn't exist.");
        }
    }

    private void initAdjParams() {
        this.faultModelNamesStrings.add(FAULT_MODEL_FRANKEL);
        this.faultModelNamesStrings.add(FAULT_MODEL_STIRLING);
        this.faultModelParam = new StringParameter(FAULT_MODEL_NAME, this.faultModelNamesStrings, (String)this.faultModelNamesStrings.get(0));
        this.backSeisOptionsStrings.add(BACK_SEIS_EXCLUDE);
        this.backSeisOptionsStrings.add(BACK_SEIS_INCLUDE);
        this.backSeisOptionsStrings.add(BACK_SEIS_ONLY);
        this.backSeisParam = new StringParameter(BACK_SEIS_NAME, this.backSeisOptionsStrings, BACK_SEIS_INCLUDE);
        this.fracGR_Param = new DoubleParameter(FRAC_GR_PARAM_NAME, 0.0, 1.0, FRAC_GR_PARAM_UNITS, this.DEFAULT_FRAC_GR_VAL);
        this.fracGR_Param.setInfo(FRAC_GR_PARAM_INFO);
        this.rupOffset_Param = new DoubleParameter(RUP_OFFSET_PARAM_NAME, 1.0, 100.0, RUP_OFFSET_PARAM_UNITS, this.DEFAULT_RUP_OFFSET_VAL);
        this.rupOffset_Param.setInfo(RUP_OFFSET_PARAM_INFO);
    }

    private void makeFaultSources() throws FaultException {
        this.FrankelA_CharEqkSources = new ArrayList();
        this.FrankelB_CharEqkSources = new ArrayList();
        this.FrankelB_GR_EqkSources = new ArrayList();
        String S = C + ": makeSoureces(): ";
        if (this.D) {
            System.out.println(S + "Starting");
        }
        String faultClass = "";
        String faultName = "";
        double rake = 0.0;
        double mag = 0.0;
        double charRate = 0.0;
        double dip = 0.0;
        double downDipWidth = 0.0;
        double depthToTop = 0.0;
        double fracGR = (Double)this.fracGR_Param.getValue();
        String faultModel = (String)this.faultModelParam.getValue();
        double rupOffset = (Double)this.rupOffset_Param.getValue();
        double timeDuration = this.timeSpan.getDuration();
        ListIterator it = this.inputFaultFileLines.listIterator();
        while (it.hasNext()) {
            StringTokenizer st = new StringTokenizer(it.next().toString());
            faultClass = new String(st.nextToken());
            String faultingStyle = new String(st.nextToken());
            if (faultingStyle.equalsIgnoreCase(this.FAULTING_STYLE_SS)) {
                rake = 0.0;
            }
            if (faultingStyle.equalsIgnoreCase(this.FAULTING_STYLE_R)) {
                rake = 90.0;
            }
            if (faultingStyle.equalsIgnoreCase(this.FAULTING_STYLE_N)) {
                rake = -90.0;
            }
            faultName = new String(st.nextToken());
            if (this.D) {
                System.out.println(C + ":FaultName::" + faultName);
            }
            st = new StringTokenizer(it.next().toString());
            mag = Double.parseDouble(st.nextToken());
            charRate = Double.parseDouble(st.nextToken());
            st = new StringTokenizer(it.next().toString());
            dip = Double.parseDouble(st.nextToken());
            downDipWidth = Double.parseDouble(st.nextToken());
            double upperSeismoDepth = depthToTop = Double.parseDouble(st.nextToken());
            double lowerSeismoDepth = depthToTop + downDipWidth * Math.sin(Math.toRadians(Math.abs(dip)));
            int numOfDataLines = Integer.parseInt(it.next().toString().trim());
            FaultTrace faultTrace = new FaultTrace(faultName);
            for (int i = 0; i < numOfDataLines; ++i) {
                double lon;
                double lat;
                if (!it.hasNext()) {
                    throw ERR;
                }
                st = new StringTokenizer(it.next().toString().trim());
                try {
                    lat = Double.valueOf(st.nextToken());
                }
                catch (NumberFormatException e) {
                    throw ERR;
                }
                try {
                    lon = Double.valueOf(st.nextToken());
                }
                catch (NumberFormatException e) {
                    throw ERR;
                }
                Location loc = new Location(lat, lon, upperSeismoDepth);
                faultTrace.add(loc.clone());
            }
            if (dip < 0.0) {
                faultTrace.reverse();
                dip *= -1.0;
            }
            if (this.D) {
                System.out.println(C + ":faultTrace::" + faultTrace.toString());
            }
            EvenlyGriddedSurfFromSimpleFaultData surface = faultModel.equals(FAULT_MODEL_FRANKEL) ? new FrankelGriddedSurface(faultTrace, dip, upperSeismoDepth, lowerSeismoDepth, this.GRID_SPACING) : new StirlingGriddedSurface(faultTrace, dip, upperSeismoDepth, lowerSeismoDepth, this.GRID_SPACING);
            if (faultClass.equalsIgnoreCase(this.FAULT_CLASS_B) && mag > 6.5) {
                double rate = (1.0 - fracGR) * charRate;
                double moRate = fracGR * charRate * MagUtils.magToMoment(mag);
                if (moRate > 0.0) {
                    Frankel96_GR_EqkSource frankel96_GR_src = new Frankel96_GR_EqkSource(rake, this.B_VALUE, this.MAG_LOWER, mag, moRate, this.DELTA_MAG, rupOffset, surface, faultName);
                    frankel96_GR_src.setTimeSpan(timeDuration);
                    this.FrankelB_GR_EqkSources.add(frankel96_GR_src);
                }
                if (!(rate > 0.0)) continue;
                Frankel96_CharEqkSource frankel96_Char_src = new Frankel96_CharEqkSource(rake, mag, rate, surface, faultName);
                frankel96_Char_src.setTimeSpan(timeDuration);
                this.FrankelB_CharEqkSources.add(frankel96_Char_src);
                continue;
            }
            if (faultClass.equalsIgnoreCase(this.FAULT_CLASS_B)) {
                Frankel96_CharEqkSource frankel96_Char_src = new Frankel96_CharEqkSource(rake, mag, charRate, surface, faultName);
                frankel96_Char_src.setTimeSpan(timeDuration);
                this.FrankelB_CharEqkSources.add(frankel96_Char_src);
                continue;
            }
            if (faultClass.equalsIgnoreCase(this.FAULT_CLASS_A)) {
                Frankel96_CharEqkSource frankel96_Char_src = new Frankel96_CharEqkSource(rake, mag, charRate, surface, faultName);
                frankel96_Char_src.setTimeSpan(timeDuration);
                this.FrankelA_CharEqkSources.add(frankel96_Char_src);
                continue;
            }
            throw new FaultException(C + " Error - Bad fault Class :" + faultClass);
        }
    }

    private void makeBackSeisSources() {
        String S = C + ": makeBackSeisSources(): ";
        if (this.D) {
            System.out.println(S + "Starting");
        }
        this.FrankelBackgrSeisSources = new ArrayList();
        double aveRake = 0.0;
        double aveDip = 90.0;
        double tempMoRate = 1.0;
        double bValue = this.B_VALUE;
        double magUpper = 7.0;
        double magDelta = 0.2;
        double magLower1 = 0.0;
        int numMag1 = 36;
        double magLower2 = 5.0;
        int numMag2 = 11;
        GutenbergRichterMagFreqDist grDist1 = new GutenbergRichterMagFreqDist(magLower1, numMag1, magDelta, tempMoRate, bValue);
        double timeDuration = this.timeSpan.getDuration();
        ListIterator it = this.inputBackSeisFileLines.listIterator();
        StringTokenizer st = new StringTokenizer(it.next().toString());
        st = new StringTokenizer(it.next().toString());
        st = new StringTokenizer(it.next().toString());
        st = new StringTokenizer(it.next().toString());
        st = new StringTokenizer(it.next().toString());
        while (it.hasNext()) {
            st = new StringTokenizer(it.next().toString());
            double lon = Double.parseDouble(st.nextToken());
            double lat = Double.parseDouble(st.nextToken());
            double rate = Double.parseDouble(st.nextToken());
            if (!(rate > 0.0)) continue;
            grDist1.scaleToIncrRate(0, rate);
            double rateAtMag5 = grDist1.getIncrRate(25);
            GutenbergRichterMagFreqDist grDist2 = new GutenbergRichterMagFreqDist(magLower2, numMag2, magDelta, tempMoRate, bValue);
            grDist2.scaleToIncrRate(0, rateAtMag5);
            PointSource.PoissonPointSource pointPoissonSource = ((PointSource.PoissonBuilder)PointSource.poissonBuilder(new Location(lat, lon)).truePointSources(0.0)).forMFDAndFocalMech(grDist2, new FocalMechanism(Double.NaN, aveDip, aveRake)).duration(timeDuration).build();
            this.FrankelBackgrSeisSources.add(pointPoissonSource);
        }
    }

    @Override
    public ProbEqkSource getSource(int iSource) {
        return (ProbEqkSource)this.allSources.get(iSource);
    }

    @Override
    public int getNumSources() {
        return this.allSources.size();
    }

    public ArrayList getSourceList() {
        return this.allSources;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void updateForecast() {
        if (this.parameterChangeFlag) {
            String backSeis = (String)this.backSeisParam.getValue();
            this.allSources = new ArrayList();
            if (backSeis.equalsIgnoreCase(BACK_SEIS_INCLUDE)) {
                this.makeFaultSources();
                this.makeBackSeisSources();
                this.allSources.addAll(this.FrankelA_CharEqkSources);
                this.allSources.addAll(this.FrankelB_CharEqkSources);
                this.allSources.addAll(this.FrankelB_GR_EqkSources);
                this.allSources.addAll(this.FrankelBackgrSeisSources);
            } else if (backSeis.equalsIgnoreCase(BACK_SEIS_EXCLUDE)) {
                this.makeFaultSources();
                this.allSources.addAll(this.FrankelA_CharEqkSources);
                this.allSources.addAll(this.FrankelB_CharEqkSources);
                this.allSources.addAll(this.FrankelB_GR_EqkSources);
            } else {
                this.makeBackSeisSources();
                this.allSources.addAll(this.FrankelBackgrSeisSources);
            }
            this.parameterChangeFlag = false;
        }
    }

    public static void main(String[] args) {
        Frankel96_EqkRupForecast frankCast = new Frankel96_EqkRupForecast();
        frankCast.updateForecast();
        System.out.println("num sources=" + frankCast.getNumSources());
        System.out.println("\n" + frankCast.getSource(0).getName() + ":\n");
        for (int i = 0; i < frankCast.getSource(0).getNumRuptures(); ++i) {
            System.out.println("  rupture #" + i + ": \n\n" + frankCast.getSource(0).getRupture(i).getInfo());
        }
    }
}

