/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.Frankel96;

import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WC1994_MagLengthRelationship;
import org.opensha.commons.data.Site;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurfaceWithSubsets;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;

public class Frankel96_GR_EqkSource
extends ProbEqkSource {
    private static String C = "Frankel96_GR_EqkSource";
    private boolean D = false;
    private GutenbergRichterMagFreqDist gR;
    private double rake;
    private double timeSpan;
    private static final double RUPTURE_WIDTH = 100.0;
    private double rupOffset;
    private int totNumRups;
    private AbstractEvenlyGriddedSurfaceWithSubsets surface;

    public Frankel96_GR_EqkSource(double rake, double bValue, double magLower, double magUpper, double moRate, double delta, double rupOffset, AbstractEvenlyGriddedSurfaceWithSubsets surface, String faultName) {
        this.name = faultName + " GR";
        this.rake = rake;
        this.surface = surface;
        this.rupOffset = rupOffset;
        int num = (int)Math.rint((magUpper - magLower) / delta + 1.0);
        if (this.D) {
            System.out.println("Frankel96_GR_EqkSource:magUpper::" + magUpper);
        }
        if (this.D) {
            System.out.println("Frankel96_GR_EqkSource:magLower::" + magLower);
        }
        if (this.D) {
            System.out.println("Frankel96_GR_EqkSource:delta::" + delta);
        }
        if (this.D) {
            System.out.println("Frankel96_GR_EqkSource:num::" + num);
        }
        this.gR = new GutenbergRichterMagFreqDist(magLower, magUpper, num);
        this.gR.setAllButTotCumRate(magLower, magUpper, moRate, bValue);
        int numMags = this.gR.size();
        this.totNumRups = 0;
        WC1994_MagLengthRelationship magLength = new WC1994_MagLengthRelationship();
        for (int i = 0; i < num; ++i) {
            double rupLen = magLength.getMedianLength(this.gR.getX(i), rake);
            this.totNumRups += this.getNumRuptures(rupLen);
        }
        if (this.D) {
            System.out.println("Frankel96_GR_EqkSource:Frankel96_GR_EqkSource:totNumRups::" + this.totNumRups);
        }
        if (this.D) {
            System.out.println("Frankel96_GR_EqkSource:Frankel96_GR_EqkSource:momentRate::" + this.gR.getTotalMomentRate());
        }
    }

    @Override
    public int getNumRuptures() {
        return this.totNumRups;
    }

    @Override
    public LocationList getAllSourceLocs() {
        return this.surface.getEvenlyDiscritizedListOfLocsOnSurface();
    }

    @Override
    public AbstractEvenlyGriddedSurface getSourceSurface() {
        return this.surface;
    }

    @Override
    public ProbEqkRupture getRupture(int nthRupture) {
        int numMags = this.gR.size();
        double mag = 0.0;
        double rupLen = 0.0;
        int numRups = 0;
        int tempNumRups = 0;
        if (nthRupture < 0 || nthRupture >= this.getNumRuptures()) {
            throw new RuntimeException("Invalid rupture index. This index does not exist");
        }
        WC1994_MagLengthRelationship magLength = new WC1994_MagLengthRelationship();
        for (int i = 0; i < numMags; ++i) {
            mag = this.gR.getX(i);
            rupLen = magLength.getMedianLength(this.gR.getX(i), this.rake);
            numRups = this.getNumRuptures(rupLen);
            if (nthRupture < (tempNumRups += numRups)) break;
        }
        ProbEqkRupture probEqkRupture = new ProbEqkRupture();
        probEqkRupture.setAveRake(this.rake);
        probEqkRupture.setMag(mag);
        double rate = this.gR.getY(mag);
        double prob = 1.0 - Math.exp(-this.timeSpan * rate / (double)numRups);
        probEqkRupture.setProbability(prob);
        probEqkRupture.setRuptureSurface(this.surface.getNthSubsetSurface(rupLen, 100.0, this.rupOffset, nthRupture + numRups - tempNumRups));
        return probEqkRupture;
    }

    public void setTimeSpan(double yrs) {
        this.timeSpan = yrs;
    }

    private int getNumRuptures(double rupLen) {
        return this.surface.getNumSubsetSurfaces(rupLen, 100.0, this.rupOffset);
    }

    @Override
    public double getMinDistance(Site site) {
        LocationVector dir = LocationUtils.vector(site.getLocation(), (Location)this.surface.get(0, 0));
        double min = dir.getHorzDistance();
        if (min > (dir = LocationUtils.vector(site.getLocation(), (Location)this.surface.get(0, this.surface.getNumCols() - 1))).getHorzDistance()) {
            min = dir.getHorzDistance();
        }
        if (min > (dir = LocationUtils.vector(site.getLocation(), (Location)this.surface.get(0, this.surface.getNumCols() / 2))).getHorzDistance()) {
            min = dir.getHorzDistance();
        }
        return min;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

