/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl;

import java.io.Serializable;
import java.util.ArrayList;
import org.opensha.commons.data.Site;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurface;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class GriddedRegionPoissonEqkSource
extends ProbEqkSource
implements Serializable {
    private static String C = new String("GriddedRegionPoissonEqkSource");
    private boolean D = false;
    private IncrementalMagFreqDist magFreqDist;
    private GriddedRegion region;
    private double aveDip = Double.NaN;
    private double aveRake = Double.NaN;
    private double aveDepth = Double.NaN;
    private double duration;
    int numLocs;
    int numMags;
    private double minMag = 0.0;
    private ArrayList mags;
    private ArrayList rates;

    public GriddedRegionPoissonEqkSource(GriddedRegion region, IncrementalMagFreqDist magFreqDist, double duration, double aveRake, double aveDip, double aveDepth, double minMag) {
        this.region = region;
        this.numLocs = region.getNodeCount();
        this.duration = duration;
        this.aveRake = aveRake;
        this.aveDip = aveDip;
        this.aveDepth = aveDepth;
        this.minMag = minMag;
        this.setMagFreqDist(magFreqDist);
        if (this.D) {
            System.out.println("GriddedRegionPoissonEqkSource Constructor: numLocs=" + this.numLocs + "; numMags=" + this.numMags + "; aveDip=" + aveDip + "; aveRake=" + aveRake);
        }
    }

    public GriddedRegionPoissonEqkSource(GriddedRegion region, IncrementalMagFreqDist magFreqDist, double duration, double aveRake, double aveDip, double aveDepth) {
        this(region, magFreqDist, duration, aveRake, aveDip, aveDepth, 0.0);
    }

    @Override
    public LocationList getAllSourceLocs() {
        return this.region.getNodeList();
    }

    @Override
    public AbstractEvenlyGriddedSurface getSourceSurface() {
        throw new RuntimeException("method not supported (not sure what to return)");
    }

    public void setMagFreqDist(IncrementalMagFreqDist magFreqDist) {
        this.magFreqDist = magFreqDist;
        this.mags = new ArrayList();
        this.rates = new ArrayList();
        for (int i = 0; i < magFreqDist.size(); ++i) {
            if (!(magFreqDist.getY(i) > 0.0) || !(magFreqDist.getX(i) >= this.minMag)) continue;
            this.mags.add(magFreqDist.getX(i));
            this.rates.add(magFreqDist.getY(i) / (double)this.numLocs);
        }
        this.numMags = this.mags.size();
    }

    @Override
    public int getNumRuptures() {
        return this.numMags * this.numLocs;
    }

    @Override
    public ProbEqkRupture getRupture(int nthRupture) {
        int ithMag = nthRupture / this.numLocs;
        int ithLoc = nthRupture % this.numLocs;
        if (this.D) {
            System.out.println(nthRupture + "th rupture; " + ithMag + "th mag; " + ithLoc + "th loc");
        }
        ProbEqkRupture probEqkRupture = new ProbEqkRupture();
        probEqkRupture.setAveRake(this.aveRake);
        probEqkRupture.setMag((Double)this.mags.get(ithMag));
        Location ithL = this.region.locationForIndex(ithLoc);
        ithL = new Location(ithL.getLatitude(), ithL.getLongitude(), this.aveDepth);
        probEqkRupture.setPointSurface(ithL, this.aveDip);
        double prob = 1.0 - Math.exp(-this.duration * (Double)this.rates.get(ithMag));
        probEqkRupture.setProbability(prob);
        return probEqkRupture;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public void setMinMag(double minMag) {
        this.minMag = minMag;
        this.setMagFreqDist(this.magFreqDist);
    }

    public double getDuration() {
        return this.duration;
    }

    public GriddedRegion getRegion() {
        return this.region;
    }

    public double getMinMag() {
        return this.minMag;
    }

    @Override
    public double getMinDistance(Site site) {
        return this.region.distanceToLocation(site.getLocation());
    }

    @Override
    public String getName() {
        return C;
    }
}

