/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.PEER_TestCases;

import java.util.ArrayList;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.PEER_testsMagAreaRelationship;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.geo.GeoTools;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.earthquake.PointSource;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.FloatingPoissonFaultSource;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.FrankelGriddedSurface;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.YC_1985_CharMagFreqDist;

public class PEER_MultiSourceForecast
extends AbstractERF {
    private static String C = new String("PEER_MultiSourceForecast");
    private boolean D = false;
    public static final String NAME = "PEER Multi Source";
    PEER_testsMagAreaRelationship magScalingRel = new PEER_testsMagAreaRelationship();
    private double rupAspectRatio = 2.0;
    private double minMag = 5.0;
    private GutenbergRichterMagFreqDist dist_gr_A_orig;
    private IncrementalMagFreqDist dist_GR;
    private YC_1985_CharMagFreqDist dist_yc_B;
    private YC_1985_CharMagFreqDist dist_yc_C;
    private FaultTrace faultTraceB;
    private FaultTrace faultTraceC;
    private static final Location faultB_loc1 = new Location(38.6749, -121.5691, 0.0);
    private static final Location faultB_loc2 = new Location(38.6749, -122.4309, 0.0);
    private static final Location faultC_loc1 = new Location(37.3242, -121.859, 0.0);
    private static final Location faultC_loc2 = new Location(37.3242, -122.141, 0.0);
    private FloatingPoissonFaultSource fltSourceB;
    private FloatingPoissonFaultSource fltSourceC;
    private static final double DIP = 90.0;
    private static final double RAKE = 0.0;
    private static final double LAT_TOP = 38.901;
    private static final double LAT_BOTTOM = 37.099;
    private static final double LAT_CENTER = 38.0;
    private static final double LONG_LEFT = -123.138;
    private static final double LONG_RIGHT = -120.862;
    private static final double LONG_CENTER = -122.0;
    private static final double MAX_DISTANCE = 100.0;
    public static final String GRID_PARAM_NAME = "Grid Spacing of Sources";
    public static final String GRID_PARAM_UNITS = "km";
    private static final double GRID_PARAM_MIN = 0.001;
    private static final double GRID_PARAM_MAX = 100.0;
    private Double DEFAULT_GRID_VAL = 1.0;
    public static final String OFFSET_PARAM_NAME = "Offset";
    private Double DEFAULT_OFFSET_VAL = 1.0;
    public static final String OFFSET_PARAM_UNITS = "kms";
    private static final double OFFSET_PARAM_MIN = 0.01;
    private static final double OFFSET_PARAM_MAX = 10000.0;
    public static final String DEPTH_LOWER_PARAM_NAME = "Area Lower Seis Depth";
    public static final String DEPTH_UPPER_PARAM_NAME = "Area Upper Seis Depth";
    public static final String DEPTH_PARAM_UNITS = "km";
    private static final double DEPTH_PARAM_MIN = 0.0;
    private static final double DEPTH_PARAM_MAX = 30.0;
    private static final Double DEPTH_PARAM_DEFAULT = 5.0;
    private LocationList locationList;
    DoubleParameter gridParam = new DoubleParameter("Grid Spacing of Sources", 0.001, 100.0, "km", this.DEFAULT_GRID_VAL);
    DoubleParameter offsetParam = new DoubleParameter("Offset", 0.01, 10000.0, "kms", this.DEFAULT_OFFSET_VAL);
    DoubleParameter depthLowerParam = new DoubleParameter("Area Lower Seis Depth", 0.0, 30.0, "km", DEPTH_PARAM_DEFAULT);
    DoubleParameter depthUpperParam = new DoubleParameter("Area Upper Seis Depth", 0.0, 30.0, "km", DEPTH_PARAM_DEFAULT);

    public PEER_MultiSourceForecast() {
        this.timeSpan = new TimeSpan("None", "Years");
        this.timeSpan.addParameterChangeListener(this);
        this.adjustableParams.addParameter(this.gridParam);
        this.adjustableParams.addParameter(this.offsetParam);
        this.adjustableParams.addParameter(this.depthLowerParam);
        this.adjustableParams.addParameter(this.depthUpperParam);
        this.gridParam.addParameterChangeListener(this);
        this.offsetParam.addParameterChangeListener(this);
        this.depthLowerParam.addParameterChangeListener(this);
        this.depthUpperParam.addParameterChangeListener(this);
        double bValue = 0.9;
        this.dist_gr_A_orig = new GutenbergRichterMagFreqDist(5.05, 6.45, 15);
        this.dist_gr_A_orig.setAllButTotMoRate(5.05, 6.45, 0.0395, bValue);
        double tempMoRate = FaultMomentCalc.getMoment(9.0E8, 0.002);
        double minMag = 0.0;
        double maxMag = 10.0;
        int numMag = 1001;
        double magLower = 0.01;
        double magUpper = 7.25;
        double deltaMagChar = 0.5;
        double magPrime = 6.75;
        double deltaMagPrime = 1.0;
        this.dist_yc_B = new YC_1985_CharMagFreqDist(minMag, maxMag, numMag);
        this.dist_yc_B.setAllButTotCharRate(magLower, magUpper, deltaMagChar, magPrime, deltaMagPrime, bValue, tempMoRate);
        tempMoRate = FaultMomentCalc.getMoment(3.0E8, 0.001);
        magUpper = 6.75;
        magPrime = 6.25;
        this.dist_yc_C = new YC_1985_CharMagFreqDist(minMag, maxMag, numMag);
        this.dist_yc_C.setAllButTotCharRate(magLower, magUpper, deltaMagChar, magPrime, deltaMagPrime, bValue, tempMoRate);
        this.faultTraceB = new FaultTrace("Fault B");
        this.faultTraceB.add(faultB_loc1);
        this.faultTraceB.add(faultB_loc2);
        this.faultTraceC = new FaultTrace("Fault C");
        this.faultTraceC.add(faultC_loc1);
        this.faultTraceC.add(faultC_loc2);
    }

    @Override
    public void updateForecast() {
        if (this.parameterChangeFlag) {
            double gridSpacing = (Double)this.gridParam.getValue();
            double depthLower = (Double)this.depthLowerParam.getValue();
            double depthUpper = (Double)this.depthUpperParam.getValue();
            if (depthUpper > depthLower) {
                throw new RuntimeException("Upper Seis Depth must be \u2264 Lower Seis Depth");
            }
            Location gridCenter = new Location(38.0, -122.0);
            double latDiff = GeoTools.degreesLatPerKm(gridCenter) * gridSpacing;
            double longDiff = GeoTools.degreesLonPerKm(gridCenter) * gridSpacing;
            this.locationList = new LocationList();
            for (double lat = 38.901; lat >= 37.099; lat -= latDiff) {
                for (double lon = -123.138; lon <= -120.862; lon += longDiff) {
                    Location location = new Location(38.0, -122.0);
                    Location location2 = new Location(lat, lon);
                    if (!(LocationUtils.horzDistance(location, location2) <= 100.0)) continue;
                    for (double depth = depthUpper; depth <= depthLower; depth += gridSpacing) {
                        this.locationList.add(new Location(lat, lon, depth));
                    }
                }
            }
            int numLocs = this.locationList.size();
            this.dist_GR = this.dist_gr_A_orig.deepClone();
            double cumRate = this.dist_GR.getCumRate(0);
            this.dist_GR.scaleToCumRate(0, cumRate /= (double)numLocs);
            if (this.D) {
                System.out.println(C + " updateForecast(): rake=0.0; dip=90.0");
            }
            double seisUpper = 0.0;
            double seisLower = 12.0;
            double offset = (Double)this.offsetParam.getValue();
            double lengthSigma = 0.0;
            FrankelGriddedSurface surfaceB = new FrankelGriddedSurface(this.faultTraceB, 90.0, seisUpper, seisLower, gridSpacing);
            this.fltSourceB = new FloatingPoissonFaultSource(this.dist_yc_B, surfaceB, this.magScalingRel, lengthSigma, this.rupAspectRatio, offset, 0.0, this.timeSpan.getDuration(), this.minMag);
            FrankelGriddedSurface surfaceC = new FrankelGriddedSurface(this.faultTraceC, 90.0, seisUpper, seisLower, gridSpacing);
            this.fltSourceC = new FloatingPoissonFaultSource(this.dist_yc_C, surfaceC, this.magScalingRel, lengthSigma, this.rupAspectRatio, offset, 0.0, this.timeSpan.getDuration(), this.minMag);
        }
        this.parameterChangeFlag = false;
    }

    @Override
    public ProbEqkSource getSource(int iSource) {
        int numSrc = this.getNumSources();
        if (iSource < numSrc - 2 && iSource >= 0) {
            PointSource.PoissonPointSource pointPoissonEqkSource = ((PointSource.PoissonBuilder)PointSource.poissonBuilder((Location)this.locationList.get(iSource)).truePointSources()).forMFDAndFocalMech(this.dist_GR, new FocalMechanism(Double.NaN, 90.0, 0.0)).duration(this.timeSpan.getDuration()).build();
            return pointPoissonEqkSource;
        }
        if (iSource == numSrc - 2) {
            return this.fltSourceB;
        }
        if (iSource == numSrc - 1) {
            return this.fltSourceC;
        }
        throw new RuntimeException("bad source index");
    }

    @Override
    public int getNumSources() {
        return this.locationList.size() + 2;
    }

    public ArrayList getSourceList() {
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

