/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.PEER_TestCases;

import java.util.ArrayList;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.PEER_testsMagAreaRelationship;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.FloatingPoissonFaultSource;
import org.opensha.sha.faultSurface.EvenlyGriddedSurfFromSimpleFaultData;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.FrankelGriddedSurface;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;

public class PEER_NonPlanarFaultForecast
extends AbstractERF {
    private static String C = new String("PEER_NonPlanarFaultForecast");
    private boolean D = false;
    public static final String NAME = "PEER Non Planar Fault Forecast";
    private FloatingPoissonFaultSource source;
    private ArrayList sourceList;
    PEER_testsMagAreaRelationship magScalingRel = new PEER_testsMagAreaRelationship();
    private double rupAspectRatio = 2.0;
    private double minMag = 5.0;
    public static final String GRID_PARAM_NAME = "Fault Grid Spacing";
    private Double DEFAULT_GRID_VAL = 1.0;
    public static final String GRID_PARAM_UNITS = "kms";
    private static final double GRID_PARAM_MIN = 0.001;
    private static final double GRID_PARAM_MAX = 1000.0;
    public static final String OFFSET_PARAM_NAME = "Offset";
    private Double DEFAULT_OFFSET_VAL = 1.0;
    public static final String OFFSET_PARAM_UNITS = "kms";
    private static final double OFFSET_PARAM_MIN = 0.01;
    private static final double OFFSET_PARAM_MAX = 10000.0;
    public static final String SIGMA_PARAM_NAME = "Mag Length Sigma";
    private double SIGMA_PARAM_MIN = 0.0;
    private double SIGMA_PARAM_MAX = 1.0;
    public Double DEFAULT_SIGMA_VAL = 0.0;
    public static final String SLIP_RATE_NAME = "Slip Rate";
    public static final String SLIP_RATE_UNITS = "mm/yr";
    public static final double SLIP_RATE_MIN = 0.0;
    public static final double SLIP_RATE_MAX = 100000.0;
    public static final Double SLIP_RATE_DEFAULT = 2.0;
    public static final String GR_MAG_UPPER = new String("Mag Upper");
    public static final String GR_MAG_UPPER_INFO = new String("Max mag of the GR distribution (must be an increment of 0.05)");
    public static final Double GR_MAG_UPPER_DEFAULT = 7.15;
    public static final String DIP_DIRECTION_NAME = new String("Dip LocationVector");
    public static final String DIP_DIRECTION_EAST = new String("East");
    public static final String DIP_DIRECTION_WEST = new String("West");
    public static final String SEGMENTATION_NAME = new String("Segmentation Model");
    public static final String SEGMENTATION_NO = new String("Unsegmented");
    public static final String SEGMENTATION_YES = new String("Segmented");
    public static final String FAULT_MODEL_NAME = new String("Fault Model");
    public static final String FAULT_MODEL_FRANKEL = new String("Frankel's");
    public static final String FAULT_MODEL_STIRLING = new String("Stirling's");
    private DoubleParameter gridParam = new DoubleParameter("Fault Grid Spacing", 0.001, 1000.0, "kms", this.DEFAULT_GRID_VAL);
    private DoubleParameter offsetParam = new DoubleParameter("Offset", 0.01, 10000.0, "kms", this.DEFAULT_OFFSET_VAL);
    private DoubleParameter lengthSigmaParam = new DoubleParameter("Mag Length Sigma", this.SIGMA_PARAM_MIN, this.SIGMA_PARAM_MAX, this.DEFAULT_SIGMA_VAL);
    private DoubleParameter slipRateParam = new DoubleParameter("Slip Rate", 0.0, 100000.0, "mm/yr", SLIP_RATE_DEFAULT);
    private DoubleParameter magUpperParam = new DoubleParameter(GR_MAG_UPPER, GR_MAG_UPPER_DEFAULT);
    private ArrayList dipDirectionStrings = new ArrayList();
    private StringParameter dipDirectionParam;
    private ArrayList segModelNamesStrings = new ArrayList();
    private StringParameter segModelParam;
    private ArrayList faultModelNamesStrings = new ArrayList();
    private StringParameter faultModelParam;
    private FaultTrace faultTraceAll;
    private FaultTrace faultTraceA;
    private FaultTrace faultTraceB;
    private FaultTrace faultTraceC;
    private FaultTrace faultTraceD;
    private FaultTrace faultTraceE;
    public static final double LOWER_SEISMO_DEPTH = 12.0;
    public static final double UPPER_SEISMO_DEPTH = 1.0;
    public static final double DIP = 60.0;
    public static final double RAKE = -90.0;
    private static final Location traceLoc1 = new Location(37.609531, -121.7168636, 1.0);
    private static final Location traceLoc2 = new Location(37.804854, -121.8580591, 1.0);
    private static final Location traceLoc3 = new Location(38.0, -122.0, 1.0);
    private static final Location traceLoc4 = new Location(38.2248, -122.0, 1.0);
    private static final Location traceLoc5 = new Location(38.419959, -121.8568637, 1.0);
    private static final Location traceLoc6 = new Location(38.614736, -121.7129562, 1.0);
    private GutenbergRichterMagFreqDist grMagFreqDist;
    public static final double GR_MIN = 0.05;
    public static final double GR_MAX = 9.95;
    public static final int GR_NUM = 100;
    public static final double GR_BVALUE = 0.9;
    public static final double GR_MAG_LOWER = 0.05;

    public PEER_NonPlanarFaultForecast() {
        this.timeSpan = new TimeSpan("None", "Years");
        this.timeSpan.addParameterChangeListener(this);
        this.dipDirectionStrings.add(DIP_DIRECTION_EAST);
        this.dipDirectionStrings.add(DIP_DIRECTION_WEST);
        this.dipDirectionParam = new StringParameter(DIP_DIRECTION_NAME, this.dipDirectionStrings, DIP_DIRECTION_EAST);
        this.segModelNamesStrings.add(SEGMENTATION_NO);
        this.segModelNamesStrings.add(SEGMENTATION_YES);
        this.segModelParam = new StringParameter(SEGMENTATION_NAME, this.segModelNamesStrings, (String)this.segModelNamesStrings.get(0));
        this.faultModelNamesStrings.add(FAULT_MODEL_FRANKEL);
        this.faultModelNamesStrings.add(FAULT_MODEL_STIRLING);
        this.faultModelParam = new StringParameter(FAULT_MODEL_NAME, this.faultModelNamesStrings, (String)this.faultModelNamesStrings.get(0));
        this.adjustableParams.addParameter(this.gridParam);
        this.adjustableParams.addParameter(this.offsetParam);
        this.adjustableParams.addParameter(this.lengthSigmaParam);
        this.adjustableParams.addParameter(this.slipRateParam);
        this.adjustableParams.addParameter(this.magUpperParam);
        this.adjustableParams.addParameter(this.segModelParam);
        this.adjustableParams.addParameter(this.faultModelParam);
        this.adjustableParams.addParameter(this.dipDirectionParam);
        this.gridParam.addParameterChangeListener(this);
        this.offsetParam.addParameterChangeListener(this);
        this.lengthSigmaParam.addParameterChangeListener(this);
        this.slipRateParam.addParameterChangeListener(this);
        this.magUpperParam.addParameterChangeListener(this);
        this.segModelParam.addParameterChangeListener(this);
        this.faultModelParam.addParameterChangeListener(this);
        this.dipDirectionParam.addParameterChangeListener(this);
        this.grMagFreqDist = new GutenbergRichterMagFreqDist(0.05, 9.95, 100);
        this.faultTraceAll = new FaultTrace("Non Planar Fault");
        this.faultTraceAll.add(traceLoc1);
        this.faultTraceAll.add(traceLoc2);
        this.faultTraceAll.add(traceLoc3);
        this.faultTraceAll.add(traceLoc4);
        this.faultTraceAll.add(traceLoc5);
        this.faultTraceAll.add(traceLoc6);
        this.faultTraceE = new FaultTrace("Non Planar Fault");
        this.faultTraceE.add(traceLoc1);
        this.faultTraceE.add(traceLoc2);
        this.faultTraceD = new FaultTrace("Non Planar Fault");
        this.faultTraceD.add(traceLoc2);
        this.faultTraceD.add(traceLoc3);
        this.faultTraceC = new FaultTrace("Non Planar Fault");
        this.faultTraceC.add(traceLoc3);
        this.faultTraceC.add(traceLoc4);
        this.faultTraceB = new FaultTrace("Non Planar Fault");
        this.faultTraceB.add(traceLoc4);
        this.faultTraceB.add(traceLoc5);
        this.faultTraceA = new FaultTrace("Non Planar Fault");
        this.faultTraceA.add(traceLoc5);
        this.faultTraceA.add(traceLoc6);
    }

    @Override
    public void updateForecast() {
        String S = C + "updateForecast: ";
        if (this.parameterChangeFlag) {
            this.sourceList = new ArrayList();
            String dipDir = (String)this.dipDirectionParam.getValue();
            boolean reversed = false;
            if (dipDir.equals(DIP_DIRECTION_WEST)) {
                this.faultTraceAll.reverse();
                this.faultTraceA.reverse();
                this.faultTraceB.reverse();
                this.faultTraceC.reverse();
                this.faultTraceD.reverse();
                this.faultTraceE.reverse();
                reversed = true;
            }
            String segType = (String)this.segModelParam.getValue();
            double gridSpacing = (Double)this.gridParam.getValue();
            String faultModel = (String)this.faultModelParam.getValue();
            double offset = (Double)this.offsetParam.getValue();
            double lengthSigma = (Double)this.lengthSigmaParam.getValue();
            double magUpper = (Double)this.magUpperParam.getValue();
            double slipRate = (Double)this.slipRateParam.getValue() / 1000.0;
            double ddw = 11.0 / Math.sin(1.0471975511965976);
            if (segType.equals(SEGMENTATION_NO)) {
                double faultArea = this.faultTraceAll.getTraceLength() * ddw * 1000000.0;
                double totMoRate = 3.0E10 * faultArea * slipRate;
                this.grMagFreqDist.setAllButTotCumRate(0.05, magUpper, totMoRate, 0.9);
                EvenlyGriddedSurfFromSimpleFaultData surfaceAll = faultModel.equals(FAULT_MODEL_FRANKEL) ? new FrankelGriddedSurface(this.faultTraceAll, 60.0, 1.0, 12.0, gridSpacing) : new StirlingGriddedSurface(this.faultTraceAll, 60.0, 1.0, 12.0, gridSpacing);
                this.source = new FloatingPoissonFaultSource(this.grMagFreqDist, surfaceAll, this.magScalingRel, lengthSigma, this.rupAspectRatio, offset, -90.0, this.timeSpan.getDuration(), this.minMag);
                this.sourceList.add(this.source);
            } else {
                double faultArea = this.faultTraceA.getTraceLength() * ddw * 1000000.0;
                double totMoRate = 3.0E10 * faultArea * slipRate;
                this.grMagFreqDist.setAllButTotCumRate(0.05, magUpper, totMoRate, 0.9);
                if (this.D) {
                    System.out.println("Segment lengths:\n\n\tA - " + this.faultTraceA.getTraceLength() + "\n\tB - " + this.faultTraceB.getTraceLength() + "\n\tC - " + this.faultTraceC.getTraceLength() + "\n\tD - " + this.faultTraceD.getTraceLength() + "\n\tE - " + this.faultTraceE.getTraceLength() + "\n");
                }
                EvenlyGriddedSurfFromSimpleFaultData surfaceA = faultModel.equals(FAULT_MODEL_FRANKEL) ? new FrankelGriddedSurface(this.faultTraceA, 60.0, 1.0, 12.0, gridSpacing) : new StirlingGriddedSurface(this.faultTraceA, 60.0, 1.0, 12.0, gridSpacing);
                this.source = new FloatingPoissonFaultSource(this.grMagFreqDist, surfaceA, this.magScalingRel, lengthSigma, this.rupAspectRatio, offset, -90.0, this.timeSpan.getDuration(), this.minMag);
                this.sourceList.add(this.source);
                EvenlyGriddedSurfFromSimpleFaultData surfaceB = faultModel.equals(FAULT_MODEL_FRANKEL) ? new FrankelGriddedSurface(this.faultTraceB, 60.0, 1.0, 12.0, gridSpacing) : new StirlingGriddedSurface(this.faultTraceB, 60.0, 1.0, 12.0, gridSpacing);
                this.source = new FloatingPoissonFaultSource(this.grMagFreqDist, surfaceB, this.magScalingRel, lengthSigma, this.rupAspectRatio, offset, -90.0, this.timeSpan.getDuration(), this.minMag);
                this.sourceList.add(this.source);
                EvenlyGriddedSurfFromSimpleFaultData surfaceC = faultModel.equals(FAULT_MODEL_FRANKEL) ? new FrankelGriddedSurface(this.faultTraceC, 60.0, 1.0, 12.0, gridSpacing) : new StirlingGriddedSurface(this.faultTraceC, 60.0, 1.0, 12.0, gridSpacing);
                this.source = new FloatingPoissonFaultSource(this.grMagFreqDist, surfaceC, this.magScalingRel, lengthSigma, this.rupAspectRatio, offset, -90.0, this.timeSpan.getDuration(), this.minMag);
                this.sourceList.add(this.source);
                EvenlyGriddedSurfFromSimpleFaultData surfaceD = faultModel.equals(FAULT_MODEL_FRANKEL) ? new FrankelGriddedSurface(this.faultTraceD, 60.0, 1.0, 12.0, gridSpacing) : new StirlingGriddedSurface(this.faultTraceD, 60.0, 1.0, 12.0, gridSpacing);
                this.source = new FloatingPoissonFaultSource(this.grMagFreqDist, surfaceD, this.magScalingRel, lengthSigma, this.rupAspectRatio, offset, -90.0, this.timeSpan.getDuration(), this.minMag);
                this.sourceList.add(this.source);
                EvenlyGriddedSurfFromSimpleFaultData surfaceE = faultModel.equals(FAULT_MODEL_FRANKEL) ? new FrankelGriddedSurface(this.faultTraceE, 60.0, 1.0, 12.0, gridSpacing) : new StirlingGriddedSurface(this.faultTraceE, 60.0, 1.0, 12.0, gridSpacing);
                this.source = new FloatingPoissonFaultSource(this.grMagFreqDist, surfaceE, this.magScalingRel, lengthSigma, this.rupAspectRatio, offset, -90.0, this.timeSpan.getDuration(), this.minMag);
                this.sourceList.add(this.source);
            }
            if (this.D) {
                System.out.println(S);
                System.out.println("   rate\u22655=" + (float)this.grMagFreqDist.getCumRate(5.05));
                System.out.println("   segType = " + segType);
                System.out.println("   faultModel = " + faultModel);
                System.out.println("   magUpper = " + magUpper);
                System.out.println("   slipRate = " + slipRate);
                System.out.println("   gridSpacing = " + gridSpacing);
                System.out.println("   offset = " + offset);
                System.out.println("   lengthSigma = " + lengthSigma);
            }
            if (reversed) {
                this.faultTraceAll.reverse();
                this.faultTraceA.reverse();
                this.faultTraceB.reverse();
                this.faultTraceC.reverse();
                this.faultTraceD.reverse();
                this.faultTraceE.reverse();
            }
        }
        this.parameterChangeFlag = false;
    }

    @Override
    public ProbEqkSource getSource(int iSource) {
        return (ProbEqkSource)this.sourceList.get(iSource);
    }

    @Override
    public int getNumSources() {
        return this.sourceList.size();
    }

    public ArrayList getSourceList() {
        return this.sourceList;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

