/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.Point2MultVertSS_Fault;

import java.util.ArrayList;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WC1994_MagLengthRelationship;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.Point2MultVertSS_FaultSource;

public class Point2MultVertSS_FaultERF
extends AbstractERF {
    private static String C = new String("Point2MultVertSS_FaultERF");
    private boolean D = false;
    public static final String NAME = "Point 2 Mult Vertical SS Fault ERF";
    private Point2MultVertSS_FaultSource source;
    WC1994_MagLengthRelationship magLengthRel = new WC1994_MagLengthRelationship();
    double upperSeisDepth = 0.0;
    double lowerSeisDepth = 1.0;
    DoubleParameter srcLatParam;
    DoubleParameter srcLonParam;
    DoubleParameter magParam;
    DoubleParameter probParam;
    DoubleParameter maxRupOffsetParam;
    DoubleParameter deltaStrikeParam;
    public static final String SRC_LAT_PARAM_NAME = "Latitude";
    private static final String SRC_LAT_PARAM_INFO = "The latitude of the point source";
    private static final String SRC_LAT_PARAM_UNITS = "Degrees";
    private Double SRC_LAT_PARAM_MIN = -90.0;
    private Double SRC_LAT_PARAM_MAX = 90.0;
    private Double SRC_LAT_PARAM_DEFAULT = 35.71;
    public static final String SRC_LON_PARAM_NAME = "Longitude";
    private static final String SRC_LON_PARAM_INFO = "The longitude of the point source";
    private static final String SRC_LON_PARAM_UNITS = "Degrees";
    private Double SRC_LON_PARAM_MIN = -360.0;
    private Double SRC_LON_PARAM_MAX = 360.0;
    private Double SRC_LON_PARAM_DEFAULT = -121.1;
    public static final String MAG_PARAM_NAME = "Magnitude";
    private static final String MAG_PARAM_INFO = "The  magnitude of the point source";
    private static final String MAG_PARAM_UNITS = null;
    private Double MAG_PARAM_MIN = 5.0;
    private Double MAG_PARAM_MAX = 10.0;
    private Double MAG_PARAM_DEFAULT = 7.0;
    public static final String PROB_PARAM_NAME = "Probability";
    private static final String PROB_PARAM_INFO = "The probability of the source (independent of whatever timeSpan is given)";
    private static final String PROB_PARAM_UNITS = null;
    private Double PROB_PARAM_MIN = 0.0;
    private Double PROB_PARAM_MAX = 1.0;
    private Double PROB_PARAM_DEFAULT = 1.0;
    public static final String RUP_OFFSET_PARAM_NAME = "Max Rupture Offset";
    private static final String RUP_OFFSET_PARAM_INFO = "The amount by which ruptures are floated along stike (actual value will be slightly less)";
    private static final String RUP_OFFSET_PARAM_UNITS = "km";
    private Double RUP_OFFSET_PARAM_MIN = 0.01;
    private Double RUP_OFFSET_PARAM_MAX = 20.0;
    private Double RUP_OFFSET_PARAM_DEFAULT = 2.0;
    public static final String DELTA_STRIKE_PARAM_NAME = "Delta Strike";
    private static final String DELTA_STRIKE_PARAM_INFO = "Discretization of strike for spinning fault";
    private static final String DELTA_STRIKE_PARAM_UNITS = "degrees";
    private Double DELTA_STRIKE_PARAM_MIN = 0.01;
    private Double DELTA_STRIKE_PARAM_MAX = 90.0;
    private Double DELTA_STRIKE_PARAM_DEFAULT = 5.0;

    public Point2MultVertSS_FaultERF() {
        this.timeSpan = null;
        this.srcLatParam = new DoubleParameter(SRC_LAT_PARAM_NAME, this.SRC_LAT_PARAM_MIN, this.SRC_LAT_PARAM_MAX, "Degrees", this.SRC_LAT_PARAM_DEFAULT);
        this.srcLatParam.setInfo(SRC_LAT_PARAM_INFO);
        this.srcLonParam = new DoubleParameter(SRC_LON_PARAM_NAME, this.SRC_LON_PARAM_MIN, this.SRC_LON_PARAM_MAX, "Degrees", this.SRC_LON_PARAM_DEFAULT);
        this.srcLonParam.setInfo(SRC_LON_PARAM_INFO);
        this.magParam = new DoubleParameter(MAG_PARAM_NAME, this.MAG_PARAM_MIN, this.MAG_PARAM_MAX, MAG_PARAM_UNITS, this.MAG_PARAM_DEFAULT);
        this.magParam.setInfo(MAG_PARAM_INFO);
        this.probParam = new DoubleParameter(PROB_PARAM_NAME, this.PROB_PARAM_MIN, this.PROB_PARAM_MAX, PROB_PARAM_UNITS, this.PROB_PARAM_DEFAULT);
        this.probParam.setInfo(PROB_PARAM_INFO);
        this.maxRupOffsetParam = new DoubleParameter(RUP_OFFSET_PARAM_NAME, this.RUP_OFFSET_PARAM_MIN, this.RUP_OFFSET_PARAM_MAX, RUP_OFFSET_PARAM_UNITS, this.RUP_OFFSET_PARAM_DEFAULT);
        this.maxRupOffsetParam.setInfo(RUP_OFFSET_PARAM_INFO);
        this.deltaStrikeParam = new DoubleParameter(DELTA_STRIKE_PARAM_NAME, this.DELTA_STRIKE_PARAM_MIN, this.DELTA_STRIKE_PARAM_MAX, DELTA_STRIKE_PARAM_UNITS, this.DELTA_STRIKE_PARAM_DEFAULT);
        this.deltaStrikeParam.setInfo(DELTA_STRIKE_PARAM_INFO);
        this.adjustableParams.addParameter(this.srcLatParam);
        this.adjustableParams.addParameter(this.srcLonParam);
        this.adjustableParams.addParameter(this.magParam);
        this.adjustableParams.addParameter(this.probParam);
        this.adjustableParams.addParameter(this.maxRupOffsetParam);
        this.adjustableParams.addParameter(this.deltaStrikeParam);
        this.srcLatParam.addParameterChangeListener(this);
        this.srcLonParam.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.probParam.addParameterChangeListener(this);
        this.maxRupOffsetParam.addParameterChangeListener(this);
        this.deltaStrikeParam.addParameterChangeListener(this);
    }

    @Override
    public void updateForecast() {
        String S = C + "updateForecast::";
        if (this.parameterChangeFlag) {
            double lat = (Double)this.srcLatParam.getValue();
            double lon = (Double)this.srcLonParam.getValue();
            double mag = (Double)this.magParam.getValue();
            double prob = (Double)this.probParam.getValue();
            double maxRupOffset = (Double)this.maxRupOffsetParam.getValue();
            double deltaStrike = (Double)this.deltaStrikeParam.getValue();
            this.source = new Point2MultVertSS_FaultSource(lat, lon, mag, prob, this.magLengthRel, this.upperSeisDepth, this.lowerSeisDepth, maxRupOffset, deltaStrike);
            this.parameterChangeFlag = false;
        }
    }

    @Override
    public ProbEqkSource getSource(int iSource) {
        if (iSource != 0) {
            throw new RuntimeException("Only 1 source available, iSource should be equal to 0");
        }
        return this.source;
    }

    @Override
    public int getNumSources() {
        return 1;
    }

    public ArrayList getSourceList() {
        ArrayList<Point2MultVertSS_FaultSource> v = new ArrayList<Point2MultVertSS_FaultSource>();
        v.add(this.source);
        return v;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setTimeSpan(TimeSpan time) {
    }
}

