/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl;

import java.util.ArrayList;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.earthquake.PointSource;
import org.opensha.sha.earthquake.param.PointSourceDistanceCorrectionParam;
import org.opensha.sha.faultSurface.utils.PointSourceDistanceCorrections;
import org.opensha.sha.magdist.GaussianMagFreqDist;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SingleMagFreqDist;
import org.opensha.sha.param.MagFreqDistParameter;

public class PointPoissonSourceERF
extends AbstractERF {
    private static String C = new String("PointPoissonSourceERF");
    private boolean D = true;
    public static final String NAME = "Point Poisson Source ERF";
    private PointSource source;
    public static final String MAG_DIST_PARAM_NAME = "Mag Freq Dist";
    public static final String RAKE_PARAM_NAME = "Rake";
    private static final String RAKE_PARAM_INFO = "The rake of the rupture (direction of slip)";
    private static final String RAKE_PARAM_UNITS = "degrees";
    private Double RAKE_PARAM_MIN = -180.0;
    private Double RAKE_PARAM_MAX = 180.0;
    private Double RAKE_PARAM_DEFAULT = 0.0;
    public static final String DIP_PARAM_NAME = "Dip";
    private static final String DIP_PARAM_INFO = "The dip of the rupture surface";
    private static final String DIP_PARAM_UNITS = "degrees";
    private Double DIP_PARAM_MIN = 0.0;
    private Double DIP_PARAM_MAX = 90.0;
    private Double DIP_PARAM_DEFAULT = 90.0;
    public static final String SRC_LAT_PARAM_NAME = "Source Latitude";
    private static final String SRC_LAT_PARAM_INFO = "Latitude of the point source";
    private static final String SRC_LAT_PARAM_UNITS = "Degrees";
    private Double SRC_LAT_PARAM_MIN = -90.0;
    private Double SRC_LAT_PARAM_MAX = 90.0;
    private Double SRC_LAT_PARAM_DEFAULT = 35.71;
    public static final String SRC_LON_PARAM_NAME = "Source Longitude";
    private static final String SRC_LON_PARAM_INFO = "Longitude of the point source";
    private static final String SRC_LON_PARAM_UNITS = "Degrees";
    private Double SRC_LON_PARAM_MIN = -360.0;
    private Double SRC_LON_PARAM_MAX = 360.0;
    private Double SRC_LON_PARAM_DEFAULT = -121.1;
    public static final String SRC_DEPTH_PARAM_NAME = "Source Depth";
    private static final String SRC_DEPTH_PARAM_INFO = "Depth of the point source";
    private static final String SRC_DEPTH_PARAM_UNITS = "km";
    private Double SRC_DEPTH_PARAM_MIN = 0.0;
    private Double SRC_DEPTH_PARAM_MAX = 50.0;
    private Double SRC_DEPTH_PARAM_DEFAULT = 7.6;
    MagFreqDistParameter magDistParam;
    DoubleParameter dipParam;
    DoubleParameter rakeParam;
    DoubleParameter srcLatParam;
    DoubleParameter srcLonParam;
    DoubleParameter srcDepthParam;
    PointSourceDistanceCorrectionParam distCorrParam;

    public PointPoissonSourceERF() {
        this.timeSpan = new TimeSpan("None", "Years");
        this.timeSpan.addParameterChangeListener(this);
        ArrayList<String> supportedMagDists = new ArrayList<String>();
        supportedMagDists.add(GutenbergRichterMagFreqDist.NAME);
        supportedMagDists.add(GaussianMagFreqDist.NAME);
        supportedMagDists.add(SingleMagFreqDist.NAME);
        this.magDistParam = new MagFreqDistParameter(MAG_DIST_PARAM_NAME, supportedMagDists);
        this.rakeParam = new DoubleParameter(RAKE_PARAM_NAME, this.RAKE_PARAM_MIN, this.RAKE_PARAM_MAX, "degrees", this.RAKE_PARAM_DEFAULT);
        this.rakeParam.setInfo(RAKE_PARAM_INFO);
        this.dipParam = new DoubleParameter(DIP_PARAM_NAME, this.DIP_PARAM_MIN, this.DIP_PARAM_MAX, "degrees", this.DIP_PARAM_DEFAULT);
        this.dipParam.setInfo(DIP_PARAM_INFO);
        this.srcLatParam = new DoubleParameter(SRC_LAT_PARAM_NAME, this.SRC_LAT_PARAM_MIN, this.SRC_LAT_PARAM_MAX, "Degrees", this.SRC_LAT_PARAM_DEFAULT);
        this.srcLatParam.setInfo(SRC_LAT_PARAM_INFO);
        this.srcLonParam = new DoubleParameter(SRC_LON_PARAM_NAME, this.SRC_LON_PARAM_MIN, this.SRC_LON_PARAM_MAX, "Degrees", this.SRC_LON_PARAM_DEFAULT);
        this.srcLonParam.setInfo(SRC_LON_PARAM_INFO);
        this.srcDepthParam = new DoubleParameter(SRC_DEPTH_PARAM_NAME, this.SRC_DEPTH_PARAM_MIN, this.SRC_DEPTH_PARAM_MAX, SRC_DEPTH_PARAM_UNITS, this.SRC_DEPTH_PARAM_DEFAULT);
        this.srcDepthParam.setInfo(SRC_DEPTH_PARAM_INFO);
        this.distCorrParam = new PointSourceDistanceCorrectionParam();
        this.adjustableParams.addParameter(this.srcLatParam);
        this.adjustableParams.addParameter(this.srcLonParam);
        this.adjustableParams.addParameter(this.srcDepthParam);
        this.adjustableParams.addParameter(this.rakeParam);
        this.adjustableParams.addParameter(this.dipParam);
        this.adjustableParams.addParameter(this.magDistParam);
        this.adjustableParams.addParameter(this.distCorrParam);
        this.rakeParam.addParameterChangeListener(this);
        this.dipParam.addParameterChangeListener(this);
        this.srcLatParam.addParameterChangeListener(this);
        this.srcLonParam.addParameterChangeListener(this);
        this.srcDepthParam.addParameterChangeListener(this);
        this.magDistParam.addParameterChangeListener(this);
        this.distCorrParam.addParameterChangeListener(this);
    }

    @Override
    public void updateForecast() {
        String S = C + "updateForecast::";
        if (this.parameterChangeFlag) {
            Location loc = new Location((Double)this.srcLatParam.getValue(), (Double)this.srcLonParam.getValue(), (Double)this.srcDepthParam.getValue());
            this.source = ((PointSource.PoissonBuilder)((PointSource.PoissonBuilder)PointSource.poissonBuilder(loc).truePointSources((Double)this.srcDepthParam.getValue())).duration(this.timeSpan.getDuration()).forMFDAndFocalMech((IncrementalMagFreqDist)this.magDistParam.getValue(), new FocalMechanism(Double.NaN, (Double)this.dipParam.getValue(), (Double)this.rakeParam.getValue())).distCorrs((PointSourceDistanceCorrections)this.distCorrParam.getValue())).build();
            this.parameterChangeFlag = false;
        }
        if (this.D) {
            System.out.println(C + " numSources=" + this.getNumSources());
            System.out.println(C + " numRuptures(0th src)=" + this.getSource(0).getNumRuptures());
            System.out.println(C + " isPoissonian(0th src)=" + this.getSource(0).isSourcePoissonian());
            for (int n = 0; n < this.getSource(0).getNumRuptures(); ++n) {
                System.out.println(C + " " + n + "th rup prob=" + this.getSource(0).getRupture(n).getProbability());
                System.out.println(C + " " + n + "th rup mag=" + this.getSource(0).getRupture(n).getMag());
            }
        }
    }

    @Override
    public PointSource getSource(int iSource) {
        if (iSource != 0) {
            throw new RuntimeException("Only 1 source available, iSource should be equal to 0");
        }
        return this.source;
    }

    @Override
    public int getNumSources() {
        return 1;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

