/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl;

import java.io.Serializable;
import java.util.ArrayList;
import org.opensha.commons.calc.magScalingRelations.MagAreaRelationship;
import org.opensha.commons.calc.magScalingRelations.MagLengthRelationship;
import org.opensha.commons.calc.magScalingRelations.MagScalingRelationship;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.griddedForecast.HypoMagFreqDistAtLoc;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

@Deprecated
public class PointToFiniteSource
extends ProbEqkSource
implements Serializable {
    protected static String C = new String("PointToFiniteSource");
    protected static String NAME = "Point-to-Finite Source";
    protected boolean D = false;
    protected ArrayList<ProbEqkRupture> probEqkRuptureList;
    protected ArrayList<Double> rates;
    protected Location location;
    protected double maxLength = 0.0;
    int numRuptures;
    IncrementalMagFreqDist[] magFreqDists;
    FocalMechanism[] focalMechanisms;
    ArbitrarilyDiscretizedFunc aveRupTopVersusMag;
    MagScalingRelationship magScalingRel;
    double lowerSeisDepth;
    double duration = Double.NaN;
    double minMag = Double.NaN;
    int numStrikes = -1;
    double firstStrike;
    boolean lineSource;

    public PointToFiniteSource() {
    }

    public PointToFiniteSource(HypoMagFreqDistAtLoc hypoMagFreqDistAtLoc, ArbitrarilyDiscretizedFunc aveRupTopVersusMag, MagScalingRelationship magScalingRel, double lowerSeisDepth, double duration, double minMag, int numStrikes, double firstStrike, boolean lineSource) {
        this.magFreqDists = hypoMagFreqDistAtLoc.getMagFreqDistList();
        this.focalMechanisms = hypoMagFreqDistAtLoc.getFocalMechanismList();
        this.aveRupTopVersusMag = aveRupTopVersusMag;
        this.magScalingRel = magScalingRel;
        this.lowerSeisDepth = lowerSeisDepth;
        this.duration = duration;
        this.minMag = minMag;
        this.numStrikes = numStrikes;
        this.firstStrike = firstStrike;
        this.lineSource = lineSource;
        this.isPoissonian = true;
        this.location = hypoMagFreqDistAtLoc.getLocation();
        this.maxLength = this.computeMaxLength();
        this.numRuptures = this.computeNumRuptures();
    }

    public PointToFiniteSource(HypoMagFreqDistAtLoc hypoMagFreqDistAtLoc, ArbitrarilyDiscretizedFunc aveRupTopVersusMag, MagScalingRelationship magScalingRel, double lowerSeisDepth, double duration, double minMag) {
        this(hypoMagFreqDistAtLoc, aveRupTopVersusMag, magScalingRel, lowerSeisDepth, duration, minMag, -1, Double.NaN, true);
    }

    public PointToFiniteSource(HypoMagFreqDistAtLoc hypoMagFreqDistAtLoc, ArbitrarilyDiscretizedFunc aveRupTopVersusMag, MagScalingRelationship magScalingRel, double lowerSeisDepth, double duration, double minMag, boolean lineSource) {
        this(hypoMagFreqDistAtLoc, aveRupTopVersusMag, magScalingRel, lowerSeisDepth, duration, minMag, -1, Double.NaN, lineSource);
    }

    public PointToFiniteSource(IncrementalMagFreqDist magDist, Location loc, FocalMechanism focalMech, double upperSeisDepth, MagScalingRelationship magScalingRel, double lowerSeisDepth, double duration, double minMag, boolean lineSource) {
        HypoMagFreqDistAtLoc hypoMagFreqDistAtLoc = new HypoMagFreqDistAtLoc(magDist, loc, focalMech);
        this.magFreqDists = hypoMagFreqDistAtLoc.getMagFreqDistList();
        this.focalMechanisms = hypoMagFreqDistAtLoc.getFocalMechanismList();
        this.aveRupTopVersusMag = new ArbitrarilyDiscretizedFunc();
        this.aveRupTopVersusMag.set(0.0, upperSeisDepth);
        this.aveRupTopVersusMag.set(10.0, upperSeisDepth);
        this.magScalingRel = magScalingRel;
        this.lowerSeisDepth = lowerSeisDepth;
        this.duration = duration;
        this.minMag = minMag;
        this.numStrikes = -1;
        this.firstStrike = Double.NaN;
        this.lineSource = lineSource;
        this.isPoissonian = true;
        this.location = hypoMagFreqDistAtLoc.getLocation();
        this.maxLength = this.computeMaxLength();
        this.numRuptures = this.computeNumRuptures();
    }

    protected double computeMaxLength() {
        double max = 0.0;
        for (int i = 0; i < this.magFreqDists.length; ++i) {
            double dip = this.focalMechanisms[i].getDip();
            double mag = this.magFreqDists[i].getMaxMagWithNonZeroRate();
            double length = PointToFiniteSource.getRupLength(mag, this.aveRupTopVersusMag.getClosestYtoX(mag), this.lowerSeisDepth, dip, this.magScalingRel);
            if (!(length > max)) continue;
            max = length;
        }
        return max;
    }

    protected int computeNumRuptures() {
        int num = 0;
        for (int i = 0; i < this.magFreqDists.length; ++i) {
            double min = this.minMag;
            IncrementalMagFreqDist mfd = this.magFreqDists[i];
            if (min < mfd.getX(0)) {
                min = mfd.getX(0);
            }
            for (int m = mfd.getXIndex(min); m < mfd.size(); ++m) {
                if (!(mfd.getY(m) > 0.0)) continue;
                ++num;
            }
        }
        if (this.numStrikes != -1) {
            num *= this.numStrikes;
        }
        return num;
    }

    private void mkAllRuptures() {
        this.probEqkRuptureList = new ArrayList();
        this.rates = new ArrayList();
        if (this.numStrikes == -1) {
            for (int i = 0; i < this.magFreqDists.length; ++i) {
                this.mkAndAddRuptures(this.location, this.magFreqDists[i], this.focalMechanisms[i], this.aveRupTopVersusMag, this.magScalingRel, this.lowerSeisDepth, this.duration, this.minMag, 1.0);
            }
        } else {
            double deltaStrike = 180 / this.numStrikes;
            double[] strike = new double[this.numStrikes];
            for (int n = 0; n < this.numStrikes; ++n) {
                strike[n] = this.firstStrike + (double)n * deltaStrike;
            }
            for (int i = 0; i < this.magFreqDists.length; ++i) {
                FocalMechanism focalMech = this.focalMechanisms[i].copy();
                for (int s = 0; s < this.numStrikes; ++s) {
                    focalMech.setStrike(strike[s]);
                    double weight = 1.0 / (double)this.numStrikes;
                    this.mkAndAddRuptures(this.location, this.magFreqDists[i], focalMech, this.aveRupTopVersusMag, this.magScalingRel, this.lowerSeisDepth, this.duration, this.minMag, weight);
                }
            }
        }
        if (this.numRuptures != this.probEqkRuptureList.size()) {
            throw new RuntimeException("Error in computing number of ruptures");
        }
    }

    protected void mkAndAddRuptures(Location location, IncrementalMagFreqDist magFreqDist, FocalMechanism focalMech, ArbitrarilyDiscretizedFunc aveRupTopVersusMag, MagScalingRelationship magScalingRel, double lowerSeisDepth, double duration, double minMag, double weight) {
        double dip = focalMech.getDip();
        double strike = focalMech.getStrike();
        boolean isStrikeRandom = false;
        if (Double.isNaN(strike)) {
            isStrikeRandom = true;
        }
        for (int m = 0; m < magFreqDist.size(); ++m) {
            double mag = magFreqDist.getX(m);
            double rate = magFreqDist.getY(m);
            if (!(rate > 0.0) || !(mag >= minMag)) continue;
            double prob = 1.0 - Math.exp(-rate * weight * duration);
            if (mag < aveRupTopVersusMag.getMinX() || mag > aveRupTopVersusMag.getMaxX()) {
                throw new RuntimeException("aveRupTopVersusMag x-axis range not wide enough");
            }
            double upperDepth = aveRupTopVersusMag.getClosestYtoX(mag);
            Location loc = new Location(location.getLatitude(), location.getLongitude(), upperDepth);
            double rupLength = PointToFiniteSource.getRupLength(mag, aveRupTopVersusMag.getClosestYtoX(mag), lowerSeisDepth, dip, magScalingRel);
            if (isStrikeRandom) {
                strike = (Math.random() - 0.5) * 360.0;
            }
            LocationVector dir = new LocationVector(strike, rupLength / 2.0, 0.0);
            Location loc1 = LocationUtils.location(loc, dir);
            dir.setAzimuth(strike - 180.0);
            Location loc2 = LocationUtils.location(loc, dir);
            FaultTrace fltTrace = new FaultTrace(null);
            fltTrace.add(loc2);
            fltTrace.add(loc1);
            StirlingGriddedSurface surf = this.lineSource ? new StirlingGriddedSurface(fltTrace, dip, upperDepth, upperDepth, 1.0) : new StirlingGriddedSurface(fltTrace, dip, upperDepth, lowerSeisDepth, 1.0);
            ProbEqkRupture rupture = new ProbEqkRupture();
            rupture.setMag(mag);
            rupture.setAveRake(focalMech.getRake());
            rupture.setRuptureSurface(surf);
            rupture.setProbability(prob);
            if (this.D) {
                System.out.println("\trupLength\t" + rupLength + "\tstrike\t" + strike + "\tdip\t" + focalMech.getDip() + "\trake\t" + rupture.getAveRake() + "\tmag\t" + (float)mag + "\trate\t" + (float)rate + "\tprob\t" + (float)prob + "\tweight\t" + (float)weight);
            }
            this.probEqkRuptureList.add(rupture);
            this.rates.add(rate * weight);
        }
    }

    public static double getRupLength(double mag, double upperSeisDepth, double lowerSeisDepth, double dip, MagScalingRelationship magScalingRel) {
        double rupLength;
        if (magScalingRel instanceof MagAreaRelationship) {
            double area;
            double ddw = (upperSeisDepth - lowerSeisDepth) / Math.sin(dip * Math.PI / 180.0);
            rupLength = ddw > Math.sqrt(area = magScalingRel.getMedianScale(mag)) ? ddw : area / ddw;
        } else if (magScalingRel instanceof MagLengthRelationship) {
            rupLength = magScalingRel.getMedianScale(mag);
        } else {
            throw new RuntimeException("bad type of MagScalingRelationship: " + String.valueOf(magScalingRel));
        }
        return rupLength;
    }

    @Override
    public LocationList getAllSourceLocs() {
        LocationList locList = new LocationList();
        for (int r = 0; r < this.getNumRuptures(); ++r) {
            locList.addAll(this.probEqkRuptureList.get(r).getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface());
        }
        return locList;
    }

    @Override
    public AbstractEvenlyGriddedSurface getSourceSurface() {
        throw new RuntimeException("Method not supported");
    }

    @Override
    public int getNumRuptures() {
        return this.numRuptures;
    }

    @Override
    public ProbEqkRupture getRupture(int nthRupture) {
        if (this.probEqkRuptureList == null) {
            this.mkAllRuptures();
        }
        return this.probEqkRuptureList.get(nthRupture);
    }

    public void setDuration(double duration) {
        this.duration = duration;
        for (int i = 0; i < this.probEqkRuptureList.size(); ++i) {
            this.probEqkRuptureList.get(i).setProbability(1.0 - Math.exp(-this.rates.get(i).doubleValue() * duration));
        }
    }

    public double getDuration() {
        return this.duration;
    }

    public double getMinMag() {
        return this.minMag;
    }

    @Override
    public double getMinDistance(Site site) {
        return LocationUtils.horzDistance(site.getLocation(), this.location) - this.maxLength / 2.0;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

