/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl;

import java.io.Serializable;
import java.util.ArrayList;
import org.opensha.commons.calc.magScalingRelations.MagAreaRelationship;
import org.opensha.commons.calc.magScalingRelations.MagLengthRelationship;
import org.opensha.commons.calc.magScalingRelations.MagScalingRelationship;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.griddedForecast.HypoMagFreqDistAtLoc;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class PointToLineSource_old
extends ProbEqkSource
implements Serializable {
    protected static String C = new String("PointToLineEqkSource");
    protected static String NAME = "Point-to-Line Source";
    protected boolean D = false;
    protected ArrayList<ProbEqkRupture> probEqkRuptureList;
    protected ArrayList<Double> rates;
    protected Location location;
    protected double duration = Double.NaN;
    protected double minMag = Double.NaN;
    protected double maxLength = 0.0;

    public PointToLineSource_old() {
    }

    public PointToLineSource_old(HypoMagFreqDistAtLoc hypoMagFreqDistAtLoc, ArbitrarilyDiscretizedFunc aveRupTopVersusMag, double defaultHypoDepth, MagScalingRelationship magScalingRel, double lowerSeisDepth, double duration, double minMag) {
        this.duration = duration;
        this.isPoissonian = true;
        this.location = hypoMagFreqDistAtLoc.getLocation();
        this.probEqkRuptureList = new ArrayList();
        this.rates = new ArrayList();
        IncrementalMagFreqDist[] magFreqDists = hypoMagFreqDistAtLoc.getMagFreqDistList();
        FocalMechanism[] focalMechanisms = hypoMagFreqDistAtLoc.getFocalMechanismList();
        for (int i = 0; i < magFreqDists.length; ++i) {
            this.mkAndAddRuptures(this.location, magFreqDists[i], focalMechanisms[i], aveRupTopVersusMag, defaultHypoDepth, magScalingRel, lowerSeisDepth, duration, minMag, 1.0);
        }
    }

    public PointToLineSource_old(HypoMagFreqDistAtLoc hypoMagFreqDistAtLoc, ArbitrarilyDiscretizedFunc aveRupTopVersusMag, double defaultHypoDepth, MagScalingRelationship magScalingRel, double lowerSeisDepth, double duration, double minMag, int numStrikes, double firstStrike) {
        this.duration = duration;
        this.isPoissonian = true;
        this.location = hypoMagFreqDistAtLoc.getLocation();
        this.probEqkRuptureList = new ArrayList();
        this.rates = new ArrayList();
        double deltaStrike = 180 / numStrikes;
        double[] strike = new double[numStrikes];
        for (int n = 0; n < numStrikes; ++n) {
            strike[n] = firstStrike + (double)n * deltaStrike;
        }
        IncrementalMagFreqDist[] magFreqDists = hypoMagFreqDistAtLoc.getMagFreqDistList();
        FocalMechanism[] focalMechanisms = hypoMagFreqDistAtLoc.getFocalMechanismList();
        for (int i = 0; i < magFreqDists.length; ++i) {
            FocalMechanism focalMech = focalMechanisms[i].copy();
            for (int s = 0; s < numStrikes; ++s) {
                focalMech.setStrike(strike[s]);
                double weight = 1.0 / (double)numStrikes;
                this.mkAndAddRuptures(this.location, magFreqDists[i], focalMechanisms[i], aveRupTopVersusMag, defaultHypoDepth, magScalingRel, lowerSeisDepth, duration, minMag, weight);
            }
        }
    }

    protected void mkAndAddRuptures(Location location, IncrementalMagFreqDist magFreqDist, FocalMechanism focalMech, ArbitrarilyDiscretizedFunc aveRupTopVersusMag, double defaultHypoDepth, MagScalingRelationship magScalingRel, double lowerSeisDepth, double duration, double minMag, double weight) {
        double dip = focalMech.getDip();
        double strike = focalMech.getStrike();
        boolean isStrikeRandom = false;
        if (Double.isNaN(strike)) {
            isStrikeRandom = true;
        }
        for (int m = 0; m < magFreqDist.size(); ++m) {
            double mag = magFreqDist.getX(m);
            double rate = magFreqDist.getY(m);
            double prob = 1.0 - Math.exp(-rate * weight * duration);
            if (!(prob > 0.0) || !(mag >= minMag)) continue;
            double depth = mag < aveRupTopVersusMag.getMinX() ? defaultHypoDepth : aveRupTopVersusMag.getClosestYtoX(mag);
            Location loc = new Location(location.getLatitude(), location.getLongitude(), depth);
            double rupLength = this.getRupLength(mag, aveRupTopVersusMag, lowerSeisDepth, dip, magScalingRel);
            if (rupLength > this.maxLength) {
                this.maxLength = rupLength;
            }
            if (isStrikeRandom) {
                strike = (Math.random() - 0.5) * 180.0;
            }
            LocationVector dir = new LocationVector(strike, rupLength / 2.0, 0.0);
            Location loc1 = LocationUtils.location(loc, dir);
            dir.setAzimuth(strike - 180.0);
            Location loc2 = LocationUtils.location(loc, dir);
            FaultTrace fltTrace = new FaultTrace(null);
            fltTrace.add(loc1);
            fltTrace.add(loc2);
            StirlingGriddedSurface surf = new StirlingGriddedSurface(fltTrace, dip, depth, depth, 1.0);
            ProbEqkRupture rupture = new ProbEqkRupture();
            rupture.setMag(mag);
            rupture.setAveRake(focalMech.getRake());
            rupture.setRuptureSurface(surf);
            rupture.setProbability(prob);
            if (this.D) {
                System.out.println("\tstrike\t" + strike + "\tmag\t" + (float)mag + "\trate\t" + (float)rate + "\tprob\t" + (float)prob + "\tweight\t" + (float)weight);
            }
            this.probEqkRuptureList.add(rupture);
            this.rates.add(rate * weight);
        }
    }

    private double getRupLength(double mag, ArbitrarilyDiscretizedFunc aveRupTopVersusMag, double lowerSeisDepth, double dip, MagScalingRelationship magScalingRel) {
        double rupLength;
        if (magScalingRel instanceof MagAreaRelationship) {
            double area;
            double ddw = (aveRupTopVersusMag.getClosestYtoX(mag) - lowerSeisDepth) / Math.sin(dip * Math.PI / 180.0);
            rupLength = ddw > Math.sqrt(area = magScalingRel.getMedianScale(mag)) ? ddw : area / ddw;
        } else if (magScalingRel instanceof MagLengthRelationship) {
            rupLength = magScalingRel.getMedianScale(mag);
        } else {
            throw new RuntimeException("bad type of MagScalingRelationship");
        }
        return rupLength;
    }

    @Override
    public LocationList getAllSourceLocs() {
        LocationList locList = new LocationList();
        for (int r = 0; r < this.getNumRuptures(); ++r) {
            locList.addAll(this.probEqkRuptureList.get(r).getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface());
        }
        return locList;
    }

    @Override
    public AbstractEvenlyGriddedSurface getSourceSurface() {
        throw new RuntimeException("Method not supported");
    }

    @Override
    public int getNumRuptures() {
        return this.probEqkRuptureList.size();
    }

    @Override
    public ProbEqkRupture getRupture(int nthRupture) {
        return this.probEqkRuptureList.get(nthRupture);
    }

    public void setDuration(double duration) {
        this.duration = duration;
        for (int i = 0; i < this.probEqkRuptureList.size(); ++i) {
            this.probEqkRuptureList.get(i).setProbability(1.0 - Math.exp(-this.rates.get(i).doubleValue() * duration));
        }
    }

    public double getDuration() {
        return this.duration;
    }

    public double getMinMag() {
        return this.minMag;
    }

    @Override
    public double getMinDistance(Site site) {
        return LocationUtils.horzDistance(site.getLocation(), this.location) - this.maxLength / 2.0;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

