/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl;

import java.util.ArrayList;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.FaultRuptureSource;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurfaceWithSubsets;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.param.SimpleFaultParameter;

public class SingleFaultRuptureERF
extends AbstractERF {
    private static String C = "SingleFaultRuptureERF";
    private boolean D = false;
    public static final String NAME = "Single Fault Rupture ERF";
    private FaultRuptureSource source;
    public static final String MAG_PARAM_NAME = "Magnitude";
    private static final String MAG_PARAM_INFO = "The  magnitude of the rupture";
    private static final String MAG_PARAM_UNITS = null;
    private Double MAG_PARAM_MIN = 5.0;
    private Double MAG_PARAM_MAX = 10.0;
    private Double MAG_PARAM_DEFAULT = 7.0;
    public static final String PROB_PARAM_NAME = "Probability";
    private static final String PROB_PARAM_INFO = "The probability of the rupture";
    private static final String PROB_PARAM_UNITS = null;
    private Double PROB_PARAM_MIN = 0.0;
    private Double PROB_PARAM_MAX = 1.0;
    private Double PROB_PARAM_DEFAULT = 1.0;
    public static final String FAULT_PARAM_NAME = "Fault Parameter";
    public static final String RAKE_PARAM_NAME = "Rake";
    private static final String RAKE_PARAM_INFO = "The rake of the rupture (direction of slip)";
    private static final String RAKE_PARAM_UNITS = "degrees";
    private Double RAKE_PARAM_MIN = -180.0;
    private Double RAKE_PARAM_MAX = 180.0;
    private Double RAKE_PARAM_DEFAULT = 0.0;
    DoubleParameter magParam;
    DoubleParameter probParam;
    SimpleFaultParameter faultParam;
    DoubleParameter rakeParam;

    public SingleFaultRuptureERF() {
        this.timeSpan = null;
        this.magParam = new DoubleParameter(MAG_PARAM_NAME, this.MAG_PARAM_MIN, this.MAG_PARAM_MAX, MAG_PARAM_UNITS, this.MAG_PARAM_DEFAULT);
        this.magParam.setInfo(MAG_PARAM_INFO);
        this.probParam = new DoubleParameter(PROB_PARAM_NAME, this.PROB_PARAM_MIN, this.PROB_PARAM_MAX, PROB_PARAM_UNITS, this.PROB_PARAM_DEFAULT);
        this.probParam.setInfo(PROB_PARAM_INFO);
        this.faultParam = new SimpleFaultParameter(FAULT_PARAM_NAME);
        this.rakeParam = new DoubleParameter(RAKE_PARAM_NAME, this.RAKE_PARAM_MIN, this.RAKE_PARAM_MAX, RAKE_PARAM_UNITS, this.RAKE_PARAM_DEFAULT);
        this.rakeParam.setInfo(RAKE_PARAM_INFO);
        this.adjustableParams.addParameter(this.magParam);
        this.adjustableParams.addParameter(this.probParam);
        this.adjustableParams.addParameter(this.rakeParam);
        this.adjustableParams.addParameter(this.faultParam);
        this.rakeParam.addParameterChangeListener(this);
        this.faultParam.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.probParam.addParameterChangeListener(this);
    }

    public SingleFaultRuptureERF(EqkRupture eqkRupture, double probability) {
        this();
        this.magParam.setValue(eqkRupture.getMag());
        this.rakeParam.setValue(eqkRupture.getAveRake());
        this.faultParam.setValue(eqkRupture.getRuptureSurface());
        this.probParam.setValue(probability);
        this.updateForecast();
    }

    @Override
    public void updateForecast() {
        String S = C + "updateForecast::";
        if (this.parameterChangeFlag) {
            this.source = new FaultRuptureSource((double)((Double)this.magParam.getValue()), (RuptureSurface)((AbstractEvenlyGriddedSurfaceWithSubsets)this.faultParam.getValue()), (double)((Double)this.rakeParam.getValue()), (double)((Double)this.probParam.getValue()));
            this.parameterChangeFlag = false;
        }
    }

    @Override
    public ProbEqkSource getSource(int iSource) {
        if (iSource != 0) {
            throw new RuntimeException("Only 1 source available, iSource should be equal to 0");
        }
        return this.source;
    }

    @Override
    public int getNumSources() {
        return 1;
    }

    public ArrayList getSourceList() {
        ArrayList<FaultRuptureSource> v = new ArrayList<FaultRuptureSource>();
        v.add(this.source);
        return v;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setTimeSpan(TimeSpan time) {
    }
}

