/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis;

import java.io.FileWriter;
import java.util.HashMap;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.MeanUCERF2.MeanUCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2_TimeIndependentEpistemicList;

public class CompareUCERF_SourceRates {
    public static void main(String[] args) {
        double duration = 1.0;
        try {
            UCERF2_TimeIndependentEpistemicList erfList = new UCERF2_TimeIndependentEpistemicList();
            int numERFs = erfList.getNumERFs();
            erfList.getTimeSpan().setDuration(duration);
            HashMap<String, Double> srcRateMapping = new HashMap<String, Double>();
            for (int erfIndex = 0; erfIndex < numERFs; ++erfIndex) {
                UCERF2 ucerf2 = (UCERF2)erfList.getERF(erfIndex);
                double wt = erfList.getERF_RelativeWeight(erfIndex);
                int numSources = ucerf2.getNumSources();
                for (int srcIndex = 0; srcIndex < numSources; ++srcIndex) {
                    ProbEqkSource source = ucerf2.getSource(srcIndex);
                    int numRups = source.getNumRuptures();
                    double meanAnnualRate = 0.0;
                    for (int rupIndex = 0; rupIndex < numRups; ++rupIndex) {
                        meanAnnualRate += source.getRupture(rupIndex).getMeanAnnualRate(duration);
                    }
                    String srcName = source.getName();
                    if (!srcRateMapping.containsKey(srcName)) {
                        srcRateMapping.put(srcName, 0.0);
                    }
                    double newRate = (Double)srcRateMapping.get(srcName) + wt * meanAnnualRate;
                    srcRateMapping.put(srcName, newRate);
                }
            }
            FileWriter fw = new FileWriter("LogicTreeUCERF2.txt");
            for (String name : srcRateMapping.keySet()) {
                fw.write(name + "\t" + String.valueOf(srcRateMapping.get(name)) + "\n");
            }
            fw.close();
            MeanUCERF2 meanUCERF2 = new MeanUCERF2();
            meanUCERF2.setParameter("Probability Model", "Poisson");
            meanUCERF2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_EXCLUDE);
            meanUCERF2.getTimeSpan().setDuration(duration);
            fw = new FileWriter("MeanUCERF2.txt");
            meanUCERF2.updateForecast();
            int numSources = meanUCERF2.getNumSources();
            for (int srcIndex = 0; srcIndex < numSources; ++srcIndex) {
                ProbEqkSource source = meanUCERF2.getSource(srcIndex);
                int numRups = source.getNumRuptures();
                double meanAnnualRate = 0.0;
                for (int rupIndex = 0; rupIndex < numRups; ++rupIndex) {
                    meanAnnualRate += source.getRupture(rupIndex).getMeanAnnualRate(duration);
                }
                fw.write(source.getName() + "\t" + meanAnnualRate + "\n");
            }
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

