/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis;

import java.io.FileWriter;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.Location;
import org.opensha.sha.earthquake.griddedForecast.HypoMagFreqDistAtLoc;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.MeanUCERF2.MeanUCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis.ERF_ToGriddedParticipationRatesMFD_Forecast;

public class GenerateFilesForParticipationProbMaps {
    public static void main(String[] args) {
        int duration = 30;
        double[] mags = new double[]{5.0, 6.0, 6.5, 6.7, 7.1, 7.2, 7.5, 7.7, 8.0};
        CaliforniaRegions.RELM_TESTING_GRIDDED evenlyGriddedRegion = new CaliforniaRegions.RELM_TESTING_GRIDDED();
        MeanUCERF2 meanUCERF2 = new MeanUCERF2();
        meanUCERF2.setParameter("Rupture Offset", 5.0);
        meanUCERF2.getParameter("Probability Model").setValue("Poisson");
        meanUCERF2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_INCLUDE);
        meanUCERF2.setParameter(UCERF2.BACK_SEIS_RUP_NAME, UCERF2.BACK_SEIS_RUP_CROSSHAIR);
        meanUCERF2.getTimeSpan().setDuration(duration);
        meanUCERF2.updateForecast();
        double minMag = 5.0;
        double maxMag = 9.0;
        int numMag = 41;
        System.out.println("Poisson------------");
        ERF_ToGriddedParticipationRatesMFD_Forecast griddedHypoMagFeqDistForecast1 = new ERF_ToGriddedParticipationRatesMFD_Forecast(meanUCERF2, evenlyGriddedRegion, minMag, maxMag, numMag, duration);
        GenerateFilesForParticipationProbMaps.generateProbabilityFiles("UCERF2_Poiss", griddedHypoMagFeqDistForecast1, mags, duration);
        System.out.println("Preferred Blend------------");
        meanUCERF2.getParameter("Probability Model").setValue("WGCEP Preferred Blend");
        meanUCERF2.getTimeSpan().setDuration(duration);
        meanUCERF2.updateForecast();
        ERF_ToGriddedParticipationRatesMFD_Forecast griddedHypoMagFeqDistForecast2 = new ERF_ToGriddedParticipationRatesMFD_Forecast(meanUCERF2, evenlyGriddedRegion, minMag, maxMag, numMag, duration);
        GenerateFilesForParticipationProbMaps.generateProbabilityFiles("UCERF2_PrefBlend", griddedHypoMagFeqDistForecast2, mags, duration);
        GenerateFilesForParticipationProbMaps.generateRatioFiles("UCERF2_PrefBlend_Poiss", griddedHypoMagFeqDistForecast2, griddedHypoMagFeqDistForecast1, mags, duration);
    }

    public static void generateRatioFiles(String fileNamePrefix, ERF_ToGriddedParticipationRatesMFD_Forecast griddedHypoMagFeqDistForecast1, ERF_ToGriddedParticipationRatesMFD_Forecast griddedHypoMagFeqDistForecast2, double[] mags, double duration) {
        try {
            FileWriter[] fileWriters = new FileWriter[mags.length];
            for (int magIndex = 0; magIndex < mags.length; ++magIndex) {
                fileWriters[magIndex] = new FileWriter(fileNamePrefix + "_Ratio" + mags[magIndex] + ".txt");
            }
            int numLocs = griddedHypoMagFeqDistForecast1.getNumHypoLocs();
            for (int i = 0; i < numLocs; ++i) {
                HypoMagFreqDistAtLoc mfdAtLoc1 = griddedHypoMagFeqDistForecast1.getHypoMagFreqDistAtLoc(i);
                HypoMagFreqDistAtLoc mfdAtLoc2 = griddedHypoMagFeqDistForecast2.getHypoMagFreqDistAtLoc(i);
                Location loc = mfdAtLoc1.getLocation();
                EvenlyDiscretizedFunc cumDist1 = mfdAtLoc1.getFirstMagFreqDist().getCumRateDist();
                EvenlyDiscretizedFunc cumDist2 = mfdAtLoc2.getFirstMagFreqDist().getCumRateDist();
                float latitude = (float)loc.getLatitude();
                float longitude = (float)loc.getLongitude();
                for (int magIndex = 0; magIndex < mags.length; ++magIndex) {
                    double predictedRate1 = cumDist1.getInterpolatedY(mags[magIndex]);
                    double probability1 = 1.0 - Math.exp(-predictedRate1 * duration);
                    double predictedRate2 = cumDist2.getInterpolatedY(mags[magIndex]);
                    double probability2 = 1.0 - Math.exp(-predictedRate2 * duration);
                    fileWriters[magIndex].write(latitude + "\t" + longitude + "\t" + (float)(probability1 / probability2) + "\n");
                }
            }
            for (int magIndex = 0; magIndex < mags.length; ++magIndex) {
                fileWriters[magIndex].close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void generateProbabilityFiles(String fileNamePrefix, ERF_ToGriddedParticipationRatesMFD_Forecast participationRatesMFD_Forecast, double[] mags, double duration) {
        try {
            FileWriter[] fileWriters = new FileWriter[mags.length];
            for (int magIndex = 0; magIndex < mags.length; ++magIndex) {
                fileWriters[magIndex] = new FileWriter(fileNamePrefix + "_Pred" + mags[magIndex] + ".txt");
            }
            int numLocs = participationRatesMFD_Forecast.getNumHypoLocs();
            for (int i = 0; i < numLocs; ++i) {
                HypoMagFreqDistAtLoc mfdAtLoc = participationRatesMFD_Forecast.getHypoMagFreqDistAtLoc(i);
                Location loc = mfdAtLoc.getLocation();
                EvenlyDiscretizedFunc cumDist = mfdAtLoc.getFirstMagFreqDist().getCumRateDist();
                float latitude = (float)loc.getLatitude();
                float longitude = (float)loc.getLongitude();
                for (int magIndex = 0; magIndex < mags.length; ++magIndex) {
                    double predictedRate = cumDist.getInterpolatedY(mags[magIndex]);
                    double probability = 1.0 - Math.exp(-predictedRate * duration);
                    fileWriters[magIndex].write(latitude + "\t" + longitude + "\t" + (float)probability + "\n");
                }
            }
            for (int magIndex = 0; magIndex < mags.length; ++magIndex) {
                fileWriters[magIndex].close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

