/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.A_Faults.A_FaultSegmentedSourceGenerator;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UnsegmentedSource;

public class NSHMP_FileWriter {
    private UCERF2 ucerf2;

    public NSHMP_FileWriter() {
        this.ucerf2 = new UCERF2();
    }

    public NSHMP_FileWriter(UCERF2 ucerf2) {
        this.ucerf2 = ucerf2;
    }

    public void writeNSHMP_SrcFiles(String dirName) {
        File file = new File(dirName);
        if (!file.isDirectory()) {
            file.mkdirs();
        }
        this.writeNSHMP_SrcFilesForDefModel(dirName, "D2.1");
        this.writeNSHMP_SrcFilesForDefModel(dirName, "D2.2");
        this.writeNSHMP_SrcFilesForDefModel(dirName, "D2.3");
        this.writeNSHMP_SrcFilesForDefModel(dirName, "D2.4");
        this.writeNSHMP_SrcFilesForDefModel(dirName, "D2.5");
        this.writeNSHMP_SrcFilesForDefModel(dirName, "D2.6");
    }

    public void writeNSHMP_SrcFilesForDefModel(String dirName, String defModelName) {
        this.ucerf2.setParamDefaults();
        this.ucerf2.setParameter("Probability Model", "Poisson");
        this.ucerf2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_EXCLUDE);
        this.ucerf2.getParameter("Deformation Model").setValue(defModelName);
        this.ucerf2.updateForecast();
        this.writeNSHMP_SegmentedAfaultSrcFile(dirName + "/aFault_MoBal_EllB_" + defModelName);
        this.ucerf2.getParameter("Mag-Area Relationship").setValue("Hanks & Bakun (2002)");
        this.ucerf2.updateForecast();
        this.writeNSHMP_SegmentedAfaultSrcFile(dirName + "/aFault_MoBal_HB_" + defModelName);
        this.ucerf2.setParamDefaults();
        this.ucerf2.setParameter("Probability Model", "Poisson");
        this.ucerf2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_EXCLUDE);
        this.ucerf2.getParameter("Deformation Model").setValue(defModelName);
        this.ucerf2.getParameter("Wt On A-Priori Rates").setValue(1.0E10);
        this.ucerf2.getParameter("Min Fraction for Unknown Ruptures").setValue(0.0);
        this.ucerf2.getParameter("Min Fraction for Unlikely Ruptures").setValue(0.0);
        this.ucerf2.updateForecast();
        this.writeNSHMP_SegmentedAfaultSrcFile(dirName + "/aFault_aPriori_EllB_" + defModelName);
        this.ucerf2.getParameter("Mag-Area Relationship").setValue("Hanks & Bakun (2002)");
        this.ucerf2.updateForecast();
        this.writeNSHMP_SegmentedAfaultSrcFile(dirName + "/aFault_aPriori_HB_" + defModelName);
        this.ucerf2.setParamDefaults();
        this.ucerf2.setParameter("Probability Model", "Poisson");
        this.ucerf2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_EXCLUDE);
        this.ucerf2.getParameter("Deformation Model").setValue(defModelName);
        this.ucerf2.getParameter("A-Fault Solution Type").setValue("Unsegmented Model");
        this.ucerf2.updateForecast();
        this.writeNSHMP_UnsegmentedAfaultSrcFile(dirName + "/aFault_unseg_EllB_" + defModelName);
        this.writeNSHMP_BfaultSrcFiles(dirName + "/bFault_stitched_EllB_" + defModelName);
        this.ucerf2.getParameter("Mag-Area Relationship").setValue("Hanks & Bakun (2002)");
        this.ucerf2.updateForecast();
        this.writeNSHMP_UnsegmentedAfaultSrcFile(dirName + "/aFault_unseg_HB_" + defModelName);
        this.writeNSHMP_BfaultSrcFiles(dirName + "/bFault_stitched_HB_" + defModelName);
        this.ucerf2.setParamDefaults();
        this.ucerf2.setParameter("Probability Model", "Poisson");
        this.ucerf2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_EXCLUDE);
        this.ucerf2.getParameter("Deformation Model").setValue(defModelName);
        this.ucerf2.getParameter("Connect More B Faults?").setValue(false);
        this.ucerf2.updateForecast();
        this.writeNSHMP_BfaultSrcFiles(dirName + "/bFault_unstitched_EllB_" + defModelName);
        this.ucerf2.getParameter("Mag-Area Relationship").setValue("Hanks & Bakun (2002)");
        this.ucerf2.updateForecast();
        this.writeNSHMP_BfaultSrcFiles(dirName + "/bFault_unstitched_HB_" + defModelName);
    }

    private void writeNSHMP_SegmentedAfaultSrcFile(String fileNamePrefix) {
        try {
            ArrayList aFaultSourceGenerators = this.ucerf2.get_A_FaultSourceGenerators();
            int numSources = aFaultSourceGenerators.size();
            FileWriter fw = new FileWriter(fileNamePrefix + ".txt");
            for (int iSrc = 0; iSrc < numSources; ++iSrc) {
                A_FaultSegmentedSourceGenerator segmentedSource = (A_FaultSegmentedSourceGenerator)aFaultSourceGenerators.get(iSrc);
                String faultName = segmentedSource.getFaultSegmentData().getFaultName();
                fw.write(segmentedSource.getNSHMP_SrcFileString());
            }
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeNSHMP_UnsegmentedAfaultSrcFile(String fileName) {
        try {
            ArrayList aFaultSourceGenerators = this.ucerf2.get_A_FaultSourceGenerators();
            int numSources = aFaultSourceGenerators.size();
            FileWriter fw = new FileWriter(fileName + ".txt");
            for (int iSrc = 0; iSrc < numSources; ++iSrc) {
                UnsegmentedSource unsegmentedSource = (UnsegmentedSource)aFaultSourceGenerators.get(iSrc);
                fw.write(unsegmentedSource.getNSHMP_GR_SrcFileString());
            }
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeNSHMP_BfaultSrcFiles(String fileName) {
        try {
            ArrayList bFaultSources = this.ucerf2.get_B_FaultSources();
            int numSources = bFaultSources.size();
            FileWriter fw = new FileWriter(fileName + "_GR.txt");
            FileWriter fwChar = new FileWriter(fileName + "_Char.txt");
            for (int iSrc = 0; iSrc < numSources; ++iSrc) {
                UnsegmentedSource unsegmentedSource = (UnsegmentedSource)bFaultSources.get(iSrc);
                if (unsegmentedSource.getFaultSegmentData().getFaultName().equalsIgnoreCase("San Andreas (Creeping Segment)")) continue;
                fw.write(unsegmentedSource.getNSHMP_GR_SrcFileString());
                fwChar.write(unsegmentedSource.getNSHMP_Char_SrcFileString());
            }
            fw.close();
            fwChar.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        NSHMP_FileWriter nshmpFileWriter = new NSHMP_FileWriter();
        nshmpFileWriter.writeNSHMP_SrcFiles("NSHMP_March25");
    }
}

