/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis;

import java.awt.Color;
import java.util.ArrayList;
import org.jfree.data.Range;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.function.XY_DataSetList;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotPreferences;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.A_Faults.A_FaultSegmentedSourceGenerator;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UnsegmentedSource;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.A_FaultsFetcher;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.UCERF1MfdReader;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui.A_FaultsMFD_Plotter;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;

public class UCERF1ComparisonPlotter {
    private UCERF2 ucerf2;

    public UCERF1ComparisonPlotter(UCERF2 ucerf2) {
        this.ucerf2 = ucerf2;
    }

    public UCERF1ComparisonPlotter() {
        this.ucerf2 = new UCERF2();
    }

    public void plot_SJ_SSAF_FaultsDefModels() {
        ArrayList<XY_DataSetList> aFaultIncrRateFuncList = new ArrayList<XY_DataSetList>();
        ArrayList<XY_DataSetList> aFaultCumRateFuncList = new ArrayList<XY_DataSetList>();
        int sanJacintoIndex = 2;
        int soSAF_Index = 4;
        XY_DataSetList sjIncrRateFuncList = new XY_DataSetList();
        XY_DataSetList ssafIncrRateFuncList = new XY_DataSetList();
        XY_DataSetList sjCumRateFuncList = new XY_DataSetList();
        XY_DataSetList ssafCumRateFuncList = new XY_DataSetList();
        System.out.println("Doing Deformation model 2.1");
        this.fillCumAndIncrFuncListForDefModel("D2.1", aFaultIncrRateFuncList, aFaultCumRateFuncList);
        int numCurvesAdded = aFaultIncrRateFuncList.get(sanJacintoIndex).size();
        sjIncrRateFuncList.add((XY_DataSet)aFaultIncrRateFuncList.get(sanJacintoIndex).get(numCurvesAdded - 1));
        ssafIncrRateFuncList.add((XY_DataSet)aFaultIncrRateFuncList.get(soSAF_Index).get(numCurvesAdded - 1));
        sjCumRateFuncList.add((XY_DataSet)aFaultCumRateFuncList.get(sanJacintoIndex).get(numCurvesAdded - 1));
        ssafCumRateFuncList.add((XY_DataSet)aFaultCumRateFuncList.get(soSAF_Index).get(numCurvesAdded - 1));
        System.out.println("Doing Deformation model 2.2");
        aFaultIncrRateFuncList = new ArrayList();
        aFaultCumRateFuncList = new ArrayList();
        this.fillCumAndIncrFuncListForDefModel("D2.2", aFaultIncrRateFuncList, aFaultCumRateFuncList);
        numCurvesAdded = aFaultIncrRateFuncList.get(sanJacintoIndex).size();
        sjIncrRateFuncList.add((XY_DataSet)aFaultIncrRateFuncList.get(sanJacintoIndex).get(numCurvesAdded - 1));
        ssafIncrRateFuncList.add((XY_DataSet)aFaultIncrRateFuncList.get(soSAF_Index).get(numCurvesAdded - 1));
        sjCumRateFuncList.add((XY_DataSet)aFaultCumRateFuncList.get(sanJacintoIndex).get(numCurvesAdded - 1));
        ssafCumRateFuncList.add((XY_DataSet)aFaultCumRateFuncList.get(soSAF_Index).get(numCurvesAdded - 1));
        System.out.println("Doing Deformation model 2.3");
        aFaultIncrRateFuncList = new ArrayList();
        aFaultCumRateFuncList = new ArrayList();
        this.fillCumAndIncrFuncListForDefModel("D2.3", aFaultIncrRateFuncList, aFaultCumRateFuncList);
        numCurvesAdded = aFaultIncrRateFuncList.get(sanJacintoIndex).size();
        sjIncrRateFuncList.add((XY_DataSet)aFaultIncrRateFuncList.get(sanJacintoIndex).get(numCurvesAdded - 1));
        ssafIncrRateFuncList.add((XY_DataSet)aFaultIncrRateFuncList.get(soSAF_Index).get(numCurvesAdded - 1));
        sjCumRateFuncList.add((XY_DataSet)aFaultCumRateFuncList.get(sanJacintoIndex).get(numCurvesAdded - 1));
        ssafCumRateFuncList.add((XY_DataSet)aFaultCumRateFuncList.get(soSAF_Index).get(numCurvesAdded - 1));
        String name = "Wt Avg MFD";
        IncrementalMagFreqDist sjWtAveMFD = ((IncrementalMagFreqDist)sjIncrRateFuncList.get(0)).deepClone();
        IncrementalMagFreqDist ssafWtAveMFD = ((IncrementalMagFreqDist)ssafIncrRateFuncList.get(0)).deepClone();
        XY_DataSet func = (XY_DataSet)sjIncrRateFuncList.get(0);
        for (int imag = 0; imag < func.size(); ++imag) {
            double val1 = 0.5 * ((XY_DataSet)sjIncrRateFuncList.get(0)).getY(imag) + 0.2 * ((XY_DataSet)sjIncrRateFuncList.get(1)).getY(imag) + 0.3 * ((XY_DataSet)sjIncrRateFuncList.get(2)).getY(imag);
            sjWtAveMFD.set(func.getX(imag), val1);
            val1 = 0.5 * ((XY_DataSet)ssafIncrRateFuncList.get(0)).getY(imag) + 0.2 * ((XY_DataSet)ssafIncrRateFuncList.get(1)).getY(imag) + 0.3 * ((XY_DataSet)ssafIncrRateFuncList.get(2)).getY(imag);
            ssafWtAveMFD.set(func.getX(imag), val1);
        }
        sjWtAveMFD.setName(name);
        sjIncrRateFuncList.add(sjWtAveMFD);
        EvenlyDiscretizedFunc cumMFD = sjWtAveMFD.getCumRateDistWithOffset();
        cumMFD.setName(name);
        sjCumRateFuncList.add(cumMFD);
        ssafWtAveMFD.setName(name);
        ssafIncrRateFuncList.add(ssafWtAveMFD);
        cumMFD = ssafWtAveMFD.getCumRateDistWithOffset();
        cumMFD.setName(name);
        ssafCumRateFuncList.add(cumMFD);
        PlotCurveCharacterstics PLOT_CHAR1 = new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, null, 4.0f, Color.BLACK);
        PlotCurveCharacterstics PLOT_CHAR2 = new PlotCurveCharacterstics(PlotLineType.DOTTED, 2.0f, null, 4.0f, Color.BLACK);
        PlotCurveCharacterstics PLOT_CHAR3 = new PlotCurveCharacterstics(PlotLineType.DOTTED_AND_DASHED, 2.0f, null, 4.0f, Color.BLACK);
        PlotCurveCharacterstics PLOT_CHAR4 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 4.0f, Color.BLACK);
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(PLOT_CHAR1);
        plotChars.add(PLOT_CHAR2);
        plotChars.add(PLOT_CHAR3);
        plotChars.add(PLOT_CHAR4);
        this.makePlot(sjIncrRateFuncList, plotChars, "San Jacinto");
        this.makePlot(ssafIncrRateFuncList, plotChars, "S San Andreas");
        this.makePlot(sjCumRateFuncList, plotChars, "San Jacinto");
        this.makePlot(ssafCumRateFuncList, plotChars, "S San Andreas");
    }

    private void makePlot(XY_DataSetList sjIncrRateFuncList, ArrayList plotChars, String label) {
        ArrayList<DiscretizedFunc> aList = new ArrayList<DiscretizedFunc>();
        for (int i = 0; i < sjIncrRateFuncList.size(); ++i) {
            aList.add((DiscretizedFunc)sjIncrRateFuncList.get(i));
        }
        A_FaultsMFD_Plotter aFaultsPlotter = new A_FaultsMFD_Plotter(aList, false);
        aFaultsPlotter.setPlottingFeatures(plotChars);
        PlotSpec spec = aFaultsPlotter.getPlotSpec();
        spec.setTitle(label);
        GraphWindow graphWindow = new GraphWindow(spec, PlotPreferences.getDefault(), aFaultsPlotter.getXLog(), aFaultsPlotter.getYLog(), new Range(aFaultsPlotter.getUserMinX(), aFaultsPlotter.getUserMaxX()), new Range(aFaultsPlotter.getUserMinY(), aFaultsPlotter.getUserMaxY()));
        graphWindow.setVisible(true);
    }

    public void plotA_FaultMFDs_forReport(String defModelName) {
        GraphWindow graphWindow;
        PlotSpec spec;
        A_FaultsMFD_Plotter aFaultsPlotter;
        ArrayList<DiscretizedFunc> funcArrayList;
        String faultName;
        XY_DataSetList funcList;
        int i;
        ArrayList<XY_DataSetList> aFaultIncrRateFuncList = new ArrayList<XY_DataSetList>();
        ArrayList<XY_DataSetList> aFaultCumRateFuncList = new ArrayList<XY_DataSetList>();
        ArrayList<String> faultNames = this.fillCumAndIncrFuncListForDefModel(defModelName, aFaultIncrRateFuncList, aFaultCumRateFuncList);
        String name = "UCERF1 MFD";
        for (i = 0; i < aFaultIncrRateFuncList.size(); ++i) {
            String faultName2 = faultNames.get(i);
            ArbitrarilyDiscretizedFunc ucerf1Rate = UCERF1MfdReader.getUCERF1IncrementalMFD(faultName2);
            if (ucerf1Rate.size() == 0) {
                ucerf1Rate.set(0.0, 0.0);
            }
            aFaultIncrRateFuncList.get(i).add(ucerf1Rate);
            ucerf1Rate.setName(name);
            ArbitrarilyDiscretizedFunc cumMFD = UCERF1MfdReader.getUCERF1CumMFD(faultName2);
            if (cumMFD.size() == 0) {
                cumMFD.set(0.0, 0.0);
            }
            cumMFD.setName(name);
            aFaultCumRateFuncList.get(i).add(cumMFD);
        }
        for (i = 0; i < aFaultIncrRateFuncList.size(); ++i) {
            funcList = aFaultIncrRateFuncList.get(i);
            faultName = faultNames.get(i);
            funcArrayList = new ArrayList<DiscretizedFunc>();
            funcArrayList.add((DiscretizedFunc)funcList.get(funcList.size() - 1));
            funcArrayList.add((DiscretizedFunc)funcList.get(funcList.size() - 2));
            for (int j = 0; j < funcList.size() - 2; ++j) {
                funcArrayList.add((DiscretizedFunc)funcList.get(j));
            }
            aFaultsPlotter = new A_FaultsMFD_Plotter(funcArrayList, false);
            spec = aFaultsPlotter.getPlotSpec();
            spec.setTitle(faultName);
            graphWindow = new GraphWindow(spec, PlotPreferences.getDefault(), aFaultsPlotter.getXLog(), aFaultsPlotter.getYLog(), new Range(aFaultsPlotter.getUserMinX(), aFaultsPlotter.getUserMaxX()), new Range(aFaultsPlotter.getUserMinY(), aFaultsPlotter.getUserMaxY()));
            graphWindow.setVisible(true);
        }
        for (i = 0; i < aFaultCumRateFuncList.size(); ++i) {
            funcList = aFaultCumRateFuncList.get(i);
            faultName = faultNames.get(i);
            funcArrayList = new ArrayList();
            funcArrayList.add((DiscretizedFunc)funcList.get(funcList.size() - 1));
            funcArrayList.add((DiscretizedFunc)funcList.get(funcList.size() - 2));
            for (int j = 0; j < funcList.size() - 2; ++j) {
                funcArrayList.add((DiscretizedFunc)funcList.get(j));
            }
            aFaultsPlotter = new A_FaultsMFD_Plotter(funcArrayList, false);
            spec = aFaultsPlotter.getPlotSpec();
            spec.setTitle(faultName);
            graphWindow = new GraphWindow(spec, PlotPreferences.getDefault(), aFaultsPlotter.getXLog(), aFaultsPlotter.getYLog(), new Range(aFaultsPlotter.getUserMinX(), aFaultsPlotter.getUserMaxX()), new Range(aFaultsPlotter.getUserMinY(), aFaultsPlotter.getUserMaxY()));
            graphWindow.setVisible(true);
        }
    }

    private ArrayList<String> fillCumAndIncrFuncListForDefModel(String defModelName, ArrayList<XY_DataSetList> aFaultIncrRateFuncList, ArrayList<XY_DataSetList> aFaultCumRateFuncList) {
        this.ucerf2.setParamDefaults();
        this.ucerf2.updateForecast();
        ArrayList aFaultSourceGenerators = this.ucerf2.get_A_FaultSourceGenerators();
        A_FaultsFetcher aFaultsFetcher = this.ucerf2.getA_FaultsFetcher();
        int numA_Faults = aFaultSourceGenerators.size();
        ArrayList<String> faultNames = aFaultsFetcher.getAllFaultNames();
        for (int i = 0; i < numA_Faults; ++i) {
            aFaultIncrRateFuncList.add(new XY_DataSetList());
            aFaultCumRateFuncList.add(new XY_DataSetList());
        }
        this.ucerf2.setParamDefaults();
        this.ucerf2.getParameter("Deformation Model").setValue(defModelName);
        this.ucerf2.updateForecast();
        String name = "Default Parameters with Deformation Model=" + defModelName;
        this.addToFuncListForReportPlots(aFaultIncrRateFuncList, aFaultCumRateFuncList, name);
        this.ucerf2.setParameter("Mag-Area Relationship", "Hanks & Bakun (2002)");
        this.ucerf2.updateForecast();
        name = "Def Params w/ change Mag Area to Hanks Bakun with Deformation Model=" + defModelName;
        this.addToFuncListForReportPlots(aFaultIncrRateFuncList, aFaultCumRateFuncList, name);
        this.ucerf2.setParamDefaults();
        this.ucerf2.getParameter("Deformation Model").setValue(defModelName);
        this.ucerf2.setParameter("Wt On A-Priori Rates", 1.0E10);
        this.ucerf2.setParameter("Min Fraction for Unknown Ruptures", 0.0);
        this.ucerf2.setParameter("Min Fraction for Unlikely Ruptures", 0.0);
        this.ucerf2.updateForecast();
        name = "Def. params with High apriori model weight with Deformation Model=" + defModelName;
        this.addToFuncListForReportPlots(aFaultIncrRateFuncList, aFaultCumRateFuncList, name);
        this.ucerf2.setParameter("Mag-Area Relationship", "Hanks & Bakun (2002)");
        this.ucerf2.updateForecast();
        name = "Def. params with High apriori model weight & change Mag Area to Hanks Bakun with Deformation Model=" + defModelName;
        this.addToFuncListForReportPlots(aFaultIncrRateFuncList, aFaultCumRateFuncList, name);
        this.ucerf2.setParamDefaults();
        this.ucerf2.getParameter("Deformation Model").setValue(defModelName);
        this.ucerf2.setParameter("A-Fault Solution Type", "Unsegmented Model");
        this.ucerf2.updateForecast();
        name = "Def. Params with unegmented with Deformation Model=" + defModelName;
        this.addToFuncListForReportPlots(aFaultIncrRateFuncList, aFaultCumRateFuncList, name);
        this.ucerf2.setParameter("Mag-Area Relationship", "Hanks & Bakun (2002)");
        this.ucerf2.updateForecast();
        name = "Def. Params with unegmented & change Mag Area to Hans Bakun with Deformation Model=" + defModelName;
        this.addToFuncListForReportPlots(aFaultIncrRateFuncList, aFaultCumRateFuncList, name);
        name = "Wt Avg MFD with Deformation Model=" + defModelName;
        for (int i = 0; i < aFaultIncrRateFuncList.size(); ++i) {
            XY_DataSetList funcList = aFaultIncrRateFuncList.get(i);
            IncrementalMagFreqDist wtAveMFD = ((IncrementalMagFreqDist)funcList.get(0)).deepClone();
            XY_DataSet func = (XY_DataSet)funcList.get(0);
            for (int imag = 0; imag < func.size(); ++imag) {
                double val1 = 0.225 * ((XY_DataSet)funcList.get(0)).getY(imag) + 0.225 * ((XY_DataSet)funcList.get(1)).getY(imag) + 0.225 * ((XY_DataSet)funcList.get(2)).getY(imag) + 0.225 * ((XY_DataSet)funcList.get(3)).getY(imag) + 0.05 * ((XY_DataSet)funcList.get(4)).getY(imag) + 0.05 * ((XY_DataSet)funcList.get(5)).getY(imag);
                wtAveMFD.set(func.getX(imag), val1);
            }
            wtAveMFD.setName(name);
            aFaultIncrRateFuncList.get(i).add(wtAveMFD);
            EvenlyDiscretizedFunc cumMFD = wtAveMFD.getCumRateDistWithOffset();
            cumMFD.setName(name);
            aFaultCumRateFuncList.get(i).add(cumMFD);
        }
        return faultNames;
    }

    public void plotB_FaultMFDs_forReport() {
        GraphWindow graphWindow;
        PlotSpec spec;
        A_FaultsMFD_Plotter aFaultsPlotter;
        ArrayList<DiscretizedFunc> funcArrayList;
        String faultName;
        XY_DataSetList funcList;
        int i;
        this.ucerf2.setParamDefaults();
        this.ucerf2.updateForecast();
        String[] bFaultNames = new String[]{"San Gregorio Connected", "Greenville Connected", "Green Valley Connected", "Mount Diablo Thrust"};
        int[] b_FaultIndices = new int[bFaultNames.length];
        ArrayList bFaultSources = this.ucerf2.get_B_FaultSources();
        block0: for (int i2 = 0; i2 < bFaultNames.length; ++i2) {
            String faultName2 = bFaultNames[i2];
            for (int j = 0; j < bFaultSources.size(); ++j) {
                if (!((UnsegmentedSource)bFaultSources.get(j)).getFaultSegmentData().getFaultName().equalsIgnoreCase(faultName2)) continue;
                b_FaultIndices[i2] = j;
                continue block0;
            }
        }
        int numB_Faults = bFaultNames.length;
        ArrayList<XY_DataSetList> bFaultIncrRateFuncList = new ArrayList<XY_DataSetList>();
        ArrayList<XY_DataSetList> bFaultCumRateFuncList = new ArrayList<XY_DataSetList>();
        for (int i3 = 0; i3 < numB_Faults; ++i3) {
            bFaultIncrRateFuncList.add(new XY_DataSetList());
            bFaultCumRateFuncList.add(new XY_DataSetList());
        }
        String name = "Default Parameters";
        this.addToB_FaultsPlottingList(b_FaultIndices, numB_Faults, bFaultIncrRateFuncList, bFaultCumRateFuncList, name);
        this.ucerf2.setParameter("Mag-Area Relationship", "Hanks & Bakun (2002)");
        this.ucerf2.updateForecast();
        name = "Def Params w/ change Mag Area to Hanks Bakun";
        this.addToB_FaultsPlottingList(b_FaultIndices, numB_Faults, bFaultIncrRateFuncList, bFaultCumRateFuncList, name);
        this.ucerf2.setParamDefaults();
        this.ucerf2.setParameter("Mean Mag Correction", -0.1);
        this.ucerf2.updateForecast();
        name = "Def Params w/ change Mean Mag Correction to -0.1";
        this.addToB_FaultsPlottingList(b_FaultIndices, numB_Faults, bFaultIncrRateFuncList, bFaultCumRateFuncList, name);
        this.ucerf2.setParameter("Mag-Area Relationship", "Hanks & Bakun (2002)");
        this.ucerf2.updateForecast();
        name = "Def Params w/ change Mean Mag Correction to -0.1 and Mag Area to Hanks Bakun";
        this.addToB_FaultsPlottingList(b_FaultIndices, numB_Faults, bFaultIncrRateFuncList, bFaultCumRateFuncList, name);
        this.ucerf2.setParamDefaults();
        this.ucerf2.setParameter("Mean Mag Correction", 0.1);
        this.ucerf2.updateForecast();
        name = "Def Params w/ change Mean Mag Correction to 0.1";
        this.addToB_FaultsPlottingList(b_FaultIndices, numB_Faults, bFaultIncrRateFuncList, bFaultCumRateFuncList, name);
        this.ucerf2.setParameter("Mag-Area Relationship", "Hanks & Bakun (2002)");
        this.ucerf2.updateForecast();
        name = "Def Params w/ change Mean Mag Correction to 0.1 and Mag Area to Hanks Bakun";
        this.addToB_FaultsPlottingList(b_FaultIndices, numB_Faults, bFaultIncrRateFuncList, bFaultCumRateFuncList, name);
        name = "Wt Avg MFD";
        for (i = 0; i < bFaultIncrRateFuncList.size(); ++i) {
            funcList = bFaultIncrRateFuncList.get(i);
            IncrementalMagFreqDist wtAveMFD = ((IncrementalMagFreqDist)funcList.get(0)).deepClone();
            XY_DataSet func = (XY_DataSet)funcList.get(0);
            for (int imag = 0; imag < func.size(); ++imag) {
                wtAveMFD.set(func.getX(imag), 0.3 * ((XY_DataSet)funcList.get(0)).getY(imag) + 0.3 * ((XY_DataSet)funcList.get(1)).getY(imag) + 0.1 * ((XY_DataSet)funcList.get(2)).getY(imag) + 0.1 * ((XY_DataSet)funcList.get(3)).getY(imag) + 0.1 * ((XY_DataSet)funcList.get(4)).getY(imag) + 0.1 * ((XY_DataSet)funcList.get(4)).getY(imag));
            }
            wtAveMFD.setName(name);
            bFaultIncrRateFuncList.get(i).add(wtAveMFD);
            EvenlyDiscretizedFunc cumMFD = wtAveMFD.getCumRateDistWithOffset();
            cumMFD.setName(name);
            bFaultCumRateFuncList.get(i).add(cumMFD);
        }
        name = "UCERF1 MFD";
        for (i = 0; i < bFaultIncrRateFuncList.size(); ++i) {
            String faultName3 = bFaultNames[i];
            ArbitrarilyDiscretizedFunc ucerf1Rate = UCERF1MfdReader.getUCERF1IncrementalMFD(faultName3);
            if (ucerf1Rate.size() == 0) {
                ucerf1Rate.set(0.0, 0.0);
            }
            bFaultIncrRateFuncList.get(i).add(ucerf1Rate);
            ucerf1Rate.setName(name);
            ArbitrarilyDiscretizedFunc cumMFD = UCERF1MfdReader.getUCERF1CumMFD(faultName3);
            if (cumMFD.size() == 0) {
                cumMFD.set(0.0, 0.0);
            }
            cumMFD.setName(name);
            bFaultCumRateFuncList.get(i).add(cumMFD);
        }
        for (i = 0; i < bFaultIncrRateFuncList.size(); ++i) {
            funcList = bFaultIncrRateFuncList.get(i);
            faultName = bFaultNames[i];
            funcArrayList = new ArrayList<DiscretizedFunc>();
            funcArrayList.add((DiscretizedFunc)funcList.get(funcList.size() - 1));
            funcArrayList.add((DiscretizedFunc)funcList.get(funcList.size() - 2));
            aFaultsPlotter = new A_FaultsMFD_Plotter(funcArrayList, false);
            spec = aFaultsPlotter.getPlotSpec();
            spec.setTitle(faultName);
            graphWindow = new GraphWindow(spec, PlotPreferences.getDefault(), aFaultsPlotter.getXLog(), aFaultsPlotter.getYLog(), new Range(aFaultsPlotter.getUserMinX(), aFaultsPlotter.getUserMaxX()), new Range(aFaultsPlotter.getUserMinY(), aFaultsPlotter.getUserMaxY()));
            graphWindow.setVisible(true);
        }
        for (i = 0; i < bFaultCumRateFuncList.size(); ++i) {
            funcList = bFaultCumRateFuncList.get(i);
            faultName = bFaultNames[i];
            funcArrayList = new ArrayList();
            funcArrayList.add((DiscretizedFunc)funcList.get(funcList.size() - 1));
            funcArrayList.add((DiscretizedFunc)funcList.get(funcList.size() - 2));
            aFaultsPlotter = new A_FaultsMFD_Plotter(funcArrayList, false);
            spec = aFaultsPlotter.getPlotSpec();
            spec.setTitle(faultName);
            graphWindow = new GraphWindow(spec, PlotPreferences.getDefault(), aFaultsPlotter.getXLog(), aFaultsPlotter.getYLog(), new Range(aFaultsPlotter.getUserMinX(), aFaultsPlotter.getUserMaxX()), new Range(aFaultsPlotter.getUserMinY(), aFaultsPlotter.getUserMaxY()));
            graphWindow.setVisible(true);
        }
    }

    private void addToB_FaultsPlottingList(int[] b_FaultIndices, int numB_Faults, ArrayList<XY_DataSetList> bFaultIncrRateFuncList, ArrayList<XY_DataSetList> bFaultCumRateFuncList, String name) {
        ArrayList bFaultSources = this.ucerf2.get_B_FaultSources();
        for (int i = 0; i < numB_Faults; ++i) {
            IncrementalMagFreqDist incrMFD = ((UnsegmentedSource)bFaultSources.get(b_FaultIndices[i])).getMagFreqDist();
            incrMFD.setName(name);
            incrMFD.setInfo("");
            EvenlyDiscretizedFunc cumMFD = incrMFD.getCumRateDistWithOffset();
            cumMFD.setName(name);
            cumMFD.setInfo("");
            bFaultIncrRateFuncList.get(i).add(incrMFD);
            bFaultCumRateFuncList.get(i).add(cumMFD);
        }
    }

    private void addToFuncListForReportPlots(ArrayList<XY_DataSetList> aFaultIncrRateFuncList, ArrayList<XY_DataSetList> aFaultCumRateFuncList, String name) {
        String modelType = (String)this.ucerf2.getParameter("A-Fault Solution Type").getValue();
        boolean isUnsegmented = false;
        if (modelType.equalsIgnoreCase("Unsegmented Model")) {
            isUnsegmented = true;
        }
        ArrayList aFaultSourceGenerators = this.ucerf2.get_A_FaultSourceGenerators();
        for (int i = 0; i < aFaultSourceGenerators.size(); ++i) {
            IncrementalMagFreqDist incrMFD;
            boolean isSanJacinto = false;
            Object obj = aFaultSourceGenerators.get(i);
            if (obj instanceof A_FaultSegmentedSourceGenerator) {
                incrMFD = ((A_FaultSegmentedSourceGenerator)obj).getTotalRupMFD();
            } else {
                incrMFD = ((UnsegmentedSource)obj).getMagFreqDist();
                if (i == 2) {
                    String faultName1 = ((UnsegmentedSource)obj).getFaultSegmentData().getFaultName();
                    String faultName2 = ((UnsegmentedSource)aFaultSourceGenerators.get(i + 1)).getFaultSegmentData().getFaultName();
                    if (!faultName1.equalsIgnoreCase("San Jacinto (SB to C)") || !faultName2.equalsIgnoreCase("San Jacinto (CC to SM)")) {
                        throw new RuntimeException("Invalid combination of San Jacinto faults");
                    }
                    isSanJacinto = true;
                    IncrementalMagFreqDist incrMFD2 = ((UnsegmentedSource)aFaultSourceGenerators.get(i + 1)).getMagFreqDist();
                    ((SummedMagFreqDist)incrMFD).addIncrementalMagFreqDist(incrMFD2);
                }
            }
            incrMFD.setName(name);
            EvenlyDiscretizedFunc cumMFD = incrMFD.getCumRateDistWithOffset();
            cumMFD.setName(name);
            incrMFD.setInfo("");
            cumMFD.setInfo("");
            if (isUnsegmented && i > 2) {
                aFaultIncrRateFuncList.get(i - 1).add(incrMFD);
                aFaultCumRateFuncList.get(i - 1).add(cumMFD);
            } else {
                aFaultIncrRateFuncList.get(i).add(incrMFD);
                aFaultCumRateFuncList.get(i).add(cumMFD);
            }
            if (!isSanJacinto) continue;
            ++i;
        }
    }

    public static void main(String[] args) {
        UCERF1ComparisonPlotter ucerf1ComparisonPlotter = new UCERF1ComparisonPlotter();
        ucerf1ComparisonPlotter.plotB_FaultMFDs_forReport();
    }
}

