/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.ListIterator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.A_Faults.A_FaultSegmentedSourceGenerator;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.FaultSegmentData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis.ParamOptions;

public class WriteTimeDepSegmentedProbAndGain {
    private static final String PATH = "src/org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/analysis/files/";
    private static final String README_TEXT = "This Excel spreadsheet tabulates Rupture Probability, Rupture Prob for Mag\u22656.7, Rupture Gain, Segment Probability, Segment Prob for M\u22656.7, Segment Gain, Segment Rate, and Segment Recurrence Interval (each on a different sheet) for all Type-A fault segmented models, and for various logic-tree branches. The exact parameter settings for each logic-tree branch are listed in the \"Parameter Settings\" sheet, where those that vary between branches are in bold typeface.  The total aggregated rupture probability for each fault is given at the bottom of the list for each fault. The third-to-last column gives the weighted average value (over all logic tree branches, where the weights are given on row 147 on the rupture-related sheets and row 52 on the segment-related sheets.  The last two columns give the Min and Max, respectively, among all the logic-tree branches. \"Gain\" is defined as the ratio of the probability to the Poisson probability.  Note that the weighted averages for the gains are the individual ratios averaged, which is not the same as the weight-averaged probability divided by the weight-averaged Poisson probability (the latter is more correct). The \"Segment Rate\" and \"Segment Recurrence Interval\" sheets give data on the long-term annual rate of events and recurrence interval, respectively, on each segment (i.e., the Empricial model does not influence these values).";
    private ArrayList<String> paramNames;
    private ArrayList<ParamOptions> paramValues;
    private int lastParamIndex;
    private UCERF2 ucerf2;
    private HSSFSheet rupProbSheet;
    private HSSFSheet rupGainSheet;
    private HSSFSheet segProbSheet;
    private HSSFSheet segProbSheet67;
    private HSSFSheet segGainSheet;
    private HSSFSheet rupProbSheet67;
    private HSSFSheet adjustableParamsSheet;
    private HSSFSheet readmeSheet;
    private HSSFSheet segRateSheet;
    private HSSFSheet segRecurIntvSheet;
    private int loginTreeBranchIndex;
    private ArrayList<String> adjustableParamNames;
    private ArrayList<Double> segProbWtAve;
    private ArrayList<Double> segProbMin;
    private ArrayList<Double> segProbMax;
    private ArrayList<Double> segProbWtAve67;
    private ArrayList<Double> segProbMin67;
    private ArrayList<Double> segProbMax67;
    private ArrayList<Double> rupProbWtAve;
    private ArrayList<Double> rupProbMin;
    private ArrayList<Double> rupProbMax;
    private ArrayList<Double> rupProbWtAve67;
    private ArrayList<Double> rupProbMin67;
    private ArrayList<Double> rupProbMax67;
    private ArrayList<Double> segGainWtAve;
    private ArrayList<Double> segGainMin;
    private ArrayList<Double> segGainMax;
    private ArrayList<Double> rupGainWtAve;
    private ArrayList<Double> rupGainMin;
    private ArrayList<Double> rupGainMax;
    private ArrayList<Double> segRateWtAve;
    private ArrayList<Double> segRateMin;
    private ArrayList<Double> segRateMax;
    private ArrayList<Integer> segRecurIntvMin;
    private ArrayList<Integer> segRecurIntvMax;
    private ArrayList<Double> segRecurIntvWtAve;
    private HSSFCellStyle boldStyle;
    private static double DURATION;
    private static Boolean SEG_DEP_APERIODICITY;
    private static String PROB_MODEL_VAL;
    private String FILENAME;
    private double MAG_67 = 6.7;

    public WriteTimeDepSegmentedProbAndGain() {
        this(new UCERF2());
    }

    public WriteTimeDepSegmentedProbAndGain(UCERF2 ucerf2) {
        this.ucerf2 = ucerf2;
        this.fillAdjustableParams();
        DURATION = 30.0;
        this.FILENAME = "RupProbs_Pois_30yr.xls";
        PROB_MODEL_VAL = "Poisson";
        this.makeExcelSheet(ucerf2);
        DURATION = 5.0;
        this.FILENAME = "RupProbs_Pois_5yr.xls";
        PROB_MODEL_VAL = "Poisson";
        this.makeExcelSheet(ucerf2);
        DURATION = 30.0;
        this.FILENAME = "RupProbs_Empirical_30yr.xls";
        PROB_MODEL_VAL = "Empirical";
        this.makeExcelSheet(ucerf2);
        DURATION = 5.0;
        this.FILENAME = "RupProbs_Empirical_5yr.xls";
        PROB_MODEL_VAL = "Empirical";
        this.makeExcelSheet(ucerf2);
        DURATION = 30.0;
        this.FILENAME = "RupProbs_BPT_30yr_SegDepAper.xls";
        SEG_DEP_APERIODICITY = true;
        PROB_MODEL_VAL = "BPT";
        this.makeExcelSheet(ucerf2);
        DURATION = 5.0;
        this.FILENAME = "RupProbs_BPT_5yr_SegDepAper.xls";
        SEG_DEP_APERIODICITY = true;
        PROB_MODEL_VAL = "BPT";
        this.makeExcelSheet(ucerf2);
        DURATION = 30.0;
        this.FILENAME = "RupProbs_BPT_30yr_ConstAper.xls";
        SEG_DEP_APERIODICITY = false;
        PROB_MODEL_VAL = "BPT";
        this.makeExcelSheet(ucerf2);
        DURATION = 5.0;
        this.FILENAME = "RupProbs_BPT_5yr_ConstAper.xls";
        SEG_DEP_APERIODICITY = false;
        PROB_MODEL_VAL = "BPT";
        this.makeExcelSheet(ucerf2);
        this.paramNames.add("Probability Model");
        ParamOptions options = new ParamOptions();
        options.addValueWeight("Empirical", 0.3);
        options.addValueWeight("BPT", 0.7);
        this.paramValues.add(options);
        this.paramNames.add("Aperiodicity");
        options = new ParamOptions();
        options.addValueWeight(0.3, 0.2);
        options.addValueWeight(0.5, 0.5);
        options.addValueWeight(0.7, 0.3);
        this.paramValues.add(options);
        DURATION = 5.0;
        this.FILENAME = "RupProbs_Emp_BPT_5yr.xls";
        SEG_DEP_APERIODICITY = false;
        this.makeExcelSheet(ucerf2);
        DURATION = 30.0;
        this.FILENAME = "RupProbs_Emp_BPT_30yr.xls";
        SEG_DEP_APERIODICITY = false;
        this.makeExcelSheet(ucerf2);
        this.paramNames.remove("Probability Model");
        this.paramValues.remove(this.paramValues.size() - 2);
        DURATION = 30.0;
        this.FILENAME = "RupProbs_BPT_30yr_ConstAperBranches.xls";
        SEG_DEP_APERIODICITY = false;
        PROB_MODEL_VAL = "BPT";
        this.makeExcelSheet(ucerf2);
        DURATION = 5.0;
        this.FILENAME = "RupProbs_BPT_5yr_ConstAperBranches.xls";
        SEG_DEP_APERIODICITY = false;
        PROB_MODEL_VAL = "BPT";
        this.makeExcelSheet(ucerf2);
    }

    private void makeExcelSheet(UCERF2 ucerf2) {
        Parameter param;
        System.out.println(this.FILENAME);
        this.loginTreeBranchIndex = 0;
        this.lastParamIndex = this.paramNames.size() - 1;
        HSSFWorkbook wb = new HSSFWorkbook();
        this.readmeSheet = wb.createSheet("README");
        this.adjustableParamsSheet = wb.createSheet("Parameter Settings");
        this.rupProbSheet = wb.createSheet("Rupture Probability");
        this.rupProbSheet67 = wb.createSheet("Rup Prob for Mag>6.7");
        this.rupGainSheet = wb.createSheet("Rupture Gain");
        this.segProbSheet = wb.createSheet("Segment Probability");
        this.segProbSheet67 = wb.createSheet("Segment Prob for Mag>6.7");
        this.segGainSheet = wb.createSheet("Segment Gain");
        this.segRateSheet = wb.createSheet("Segment Rate");
        this.segRecurIntvSheet = wb.createSheet("Segment Recurrence Interval");
        ucerf2.getParameter("Probability Model").setValue(PROB_MODEL_VAL);
        ucerf2.getTimeSpan().setDuration(DURATION);
        if (ucerf2.getAdjustableParameterList().containsParameter("Seg Dependent Aperiodicity")) {
            ucerf2.getParameter("Seg Dependent Aperiodicity").setValue(SEG_DEP_APERIODICITY);
        }
        ParameterList adjustableParams = ucerf2.getAdjustableParameterList();
        ListIterator<Parameter<?>> it = adjustableParams.getParametersIterator();
        this.adjustableParamNames = new ArrayList();
        while (it.hasNext()) {
            param = (Parameter)it.next();
            this.adjustableParamNames.add(param.getName());
        }
        it = ucerf2.getTimeSpan().getAdjustableParams().getParametersIterator();
        while (it.hasNext()) {
            param = (Parameter)it.next();
            this.adjustableParamNames.add(param.getName());
        }
        HSSFFont boldFont = wb.createFont();
        boldFont.setBoldweight((short)700);
        this.boldStyle = wb.createCellStyle();
        this.boldStyle.setFont(boldFont);
        this.calcLogicTreeBranch(0, 1.0);
        this.writeWeightAvMinMaxCols();
        this.readmeSheet.setColumnWidth(0, -14336);
        HSSFCellStyle wrapCellStyle = wb.createCellStyle();
        wrapCellStyle.setWrapText(true);
        this.readmeSheet.createRow(0).createCell(0).setCellStyle(wrapCellStyle);
        this.readmeSheet.getRow(0).getCell(0).setCellValue(README_TEXT);
        try {
            FileOutputStream fileOut = new FileOutputStream(PATH + this.FILENAME);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeWeightAvMinMaxCols() {
        int rupRowIndex = 0;
        int segRowIndex = 0;
        int colIndex = this.loginTreeBranchIndex + 1;
        this.rupProbSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Weighted Average");
        this.rupProbSheet.createRow(rupRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue("Min");
        this.rupProbSheet.createRow(rupRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue("Max");
        this.rupProbSheet67.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Weighted Average");
        this.rupProbSheet67.createRow(rupRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue("Min");
        this.rupProbSheet67.createRow(rupRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue("Max");
        this.rupGainSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Weighted Average");
        this.rupGainSheet.createRow(rupRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue("Min");
        this.rupGainSheet.createRow(rupRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue("Max");
        this.segProbSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue("Weighted Average");
        this.segProbSheet.createRow(segRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue("Min");
        this.segProbSheet.createRow(segRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue("Max");
        this.segProbSheet67.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue("Weighted Average");
        this.segProbSheet67.createRow(segRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue("Min");
        this.segProbSheet67.createRow(segRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue("Max");
        this.segGainSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue("Weighted Average");
        this.segGainSheet.createRow(segRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue("Min");
        this.segGainSheet.createRow(segRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue("Max");
        this.segRateSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue("Weighted Average");
        this.segRateSheet.createRow(segRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue("Min");
        this.segRateSheet.createRow(segRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue("Max");
        this.segRecurIntvSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue("Weighted Average");
        this.segRecurIntvSheet.createRow(segRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue("Min");
        this.segRecurIntvSheet.createRow(segRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue("Max");
        ++rupRowIndex;
        ++segRowIndex;
        ++rupRowIndex;
        ++segRowIndex;
        int totRupsIndex = 0;
        int totSegsIndex = 0;
        ArrayList aFaultGenerators = this.ucerf2.get_A_FaultSourceGenerators();
        int fltGenIndex = 0;
        while (fltGenIndex < aFaultGenerators.size()) {
            A_FaultSegmentedSourceGenerator sourceGen = (A_FaultSegmentedSourceGenerator)aFaultGenerators.get(fltGenIndex);
            int numRups = sourceGen.getNumRupSources();
            ++rupRowIndex;
            int rupIndex = 0;
            while (rupIndex < numRups) {
                this.rupProbSheet.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(this.rupProbWtAve.get(totRupsIndex).doubleValue());
                this.rupProbSheet.getRow(rupRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue(this.rupProbMin.get(totRupsIndex).doubleValue());
                this.rupProbSheet.getRow(rupRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue(this.rupProbMax.get(totRupsIndex).doubleValue());
                this.rupProbSheet67.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(this.rupProbWtAve67.get(totRupsIndex).doubleValue());
                this.rupProbSheet67.getRow(rupRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue(this.rupProbMin67.get(totRupsIndex).doubleValue());
                this.rupProbSheet67.getRow(rupRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue(this.rupProbMax67.get(totRupsIndex).doubleValue());
                this.rupGainSheet.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(this.rupGainWtAve.get(totRupsIndex).doubleValue());
                this.rupGainSheet.getRow(rupRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue(this.rupGainMin.get(totRupsIndex).doubleValue());
                this.rupGainSheet.getRow(rupRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue(this.rupGainMax.get(totRupsIndex).doubleValue());
                ++rupRowIndex;
                ++rupIndex;
                ++totRupsIndex;
            }
            this.rupProbSheet.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(this.rupProbWtAve.get(totRupsIndex).doubleValue());
            this.rupProbSheet.getRow(rupRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue(this.rupProbMin.get(totRupsIndex).doubleValue());
            this.rupProbSheet.getRow(rupRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue(this.rupProbMax.get(totRupsIndex).doubleValue());
            this.rupProbSheet67.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(this.rupProbWtAve67.get(totRupsIndex).doubleValue());
            this.rupProbSheet67.getRow(rupRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue(this.rupProbMin67.get(totRupsIndex).doubleValue());
            this.rupProbSheet67.getRow(rupRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue(this.rupProbMax67.get(totRupsIndex).doubleValue());
            this.rupGainSheet.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(this.rupGainWtAve.get(totRupsIndex).doubleValue());
            this.rupGainSheet.getRow(rupRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue(this.rupGainMin.get(totRupsIndex).doubleValue());
            this.rupGainSheet.getRow(rupRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue(this.rupGainMax.get(totRupsIndex).doubleValue());
            ++totRupsIndex;
            ++rupRowIndex;
            FaultSegmentData faultSegData = sourceGen.getFaultSegmentData();
            int numSegs = faultSegData.getNumSegments();
            ++segRowIndex;
            int segIndex = 0;
            while (segIndex < numSegs) {
                this.segProbSheet.getRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue(this.segProbWtAve.get(totSegsIndex).doubleValue());
                this.segProbSheet.getRow(segRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue(this.segProbMin.get(totSegsIndex).doubleValue());
                this.segProbSheet.getRow(segRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue(this.segProbMax.get(totSegsIndex).doubleValue());
                this.segProbSheet67.getRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue(this.segProbWtAve67.get(totSegsIndex).doubleValue());
                this.segProbSheet67.getRow(segRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue(this.segProbMin67.get(totSegsIndex).doubleValue());
                this.segProbSheet67.getRow(segRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue(this.segProbMax67.get(totSegsIndex).doubleValue());
                this.segGainSheet.getRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue(this.segGainWtAve.get(totSegsIndex).doubleValue());
                this.segGainSheet.getRow(segRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue(this.segGainMin.get(totSegsIndex).doubleValue());
                this.segGainSheet.getRow(segRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue(this.segGainMax.get(totSegsIndex).doubleValue());
                this.segRateSheet.getRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue(this.segRateWtAve.get(totSegsIndex).doubleValue());
                this.segRateSheet.getRow(segRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue(this.segRateMin.get(totSegsIndex).doubleValue());
                this.segRateSheet.getRow(segRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue(this.segRateMax.get(totSegsIndex).doubleValue());
                this.segRecurIntvSheet.getRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue((double)Math.round(this.segRecurIntvWtAve.get(totSegsIndex)));
                this.segRecurIntvSheet.getRow(segRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue((double)this.segRecurIntvMin.get(totSegsIndex).intValue());
                this.segRecurIntvSheet.getRow(segRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue((double)this.segRecurIntvMax.get(totSegsIndex).intValue());
                ++segRowIndex;
                ++segIndex;
                ++totSegsIndex;
            }
            ++fltGenIndex;
            ++rupRowIndex;
            ++segRowIndex;
        }
    }

    private void fillAdjustableParams() {
        this.paramNames = new ArrayList();
        this.paramValues = new ArrayList();
        this.paramNames.add("Deformation Model");
        ParamOptions options = new ParamOptions();
        options.addValueWeight("D2.1", 0.5);
        options.addValueWeight("D2.2", 0.2);
        options.addValueWeight("D2.3", 0.3);
        this.paramValues.add(options);
        this.paramNames.add("Mag-Area Relationship");
        options = new ParamOptions();
        options.addValueWeight("Ellsworth-B (WGCEP, 2002, Eq 4.5b)", 0.5);
        options.addValueWeight("Hanks & Bakun (2002)", 0.5);
        this.paramValues.add(options);
        this.paramNames.add("Wt On A-Priori Rates");
        options = new ParamOptions();
        options.addValueWeight(1.0E-4, 0.5);
        options.addValueWeight(1.0E10, 0.5);
        this.paramValues.add(options);
    }

    private void calcLogicTreeBranch(int paramIndex, double weight) {
        ParamOptions options = this.paramValues.get(paramIndex);
        String paramName = this.paramNames.get(paramIndex);
        int numValues = options.getNumValues();
        for (int i = 0; i < numValues; ++i) {
            double newWt;
            if (this.ucerf2.getAdjustableParameterList().containsParameter(paramName)) {
                this.ucerf2.getParameter(paramName).setValue(options.getValue(i));
                newWt = weight * options.getWeight(i);
                if (paramName.equalsIgnoreCase("Wt On A-Priori Rates")) {
                    Parameter param = this.ucerf2.getParameter("Wt On A-Priori Rates");
                    if ((Double)param.getValue() == 1.0E10) {
                        this.ucerf2.getParameter("Min Fraction for Unknown Ruptures").setValue(0.0);
                        this.ucerf2.getParameter("Min Fraction for Unlikely Ruptures").setValue(0.0);
                    } else {
                        this.ucerf2.getParameter("Min Fraction for Unknown Ruptures").setValue(UCERF2.MIN_A_FAULT_RATE_1_DEFAULT);
                        this.ucerf2.getParameter("Min Fraction for Unlikely Ruptures").setValue(UCERF2.MIN_A_FAULT_RATE_2_DEFAULT);
                    }
                }
            } else if (i == 0) {
                newWt = weight;
            } else {
                return;
            }
            if (paramIndex == this.lastParamIndex) {
                int colIndex;
                int segRowIndex;
                int rupRowIndex;
                System.out.println("Doing run:" + (this.loginTreeBranchIndex + 1));
                this.ucerf2.getTimeSpan().setDuration(DURATION);
                this.ucerf2.updateForecast();
                ArrayList aFaultGenerators = this.ucerf2.get_A_FaultSourceGenerators();
                if (this.loginTreeBranchIndex == 0) {
                    this.segProbWtAve = new ArrayList();
                    this.segProbMin = new ArrayList();
                    this.segProbMax = new ArrayList();
                    this.segProbWtAve67 = new ArrayList();
                    this.segProbMin67 = new ArrayList();
                    this.segProbMax67 = new ArrayList();
                    this.segGainWtAve = new ArrayList();
                    this.segGainMin = new ArrayList();
                    this.segGainMax = new ArrayList();
                    this.segRateWtAve = new ArrayList();
                    this.segRateMin = new ArrayList();
                    this.segRateMax = new ArrayList();
                    this.segRecurIntvWtAve = new ArrayList();
                    this.segRecurIntvMin = new ArrayList();
                    this.segRecurIntvMax = new ArrayList();
                    this.rupProbWtAve = new ArrayList();
                    this.rupProbMin = new ArrayList();
                    this.rupProbMax = new ArrayList();
                    this.rupProbWtAve67 = new ArrayList();
                    this.rupProbMin67 = new ArrayList();
                    this.rupProbMax67 = new ArrayList();
                    this.rupGainWtAve = new ArrayList();
                    this.rupGainMin = new ArrayList();
                    this.rupGainMax = new ArrayList();
                    rupRowIndex = 0;
                    segRowIndex = 0;
                    colIndex = this.loginTreeBranchIndex;
                    this.rupProbSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Rupture Name");
                    this.rupProbSheet67.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Rupture Name");
                    this.rupGainSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Rupture Name");
                    this.segProbSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue("Segment Name");
                    this.segProbSheet67.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue("Segment Name");
                    this.segGainSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue("Segment Name");
                    this.segRateSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue("Segment Name");
                    this.segRecurIntvSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue("Segment Name");
                    ++rupRowIndex;
                    ++segRowIndex;
                    ++rupRowIndex;
                    ++segRowIndex;
                    int fltGenIndex = 0;
                    while (fltGenIndex < aFaultGenerators.size()) {
                        A_FaultSegmentedSourceGenerator sourceGen = (A_FaultSegmentedSourceGenerator)aFaultGenerators.get(fltGenIndex);
                        this.rupProbSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(sourceGen.getFaultSegmentData().getFaultName());
                        this.rupProbSheet67.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(sourceGen.getFaultSegmentData().getFaultName());
                        this.rupGainSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(sourceGen.getFaultSegmentData().getFaultName());
                        int numRups = sourceGen.getNumRupSources();
                        ++rupRowIndex;
                        for (int rupIndex = 0; rupIndex < numRups; ++rupIndex) {
                            this.rupProbSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(sourceGen.getLongRupName(rupIndex));
                            this.rupProbSheet67.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(sourceGen.getLongRupName(rupIndex));
                            this.rupGainSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(sourceGen.getLongRupName(rupIndex));
                            ++rupRowIndex;
                            this.rupProbWtAve.add(0.0);
                            this.rupProbWtAve.add(0.0);
                            this.rupProbMin.add((Double)Double.MAX_VALUE);
                            this.rupProbMax.add(0.0);
                            this.rupProbWtAve67.add(0.0);
                            this.rupProbWtAve67.add(0.0);
                            this.rupProbMin67.add((Double)Double.MAX_VALUE);
                            this.rupProbMax67.add(0.0);
                            this.rupGainWtAve.add(0.0);
                            this.rupGainWtAve.add(0.0);
                            this.rupGainMin.add((Double)Double.MAX_VALUE);
                            this.rupGainMax.add(0.0);
                        }
                        this.rupProbSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Total Probability");
                        this.rupProbSheet67.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Total Probability");
                        this.rupGainSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Total Gain");
                        this.rupProbWtAve.add(0.0);
                        this.rupProbMin.add((Double)Double.MAX_VALUE);
                        this.rupProbMax.add(0.0);
                        this.rupProbWtAve67.add(0.0);
                        this.rupProbMin67.add((Double)Double.MAX_VALUE);
                        this.rupProbMax67.add(0.0);
                        this.rupGainWtAve.add(0.0);
                        this.rupGainMin.add((Double)Double.MAX_VALUE);
                        this.rupGainMax.add(0.0);
                        ++rupRowIndex;
                        this.segProbSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue(sourceGen.getFaultSegmentData().getFaultName());
                        this.segProbSheet67.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue(sourceGen.getFaultSegmentData().getFaultName());
                        this.segGainSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue(sourceGen.getFaultSegmentData().getFaultName());
                        this.segRateSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue(sourceGen.getFaultSegmentData().getFaultName());
                        this.segRecurIntvSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue(sourceGen.getFaultSegmentData().getFaultName());
                        FaultSegmentData faultSegData = sourceGen.getFaultSegmentData();
                        int numSegs = faultSegData.getNumSegments();
                        ++segRowIndex;
                        for (int segIndex = 0; segIndex < numSegs; ++segIndex) {
                            this.segProbSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue(faultSegData.getSegmentName(segIndex));
                            this.segProbSheet67.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue(faultSegData.getSegmentName(segIndex));
                            this.segGainSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue(faultSegData.getSegmentName(segIndex));
                            this.segRateSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue(faultSegData.getSegmentName(segIndex));
                            this.segRecurIntvSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue(faultSegData.getSegmentName(segIndex));
                            ++segRowIndex;
                            this.segProbWtAve.add(0.0);
                            this.segProbMin.add((Double)Double.MAX_VALUE);
                            this.segProbMax.add(0.0);
                            this.segProbWtAve67.add(0.0);
                            this.segProbMin67.add((Double)Double.MAX_VALUE);
                            this.segProbMax67.add(0.0);
                            this.segGainWtAve.add(0.0);
                            this.segGainMin.add((Double)Double.MAX_VALUE);
                            this.segGainMax.add(0.0);
                            this.segRateWtAve.add(0.0);
                            this.segRateMin.add((Double)Double.MAX_VALUE);
                            this.segRateMax.add(0.0);
                            this.segRecurIntvWtAve.add(0.0);
                            this.segRecurIntvMin.add(Integer.MAX_VALUE);
                            this.segRecurIntvMax.add(0);
                        }
                        ++fltGenIndex;
                        ++rupRowIndex;
                        ++segRowIndex;
                    }
                    this.rupProbSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Branch Weight");
                    this.rupProbSheet67.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Branch Weight");
                    this.rupGainSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Branch Weight");
                    this.segProbSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue("Branch Weight");
                    this.segProbSheet67.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue("Branch Weight");
                    this.segGainSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue("Branch Weight");
                    this.segRateSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue("Branch Weight");
                    this.segRecurIntvSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue("Branch Weight");
                    HSSFRow row = this.adjustableParamsSheet.createRow(0);
                    row.createCell(0).setCellValue("Parameters");
                    for (int p = 1; p <= this.adjustableParamNames.size(); ++p) {
                        String adjParamName = this.adjustableParamNames.get(p - 1);
                        HSSFCell cell = this.adjustableParamsSheet.createRow(p).createCell(0);
                        if (this.paramNames.contains(adjParamName) || adjParamName.equalsIgnoreCase("Min Fraction for Unknown Ruptures") || adjParamName.equalsIgnoreCase("Min Fraction for Unlikely Ruptures")) {
                            cell.setCellStyle(this.boldStyle);
                        }
                        cell.setCellValue(adjParamName);
                    }
                }
                rupRowIndex = 0;
                segRowIndex = 0;
                colIndex = ++this.loginTreeBranchIndex;
                this.rupProbSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Branch " + this.loginTreeBranchIndex);
                this.rupProbSheet67.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Branch " + this.loginTreeBranchIndex);
                this.rupGainSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Branch " + this.loginTreeBranchIndex);
                this.segProbSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue("Branch " + this.loginTreeBranchIndex);
                this.segProbSheet67.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue("Branch " + this.loginTreeBranchIndex);
                this.segGainSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue("Branch " + this.loginTreeBranchIndex);
                this.segRateSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue("Branch " + this.loginTreeBranchIndex);
                this.segRecurIntvSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue("Branch " + this.loginTreeBranchIndex);
                this.adjustableParamsSheet.createRow(0).createCell((int)((short)colIndex)).setCellValue("Branch " + this.loginTreeBranchIndex);
                ++rupRowIndex;
                ++segRowIndex;
                ++rupRowIndex;
                ++segRowIndex;
                int totRupsIndex = 0;
                int totSegsIndex = 0;
                int fltGenIndex = 0;
                while (fltGenIndex < aFaultGenerators.size()) {
                    double rupGain;
                    double rupProb67;
                    double rupProb;
                    A_FaultSegmentedSourceGenerator sourceGen = (A_FaultSegmentedSourceGenerator)aFaultGenerators.get(fltGenIndex);
                    int numRups = sourceGen.getNumRupSources();
                    ++rupRowIndex;
                    int rupIndex = 0;
                    while (rupIndex < numRups) {
                        rupProb = sourceGen.getRupSourceProb(rupIndex);
                        this.rupProbWtAve.set(totRupsIndex, this.rupProbWtAve.get(totRupsIndex) + newWt * rupProb);
                        if (this.rupProbMin.get(totRupsIndex) > rupProb) {
                            this.rupProbMin.set(totRupsIndex, rupProb);
                        }
                        if (this.rupProbMax.get(totRupsIndex) < rupProb) {
                            this.rupProbMax.set(totRupsIndex, rupProb);
                        }
                        this.rupProbSheet.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(rupProb);
                        rupProb67 = sourceGen.getRupSourceProbAboveMag(rupIndex, this.MAG_67);
                        this.rupProbWtAve67.set(totRupsIndex, this.rupProbWtAve67.get(totRupsIndex) + newWt * rupProb67);
                        if (this.rupProbMin67.get(totRupsIndex) > rupProb67) {
                            this.rupProbMin67.set(totRupsIndex, rupProb67);
                        }
                        if (this.rupProbMax67.get(totRupsIndex) < rupProb67) {
                            this.rupProbMax67.set(totRupsIndex, rupProb67);
                        }
                        this.rupProbSheet67.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(rupProb67);
                        rupGain = sourceGen.getRupSourcProbGain(rupIndex);
                        this.rupGainWtAve.set(totRupsIndex, this.rupGainWtAve.get(totRupsIndex) + newWt * rupGain);
                        if (this.rupGainMin.get(totRupsIndex) > rupGain) {
                            this.rupGainMin.set(totRupsIndex, rupGain);
                        }
                        if (this.rupGainMax.get(totRupsIndex) < rupGain) {
                            this.rupGainMax.set(totRupsIndex, rupGain);
                        }
                        this.rupGainSheet.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(rupGain);
                        ++rupRowIndex;
                        ++rupIndex;
                        ++totRupsIndex;
                    }
                    rupProb = sourceGen.getTotFaultProb();
                    this.rupProbWtAve.set(totRupsIndex, this.rupProbWtAve.get(totRupsIndex) + newWt * rupProb);
                    if (this.rupProbMin.get(totRupsIndex) > rupProb) {
                        this.rupProbMin.set(totRupsIndex, rupProb);
                    }
                    if (this.rupProbMax.get(totRupsIndex) < rupProb) {
                        this.rupProbMax.set(totRupsIndex, rupProb);
                    }
                    this.rupProbSheet.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(rupProb);
                    rupProb67 = sourceGen.getTotFaultProb(this.MAG_67);
                    this.rupProbWtAve67.set(totRupsIndex, this.rupProbWtAve67.get(totRupsIndex) + newWt * rupProb67);
                    if (this.rupProbMin67.get(totRupsIndex) > rupProb67) {
                        this.rupProbMin67.set(totRupsIndex, rupProb67);
                    }
                    if (this.rupProbMax67.get(totRupsIndex) < rupProb67) {
                        this.rupProbMax67.set(totRupsIndex, rupProb67);
                    }
                    this.rupProbSheet67.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(rupProb67);
                    rupGain = sourceGen.getTotFaultProbGain();
                    this.rupGainWtAve.set(totRupsIndex, this.rupGainWtAve.get(totRupsIndex) + newWt * rupGain);
                    if (this.rupGainMin.get(totRupsIndex) > rupGain) {
                        this.rupGainMin.set(totRupsIndex, rupGain);
                    }
                    if (this.rupGainMax.get(totRupsIndex) < rupGain) {
                        this.rupGainMax.set(totRupsIndex, rupGain);
                    }
                    this.rupGainSheet.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(rupGain);
                    ++totRupsIndex;
                    ++rupRowIndex;
                    FaultSegmentData faultSegData = sourceGen.getFaultSegmentData();
                    int numSegs = faultSegData.getNumSegments();
                    ++segRowIndex;
                    int segIndex = 0;
                    while (segIndex < numSegs) {
                        double segProb = sourceGen.getSegProb(segIndex);
                        this.segProbWtAve.set(totSegsIndex, this.segProbWtAve.get(totSegsIndex) + newWt * segProb);
                        if (this.segProbMin.get(totSegsIndex) > segProb) {
                            this.segProbMin.set(totSegsIndex, segProb);
                        }
                        if (this.segProbMax.get(totSegsIndex) < segProb) {
                            this.segProbMax.set(totSegsIndex, segProb);
                        }
                        this.segProbSheet.getRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue(segProb);
                        double segProb67 = sourceGen.computeSegProbAboveMag(this.MAG_67, segIndex);
                        this.segProbWtAve67.set(totSegsIndex, this.segProbWtAve67.get(totSegsIndex) + newWt * segProb67);
                        if (this.segProbMin67.get(totSegsIndex) > segProb67) {
                            this.segProbMin67.set(totSegsIndex, segProb67);
                        }
                        if (this.segProbMax67.get(totSegsIndex) < segProb67) {
                            this.segProbMax67.set(totSegsIndex, segProb67);
                        }
                        this.segProbSheet67.getRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue(segProb67);
                        double segGain = sourceGen.getSegProbGain(segIndex);
                        this.segGainWtAve.set(totSegsIndex, this.segGainWtAve.get(totSegsIndex) + newWt * segGain);
                        if (this.segGainMin.get(totSegsIndex) > segGain) {
                            this.segGainMin.set(totSegsIndex, segGain);
                        }
                        if (this.segGainMax.get(totSegsIndex) < segGain) {
                            this.segGainMax.set(totSegsIndex, segGain);
                        }
                        this.segGainSheet.getRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue(segGain);
                        this.segGainSheet.getRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue(segGain);
                        double segRate = sourceGen.getFinalSegmentRate(segIndex);
                        this.segRateWtAve.set(totSegsIndex, this.segRateWtAve.get(totSegsIndex) + newWt * segRate);
                        if (this.segRateMin.get(totSegsIndex) > segRate) {
                            this.segRateMin.set(totSegsIndex, segRate);
                        }
                        if (this.segRateMax.get(totSegsIndex) < segRate) {
                            this.segRateMax.set(totSegsIndex, segRate);
                        }
                        this.segRateSheet.getRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue(segRate);
                        this.segRateSheet.getRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue(segRate);
                        int segRecurIntv = Math.round((float)(1.0 / sourceGen.getFinalSegmentRate(segIndex)));
                        this.segRecurIntvWtAve.set(totSegsIndex, this.segRecurIntvWtAve.get(totSegsIndex) + newWt * (double)segRecurIntv);
                        if (this.segRecurIntvMin.get(totSegsIndex) > segRecurIntv) {
                            this.segRecurIntvMin.set(totSegsIndex, segRecurIntv);
                        }
                        if (this.segRecurIntvMax.get(totSegsIndex) < segRecurIntv) {
                            this.segRecurIntvMax.set(totSegsIndex, segRecurIntv);
                        }
                        this.segRecurIntvSheet.getRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue((double)segRecurIntv);
                        this.segRecurIntvSheet.getRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue((double)segRecurIntv);
                        ++segRowIndex;
                        ++segIndex;
                        ++totSegsIndex;
                    }
                    ++fltGenIndex;
                    ++rupRowIndex;
                    ++segRowIndex;
                }
                this.rupProbSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(newWt);
                this.rupProbSheet67.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(newWt);
                this.rupGainSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(newWt);
                this.segProbSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue(newWt);
                this.segProbSheet67.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue(newWt);
                this.segGainSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue(newWt);
                this.segRateSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue(newWt);
                this.segRecurIntvSheet.createRow(segRowIndex).createCell((int)((short)colIndex)).setCellValue(newWt);
                ParameterList paramList = this.ucerf2.getAdjustableParameterList();
                ParameterList timeSpanParamList = this.ucerf2.getTimeSpan().getAdjustableParams();
                for (int p = 1; p <= this.adjustableParamNames.size(); ++p) {
                    String parameterName = this.adjustableParamNames.get(p - 1);
                    if (paramList.containsParameter(parameterName)) {
                        HSSFCell cell = this.adjustableParamsSheet.getRow(p).createCell((int)((short)this.loginTreeBranchIndex));
                        if (this.paramNames.contains(parameterName) || parameterName.equalsIgnoreCase("Min Fraction for Unknown Ruptures") || parameterName.equalsIgnoreCase("Min Fraction for Unlikely Ruptures")) {
                            cell.setCellStyle(this.boldStyle);
                        }
                        cell.setCellValue(paramList.getValue(parameterName).toString());
                        continue;
                    }
                    if (!timeSpanParamList.containsParameter(parameterName)) continue;
                    this.adjustableParamsSheet.getRow(p).createCell((int)((short)this.loginTreeBranchIndex)).setCellValue(timeSpanParamList.getValue(parameterName).toString());
                }
                continue;
            }
            this.calcLogicTreeBranch(paramIndex + 1, newWt);
        }
    }

    public static void main(String[] args) {
        WriteTimeDepSegmentedProbAndGain rupProbWriter = new WriteTimeDepSegmentedProbAndGain();
    }
}

