/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.finalReferenceFaultParamDb.fileGen;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.opensha.commons.geo.Location;
import org.opensha.refFaultParamDb.vo.DeformationModelSummary;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.finalReferenceFaultParamDb.DeformationModelPrefDataFinal;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.finalReferenceFaultParamDb.DeformationModelSummaryFinal;
import org.opensha.sha.faultSurface.FaultTrace;

public class DeformationModelFileGenerator {
    private static final String FILE_PATH = "org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/data/finalReferenceFaultParamDb/fileGen/";
    private boolean sort = true;
    DeformationModelSummaryFinal summaries = new DeformationModelSummaryFinal();
    DeformationModelPrefDataFinal defModels = new DeformationModelPrefDataFinal();
    ArrayList<DeformationModelSummary> deformationModelSummariesList;
    ArrayList<ArrayList<FaultSectionPrefData>> faulSectionIDListList = new ArrayList();

    public DeformationModelFileGenerator() {
        this.loadDefModels();
    }

    private void loadDefModels() {
        this.deformationModelSummariesList = this.summaries.getAllDeformationModels();
        for (DeformationModelSummary summary : this.deformationModelSummariesList) {
            int id = summary.getDeformationModelId();
            ArrayList<FaultSectionPrefData> faultSections = this.defModels.getAllFaultSectionPrefData(id);
            ArrayList<FaultSectionPrefData> noSlips = new ArrayList<FaultSectionPrefData>();
            for (FaultSectionPrefData section : faultSections) {
                if (section.getOrigAveSlipRate() != Double.NaN && !("" + section.getOrigAveSlipRate()).equals("NaN")) continue;
                noSlips.add(section);
            }
            int before = faultSections.size();
            if (noSlips.size() > 0) {
                faultSections.removeAll(noSlips);
            }
            System.out.println("Removed " + (before - faultSections.size()) + " NaN Faults for " + summary.getDeformationModelName() + " (" + summary.getFaultModel().getFaultModelName() + ")");
            if (this.sort) {
                Collections.sort(faultSections, new FaultSectionNameComparator());
            }
            this.faulSectionIDListList.add(faultSections);
        }
    }

    public void saveToFiles() {
        for (int i = 0; i < this.deformationModelSummariesList.size(); ++i) {
            DeformationModelSummary summary = this.deformationModelSummariesList.get(i);
            ArrayList<FaultSectionPrefData> sections = this.faulSectionIDListList.get(i);
            String filePrefix = "org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/data/finalReferenceFaultParamDb/fileGen/DeformationModel_" + summary.getDeformationModelName();
            this.saveDefModelToXML(summary, sections, filePrefix);
            this.saveDefModelToText(summary, sections, filePrefix);
        }
    }

    private void saveDefModelToText(DeformationModelSummary model, ArrayList<FaultSectionPrefData> sections, String filePrefix) {
        String fileName = filePrefix + ".txt";
        System.out.println("Writing Text " + model.getDeformationModelName() + " to " + fileName);
        try {
            FileWriter fw = new FileWriter(fileName);
            fw.write("#********************************\n");
            fw.write("# This file represents a WGCEP UCERF 2 Deformation Model\n");
            fw.write("#\n");
            fw.write("# Deformation Model Name: " + model.getDeformationModelName() + "\n");
            fw.write("# Fault Model Name: " + model.getFaultModel().getFaultModelName() + "\n");
            fw.write("#\n");
            fw.write("# Each fault trace is separated by an empty line.\n");
            fw.write("# The fields for each fault section are as follows:\n");
            fw.write("# Section Name\n");
            fw.write("# Ave Upper Seis Depth (km)\n");
            fw.write("# Ave Lower Seis Depth (km)\n");
            fw.write("# Ave Dip (degrees) defined by http://www.opensha.org/documentation/glossary/AkiRichardsDefn.html\n");
            fw.write("# Ave Long Term Slip Rate\n");
            fw.write("# Ave Long Term Slip Rate Standard Deviation\n");
            fw.write("# Ave Aseismic Slip Factor\n");
            fw.write("# Ave Rake defined by http://www.opensha.org/documentation/glossary/AkiRichardsDefn.html\n");
            fw.write("# Num Trace Points\n");
            fw.write("# lat1 lon1\n");
            fw.write("# lat2 lon2\n");
            fw.write("# latN lonN\n");
            fw.write("#********************************\n");
            for (FaultSectionPrefData section : sections) {
                fw.write(section.getSectionName() + "\n");
                fw.write((float)section.getOrigAveUpperDepth() + "\n");
                fw.write((float)section.getAveLowerDepth() + "\n");
                fw.write((float)section.getAveDip() + "\n");
                fw.write((float)section.getOrigAveSlipRate() + "\n");
                fw.write((float)section.getOrigSlipRateStdDev() + "\n");
                fw.write((float)section.getAseismicSlipFactor() + "\n");
                fw.write((float)section.getAveRake() + "\n");
                FaultTrace trace = section.getFaultTrace();
                fw.write(trace.getNumLocations() + "\n");
                for (int i = 0; i < trace.getNumLocations(); ++i) {
                    Location loc = (Location)trace.get(i);
                    fw.write(loc.getLatitude() + " " + loc.getLongitude() + "\n");
                }
                fw.write("\n");
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveDefModelToXML(DeformationModelSummary model, ArrayList<FaultSectionPrefData> sections, String filePrefix) {
        String fileName = filePrefix + ".xml";
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("DeformationModel");
        root = model.toXMLMetadata(root);
        root = model.getFaultModel().toXMLMetadata(root);
        Element sectionsEl = root.addElement("FaultSections");
        for (FaultSectionPrefData section : sections) {
            sectionsEl = section.toXMLMetadata(root);
        }
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            System.out.println("Writing XML " + model.getDeformationModelName() + " to " + fileName);
            XMLWriter writer = new XMLWriter((Writer)new FileWriter(fileName), format);
            writer.write(document);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void printComparisonTable() {
        ArrayList<Integer> differing = new ArrayList<Integer>();
        int max_model = 3;
        for (int i = 0; i < this.deformationModelSummariesList.size() && i != max_model; ++i) {
            DeformationModelSummary summary = this.deformationModelSummariesList.get(i);
            ArrayList<FaultSectionPrefData> sections = this.faulSectionIDListList.get(i);
            block1: for (int j = 0; j < sections.size(); ++j) {
                FaultSectionPrefData section = sections.get(j);
                for (int k = 0; k < this.deformationModelSummariesList.size() && k != max_model; ++k) {
                    float slip2;
                    DeformationModelSummary summary2 = this.deformationModelSummariesList.get(k);
                    ArrayList<FaultSectionPrefData> sections2 = this.faulSectionIDListList.get(k);
                    FaultSectionPrefData section2 = sections2.get(j);
                    float slip1 = (float)section.getOrigAveSlipRate();
                    if (slip1 == (slip2 = (float)section2.getOrigAveSlipRate())) continue;
                    boolean contains = false;
                    for (Integer theInt : differing) {
                        int l = theInt;
                        if (l != j) continue;
                        contains = true;
                        break;
                    }
                    if (contains) continue block1;
                    differing.add(j);
                    continue block1;
                }
            }
            if (i > 0) {
                System.out.print("\t\t");
            }
            System.out.print(summary.getDeformationModelName());
        }
        for (Integer id : differing) {
            System.out.println();
            for (int i = 0; i < this.deformationModelSummariesList.size() && i != max_model; ++i) {
                ArrayList<FaultSectionPrefData> sections = this.faulSectionIDListList.get(i);
                float slip = (float)sections.get(id).getOrigAveSlipRate();
                float stdDev = (float)sections.get(id).getOrigSlipRateStdDev();
                System.out.print(slip + "(" + stdDev + ")\t");
            }
            System.out.print(this.faulSectionIDListList.get(0).get(id).getSectionName());
        }
    }

    public static void main(String[] args) {
        DeformationModelFileGenerator gen = new DeformationModelFileGenerator();
        gen.saveToFiles();
        gen.printComparisonTable();
    }

    class FaultSectionNameComparator
    implements Comparator<FaultSectionPrefData> {
        private Collator c = Collator.getInstance();

        FaultSectionNameComparator() {
        }

        @Override
        public int compare(FaultSectionPrefData f1, FaultSectionPrefData f2) {
            if (f1 == f2) {
                return 0;
            }
            return this.c.compare(f1.getSectionName(), f2.getSectionName());
        }
    }
}

