/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.FaultSegmentData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UnsegmentedSource;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

class B_FaultDataTableModel
extends AbstractTableModel {
    private static final String[] columnNames = new String[]{"Name", "Mag", "Tot Rate", "Tot Prob", "Prob (M>=6.7)", "Slip Rate (mm/yr)", "Area (sq-km)", "Length (km)", "Moment Rate", "Ave Aseismicity", "Mag Freq Dist"};
    private ArrayList unsegmentedSourceList;
    private static final DecimalFormat SLIP_RATE_FORMAT = new DecimalFormat("0.#####");
    private static final DecimalFormat AREA_LENGTH_FORMAT = new DecimalFormat("0.#");
    private static final DecimalFormat MOMENT_FORMAT = new DecimalFormat("0.000E0");
    private static final DecimalFormat MAG_FORMAT = new DecimalFormat("0.00");
    private static final DecimalFormat RATE_FORMAT = new DecimalFormat("0.00000");
    private static final DecimalFormat ASEISMSIC_FORMAT = new DecimalFormat("0.00");

    public B_FaultDataTableModel() {
        this(null);
    }

    public B_FaultDataTableModel(ArrayList unsegmentedSourceList) {
        this.setUnsegmentedSourceList(unsegmentedSourceList);
    }

    public void setUnsegmentedSourceList(ArrayList unsegmentedSourceList) {
        if (unsegmentedSourceList == null) {
            this.unsegmentedSourceList = null;
        } else {
            TreeMap<String, UnsegmentedSource> map = new TreeMap<String, UnsegmentedSource>();
            for (int i = 0; i < unsegmentedSourceList.size(); ++i) {
                UnsegmentedSource source = (UnsegmentedSource)unsegmentedSourceList.get(i);
                map.put(source.getFaultSegmentData().getFaultName(), source);
            }
            this.unsegmentedSourceList = new ArrayList(map.values());
        }
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int index) {
        return columnNames[index];
    }

    @Override
    public int getRowCount() {
        if (this.unsegmentedSourceList == null) {
            return 0;
        }
        return this.unsegmentedSourceList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.unsegmentedSourceList == null) {
            return "";
        }
        UnsegmentedSource source = (UnsegmentedSource)this.unsegmentedSourceList.get(rowIndex);
        FaultSegmentData faultSegmentData = source.getFaultSegmentData();
        switch (columnIndex) {
            case 0: {
                return faultSegmentData.getFaultName();
            }
            case 1: {
                return MAG_FORMAT.format(source.getSourceMag());
            }
            case 2: {
                return "" + (float)source.getMagFreqDist().getTotalIncrRate();
            }
            case 3: {
                return "" + (float)source.computeTotalProbAbove(6.7);
            }
            case 4: {
                return "" + (float)source.computeTotalProb();
            }
            case 5: {
                return SLIP_RATE_FORMAT.format(faultSegmentData.getTotalAveSlipRate() * 1000.0);
            }
            case 6: {
                return AREA_LENGTH_FORMAT.format(faultSegmentData.getTotalArea() / 1000000.0);
            }
            case 7: {
                return AREA_LENGTH_FORMAT.format(faultSegmentData.getTotalLength() / 1000.0);
            }
            case 8: {
                return MOMENT_FORMAT.format(source.getMomentRate());
            }
            case 9: {
                return ASEISMSIC_FORMAT.format(faultSegmentData.getTotalAveAseismicityFactor());
            }
            case 10: {
                ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
                IncrementalMagFreqDist magFreqDist1 = source.getMagFreqDist();
                magFreqDist1.setName("Mag Freq Dist");
                EvenlyDiscretizedFunc cumFreqDist1 = magFreqDist1.getCumRateDistWithOffset();
                cumFreqDist1.setName("Cumulative Mag Freq Dist");
                funcs.add(magFreqDist1);
                funcs.add(cumFreqDist1);
                IncrementalMagFreqDist magFreqDist2 = source.getVisibleSourceMagFreqDist();
                magFreqDist2.setName("Visible Mag Freq Dist (Dashed Lines)");
                EvenlyDiscretizedFunc cumFreqDist2 = magFreqDist2.getCumRateDistWithOffset();
                cumFreqDist2.setName("Visible Cumulative Mag Freq Dist (Dashed Lines)");
                funcs.add(magFreqDist2);
                funcs.add(cumFreqDist2);
                return funcs;
            }
        }
        return "";
    }
}

