/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.A_Faults.A_FaultSegmentedSourceGenerator;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.FaultSegmentData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UnsegmentedSource;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui.B_FaultDataPanel;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui.C_ZoneDataPanel;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui.EqkRateModel2_MFDsPlotter;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui.ProbsTableModel;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui.RuptureDataPanel;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui.RuptureTableModel;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui.SegmentDataPanel;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui.SegmentDataTableModel;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class EqkRateModel2_Output_Window
extends JFrame
implements ActionListener,
ParameterChangeListener {
    private static final String CUM_PLOT_LABEL = "Cumulative  Rates";
    private static final String INCR_PLOT_LABEL = "Incremental  Rates";
    private JButton plotCumMFDsButton = new JButton("Plot Cum Mag Freq Dist");
    private JButton plotIncrMFDsButton = new JButton("Plot Incr Mag Freq Dist");
    private JButton modSlipRateButton = new JButton("Plot Histogram of Normalized Slip-Rate Residuals ((Final_SR-Orig_SR)/SR_Sigma)");
    private JButton dataERButton = new JButton("Plot Histogram of Normalized Segment Event-Rate Residuals - (Final_ER-Data_ER)/ER_Sigma");
    private JButton predERButton = new JButton("Plot the ratio of Final to Pred Segment Event Rate");
    private JButton rupRatesRatioButton = new JButton("Plot Histogram of (FinalRate-A_PrioriRate)/Max(A_PrioriRate,FinalRate)");
    private JButton aFaultsSegDataButton = new JButton("Table of all A-Faults Segment Data");
    private JButton aFaultsRupDataButton = new JButton("Table of all A-Faults Rupture Data");
    private JButton probContrButton = new JButton("Table of all Probability Contributions");
    private UCERF2 ucerf2;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private HashMap aFaultSourceMap;
    private SegmentDataPanel segmentDataPanel;
    private RuptureDataPanel ruptureDataPanel;
    private static final int W = 800;
    private static final int H = 800;
    private StringParameter aFaultParam;
    private static final String A_FAULT_PARAM_NAME = "A Fault";
    private boolean isUnsegmented;
    private ArrayList<Double> normModlSlipRateRatioList;
    private ArrayList<Double> normDataER_RatioList;
    private ArrayList<Double> predER_RatioList;
    private ArrayList<Double> normRupRatesRatioList;
    private boolean isAseisReducesArea;
    private JTable aFaultsSegData;
    private JTable aFaultsRupData;
    private JTable probContrTable;
    private EqkRateModel2_MFDsPlotter cumMfdsPlotter;
    private EqkRateModel2_MFDsPlotter incrMfdsPlotter;

    public EqkRateModel2_Output_Window(UCERF2 ucerf2) {
        this.ucerf2 = ucerf2;
        this.createGUI();
        this.pack();
        this.setSize(800, 800);
        this.show();
    }

    private void createGUI() {
        this.isAseisReducesArea = true;
        JPanel aFaultSummaryPanel = this.getA_FaultSummaryGUI();
        this.tabbedPane.addTab("Total Model Summary", this.getTotalModelSummaryGUI());
        this.tabbedPane.addTab("A Fault Summary", aFaultSummaryPanel);
        this.tabbedPane.addTab("B Fault Summary", this.getB_FaultSummaryGUI());
        this.tabbedPane.addTab("C Zones Summary", this.getC_ZonesSummaryGUI());
        if (!this.isUnsegmented) {
            this.calcNormModSlipRateResids();
            this.calcNormDataER_Resids();
            this.calcPredERRatio();
            this.calcNormRupRatesDiff();
            this.calcA_FaultRupData();
            this.calcA_FaultSegData();
            this.probContrTable = new JTable(new ProbsTableModel(this.ucerf2));
        } else {
            this.modSlipRateButton.setVisible(false);
            this.predERButton.setVisible(false);
            this.dataERButton.setVisible(false);
            this.rupRatesRatioButton.setVisible(false);
            this.aFaultsRupDataButton.setVisible(false);
            this.aFaultsSegDataButton.setVisible(false);
        }
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        container.add((Component)this.tabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getTotalModelSummaryGUI() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.cumMfdsPlotter = new EqkRateModel2_MFDsPlotter(this.ucerf2, true);
        this.incrMfdsPlotter = new EqkRateModel2_MFDsPlotter(this.ucerf2, false);
        JTextArea textArea = new JTextArea();
        textArea.setText("");
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        if (this.ucerf2.getParameter("Probability Model").getValue().equals("Empirical")) {
            textArea.append("Important Note: The influence of the Empirical Model is not included in the magnitude-frequency distributions plotted here.  However, the influence is included in the rupture and segment probabilities and gains shown for the Type A faults. The influence is also included in Total Prob for B-Faults\n\n");
        }
        IncrementalMagFreqDist totalMFD = this.ucerf2.getTotalMFD();
        textArea.append("Total Rate (M>=5) = " + (float)totalMFD.getTotalIncrRate() + "\n");
        boolean includeAfterShocks = this.ucerf2.areAfterShocksIncluded();
        textArea.append("Predicted 6.5 rate over observed = " + totalMFD.getCumRate(6.5 + totalMFD.getDelta() / 2.0) / UCERF2.getObsCumMFD(includeAfterShocks).get(0).getInterpolatedY(6.5 + totalMFD.getDelta() / 2.0) + "\n");
        textArea.append("Total Moment Rate = " + (float)totalMFD.getTotalMomentRate() + "\n");
        if (!this.isUnsegmented) {
            textArea.append("\nTotal A-Fault Pred Errors:\n");
            textArea.append("\n\tGen Pred Error = " + (float)this.ucerf2.getGeneralPredErr() + "\n");
            textArea.append("\tSeg Slip Rate Error = " + (float)this.ucerf2.getModSlipRateError() + "\n");
            textArea.append("\tSeg Event Rate Error = " + (float)this.ucerf2.getDataER_Err() + "\n");
            textArea.append("\tA-Priori Rup Rate Error = " + (float)this.ucerf2.getNormalizedA_PrioriRateErr() + "  ");
            textArea.append("(non-normalized = " + (float)this.ucerf2.getNonNormalizedA_PrioriRateErr() + ")\n\n\n");
        }
        textArea.append("\tRate (M>=5)\tRate (M>=6.5)\tMoment Rate\n");
        textArea.append("------------------------------------------------\n");
        textArea.append("A Faults\t" + (float)this.ucerf2.getTotal_A_FaultsMFD().getTotalIncrRate() + "\t" + (float)this.ucerf2.getTotal_A_FaultsMFD().getCumRate(6.5 + totalMFD.getDelta() / 2.0) + "\t" + (float)this.ucerf2.getTotal_A_FaultsMFD().getTotalMomentRate() + "\n");
        textArea.append("B Char\t" + (float)this.ucerf2.getTotal_B_FaultsCharMFD().getTotalIncrRate() + "\t" + (float)this.ucerf2.getTotal_B_FaultsCharMFD().getCumRate(6.5 + totalMFD.getDelta() / 2.0) + "\t" + (float)this.ucerf2.getTotal_B_FaultsCharMFD().getTotalMomentRate() + "\n");
        textArea.append("B GR\t" + (float)this.ucerf2.getTotal_B_FaultsGR_MFD().getTotalIncrRate() + "\t" + (float)this.ucerf2.getTotal_B_FaultsGR_MFD().getCumRate(6.5 + totalMFD.getDelta() / 2.0) + "\t" + (float)this.ucerf2.getTotal_B_FaultsGR_MFD().getTotalMomentRate() + "\n");
        textArea.append("B (Non-CA)\t" + (float)this.ucerf2.getTotal_NonCA_B_FaultsMFD().getTotalIncrRate() + "\t" + (float)this.ucerf2.getTotal_NonCA_B_FaultsMFD().getCumRate(6.5 + totalMFD.getDelta() / 2.0) + "\t" + (float)this.ucerf2.getTotal_NonCA_B_FaultsMFD().getTotalMomentRate() + "\n");
        textArea.append("C Zone\t" + (float)this.ucerf2.getTotal_C_ZoneMFD().getTotalIncrRate() + "\t" + (float)this.ucerf2.getTotal_C_ZoneMFD().getCumRate(6.5 + totalMFD.getDelta() / 2.0) + "\t" + (float)this.ucerf2.getTotal_C_ZoneMFD().getTotalMomentRate() + "\n");
        textArea.append("Background\t" + (float)this.ucerf2.getTotal_BackgroundMFD().getTotalIncrRate() + "\t" + (float)this.ucerf2.getTotal_BackgroundMFD().getCumRate(6.5 + totalMFD.getDelta() / 2.0) + "\t" + (float)this.ucerf2.getTotal_BackgroundMFD().getTotalMomentRate() + "\n");
        textArea.append("Total\t" + (float)totalMFD.getTotalIncrRate() + "\t" + (float)totalMFD.getCumRate(6.5 + totalMFD.getDelta() / 2.0) + "\t" + (float)totalMFD.getTotalMomentRate() + "\n\n");
        textArea.append("Adjustable Params Metadata:\n");
        textArea.append(this.ucerf2.getAdjustableParameterList().getParameterListMetadataString("\n"));
        textArea.append("\n" + this.ucerf2.getTimeSpan().getAdjustableParams().getParameterListMetadataString("\n"));
        panel.add((Component)new JScrollPane(textArea), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.plotCumMFDsButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.plotIncrMFDsButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.modSlipRateButton, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.predERButton, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.dataERButton, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.rupRatesRatioButton, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.aFaultsRupDataButton, new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.aFaultsSegDataButton, new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.probContrButton, new GridBagConstraints(0, 9, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        textArea.setEditable(false);
        this.plotCumMFDsButton.addActionListener(this);
        this.plotIncrMFDsButton.addActionListener(this);
        this.modSlipRateButton.addActionListener(this);
        this.predERButton.addActionListener(this);
        this.dataERButton.addActionListener(this);
        this.rupRatesRatioButton.addActionListener(this);
        this.aFaultsRupDataButton.addActionListener(this);
        this.aFaultsSegDataButton.addActionListener(this);
        this.probContrButton.addActionListener(this);
        return panel;
    }

    private void calcA_FaultSegData() {
        ArrayList<String> faultNames = this.aFaultParam.getAllowedStrings();
        int totalRows = faultNames.size();
        for (int srcIndex = 0; srcIndex < faultNames.size(); ++srcIndex) {
            A_FaultSegmentedSourceGenerator source = (A_FaultSegmentedSourceGenerator)this.aFaultSourceMap.get(faultNames.get(srcIndex));
            totalRows += source.getFaultSegmentData().getNumSegments() + 1;
        }
        int totalCols = SegmentDataTableModel.columnNames.length;
        Object[][] rowData = new Object[totalRows][totalCols];
        int rowIndex = 0;
        SegmentDataTableModel segTableModel = new SegmentDataTableModel();
        for (int srcIndex = 0; srcIndex < faultNames.size(); ++srcIndex) {
            A_FaultSegmentedSourceGenerator source = (A_FaultSegmentedSourceGenerator)this.aFaultSourceMap.get(faultNames.get(srcIndex));
            FaultSegmentData faultSegmentData = source.getFaultSegmentData();
            rowData[rowIndex][0] = faultSegmentData.getFaultName();
            for (int colIndex = 1; colIndex < totalCols; ++colIndex) {
                rowData[rowIndex][colIndex] = "";
            }
            ++rowIndex;
            segTableModel.setFaultData(faultSegmentData, source, null);
            int segIndex = 0;
            while (segIndex <= faultSegmentData.getNumSegments()) {
                for (int colIndex = 0; colIndex < totalCols; ++colIndex) {
                    rowData[rowIndex][colIndex] = segTableModel.getValueAt(segIndex, colIndex);
                }
                ++segIndex;
                ++rowIndex;
            }
        }
        this.aFaultsSegData = new JTable(rowData, SegmentDataTableModel.columnNames);
        this.aFaultsSegData.setColumnSelectionAllowed(true);
    }

    private void calcA_FaultRupData() {
        ArrayList<String> faultNames = this.aFaultParam.getAllowedStrings();
        int totalRows = faultNames.size();
        for (int srcIndex = 0; srcIndex < faultNames.size(); ++srcIndex) {
            A_FaultSegmentedSourceGenerator source = (A_FaultSegmentedSourceGenerator)this.aFaultSourceMap.get(faultNames.get(srcIndex));
            totalRows += source.getNumRupSources() + 1;
        }
        int totalCols = RuptureTableModel.columnNames.length;
        Object[][] rowData = new Object[totalRows][totalCols];
        int rowIndex = 0;
        RuptureTableModel rupTableModel = new RuptureTableModel();
        for (int srcIndex = 0; srcIndex < faultNames.size(); ++srcIndex) {
            A_FaultSegmentedSourceGenerator source = (A_FaultSegmentedSourceGenerator)this.aFaultSourceMap.get(faultNames.get(srcIndex));
            FaultSegmentData faultSegmentData = source.getFaultSegmentData();
            rowData[rowIndex][0] = faultSegmentData.getFaultName();
            for (int colIndex = 1; colIndex < totalCols; ++colIndex) {
                rowData[rowIndex][colIndex] = "";
            }
            ++rowIndex;
            rupTableModel.setFaultSegmentedSource(source);
            int rupIndex = 0;
            while (rupIndex <= source.getNumRupSources()) {
                for (int colIndex = 0; colIndex < totalCols; ++colIndex) {
                    rowData[rowIndex][colIndex] = rupTableModel.getValueAt(rupIndex, colIndex);
                }
                ++rupIndex;
                ++rowIndex;
            }
        }
        this.aFaultsRupData = new JTable(rowData, RuptureTableModel.columnNames);
        this.aFaultsRupData.setColumnSelectionAllowed(true);
    }

    private JPanel getA_FaultSummaryGUI() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.aFaultSourceMap = new HashMap();
        ArrayList aFaultSourceGenerators = this.ucerf2.get_A_FaultSourceGenerators();
        String rupModel = (String)this.ucerf2.getParameter("A-Fault Solution Type").getValue();
        if (rupModel.equalsIgnoreCase("Unsegmented Model")) {
            this.isUnsegmented = true;
            this.predERButton.setVisible(false);
            this.dataERButton.setVisible(false);
        } else {
            this.isUnsegmented = false;
            this.predERButton.setVisible(true);
            this.dataERButton.setVisible(true);
        }
        if (aFaultSourceGenerators == null) {
            return panel;
        }
        this.segmentDataPanel = new SegmentDataPanel();
        ArrayList<String> faultNames = new ArrayList<String>();
        for (int i = 0; i < aFaultSourceGenerators.size(); ++i) {
            Object source = aFaultSourceGenerators.get(i);
            FaultSegmentData faultSegmentData = this.getFaultSegmentData(source);
            faultNames.add(faultSegmentData.getFaultName());
            this.aFaultSourceMap.put(faultSegmentData.getFaultName(), source);
        }
        this.aFaultParam = new StringParameter(A_FAULT_PARAM_NAME, faultNames, (String)faultNames.get(0));
        this.aFaultParam.addParameterChangeListener(this);
        ConstrainedStringParameterEditor paramEditor = new ConstrainedStringParameterEditor(this.aFaultParam);
        panel.add((Component)paramEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JTabbedPane segmentInfoTabbedPane = new JTabbedPane();
        segmentInfoTabbedPane.addTab("Segment Info", this.segmentDataPanel);
        if (this.isUnsegmented) {
            B_FaultDataPanel bFaultDataPanel = new B_FaultDataPanel();
            bFaultDataPanel.setB_FaultSources(aFaultSourceGenerators);
            segmentInfoTabbedPane.addTab("Rupture Info", bFaultDataPanel);
        } else {
            this.ruptureDataPanel = new RuptureDataPanel();
            segmentInfoTabbedPane.addTab("Rupture Info", this.ruptureDataPanel);
            this.ruptureDataPanel.setSourcesForMagAreaPlot(aFaultSourceGenerators, this.ucerf2.getMagAreaRelationships());
        }
        panel.add((Component)segmentInfoTabbedPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.updateA_FaultTableData();
        return panel;
    }

    private FaultSegmentData getFaultSegmentData(Object source) {
        if (this.isUnsegmented) {
            return ((UnsegmentedSource)source).getFaultSegmentData();
        }
        return ((A_FaultSegmentedSourceGenerator)source).getFaultSegmentData();
    }

    private JPanel getB_FaultSummaryGUI() {
        JPanel panel = new JPanel(new GridBagLayout());
        ArrayList bFaultSources = this.ucerf2.get_B_FaultSources();
        B_FaultDataPanel bFaultDataPanel = new B_FaultDataPanel();
        bFaultDataPanel.setB_FaultSources(bFaultSources);
        panel.add((Component)bFaultDataPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getC_ZonesSummaryGUI() {
        JPanel panel = new JPanel(new GridBagLayout());
        ArrayList<IncrementalMagFreqDist> cZonesMFDs = this.ucerf2.getC_ZoneMFD_List();
        C_ZoneDataPanel cZonesDataPanel = new C_ZoneDataPanel();
        cZonesDataPanel.setC_ZonesMFD_List(cZonesMFDs);
        panel.add((Component)cZonesDataPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.updateA_FaultTableData();
    }

    private void updateA_FaultTableData() {
        String selectedFault = (String)this.aFaultParam.getValue();
        Object source = this.aFaultSourceMap.get(selectedFault);
        if (!this.isUnsegmented) {
            this.ruptureDataPanel.setSource((A_FaultSegmentedSourceGenerator)source);
            this.segmentDataPanel.setFaultSegmentData((A_FaultSegmentedSourceGenerator)source, null, this.isAseisReducesArea, this.ucerf2.getMagAreaRelationships());
        } else {
            this.segmentDataPanel.setEventRatesList(this.ucerf2.getA_FaultsFetcher().getEventRatesList());
            this.segmentDataPanel.setFaultSegmentData(null, (UnsegmentedSource)source, this.isAseisReducesArea, this.ucerf2.getMagAreaRelationships());
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.plotCumMFDsButton) {
            GraphWindow graphWindow = new GraphWindow(this.cumMfdsPlotter.getCurveFunctionList(), CUM_PLOT_LABEL, this.cumMfdsPlotter.getPlottingFeatures());
            graphWindow.setVisible(true);
        } else if (src == this.plotIncrMFDsButton) {
            GraphWindow graphWindow = new GraphWindow(this.incrMfdsPlotter.getCurveFunctionList(), INCR_PLOT_LABEL, this.incrMfdsPlotter.getPlottingFeatures());
            graphWindow.setVisible(true);
        } else if (src == this.modSlipRateButton) {
            String plotLabel = "Normalized Segment Slip-Rate Residuals\n((Final_SR-Orig_SR)/SR_Sigma)";
            this.showHistograms(this.normModlSlipRateRatioList, plotLabel, "Normalized Segment Slip-Rate Residuals");
        } else if (src == this.dataERButton) {
            String plotLabel = "Normalized Segment Event-Rate Residuals\n((Final_ER-Data_ER)/ER_Sigma)";
            this.showHistograms(this.normDataER_RatioList, plotLabel, "Normalized Segment Event-Rate Residuals");
        } else if (src == this.predERButton) {
            String plotLabel = "Final vs Pred Segment Event Rate Ratios";
            this.showHistograms(this.predER_RatioList, plotLabel, "Ratio of final Event Ratio to Pred Event Ratio");
        } else if (src == this.rupRatesRatioButton) {
            String plotLabel = "Histogram of (FinalRate-A_PrioriRate)/Max(A_PrioriRate,FinalRate)";
            this.showHistograms(this.normRupRatesRatioList, plotLabel, plotLabel);
        } else if (src == this.aFaultsSegDataButton) {
            JFrame frame = new JFrame();
            frame.getContentPane().setLayout(new GridBagLayout());
            frame.getContentPane().add((Component)new JScrollPane(this.aFaultsSegData), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            frame.pack();
            frame.show();
        } else if (src == this.aFaultsRupDataButton) {
            JFrame frame = new JFrame();
            frame.getContentPane().setLayout(new GridBagLayout());
            frame.getContentPane().add((Component)new JScrollPane(this.aFaultsRupData), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            frame.pack();
            frame.show();
        } else if (src == this.probContrButton) {
            JFrame frame = new JFrame();
            frame.getContentPane().setLayout(new GridBagLayout());
            frame.getContentPane().add((Component)new JScrollPane(this.probContrTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            frame.pack();
            frame.show();
        }
    }

    private void calcNormRupRatesDiff() {
        ArrayList sourceGeneratorList = this.ucerf2.get_A_FaultSourceGenerators();
        this.normRupRatesRatioList = new ArrayList();
        for (int i = 0; i < sourceGeneratorList.size(); ++i) {
            A_FaultSegmentedSourceGenerator source = (A_FaultSegmentedSourceGenerator)sourceGeneratorList.get(i);
            int numRuptures = source.getNumRupSources();
            for (int rupIndex = 0; rupIndex < numRuptures; ++rupIndex) {
                this.normRupRatesRatioList.add(source.getRupRateResid(rupIndex));
            }
        }
    }

    private void calcNormModSlipRateResids() {
        ArrayList sourceGeneratorList = this.ucerf2.get_A_FaultSourceGenerators();
        this.normModlSlipRateRatioList = new ArrayList();
        for (int i = 0; i < sourceGeneratorList.size(); ++i) {
            A_FaultSegmentedSourceGenerator source = (A_FaultSegmentedSourceGenerator)sourceGeneratorList.get(i);
            double[] normModResids = source.getNormModSlipRateResids();
            for (int segIndex = 0; segIndex < normModResids.length; ++segIndex) {
                this.normModlSlipRateRatioList.add(normModResids[segIndex]);
            }
        }
    }

    private void calcNormDataER_Resids() {
        ArrayList sourceGeneratorList = this.ucerf2.get_A_FaultSourceGenerators();
        this.normDataER_RatioList = new ArrayList();
        for (int i = 0; i < sourceGeneratorList.size(); ++i) {
            A_FaultSegmentedSourceGenerator source = (A_FaultSegmentedSourceGenerator)sourceGeneratorList.get(i);
            double[] normDataER_Resids = source.getNormDataER_Resids();
            for (int segIndex = 0; segIndex < normDataER_Resids.length; ++segIndex) {
                if (Double.isNaN(normDataER_Resids[segIndex])) continue;
                this.normDataER_RatioList.add(normDataER_Resids[segIndex]);
            }
        }
    }

    private void calcPredERRatio() {
        ArrayList sourceGeneratorList = this.ucerf2.get_A_FaultSourceGenerators();
        this.predER_RatioList = new ArrayList();
        for (int i = 0; i < sourceGeneratorList.size(); ++i) {
            A_FaultSegmentedSourceGenerator source = (A_FaultSegmentedSourceGenerator)sourceGeneratorList.get(i);
            int numSegments = source.getFaultSegmentData().getNumSegments();
            for (int segIndex = 0; segIndex < numSegments; ++segIndex) {
                this.predER_RatioList.add(source.getFinalSegmentRate(segIndex) / source.getSegRateFromAprioriRates(segIndex));
            }
        }
    }

    private void showHistograms(ArrayList<Double> ratioList, String plotLabel, String funcName) {
        double min = Math.floor(Collections.min(ratioList));
        double max = Math.ceil(Collections.max(ratioList));
        double delta = 0.2;
        EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(min, (int)Math.round((max - min) / delta) + 1, delta);
        func.setTolerance(func.getDelta());
        for (int i = 0; i < ratioList.size(); ++i) {
            int xIndex = func.getXIndex(ratioList.get(i));
            func.add(xIndex, 1.0);
        }
        ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
        funcs.add(func);
        String yAxisLabel = "Count";
        GraphWindow graphWindow = new GraphWindow(funcs, plotLabel);
        graphWindow.setY_AxisLabel(yAxisLabel);
        graphWindow.setVisible(true);
    }
}

