/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.oldClasses;

import java.util.ArrayList;
import java.util.Iterator;
import org.opensha.commons.exceptions.FaultException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.oldClasses.UCERF2_Final_RelativeLocation;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.EvenlyGriddedSurfFromSimpleFaultData;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.SimpleFaultData;

public class UCERF2_Final_StirlingGriddedSurface
extends EvenlyGriddedSurfFromSimpleFaultData {
    private static final long serialVersionUID = 1L;
    protected static final String C = "StirlingGriddedSurface";
    protected static final boolean D = false;
    protected double aveDipDir = Double.NaN;
    protected static final double PI_RADIANS = Math.PI / 180;
    protected static final String ERR = " is null, unable to process.";

    public UCERF2_Final_StirlingGriddedSurface(SimpleFaultData simpleFaultData, double gridSpacing) throws FaultException {
        super(simpleFaultData, gridSpacing);
        this.aveDipDir = simpleFaultData.getAveDipDir();
        this.createEvenlyGriddedSurface();
    }

    public UCERF2_Final_StirlingGriddedSurface(FaultTrace faultTrace, double aveDip, double upperSeismogenicDepth, double lowerSeismogenicDepth, double gridSpacing) throws FaultException {
        super(faultTrace, aveDip, upperSeismogenicDepth, lowerSeismogenicDepth, gridSpacing);
        this.createEvenlyGriddedSurface();
    }

    public UCERF2_Final_StirlingGriddedSurface(SimpleFaultData simpleFaultData, double maxGridSpacingAlong, double maxGridSpacingDown) throws FaultException {
        super(simpleFaultData, maxGridSpacingAlong, maxGridSpacingDown);
        this.aveDipDir = simpleFaultData.getAveDipDir();
        this.createEvenlyGriddedSurface();
    }

    public UCERF2_Final_StirlingGriddedSurface(FaultTrace faultTrace, double aveDip, double upperSeismogenicDepth, double lowerSeismogenicDepth, double gridSpacing, double aveDipDir) throws FaultException {
        super(faultTrace, aveDip, upperSeismogenicDepth, lowerSeismogenicDepth, gridSpacing);
        this.aveDipDir = aveDipDir;
        this.createEvenlyGriddedSurface();
    }

    public UCERF2_Final_StirlingGriddedSurface(ArrayList<SimpleFaultData> simpleFaultData, double gridSpacing) throws FaultException {
        super(UCERF2_Final_StirlingGriddedSurface.getCombinedSimpleFaultData(simpleFaultData), gridSpacing);
        this.createEvenlyGriddedSurface();
    }

    public static SimpleFaultData getCombinedSimpleFaultData(ArrayList<SimpleFaultData> simpleFaultDataList) {
        int i;
        if (simpleFaultDataList.size() == 1) {
            return simpleFaultDataList.get(0);
        }
        FaultTrace faultTrace1 = simpleFaultDataList.get(0).getFaultTrace();
        FaultTrace faultTrace2 = simpleFaultDataList.get(1).getFaultTrace();
        double minDist = Double.MAX_VALUE;
        boolean reverse = false;
        ArrayList<Integer> reversedIndices = new ArrayList<Integer>();
        double distance = UCERF2_Final_RelativeLocation.getHorzDistance((Location)faultTrace1.get(0), (Location)faultTrace2.get(0));
        if (distance < minDist) {
            minDist = distance;
            reverse = true;
        }
        if ((distance = UCERF2_Final_RelativeLocation.getHorzDistance((Location)faultTrace1.get(0), (Location)faultTrace2.get(faultTrace2.getNumLocations() - 1))) < minDist) {
            minDist = distance;
            reverse = true;
        }
        if ((distance = UCERF2_Final_RelativeLocation.getHorzDistance((Location)faultTrace1.get(faultTrace1.getNumLocations() - 1), (Location)faultTrace2.get(0))) < minDist) {
            minDist = distance;
            reverse = false;
        }
        if ((distance = UCERF2_Final_RelativeLocation.getHorzDistance((Location)faultTrace1.get(faultTrace1.getNumLocations() - 1), (Location)faultTrace2.get(faultTrace2.getNumLocations() - 1))) < minDist) {
            minDist = distance;
            reverse = false;
        }
        if (reverse) {
            reversedIndices.add(0);
            faultTrace1.reverse();
            if (simpleFaultDataList.get(0).getAveDip() != 90.0) {
                simpleFaultDataList.get(0).setAveDip(-simpleFaultDataList.get(0).getAveDip());
            }
        }
        double combinedDip = 0.0;
        double combinedUpperSeisDepth = 0.0;
        double totArea = 0.0;
        double totLength = 0.0;
        FaultTrace combinedFaultTrace = new FaultTrace("Combined Fault Sections");
        int num = simpleFaultDataList.size();
        for (i = 0; i < num; ++i) {
            FaultTrace faultTrace = simpleFaultDataList.get(i).getFaultTrace();
            int numLocations = faultTrace.getNumLocations();
            if (i > 0) {
                FaultTrace prevFaultTrace = simpleFaultDataList.get(i - 1).getFaultTrace();
                Location lastLoc = (Location)prevFaultTrace.get(prevFaultTrace.getNumLocations() - 1);
                double distance1 = UCERF2_Final_RelativeLocation.getHorzDistance(lastLoc, (Location)faultTrace.get(0));
                double distance2 = UCERF2_Final_RelativeLocation.getHorzDistance(lastLoc, (Location)faultTrace.get(faultTrace.getNumLocations() - 1));
                if (distance2 < distance1) {
                    faultTrace.reverse();
                    reversedIndices.add(i);
                    if (simpleFaultDataList.get(i).getAveDip() != 90.0) {
                        simpleFaultDataList.get(i).setAveDip(-simpleFaultDataList.get(i).getAveDip());
                    }
                }
                if (distance2 > 1.0 && distance1 > 1.0) {
                    combinedFaultTrace.add(((Location)faultTrace.get(0)).clone());
                }
                for (int locIndex = 1; locIndex < numLocations; ++locIndex) {
                    combinedFaultTrace.add(((Location)faultTrace.get(locIndex)).clone());
                }
            } else {
                for (int locIndex = 0; locIndex < numLocations; ++locIndex) {
                    combinedFaultTrace.add(((Location)faultTrace.get(locIndex)).clone());
                }
            }
            double length = UCERF2_Final_RelativeLocation.getOldFaultLength(faultTrace);
            double dip = simpleFaultDataList.get(i).getAveDip();
            double area = Math.abs(length * (simpleFaultDataList.get(i).getLowerSeismogenicDepth() - simpleFaultDataList.get(i).getUpperSeismogenicDepth()) / Math.sin(dip * Math.PI / 180.0));
            totLength += length;
            totArea += area;
            combinedUpperSeisDepth += area * simpleFaultDataList.get(i).getUpperSeismogenicDepth();
            if (dip > 0.0) {
                combinedDip += area * dip;
                continue;
            }
            combinedDip += area * (dip + 180.0);
        }
        for (i = 0; i < reversedIndices.size(); ++i) {
            int index = (Integer)reversedIndices.get(i);
            simpleFaultDataList.get(index).getFaultTrace().reverse();
            if (simpleFaultDataList.get(index).getAveDip() == 90.0) continue;
            simpleFaultDataList.get(index).setAveDip(-simpleFaultDataList.get(index).getAveDip());
        }
        double dip = combinedDip / totArea;
        if (dip > 90.0) {
            dip = 180.0 - dip;
            combinedFaultTrace.reverse();
        }
        SimpleFaultData simpleFaultData = new SimpleFaultData();
        simpleFaultData.setAveDip(dip);
        double upperSeismogenicDepth = combinedUpperSeisDepth / totArea;
        simpleFaultData.setUpperSeismogenicDepth(upperSeismogenicDepth);
        for (int i2 = 0; i2 < combinedFaultTrace.getNumLocations(); ++i2) {
            Location old = (Location)combinedFaultTrace.get(i2);
            Location loc = Location.backwardsCompatible(old.getLatitude(), old.getLongitude(), upperSeismogenicDepth);
            combinedFaultTrace.set(i2, loc);
        }
        simpleFaultData.setLowerSeismogenicDepth(totArea / totLength * Math.sin(dip * Math.PI / 180.0) + upperSeismogenicDepth);
        simpleFaultData.setFaultTrace(combinedFaultTrace);
        return simpleFaultData;
    }

    private void createEvenlyGriddedSurface() throws FaultException {
        Location firstLoc;
        String S = "StirlingGriddedSurface: createEvenlyGriddedSurface():";
        this.assertValidData();
        int numSegments = this.faultTrace.getNumLocations() - 1;
        double avDipRadians = this.aveDip * (Math.PI / 180);
        double gridSpacingCosAveDipRadians = this.gridSpacingDown * Math.cos(avDipRadians);
        double gridSpacingSinAveDipRadians = this.gridSpacingDown * Math.sin(avDipRadians);
        double[] segmentLenth = new double[numSegments];
        double[] segmentAzimuth = new double[numSegments];
        double[] segmentCumLenth = new double[numSegments];
        double cumDistance = 0.0;
        int i = 0;
        double aveDipDirection = Double.isNaN(this.aveDipDir) ? this.faultTrace.getDipDirection() : this.aveDipDir;
        Iterator it = this.faultTrace.iterator();
        Location lastLoc = firstLoc = (Location)it.next();
        Location loc = null;
        LocationVector dir = null;
        while (it.hasNext()) {
            loc = (Location)it.next();
            dir = UCERF2_Final_RelativeLocation.getDirection(lastLoc, loc);
            double azimuth = dir.getAzimuth();
            double distance = dir.getHorzDistance();
            segmentLenth[i] = distance;
            segmentAzimuth[i] = azimuth;
            segmentCumLenth[i] = cumDistance += distance;
            ++i;
            lastLoc = loc;
        }
        double downDipWidth = (this.lowerSeismogenicDepth - this.upperSeismogenicDepth) / Math.sin(avDipRadians);
        int rows = 1 + Math.round((float)(downDipWidth / this.gridSpacingDown));
        int cols = 1 + Math.round((float)(segmentCumLenth[numSegments - 1] / this.gridSpacingAlong));
        this.setNumRowsAndNumCols(rows, cols);
        for (int ith_col = 0; ith_col < cols; ++ith_col) {
            Location topLocation;
            double hDistance;
            double vDistance;
            int segmentNumber;
            double distanceAlong = (double)ith_col * this.gridSpacingAlong;
            for (segmentNumber = 1; segmentNumber <= numSegments && distanceAlong > segmentCumLenth[segmentNumber - 1]; ++segmentNumber) {
            }
            if (segmentNumber == numSegments + 1) {
                --segmentNumber;
            }
            double distance = segmentNumber > 1 ? distanceAlong - segmentCumLenth[segmentNumber - 2] : distanceAlong;
            Location location1 = (Location)this.faultTrace.get(segmentNumber - 1);
            Location traceLocation = UCERF2_Final_RelativeLocation.getLocation(location1, dir = new LocationVector(segmentAzimuth[segmentNumber - 1], distance, 0.0));
            if (traceLocation.getDepth() < this.upperSeismogenicDepth) {
                vDistance = traceLocation.getDepth() - this.upperSeismogenicDepth;
                hDistance = vDistance / Math.tan(avDipRadians);
                dir = new LocationVector(aveDipDirection, hDistance, vDistance);
                topLocation = UCERF2_Final_RelativeLocation.getLocation(traceLocation, dir);
            } else {
                topLocation = traceLocation;
            }
            this.set(0, ith_col, topLocation.clone());
            for (int ith_row = 1; ith_row < rows; ++ith_row) {
                hDistance = (double)ith_row * gridSpacingCosAveDipRadians;
                vDistance = (double)(-ith_row) * gridSpacingSinAveDipRadians;
                dir = new LocationVector(aveDipDirection, hDistance, vDistance);
                Location depthLocation = UCERF2_Final_RelativeLocation.getLocation(topLocation, dir);
                this.set(ith_row, ith_col, depthLocation.clone());
            }
        }
    }

    public static void main(String[] args) {
        double test = 4.0;
        System.out.println(test);
    }

    @Override
    public double getAveDipDirection() {
        return this.aveDipDir;
    }

    @Override
    public LocationList getPerimeter() {
        LocationList topTrace = new LocationList();
        LocationList botTrace = new LocationList();
        double avDipRadians = this.aveDip * (Math.PI / 180);
        double aveDipDirection = Double.isNaN(this.aveDipDir) ? this.faultTrace.getDipDirection() : this.aveDipDir;
        for (Location traceLoc : this.faultTrace) {
            double vDistance = this.upperSeismogenicDepth - traceLoc.getDepth();
            double hDistance = vDistance / Math.tan(avDipRadians);
            LocationVector dir = new LocationVector(aveDipDirection, hDistance, vDistance);
            Location topLoc = LocationUtils.location(traceLoc, dir);
            topTrace.add(topLoc);
            vDistance = this.lowerSeismogenicDepth - traceLoc.getDepth();
            hDistance = vDistance / Math.tan(avDipRadians);
            dir = new LocationVector(aveDipDirection, hDistance, vDistance);
            Location botLoc = LocationUtils.location(traceLoc, dir);
            botTrace.add(botLoc);
        }
        LocationList perimiter = new LocationList();
        perimiter.addAll(topTrace);
        botTrace.reverse();
        perimiter.addAll(botTrace);
        perimiter.add((Location)topTrace.get(0));
        return perimiter;
    }

    @Override
    protected AbstractEvenlyGriddedSurface getNewInstance() {
        throw new UnsupportedOperationException("Not supported");
    }
}

