/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.YuccaMountain;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.FaultRuptureSource;
import org.opensha.sha.earthquake.rupForecastImpl.GriddedRegionPoissonEqkSource;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurfaceWithSubsets;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.opensha.sha.magdist.GaussianMagFreqDist;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;

public class YuccaMountainERF
extends AbstractERF {
    private static String C = new String("YuccaMountainERF");
    private boolean D = false;
    public static final String NAME = new String("Yucca mountain Adj. ERF");
    private static final String FAULT_SOURCE_FILENAME = "/data/erf/yucca_mountain/FAULTmodelYM.txt";
    private static final String BG_FILE_NAME = "/data/erf/yucca_mountain/BACKGROUNDmodelYM.txt";
    private static final double MIN_MAG = 5.5;
    private static final double MAX_MAG = 8.5;
    private static final int NUM_MAGS = 31;
    private static final double DEFAULT_GRID_SPACING = 1.0;
    public static final String BACK_SEIS_NAME = new String("Background Seismicity");
    public static final String BACK_SEIS_INCLUDE = new String("Include");
    public static final String BACK_SEIS_EXCLUDE = new String("Exclude");
    private StringParameter backSeisParam;
    private ArrayList<String> sourceNames = new ArrayList();
    private ArrayList<Double> sourceMags = new ArrayList();
    private ArrayList<Double> sourceSigmas = new ArrayList();
    private ArrayList<Double> sourceRakes = new ArrayList();
    private ArrayList<Double> sourceMoRates = new ArrayList();
    private ArrayList<AbstractEvenlyGriddedSurfaceWithSubsets> sourceGriddedSurface = new ArrayList();
    private ArrayList<ProbEqkSource> allSources;
    private GutenbergRichterMagFreqDist backgroundMagDist;
    private GriddedRegion backgroundRegion;

    public YuccaMountainERF() {
        this.createFaultSurfaces();
        this.mkBackRegion();
        this.initAdjParams();
        this.timeSpan = new TimeSpan("None", "Years");
        this.timeSpan.addParameterChangeListener(this);
        this.timeSpan.setDuration(50.0);
    }

    private void initAdjParams() {
        ArrayList<String> backSeisOptionsStrings = new ArrayList<String>();
        backSeisOptionsStrings.add(BACK_SEIS_INCLUDE);
        backSeisOptionsStrings.add(BACK_SEIS_EXCLUDE);
        this.backSeisParam = new StringParameter(BACK_SEIS_NAME, backSeisOptionsStrings, BACK_SEIS_INCLUDE);
        this.backSeisParam.addParameterChangeListener(this);
        this.adjustableParams.addParameter(this.backSeisParam);
    }

    private void mkBackRegion() {
        try {
            ArrayList<String> fileLines = FileUtils.loadJarFile(BG_FILE_NAME);
            int i = 5;
            String sourceName = fileLines.get(i);
            StringTokenizer st = new StringTokenizer(sourceName);
            String srcCode = st.nextToken();
            int srcCodeLength = srcCode.length();
            String sourceNameString = sourceName.substring(srcCodeLength);
            String magDistInfo = fileLines.get(++i);
            st = new StringTokenizer(magDistInfo);
            double aVal = Double.parseDouble(st.nextToken().trim());
            double uncertainity = Double.parseDouble(st.nextToken().trim());
            double bVal = Double.parseDouble(st.nextToken().trim());
            double sigma = Double.parseDouble(st.nextToken().trim());
            double minMag = Double.parseDouble(st.nextToken().trim());
            double maxMag = Double.parseDouble(st.nextToken().trim());
            int numMag = Integer.parseInt(st.nextToken().trim());
            double totCumRate = Double.parseDouble(st.nextToken().trim());
            this.backgroundMagDist = new GutenbergRichterMagFreqDist(bVal, totCumRate, minMag, maxMag, numMag);
            String regionInfo = fileLines.get(++i);
            st = new StringTokenizer(regionInfo);
            double minLat = Double.parseDouble(st.nextToken().trim());
            double maxLat = Double.parseDouble(st.nextToken().trim());
            double minLon = Double.parseDouble(st.nextToken().trim());
            double maxLon = Double.parseDouble(st.nextToken().trim());
            double gridSpacing = Double.parseDouble(st.nextToken().trim());
            this.backgroundRegion = new GriddedRegion(new Location(minLat, minLon), new Location(maxLat, maxLon), gridSpacing, new Location(0.0, 0.0));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setMeanMagForSource(String sourceName, double mag) {
        int srcIndex = this.sourceNames.indexOf(sourceName);
        this.sourceMags.set(srcIndex, mag);
        this.parameterChangeFlag = true;
    }

    public void setMomentRateForSource(String sourceName, double momentRate) {
        int srcIndex = this.sourceNames.indexOf(sourceName);
        this.sourceMoRates.set(srcIndex, momentRate);
        this.parameterChangeFlag = true;
    }

    public void setBackgroundMFD(GutenbergRichterMagFreqDist backgroundMagDist) {
        this.backgroundMagDist = backgroundMagDist;
    }

    private void createFaultSurfaces() {
        try {
            ArrayList<String> fileLines = FileUtils.loadJarFile(FAULT_SOURCE_FILENAME);
            int size = fileLines.size();
            for (int i = 6; i < size; ++i) {
                String sourceName = fileLines.get(i);
                if (sourceName.trim().equals("")) continue;
                StringTokenizer st = new StringTokenizer(sourceName);
                String srcCode = st.nextToken();
                String sourceDipInfo = fileLines.get(++i);
                st = new StringTokenizer(sourceDipInfo);
                double dip = Double.parseDouble(st.nextToken().trim());
                double strike = Double.parseDouble(st.nextToken().trim());
                double rake = Double.parseDouble(st.nextToken().trim());
                double upperSeis = Double.parseDouble(st.nextToken().trim());
                double lowerSeis = Double.parseDouble(st.nextToken().trim());
                String sourceMFD = fileLines.get(++i);
                st = new StringTokenizer(sourceMFD);
                double meanMag = Double.parseDouble(st.nextToken().trim());
                double sigma = Double.parseDouble(st.nextToken().trim());
                double seisMomentRate = Double.parseDouble(st.nextToken().trim());
                int numSourceLocations = Integer.parseInt(fileLines.get(++i));
                FaultTrace fltTrace = new FaultTrace(srcCode);
                int numLinesDone = i++;
                while (i <= numLinesDone + numSourceLocations) {
                    String location = fileLines.get(i);
                    st = new StringTokenizer(location);
                    double lon = Double.parseDouble(st.nextToken().trim());
                    double lat = Double.parseDouble(st.nextToken().trim());
                    fltTrace.add(new Location(lat, lon));
                    ++i;
                }
                --i;
                StirlingGriddedSurface surface = new StirlingGriddedSurface(fltTrace, dip, upperSeis, lowerSeis, 1.0);
                this.sourceNames.add(srcCode);
                this.sourceMags.add(meanMag);
                this.sourceMoRates.add(seisMomentRate);
                this.sourceRakes.add(rake);
                this.sourceSigmas.add(sigma);
                this.sourceGriddedSurface.add(surface);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void mkFaultSources() {
        for (int srcIndex = 0; srcIndex < this.sourceNames.size(); ++srcIndex) {
            AbstractEvenlyGriddedSurfaceWithSubsets surface = this.sourceGriddedSurface.get(srcIndex);
            GaussianMagFreqDist magDist = new GaussianMagFreqDist(5.5, 8.5, 31, (double)this.sourceMags.get(srcIndex), (double)this.sourceSigmas.get(srcIndex), (double)this.sourceMoRates.get(srcIndex));
            FaultRuptureSource rupSource = new FaultRuptureSource(magDist, (RuptureSurface)surface, (double)this.sourceRakes.get(srcIndex), this.timeSpan.getDuration());
            rupSource.setName(this.sourceNames.get(srcIndex));
            this.allSources.add(rupSource);
        }
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.parameterChangeFlag = true;
    }

    @Override
    public int getNumSources() {
        return this.allSources.size();
    }

    @Override
    public ProbEqkSource getSource(int source) {
        return this.allSources.get(source);
    }

    public ArrayList getSourceList() {
        return this.allSources;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void updateForecast() {
        if (this.parameterChangeFlag) {
            this.allSources = new ArrayList();
            this.mkFaultSources();
            String bgVal = (String)this.backSeisParam.getValue();
            if (bgVal.equals(BACK_SEIS_INCLUDE)) {
                GriddedRegionPoissonEqkSource grSource = new GriddedRegionPoissonEqkSource(this.backgroundRegion, this.backgroundMagDist, this.timeSpan.getDuration(), -90.0, 60.0, this.backgroundMagDist.getMagLower());
                this.allSources.add(grSource);
            }
        }
        this.parameterChangeFlag = false;
    }
}

