/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import mpi.MPI;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.IntegerSampler;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.CubedGriddedRegion;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.geo.json.FeatureProperties;
import org.opensha.commons.logicTree.BranchWeightProvider;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.RupSetDeformationModel;
import org.opensha.sha.earthquake.faultSysSolution.RupSetFaultModel;
import org.opensha.sha.earthquake.faultSysSolution.RupSetScalingRelationship;
import org.opensha.sha.earthquake.faultSysSolution.RupSetSubsectioningModel;
import org.opensha.sha.earthquake.faultSysSolution.RuptureSets;
import org.opensha.sha.earthquake.faultSysSolution.inversion.ClusterSpecificInversionConfigurationFactory;
import org.opensha.sha.earthquake.faultSysSolution.inversion.ClusterSpecificInversionSolver;
import org.opensha.sha.earthquake.faultSysSolution.inversion.GridSourceProviderFactory;
import org.opensha.sha.earthquake.faultSysSolution.inversion.InversionConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.inversion.InversionSolver;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.ConstraintWeightingType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.JumpProbabilityConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.LaplacianSmoothingInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoRateInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoSlipInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.ParkfieldInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.SectionTotalRateConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.IterationCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.params.GenerationFunctionType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.params.NonnegativityConstraintType;
import org.opensha.sha.earthquake.faultSysSolution.modules.AveSlipModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.modules.FaultCubeAssociations;
import org.opensha.sha.earthquake.faultSysSolution.modules.FaultGridAssociations;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceList;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionMisfitStats;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModSectMinMags;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModelRegion;
import org.opensha.sha.earthquake.faultSysSolution.modules.PaleoseismicConstraintData;
import org.opensha.sha.earthquake.faultSysSolution.modules.PolygonFaultGridAssociations;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSubSetMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.SectSlipRates;
import org.opensha.sha.earthquake.faultSysSolution.modules.SlipAlongRuptureModel;
import org.opensha.sha.earthquake.faultSysSolution.modules.SolutionLogicTree;
import org.opensha.sha.earthquake.faultSysSolution.modules.SolutionSlipRates;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRuptureBuilder;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.JumpProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RuptureProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.ConnectivityCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSectionUtils;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.faultSysSolution.util.MaxMagOffFaultBranchNode;
import org.opensha.sha.earthquake.faultSysSolution.util.SlipAlongRuptureModelBranchNode;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.NSHM23_ConstraintBuilder;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.data.NSHM23_PaleoDataLoader;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.gridded.NSHM23_AbstractGridSourceProvider;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.gridded.NSHM23_CombinedRegionGridSourceProvider;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.gridded.NSHM23_FaultCubeAssociations;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.gridded.NSHM23_GridFocalMechs;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.gridded.NSHM23_SingleRegionGridSourceProvider;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_DeclusteringAlgorithms;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_DeformationModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_FaultModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_LogicTreeBranch;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_PaleoUncertainties;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_RegionalSeismicity;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_ScalingRelationships;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_SegmentationModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_SeisSmoothingAlgorithms;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_SingleStates;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_SlipAlongRuptureModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_U3_HybridLogicTreeBranch;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.RupsThroughCreepingSectBranchNode;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.RupturePlausibilityModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SectionSupraSeisBValues;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SegmentationMFD_Adjustment;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SegmentationModelBranchNode;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SubSectConstraintModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SubSeisMoRateReductions;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SupraSeisBValues;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.U3_UncertAddDeformationModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.random.BranchSamplingManager;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.random.RandomBValSampler;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.prior2018.NSHM18_FaultModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.SupraSeisBValInversionTargetMFDs;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators.GRParticRateEstimator;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.util.AnalyticalSingleFaultInversionSolver;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.util.ClassicModelInversionSolver;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.util.NSHM23_RegionLoader;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.GeoJSONFaultSection;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SparseGutenbergRichterSolver;
import org.opensha.sha.util.TectonicRegionType;
import scratch.UCERF3.analysis.FaultSystemRupSetCalc;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.SpatialSeisPDF;
import scratch.UCERF3.enumTreeBranches.TotalMag5Rate;
import scratch.UCERF3.erf.ETAS.SeisDepthDistribution;
import scratch.UCERF3.griddedSeismicity.FaultPolyMgr;
import scratch.UCERF3.griddedSeismicity.GridReader;

public class NSHM23_InvConfigFactory
implements ClusterSpecificInversionConfigurationFactory,
GridSourceProviderFactory {
    protected transient RuptureSets.Cache rupSetCache = new RuptureSets.Cache();
    protected transient Map<RupSetFaultModel, SectionDistanceAzimuthCalculator> distAzCache = new HashMap<RupSetFaultModel, SectionDistanceAzimuthCalculator>();
    protected transient File cacheDir;
    private boolean autoCache = true;
    private boolean adjustForActualRupSlips = NSHM23_ConstraintBuilder.ADJ_FOR_ACTUAL_RUP_SLIPS_DEFAULT;
    private boolean adjustForSlipAlong = NSHM23_ConstraintBuilder.ADJ_FOR_SLIP_ALONG_DEFAULT;
    public static final long NUM_ITERS_PER_RUP_DEFAULT = 2000L;
    protected long numItersPerRup = 2000L;
    public static final boolean SOLVE_CLUSTERS_INDIVIDUALLY_DEFAULT = true;
    protected boolean solveClustersIndividually = true;
    public static double MFD_MIN_FRACT_UNCERT = 0.1;
    public static double MIN_MAG_FOR_SEISMOGENIC_RUPS = 0.0;
    public static boolean PARKFIELD_INITIAL = true;
    public static SubSectConstraintModels SUB_SECT_CONSTR_DEFAULT = SubSectConstraintModels.TOT_NUCL_RATE;
    public static SlipAlongRuptureModelBranchNode SLIP_ALONG_DEFAULT = NSHM23_SlipAlongRuptureModels.UNIFORM;
    private static EnumMap<TectonicRegionType, Region> trtRegions = null;

    public void setNumItersPerRup(long numItersPerRup) {
        Preconditions.checkState((numItersPerRup > 0L ? 1 : 0) != 0, (String)"numItersPerRup must be >0: %s", (long)numItersPerRup);
        this.numItersPerRup = numItersPerRup;
    }

    @Override
    public boolean isSolveClustersIndividually() {
        return this.solveClustersIndividually;
    }

    public void setSolveClustersIndividually(boolean solveClustersIndividually) {
        this.solveClustersIndividually = solveClustersIndividually;
    }

    private synchronized void checkAddDistAzCalc(FaultSystemRupSet rupSet, RupSetFaultModel fm) {
        SectionDistanceAzimuthCalculator distAzCalc = this.distAzCache.get(fm);
        if (distAzCalc != null && rupSet.areSectionsEquivalentTo(distAzCalc.getSubSections())) {
            rupSet.addModule(distAzCalc);
        } else {
            distAzCalc = new SectionDistanceAzimuthCalculator(rupSet.getFaultSectionDataList());
            String name = distAzCalc.getDefaultCacheFileName();
            File distAzCacheFile = new File(this.cacheDir, name);
            if (distAzCacheFile.exists()) {
                try {
                    distAzCalc.loadCacheFile(distAzCacheFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            rupSet.addModule(distAzCalc);
            this.distAzCache.put(fm, distAzCalc);
        }
    }

    protected synchronized FaultSystemRupSet buildGenericRupSet(LogicTreeBranch<?> branch, int threads) {
        File cachedRupSetFile;
        RuptureSets.RupSetConfig config;
        FaultSystemRupSet rupSet;
        NSHM23_SingleStates state;
        RupturePlausibilityModels model;
        RupSetSubsectioningModel ssm;
        RupSetFaultModel fm;
        block23: {
            List<? extends FaultSection> subSects;
            fm = branch.requireValue(RupSetFaultModel.class);
            ssm = branch.requireValue(RupSetSubsectioningModel.class);
            model = branch.getValue(RupturePlausibilityModels.class);
            if (model == null) {
                model = fm instanceof FaultModels ? RupturePlausibilityModels.UCERF3 : RupturePlausibilityModels.COULOMB;
            }
            state = branch.getValue(NSHM23_SingleStates.class);
            rupSet = this.rupSetCache.get(fm, ssm, model);
            if (rupSet != null) {
                if (state != null) {
                    rupSet = state.getRuptureSubSet(rupSet);
                }
                return rupSet;
            }
            RupSetScalingRelationship scale = branch.requireValue(RupSetScalingRelationship.class);
            RupSetDeformationModel dm = fm.getDefaultDeformationModel();
            try {
                subSects = dm.build(fm, ssm, branch);
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            config = model.getConfig(subSects, scale);
            cachedRupSetFile = null;
            if (this.cacheDir != null) {
                File subDir = new File(this.cacheDir, "rup_sets_" + fm.getFilePrefix() + "_" + dm.getFilePrefix());
                if (!subDir.exists()) {
                    subDir.mkdir();
                }
                double dmMoment = 0.0;
                for (FaultSection faultSection : subSects) {
                    dmMoment += faultSection.calcMomentRate(false);
                }
                String momentStr = ("" + (float)dmMoment).replace('.', 'p');
                String string = "rup_set_" + model.getFilePrefix() + "_" + SectionDistanceAzimuthCalculator.getUniqueSectCacheFileStr(subSects) + "_" + momentStr + "_moment.zip";
                cachedRupSetFile = new File(subDir, string);
                config.setCacheDir(subDir);
            }
            config.setAutoCache(this.autoCache);
            if (cachedRupSetFile != null && cachedRupSetFile.exists()) {
                try {
                    rupSet = FaultSystemRupSet.load(cachedRupSetFile);
                    if (!rupSet.areSectionsEquivalentTo(subSects)) {
                        rupSet = null;
                        break block23;
                    }
                    this.checkAddDistAzCalc(rupSet, fm);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    rupSet = null;
                }
            } else if (cachedRupSetFile != null) {
                System.out.println("Rup set cache miss, doesn't exist: " + cachedRupSetFile.getAbsolutePath());
            } else {
                System.out.println("No cache directory supplied, will build rupture set from scratch. Consider settting a cache directory to speed up rupture set building in the future.");
            }
        }
        if (rupSet == null) {
            rupSet = config.build(threads);
        }
        this.rupSetCache.put(rupSet, fm, ssm, model);
        if (cachedRupSetFile != null && !cachedRupSetFile.exists()) {
            boolean write = true;
            try {
                int mpiRank = MPI.COMM_WORLD.Rank();
                write = mpiRank == 0;
            }
            catch (Throwable mpiRank) {
                // empty catch block
            }
            if (write && !cachedRupSetFile.exists()) {
                try {
                    rupSet.write(cachedRupSetFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (state != null) {
            rupSet = state.getRuptureSubSet(rupSet);
        }
        return rupSet;
    }

    @Override
    public void setCacheDir(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    @Override
    public void setAutoCache(boolean autoCache) {
        this.autoCache = autoCache;
    }

    @Override
    public void writeCache() {
        if (this.cacheDir != null) {
            // empty if block
        }
    }

    public void adjustForActualRupSlips(boolean adjustForActualRupSlips, boolean adjustForSlipAlong) {
        this.adjustForActualRupSlips = adjustForActualRupSlips;
        this.adjustForSlipAlong = adjustForSlipAlong;
    }

    @Override
    public FaultSystemRupSet buildRuptureSet(LogicTreeBranch<?> branch, int threads) throws IOException {
        return this.updateRuptureSetForBranch(this.buildGenericRupSet(branch, threads), branch);
    }

    protected List<? extends FaultSection> buildSubSectsForBranch(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) throws IOException {
        RupSetDeformationModel dm = branch.requireValue(RupSetDeformationModel.class);
        return dm.build(branch);
    }

    @Override
    public FaultSystemRupSet updateRuptureSetForBranch(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) throws IOException {
        List<? extends FaultSection> subSects;
        try {
            subSects = this.buildSubSectsForBranch(rupSet, branch);
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
        RuptureSubSetMappings subsetMappings = rupSet.getModule(RuptureSubSetMappings.class);
        if (subsetMappings != null) {
            ArrayList<? extends FaultSection> subsetSects = new ArrayList<FaultSection>();
            for (int s = 0; s < rupSet.getNumSections(); ++s) {
                FaultSection sect = subSects.get(subsetMappings.getOrigSectID(s)).clone();
                sect.setSectionId(s);
                subsetSects.add(sect);
            }
            subSects = subsetSects;
        }
        Preconditions.checkState((subSects.size() == rupSet.getNumSections() ? 1 : 0) != 0);
        ClusterRuptures cRups = rupSet.getModule(ClusterRuptures.class);
        PlausibilityConfiguration plausibility = rupSet.getModule(PlausibilityConfiguration.class);
        this.checkAddDistAzCalc(rupSet, branch.requireValue(RupSetFaultModel.class));
        RupSetScalingRelationship scale = branch.requireValue(RupSetScalingRelationship.class);
        if (cRups == null) {
            rupSet = FaultSystemRupSet.builder(subSects, rupSet.getSectionIndicesForAllRups()).forScalingRelationship(scale).build();
            if (plausibility != null) {
                rupSet.addModule(plausibility);
            }
            rupSet.addModule(ClusterRuptures.singleStranged(rupSet));
        } else {
            rupSet = ClusterRuptureBuilder.buildClusterRupSet(scale, subSects, plausibility, cRups.getAll());
        }
        if (subsetMappings != null) {
            rupSet.addModule(subsetMappings);
        }
        SlipAlongRuptureModelBranchNode slipAlong = branch.hasValue(SlipAlongRuptureModelBranchNode.class) ? branch.requireValue(SlipAlongRuptureModelBranchNode.class) : SLIP_ALONG_DEFAULT;
        rupSet.addModule(slipAlong.getModel());
        return this.getSolutionLogicTreeProcessor().processRupSet(rupSet, branch);
    }

    public static NSHM23_ConstraintBuilder.ParkfieldSelectionCriteria getParkfieldSelectionCriteria(RupSetFaultModel fm) {
        if (fm instanceof FaultModels) {
            return NSHM23_ConstraintBuilder.ParkfieldSelectionCriteria.SECT_COUNT;
        }
        return NSHM23_ConstraintBuilder.PARKFIELD_SELECT_DEFAULT;
    }

    @Override
    public SolutionLogicTree.SolutionProcessor getSolutionLogicTreeProcessor() {
        return new NSHM23SolProcessor();
    }

    private static NSHM23_ConstraintBuilder getAveragedConstraintBuilder(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
        SectionSupraSeisBValues[] bVals = branch.hasValue(SupraSeisBValues.AVERAGE) ? SupraSeisBValues.values() : new SectionSupraSeisBValues[]{branch.requireValue(SectionSupraSeisBValues.class)};
        NSHM23_SegmentationModels[] segModels = branch.hasValue(NSHM23_SegmentationModels.AVERAGE) ? NSHM23_SegmentationModels.values() : new NSHM23_SegmentationModels[]{branch.requireValue(NSHM23_SegmentationModels.class)};
        ArrayList<LogicTreeBranch<LogicTreeNode>> avgBranches = new ArrayList<LogicTreeBranch<LogicTreeNode>>();
        ArrayList<Double> avgWeights = new ArrayList<Double>();
        ArrayList levels = new ArrayList();
        for (int i = 0; i < branch.size(); ++i) {
            levels.add(branch.getLevel(i));
        }
        LogicTreeBranch<LogicTreeNode> branchCopy = new LogicTreeBranch<LogicTreeNode>(levels);
        for (LogicTreeNode node : branch) {
            branchCopy.setValue(node);
        }
        for (SectionSupraSeisBValues bVal : bVals) {
            for (NSHM23_SegmentationModels segModel : segModels) {
                LogicTreeBranch<LogicTreeNode> subBranch = branchCopy.copy();
                subBranch.setValue(bVal);
                subBranch.setValue(segModel);
                double subBranchWeight = 1.0;
                if (bVals.length > 1) {
                    subBranchWeight *= bVal.getNodeWeight(subBranch);
                }
                if (segModels.length > 1) {
                    subBranchWeight *= segModel.getNodeWeight(subBranch);
                }
                if (!(subBranchWeight > 0.0)) continue;
                avgBranches.add(subBranch);
                avgWeights.add(subBranchWeight);
            }
        }
        System.out.println("Building average SupraSeisBValTargetMFDs across " + avgBranches.size() + " sub-branches");
        Preconditions.checkState((avgBranches.size() > 1 ? 1 : 0) != 0, (Object)"Expected multiple branches to average");
        SupraSeisBValInversionTargetMFDs.SupraBAverager averager = new SupraSeisBValInversionTargetMFDs.SupraBAverager();
        for (int i = 0; i < avgBranches.size(); ++i) {
            LogicTreeBranch avgBranch = (LogicTreeBranch)avgBranches.get(i);
            double weight = (Double)avgWeights.get(i);
            Object branchStr = null;
            if (bVals.length > 1) {
                branchStr = avgBranch.requireValue(SectionSupraSeisBValues.class).getShortName();
            }
            if (segModels.length > 1) {
                branchStr = branchStr == null ? "" : (String)branchStr + ", ";
                branchStr = (String)branchStr + "SegModel=" + avgBranch.requireValue(NSHM23_SegmentationModels.class).name();
            }
            System.out.println("Building target MFDs for branch " + i + "/" + avgBranches.size() + ": " + (String)branchStr);
            NSHM23_ConstraintBuilder builder = NSHM23_InvConfigFactory.doGetConstraintBuilder(rupSet, avgBranch);
            averager.process(builder.getTargetMFDs(), weight);
        }
        SupraSeisBValInversionTargetMFDs avgTargets = averager.getSupraSeisAverageInstance();
        NSHM23_ConstraintBuilder ret = NSHM23_InvConfigFactory.doGetConstraintBuilder(rupSet, branch);
        ret.setExternalTargetMFDs(avgTargets);
        rupSet.addModule(avgTargets);
        return ret;
    }

    private static NSHM23_ConstraintBuilder getConstraintBuilder(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
        if (branch.hasValue(NSHM23_SegmentationModels.AVERAGE) || branch.hasValue(SupraSeisBValues.AVERAGE)) {
            return NSHM23_InvConfigFactory.getAveragedConstraintBuilder(rupSet, branch);
        }
        return NSHM23_InvConfigFactory.doGetConstraintBuilder(rupSet, branch);
    }

    private static NSHM23_ConstraintBuilder doGetConstraintBuilder(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
        double bVal;
        RandomBValSampler.Node bValNode = branch.getValue(RandomBValSampler.Node.class);
        double[] sectSpecificBValues = null;
        if (bValNode != null) {
            RandomBValSampler sampler = rupSet.requireModule(BranchSamplingManager.class).getSampler(bValNode);
            sectSpecificBValues = sampler.getBValues();
            Preconditions.checkState((sectSpecificBValues.length == rupSet.getNumSections() ? 1 : 0) != 0, (String)"Have %s sections but %s section b-values", (int)rupSet.getNumSections(), (int)sectSpecificBValues.length);
            bVal = NSHM23_ConstraintBuilder.momentWeightedAverage(rupSet, sectSpecificBValues);
        } else {
            SectionSupraSeisBValues bValues = branch.requireValue(SectionSupraSeisBValues.class);
            sectSpecificBValues = bValues.getSectBValues(rupSet);
            bVal = Double.isFinite(bValues.getB()) ? bValues.getB() : SectionSupraSeisBValues.momentWeightedAverage(rupSet, sectSpecificBValues);
        }
        NSHM23_ConstraintBuilder constrBuilder = new NSHM23_ConstraintBuilder(rupSet, bVal, sectSpecificBValues);
        RupSetFaultModel fm = branch.getValue(RupSetFaultModel.class);
        constrBuilder.parkfieldSelection(NSHM23_InvConfigFactory.getParkfieldSelectionCriteria(fm));
        NSHM23_PaleoUncertainties paleoUncert = branch.getValue(NSHM23_PaleoUncertainties.class);
        constrBuilder.paleoUncerts(paleoUncert);
        SupraSeisBValInversionTargetMFDs.SubSeisMoRateReduction reduction = SupraSeisBValInversionTargetMFDs.SUB_SEIS_MO_RATE_REDUCTION_DEFAULT;
        if (branch.hasValue(SubSeisMoRateReductions.class)) {
            reduction = branch.getValue(SubSeisMoRateReductions.class).getChoice();
        }
        constrBuilder.subSeisMoRateReduction(reduction);
        constrBuilder.magDepRelStdDev(M -> MFD_MIN_FRACT_UNCERT * Math.max(1.0, Math.pow(10.0, bVal * 0.5 * (M - 6.0))));
        constrBuilder.adjustForActualRupSlips(NSHM23_ConstraintBuilder.ADJ_FOR_ACTUAL_RUP_SLIPS_DEFAULT, NSHM23_ConstraintBuilder.ADJ_FOR_SLIP_ALONG_DEFAULT);
        if (NSHM23_InvConfigFactory.hasJumps(rupSet)) {
            JumpProbabilityCalc targetSegModel;
            RuptureProbabilityCalc.BinaryRuptureProbabilityCalc rupExclusionModel = NSHM23_InvConfigFactory.getExclusionModel(rupSet, branch, rupSet.requireModule(ClusterRuptures.class));
            if (rupExclusionModel != null) {
                constrBuilder.excludeRuptures(rupExclusionModel);
            }
            if ((targetSegModel = NSHM23_InvConfigFactory.buildSegModel(rupSet, branch)) != null) {
                if (targetSegModel instanceof JumpProbabilityCalc.BinaryJumpProbabilityCalc) {
                    Preconditions.checkNotNull((Object)rupExclusionModel);
                } else {
                    SegmentationMFD_Adjustment segAdj = branch.getValue(SegmentationMFD_Adjustment.class);
                    if (segAdj == null) {
                        constrBuilder.adjustForSegmentationModel(targetSegModel);
                    } else {
                        constrBuilder.adjustForSegmentationModel(targetSegModel, segAdj);
                    }
                }
            }
        }
        return constrBuilder;
    }

    public static boolean hasJumps(FaultSystemRupSet rupSet) {
        for (ClusterRupture cRup : rupSet.requireModule(ClusterRuptures.class)) {
            if (cRup.getTotalNumJumps() <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPaleoData(FaultSystemRupSet rupSet) {
        PaleoseismicConstraintData data = rupSet.getModule(PaleoseismicConstraintData.class);
        return data != null && (data.hasPaleoRateConstraints() || data.hasPaleoSlipConstraints());
    }

    public static boolean hasParkfield(FaultSystemRupSet rupSet) {
        return NSHM23_ConstraintBuilder.findParkfieldSection(rupSet) >= 0;
    }

    private static boolean hasConstrainableJumps(FaultSystemRupSet rupSet, JumpProbabilityCalc segModel) {
        if (segModel instanceof JumpProbabilityCalc.BinaryJumpProbabilityCalc) {
            return false;
        }
        for (ClusterRupture cRup : rupSet.requireModule(ClusterRuptures.class)) {
            for (Jump jump : cRup.getJumpsIterable()) {
                double prob = segModel.calcJumpProbability(cRup, jump, false);
                if (!(prob > 0.0) || !(prob < 1.0)) continue;
                return true;
            }
        }
        return false;
    }

    private static JumpProbabilityCalc buildSegModel(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
        SegmentationModelBranchNode segModel = branch.getValue(SegmentationModelBranchNode.class);
        JumpProbabilityCalc jumpProb = segModel == null ? null : segModel.getModel(rupSet, branch);
        return jumpProb;
    }

    @Override
    public LogicTree<?> getGridSourceTree(LogicTree<?> faultTree) {
        if (NSHM23_InvConfigFactory.isU3Branch(faultTree.getBranch(0))) {
            return LogicTree.buildExhaustive(NSHM23_U3_HybridLogicTreeBranch.levelsOffFault, true, new LogicTreeNode[0]);
        }
        return LogicTree.buildExhaustive(NSHM23_LogicTreeBranch.levelsOffFault, true, new LogicTreeNode[0]);
    }

    private static boolean isU3Branch(LogicTreeBranch<?> branch) {
        return branch.hasValue(FaultModels.class) || branch.hasValue(U3_UncertAddDeformationModels.class) || branch.hasValue(SpatialSeisPDF.class);
    }

    public static List<NSHM23_RegionLoader.SeismicityRegions> getSeismicityRegions(Region modelRegion) throws IOException {
        ArrayList<NSHM23_RegionLoader.SeismicityRegions> seisRegions = new ArrayList<NSHM23_RegionLoader.SeismicityRegions>();
        for (NSHM23_RegionLoader.SeismicityRegions seisReg : NSHM23_RegionLoader.SeismicityRegions.values()) {
            Region testReg = seisReg.load();
            if (!testReg.equalsRegion(modelRegion) && !modelRegion.intersects(testReg) && !modelRegion.contains(testReg)) continue;
            seisRegions.add(seisReg);
        }
        return seisRegions;
    }

    public static GriddedRegion getGriddedSeisRegion(NSHM23_RegionLoader.SeismicityRegions seisRegion) throws IOException {
        return NSHM23_InvConfigFactory.getGriddedSeisRegion(List.of(seisRegion));
    }

    public static GriddedRegion getGriddedSeisRegion(List<NSHM23_RegionLoader.SeismicityRegions> seisRegions) throws IOException {
        Region region;
        Preconditions.checkState((!seisRegions.isEmpty() ? 1 : 0) != 0);
        if (seisRegions.size() == 1) {
            region = seisRegions.get(0).load();
        } else {
            ArrayList<Region> regions = new ArrayList<Region>();
            for (NSHM23_RegionLoader.SeismicityRegions seisRegion : seisRegions) {
                regions.add(seisRegion.load());
            }
            if (regions.size() > 2) {
                regions.sort(new Comparator<Region>(){

                    @Override
                    public int compare(Region o1, Region o2) {
                        return Double.compare(this.avgLon(o1), this.avgLon(o2));
                    }

                    private double avgLon(Region reg) {
                        int num = 0;
                        double sum = 0.0;
                        for (Location loc : reg.getBorder()) {
                            ++num;
                            sum += loc.getLongitude();
                        }
                        return sum / (double)num;
                    }
                });
            }
            region = (Region)regions.get(0);
            for (int i = 1; i < regions.size(); ++i) {
                region = Region.union(region, (Region)regions.get(i));
                Preconditions.checkNotNull((Object)region, (Object)"Seismicity regions don't overlap, can't union");
            }
        }
        return new GriddedRegion(region, 0.1, GriddedRegion.ANCHOR_0_0);
    }

    public static FaultCubeAssociations buildFaultCubeAssociations(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch, Region region) throws IOException {
        List<NSHM23_RegionLoader.SeismicityRegions> seisRegions = NSHM23_InvConfigFactory.getSeismicityRegions(region);
        return NSHM23_InvConfigFactory.buildFaultCubeAssociations(rupSet, seisRegions);
    }

    public static FaultCubeAssociations buildFaultCubeAssociations(FaultSystemRupSet rupSet, List<NSHM23_RegionLoader.SeismicityRegions> seisRegions) throws IOException {
        Preconditions.checkState((seisRegions.size() >= 1 ? 1 : 0) != 0);
        GriddedRegion modelGridReg = NSHM23_InvConfigFactory.getGriddedSeisRegion(seisRegions);
        if (seisRegions.size() == 1) {
            return new NSHM23_FaultCubeAssociations(rupSet, new CubedGriddedRegion(modelGridReg), 12.0);
        }
        ArrayList<NSHM23_FaultCubeAssociations> regionalAssociations = new ArrayList<NSHM23_FaultCubeAssociations>();
        for (NSHM23_RegionLoader.SeismicityRegions seisReg : seisRegions) {
            GriddedRegion subGridReg = NSHM23_InvConfigFactory.getGriddedSeisRegion(seisReg);
            regionalAssociations.add(new NSHM23_FaultCubeAssociations(rupSet, new CubedGriddedRegion(subGridReg), 12.0));
        }
        return FaultCubeAssociations.stitch(new CubedGriddedRegion(modelGridReg), regionalAssociations);
    }

    public static GridSourceProvider buildBranchAveragedGridSourceProv(FaultSystemSolution sol, LogicTreeBranch<?> faultBranch) throws IOException {
        Region modelReg;
        List<NSHM23_RegionLoader.SeismicityRegions> seisRegions;
        FaultSystemRupSet rupSet = sol.getRupSet();
        if (!rupSet.hasModule(ModelRegion.class) && faultBranch.hasValue(NSHM23_FaultModels.class)) {
            rupSet.addModule(NSHM23_FaultModels.getDefaultRegion(faultBranch));
        }
        Preconditions.checkState((!(seisRegions = NSHM23_InvConfigFactory.getSeismicityRegions(modelReg = rupSet.requireModule(ModelRegion.class).getRegion())).isEmpty() ? 1 : 0) != 0, (String)"Found no seismicity regions for model region %s", (Object)modelReg.getName());
        FaultCubeAssociations cubeAssociations = NSHM23_InvConfigFactory.buildFaultCubeAssociations(rupSet, seisRegions);
        rupSet.addModule(cubeAssociations);
        AverageableModule.AveragingAccumulator<NSHM23_AbstractGridSourceProvider> avgBuilder = null;
        LogicTreeNode[] fixedBranches = new LogicTreeNode[]{NSHM23_SeisSmoothingAlgorithms.AVERAGE, NSHM23_DeclusteringAlgorithms.AVERAGE};
        BranchWeightProvider.NodeWeightOverrides gridTreeWeightProv = new BranchWeightProvider.NodeWeightOverrides(fixedBranches, 1.0);
        LogicTree offFaultTree = LogicTree.buildExhaustive(NSHM23_LogicTreeBranch.levelsOffFault, true, gridTreeWeightProv, fixedBranches);
        System.out.println("Building branch averaged gridded seismicity model across " + offFaultTree.size() + " combinations of MMax & seis rate branches, and using the average PDF");
        for (int i = 0; i < offFaultTree.size(); ++i) {
            LogicTreeBranch gridBranch = offFaultTree.getBranch(i);
            double weight = offFaultTree.getBranchWeight(gridBranch);
            System.out.println("Building for branch " + i + "/" + offFaultTree.size() + ": " + String.valueOf(gridBranch) + " (weight=" + (float)weight + ")");
            Preconditions.checkState((weight > 0.0 ? 1 : 0) != 0, (String)"Bad weight (%s) for gridded branch: %s", (Object)weight, gridBranch);
            NSHM23_AbstractGridSourceProvider gridProv = NSHM23_InvConfigFactory.buildGridSourceProv(sol, gridBranch, seisRegions, cubeAssociations);
            if (avgBuilder == null) {
                avgBuilder = gridProv.averagingAccumulator();
            }
            avgBuilder.process(gridProv, weight);
        }
        return (GridSourceProvider)avgBuilder.getAverage();
    }

    @Override
    public GridSourceProvider buildGridSourceProvider(FaultSystemSolution sol, LogicTreeBranch<?> branch) throws IOException {
        NSHM23_AbstractGridSourceProvider prov = NSHM23_InvConfigFactory.buildGridSourceProv(sol, branch);
        double minMag = 2.55;
        if (prov instanceof NSHM23_SingleRegionGridSourceProvider) {
            return ((NSHM23_SingleRegionGridSourceProvider)prov).convertToGridSourceList(minMag);
        }
        Preconditions.checkState((boolean)(prov instanceof NSHM23_CombinedRegionGridSourceProvider));
        NSHM23_CombinedRegionGridSourceProvider combProv = (NSHM23_CombinedRegionGridSourceProvider)prov;
        List<? extends GridSourceProvider> regionalProviders = combProv.getRegionalProviders();
        GridSourceList[] gridLists = new GridSourceList[regionalProviders.size()];
        for (int i = 0; i < gridLists.length; ++i) {
            GridSourceProvider regionalProv = regionalProviders.get(i);
            Preconditions.checkState((boolean)(regionalProv instanceof NSHM23_SingleRegionGridSourceProvider));
            gridLists[i] = ((NSHM23_SingleRegionGridSourceProvider)regionalProv).convertToGridSourceList(minMag);
        }
        return GridSourceList.combine(combProv.getGriddedRegion(), gridLists);
    }

    @Override
    public void preGridBuildHook(FaultSystemSolution sol, LogicTreeBranch<?> faultBranch) throws IOException {
        NSHM23_InvConfigFactory.doPreGridBuildHook(sol, faultBranch);
    }

    private static void doPreGridBuildHook(FaultSystemSolution sol, LogicTreeBranch<?> faultBranch) throws IOException {
        boolean addCubeAssoc;
        FaultSystemRupSet rupSet = sol.getRupSet();
        if (!rupSet.hasModule(ModelRegion.class) && faultBranch.hasValue(NSHM23_FaultModels.class)) {
            rupSet.addModule(NSHM23_FaultModels.getDefaultRegion(faultBranch));
        }
        Region modelReg = rupSet.requireModule(ModelRegion.class).getRegion();
        FaultCubeAssociations cubeAssociations = rupSet.getModule(FaultCubeAssociations.class);
        boolean bl = addCubeAssoc = cubeAssociations == null;
        if (NSHM23_InvConfigFactory.isU3Branch(faultBranch)) {
            if (cubeAssociations == null) {
                cubeAssociations = NSHM23_InvConfigFactory.buildU3IngredientsFaultCubeAssociations(rupSet);
            }
        } else {
            List<NSHM23_RegionLoader.SeismicityRegions> seisRegions;
            if (rupSet.hasModule(SeismicityRegionsListModule.class)) {
                seisRegions = rupSet.requireModule(SeismicityRegionsListModule.class).seisRegions;
            } else {
                seisRegions = NSHM23_InvConfigFactory.getSeismicityRegions(modelReg);
                Preconditions.checkState((!seisRegions.isEmpty() ? 1 : 0) != 0, (String)"Found no seismicity regions for model region %s", (Object)modelReg.getName());
                rupSet.addModule(new SeismicityRegionsListModule(seisRegions));
                addCubeAssoc = true;
                cubeAssociations = null;
            }
            if (cubeAssociations == null) {
                cubeAssociations = NSHM23_InvConfigFactory.buildFaultCubeAssociations(rupSet, seisRegions);
            }
        }
        Preconditions.checkNotNull((Object)cubeAssociations, (Object)"Cube associations is null");
        if (addCubeAssoc) {
            rupSet.addModule(cubeAssociations);
        }
    }

    public static NSHM23_AbstractGridSourceProvider buildGridSourceProv(FaultSystemSolution sol, LogicTreeBranch<?> branch) throws IOException {
        NSHM23_InvConfigFactory.doPreGridBuildHook(sol, branch);
        FaultSystemRupSet rupSet = sol.getRupSet();
        SeismicityRegionsListModule seisRegionsModule = rupSet.getModule(SeismicityRegionsListModule.class);
        List<NSHM23_RegionLoader.SeismicityRegions> seisRegions = seisRegionsModule == null ? null : seisRegionsModule.seisRegions;
        FaultCubeAssociations cubeAssociations = rupSet.requireModule(FaultCubeAssociations.class);
        return NSHM23_InvConfigFactory.buildGridSourceProv(sol, branch, seisRegions, cubeAssociations);
    }

    public static NSHM23_AbstractGridSourceProvider buildGridSourceProv(FaultSystemSolution sol, LogicTreeBranch<?> branch, List<NSHM23_RegionLoader.SeismicityRegions> seisRegions, FaultCubeAssociations cubeAssociations) throws IOException {
        NSHM23_AbstractGridSourceProvider ret;
        GriddedRegion gridReg = cubeAssociations.getRegion();
        double maxMagOff = branch.requireValue(MaxMagOffFaultBranchNode.class).getMaxMagOffFault();
        IncrementalMagFreqDist refMFD = FaultSysTools.initEmptyMFD(Math.max(maxMagOff, sol.getRupSet().getMaxMag()));
        if ((seisRegions == null || seisRegions.isEmpty()) && branch.hasValue(SpatialSeisPDF.class)) {
            return NSHM23_InvConfigFactory.buildU3IngredientsGridSourceProv(sol, branch.requireValue(TotalMag5Rate.class).getRateMag5(), branch.requireValue(SpatialSeisPDF.class), maxMagOff, refMFD, cubeAssociations);
        }
        NSHM23_RegionalSeismicity seisBranch = branch.requireValue(NSHM23_RegionalSeismicity.class);
        NSHM23_DeclusteringAlgorithms declusteringAlg = branch.requireValue(NSHM23_DeclusteringAlgorithms.class);
        NSHM23_SeisSmoothingAlgorithms seisSmooth = branch.requireValue(NSHM23_SeisSmoothingAlgorithms.class);
        Preconditions.checkState((!seisRegions.isEmpty() ? 1 : 0) != 0, (String)"Found no seismicity regions for model region %s", (Object)gridReg.getName());
        List<? extends FaultCubeAssociations> regionalCubeAssoc = null;
        if (cubeAssociations instanceof FaultCubeAssociations.StitchedFaultCubeAssociations) {
            regionalCubeAssoc = ((FaultCubeAssociations.StitchedFaultCubeAssociations)cubeAssociations).getRegionalAssociations();
        }
        if (seisRegions.size() > 1 && regionalCubeAssoc != null) {
            Preconditions.checkState((regionalCubeAssoc.size() == seisRegions.size() ? 1 : 0) != 0, (String)"Have %s regions but %s regional cube associations", (int)seisRegions.size(), (int)regionalCubeAssoc.size());
            for (int i = 0; i < seisRegions.size(); ++i) {
                Preconditions.checkState((boolean)seisRegions.get(i).load().equalsRegion(regionalCubeAssoc.get(i).getRegion()), (String)"Regional cube association %s doesn't match the seismicity region at that index", (int)i);
            }
        }
        if (seisRegions.size() == 1) {
            ret = NSHM23_InvConfigFactory.buildSingleGridSourceProv(sol, seisRegions.get(0), seisBranch, declusteringAlg, seisSmooth, maxMagOff, refMFD, cubeAssociations);
        } else {
            ArrayList<NSHM23_SingleRegionGridSourceProvider> regionalProvs = new ArrayList<NSHM23_SingleRegionGridSourceProvider>();
            for (int i = 0; i < seisRegions.size(); ++i) {
                NSHM23_RegionLoader.SeismicityRegions seisRegion = seisRegions.get(i);
                FaultCubeAssociations subRegCubeAssoc = null;
                if (regionalCubeAssoc != null) {
                    subRegCubeAssoc = regionalCubeAssoc.get(i);
                } else {
                    GriddedRegion subGridReg = NSHM23_InvConfigFactory.getGriddedSeisRegion(seisRegion);
                    subRegCubeAssoc = new NSHM23_FaultCubeAssociations(sol.getRupSet(), new CubedGriddedRegion(subGridReg), 12.0);
                }
                regionalProvs.add(NSHM23_InvConfigFactory.buildSingleGridSourceProv(sol, seisRegion, seisBranch, declusteringAlg, seisSmooth, maxMagOff, refMFD, subRegCubeAssoc));
            }
            ret = new NSHM23_CombinedRegionGridSourceProvider(sol, cubeAssociations, regionalProvs);
        }
        return ret;
    }

    private static synchronized EnumMap<TectonicRegionType, Region> getTRT_Regions() throws IOException {
        if (trtRegions == null) {
            trtRegions = new EnumMap(TectonicRegionType.class);
            trtRegions.put(TectonicRegionType.ACTIVE_SHALLOW, NSHM23_RegionLoader.GridSystemRegions.WUS_ACTIVE.load());
            trtRegions.put(TectonicRegionType.STABLE_SHALLOW, NSHM23_RegionLoader.GridSystemRegions.CEUS_STABLE.load());
        }
        return trtRegions;
    }

    private static NSHM23_SingleRegionGridSourceProvider buildSingleGridSourceProv(FaultSystemSolution sol, NSHM23_RegionLoader.SeismicityRegions region, NSHM23_RegionalSeismicity seisBranch, NSHM23_DeclusteringAlgorithms declusteringAlg, NSHM23_SeisSmoothingAlgorithms seisSmooth, double maxMagOff, EvenlyDiscretizedFunc refMFD, FaultCubeAssociations cubeAssociations) throws IOException {
        IncrementalMagFreqDist totalGR = seisBranch.build(region, refMFD, maxMagOff);
        IncrementalMagFreqDist totalGridded = new IncrementalMagFreqDist(refMFD.getMinX(), refMFD.size(), refMFD.getDelta());
        GriddedRegion gridReg = cubeAssociations.getRegion();
        IncrementalMagFreqDist solNuclMFD = sol.calcNucleationMFD_forRegion((Region)gridReg, refMFD.getMinX(), refMFD.getMaxX(), refMFD.size(), false);
        for (int i = 0; i < totalGR.size(); ++i) {
            double totalRate = totalGR.getY(i);
            if (!(totalRate > 0.0)) continue;
            double solRate = solNuclMFD.getY(i);
            if (solRate > totalRate) {
                System.err.println("WARNING: MFD bulge at M=" + (float)refMFD.getX(i) + "\tGR=" + (float)totalRate + "\tsol=" + (float)solRate);
                continue;
            }
            totalGridded.set(i, totalRate - solRate);
        }
        double[] fractStrikeSlip = NSHM23_GridFocalMechs.getFractStrikeSlip(region, gridReg);
        double[] fractReverse = NSHM23_GridFocalMechs.getFractReverse(region, gridReg);
        double[] fractNormal = NSHM23_GridFocalMechs.getFractNormal(region, gridReg);
        double[] pdf = seisSmooth.load(region, declusteringAlg);
        SeisDepthDistribution seisDepthDistribution = new SeisDepthDistribution();
        double delta = 2.0;
        HistogramFunction binnedDepthDistFunc = new HistogramFunction(1.0, 12, delta);
        for (int i = 0; i < binnedDepthDistFunc.size(); ++i) {
            double prob = seisDepthDistribution.getProbBetweenDepths(binnedDepthDistFunc.getX(i) - delta / 2.0, binnedDepthDistFunc.getX(i) + delta / 2.0);
            binnedDepthDistFunc.set(i, prob);
        }
        return new NSHM23_SingleRegionGridSourceProvider(sol, cubeAssociations, pdf, totalGridded, binnedDepthDistFunc, fractStrikeSlip, fractNormal, fractReverse, NSHM23_InvConfigFactory.getTRT_Regions());
    }

    public static NSHM23_FaultCubeAssociations buildU3IngredientsFaultCubeAssociations(FaultSystemRupSet rupSet) throws IOException {
        CaliforniaRegions.RELM_TESTING_GRIDDED modelGridReg = new CaliforniaRegions.RELM_TESTING_GRIDDED();
        return new NSHM23_FaultCubeAssociations(rupSet, new CubedGriddedRegion(modelGridReg), 12.0);
    }

    public static NSHM23_SingleRegionGridSourceProvider buildU3IngredientsGridSourceProv(FaultSystemSolution sol, double totRateM5, SpatialSeisPDF spatSeisPDF, double maxMagOff, EvenlyDiscretizedFunc refMFD, FaultCubeAssociations cubeAssociations) throws IOException {
        GutenbergRichterMagFreqDist totalGR = new GutenbergRichterMagFreqDist(refMFD.getMinX(), refMFD.size(), refMFD.getDelta());
        totalGR.setAllButTotCumRate(refMFD.getX(0), refMFD.getX(refMFD.getClosestXIndex(maxMagOff)), 1.0E16, 1.0);
        totalGR.scaleToCumRate(refMFD.getClosestXIndex(5.001), totRateM5);
        totalGR.setName("Total Observed [b=1, N5=" + (float)totRateM5 + "]");
        GriddedRegion gridReg = cubeAssociations.getRegion();
        IncrementalMagFreqDist totalGridded = new IncrementalMagFreqDist(refMFD.getMinX(), refMFD.size(), refMFD.getDelta());
        IncrementalMagFreqDist solNuclMFD = sol.calcNucleationMFD_forRegion((Region)gridReg, refMFD.getMinX(), refMFD.getMaxX(), refMFD.size(), false);
        for (int i = 0; i < totalGR.size(); ++i) {
            double totalRate = totalGR.getY(i);
            if (!(totalRate > 0.0)) continue;
            double solRate = solNuclMFD.getY(i);
            if (solRate > totalRate) {
                System.err.println("WARNING: MFD bulge at M=" + (float)refMFD.getX(i) + "\tGR=" + (float)totalRate + "\tsol=" + (float)solRate);
                continue;
            }
            totalGridded.set(i, totalRate - solRate);
        }
        double[] fractStrikeSlip = new GridReader("StrikeSlipWts.txt").getValues();
        double[] fractReverse = new GridReader("ReverseWts.txt").getValues();
        double[] fractNormal = new GridReader("NormalWts.txt").getValues();
        double[] pdf = spatSeisPDF.getPDF();
        Preconditions.checkState((pdf.length == gridReg.getNodeCount() ? 1 : 0) != 0, (String)"PDF has %s nodes but grid reg has %s", (int)pdf.length, (int)gridReg.getNodeCount());
        Preconditions.checkState((pdf.length == fractStrikeSlip.length ? 1 : 0) != 0, (String)"PDF has %s nodes but fract strike-slip has %s", (int)pdf.length, (int)fractStrikeSlip.length);
        Preconditions.checkState((pdf.length == fractReverse.length ? 1 : 0) != 0, (String)"PDF has %s nodes but fract reverse has %s", (int)pdf.length, (int)fractReverse.length);
        Preconditions.checkState((pdf.length == fractNormal.length ? 1 : 0) != 0, (String)"PDF has %s nodes but fract normal has %s", (int)pdf.length, (int)fractNormal.length);
        SeisDepthDistribution seisDepthDistribution = new SeisDepthDistribution();
        double delta = 2.0;
        HistogramFunction binnedDepthDistFunc = new HistogramFunction(1.0, 12, delta);
        for (int i = 0; i < binnedDepthDistFunc.size(); ++i) {
            double prob = seisDepthDistribution.getProbBetweenDepths(binnedDepthDistFunc.getX(i) - delta / 2.0, binnedDepthDistFunc.getX(i) + delta / 2.0);
            binnedDepthDistFunc.set(i, prob);
        }
        return new NSHM23_SingleRegionGridSourceProvider(sol, cubeAssociations, pdf, totalGridded, binnedDepthDistFunc, fractStrikeSlip, fractNormal, fractReverse, null);
    }

    @Override
    public InversionConfiguration buildInversionConfig(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch, int threads) {
        double paleoSmoothWeight;
        boolean hasPaleoData;
        NSHM23_ConstraintBuilder constrBuilder = NSHM23_InvConfigFactory.getConstraintBuilder(rupSet, branch);
        if (rupSet.hasModule(ModSectMinMags.class) && rupSet.hasModule(RuptureSubSetMappings.class)) {
            int numBelowMinMag = constrBuilder.getRupIndexesBelowMinMag().size();
            Preconditions.checkState((numBelowMinMag >= 0 && numBelowMinMag <= rupSet.getNumRuptures() ? 1 : 0) != 0);
            if (numBelowMinMag == rupSet.getNumRuptures()) {
                System.out.println("Warning: skipping cluster specific inversion for cluster with " + rupSet.getNumSections() + " sections and " + rupSet.getNumRuptures() + " ruptures, all below minimum mag");
                return null;
            }
        }
        if (hasPaleoData = rupSet.hasModule(PaleoseismicConstraintData.class)) {
            PaleoseismicConstraintData paleoData = rupSet.getModule(PaleoseismicConstraintData.class);
            hasPaleoData = paleoData.hasPaleoRateConstraints() || paleoData.hasPaleoSlipConstraints();
        }
        boolean hasParkfield = constrBuilder.rupSetHasParkfield();
        boolean hasNonZeroSlip = false;
        for (double slipRate : rupSet.requireModule(SectSlipRates.class).getSlipRates()) {
            if (!(slipRate > 0.0)) continue;
            hasNonZeroSlip = true;
            break;
        }
        if (!(hasNonZeroSlip || hasPaleoData || hasParkfield)) {
            System.out.println("Warning: skipping inversion for rupture set with " + rupSet.getNumSections() + " sections and " + rupSet.getNumRuptures() + " ruptures, no positive slip rates/paleo data/parkfield");
            return null;
        }
        constrBuilder.adjustForActualRupSlips(this.adjustForActualRupSlips, this.adjustForSlipAlong);
        SubSectConstraintModels constrModel = branch.hasValue(SubSectConstraintModels.class) ? branch.getValue(SubSectConstraintModels.class) : SUB_SECT_CONSTR_DEFAULT;
        double slipWeight = 1.0;
        double paleoWeight = hasPaleoData ? 5.0 : 0.0;
        double parkWeight = hasParkfield ? 10.0 : 0.0;
        double mfdWeight = constrModel == SubSectConstraintModels.NUCL_MFD ? 1.0 : 10.0;
        double nuclWeight = constrModel == SubSectConstraintModels.TOT_NUCL_RATE ? 0.5 : 0.0;
        double nuclMFDWeight = constrModel == SubSectConstraintModels.NUCL_MFD ? 0.5 : 0.0;
        double d = paleoSmoothWeight = paleoWeight > 0.0 ? 10000.0 : 0.0;
        if (slipWeight > 0.0) {
            constrBuilder.slipRates().weight(slipWeight);
        }
        if (paleoWeight > 0.0) {
            constrBuilder.paleoRates().weight(PaleoRateInversionConstraint.class, paleoWeight);
            constrBuilder.paleoSlips().weight(PaleoSlipInversionConstraint.class, paleoWeight);
        }
        if (parkWeight > 0.0) {
            constrBuilder.parkfield().weight(parkWeight);
        }
        if (mfdWeight > 0.0) {
            constrBuilder.supraBValMFDs().weight(mfdWeight);
        }
        if (nuclWeight > 0.0) {
            constrBuilder.sectSupraRates().weight(nuclWeight);
        }
        if (nuclMFDWeight > 0.0) {
            constrBuilder.sectSupraNuclMFDs().weight(nuclMFDWeight);
        }
        if (paleoSmoothWeight > 0.0) {
            constrBuilder.supraPaleoSmooth().weight(LaplacianSmoothingInversionConstraint.class, paleoSmoothWeight);
        }
        IntegerSampler.ExclusionIntegerSampler sampler = rupSet.hasModule(ModSectMinMags.class) ? constrBuilder.getSkipBelowMinSampler() : null;
        RuptureProbabilityCalc.BinaryRuptureProbabilityCalc rupExcludeModel = constrBuilder.getRupExclusionModel();
        if (rupExcludeModel != null) {
            sampler = NSHM23_InvConfigFactory.getExcludeSampler(rupSet.requireModule(ClusterRuptures.class), sampler, rupExcludeModel);
        }
        List<InversionConstraint> constraints = constrBuilder.build();
        SupraSeisBValInversionTargetMFDs targetMFDs = rupSet.requireModule(SupraSeisBValInversionTargetMFDs.class);
        GRParticRateEstimator rateEst = new GRParticRateEstimator(rupSet, targetMFDs);
        JumpProbabilityCalc segModel = NSHM23_InvConfigFactory.buildSegModel(rupSet, branch);
        if (segModel != null && NSHM23_InvConfigFactory.hasConstrainableJumps(rupSet, segModel)) {
            constraints = new ArrayList<InversionConstraint>(constraints);
            double weight = 100000.0;
            boolean ineq = true;
            constraints.add(new JumpProbabilityConstraint.RelativeRate(weight, ineq, rupSet, NSHM23_InvConfigFactory.buildSegModel(rupSet, branch), rateEst));
        }
        int avgThreads = Integer.max(1, threads / 4);
        int numRups = rupSet.getNumRuptures();
        if (sampler != null) {
            numRups = sampler.size();
        }
        long equivNumVars = Long.max(numRups, (long)rupSet.getNumSections() * 100L);
        IterationCompletionCriteria completion = new IterationCompletionCriteria(equivNumVars * this.numItersPerRup);
        IterationCompletionCriteria subCompletion = new IterationCompletionCriteria(equivNumVars);
        IterationCompletionCriteria avgCompletion = new IterationCompletionCriteria(equivNumVars * 50L);
        InversionConfiguration.Builder builder = InversionConfiguration.builder(constraints, completion).threads(threads).subCompletion(subCompletion).avgThreads(avgThreads, avgCompletion).perturbation(GenerationFunctionType.VARIABLE_EXPONENTIAL_SCALE).nonNegativity(NonnegativityConstraintType.TRY_ZERO_RATES_OFTEN).sampler(sampler).reweight().variablePertubationBasis(rateEst.estimateRuptureRates());
        if (parkWeight > 0.0 && PARKFIELD_INITIAL) {
            builder.initialSolution(constrBuilder.getParkfieldInitial(rupSet.hasModule(ModSectMinMags.class), targetMFDs));
        }
        return builder.build();
    }

    public static RuptureProbabilityCalc.BinaryRuptureProbabilityCalc getExclusionModel(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch, ClusterRuptures cRups) {
        int creepingSectID;
        RupsThroughCreepingSectBranchNode creepingModel;
        RuptureProbabilityCalc.BinaryRuptureProbabilityCalc exclusionModel;
        ArrayList<RuptureProbabilityCalc.BinaryRuptureProbabilityCalc> exclusionModels = new ArrayList<RuptureProbabilityCalc.BinaryRuptureProbabilityCalc>();
        SegmentationModelBranchNode segChoice = branch.getValue(SegmentationModelBranchNode.class);
        if (segChoice != null && (exclusionModel = segChoice.getExclusionModel(rupSet, branch)) != null) {
            exclusionModels.add(exclusionModel);
        }
        if ((creepingModel = branch.getValue(RupsThroughCreepingSectBranchNode.class)) != null && creepingModel.isExcludeRupturesThroughCreepingSect() && !(creepingModel instanceof NSHM23_SegmentationModels) && (creepingSectID = NSHM23_ConstraintBuilder.findCreepingSection(rupSet)) >= 0) {
            exclusionModels.add(new NSHM23_SegmentationModels.ExcludeRupsThroughCreepingSegmentationModel(creepingSectID));
        }
        if (exclusionModels.isEmpty()) {
            return null;
        }
        if (exclusionModels.size() == 1) {
            return (RuptureProbabilityCalc.BinaryRuptureProbabilityCalc)exclusionModels.get(0);
        }
        System.out.println("Combining " + exclusionModels.size() + " exclusion models");
        return new RuptureProbabilityCalc.LogicalAnd(exclusionModels.toArray(new RuptureProbabilityCalc.BinaryRuptureProbabilityCalc[0]));
    }

    @Override
    public InversionSolver getSolver(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
        NSHM23_SegmentationModels segModel = branch.getValue(NSHM23_SegmentationModels.class);
        if (segModel == NSHM23_SegmentationModels.CLASSIC || segModel == NSHM23_SegmentationModels.CLASSIC_FULL) {
            if (this.isSolveClustersIndividually()) {
                System.out.println("Returning classic model solver");
                ClusterRuptures cRups = rupSet.requireModule(ClusterRuptures.class);
                return new ClassicModelInversionSolver(rupSet, branch, NSHM23_InvConfigFactory.getExclusionModel(rupSet, branch, cRups));
            }
            if (!NSHM23_InvConfigFactory.hasPaleoData(rupSet) && !NSHM23_InvConfigFactory.hasParkfield(rupSet)) {
                ClusterRuptures cRups = rupSet.requireModule(ClusterRuptures.class);
                RuptureProbabilityCalc.BinaryRuptureProbabilityCalc exclusionModel = NSHM23_InvConfigFactory.getExclusionModel(rupSet, branch, cRups);
                boolean hasIncludedJump = false;
                for (ClusterRupture cRup : cRups) {
                    int numJumps = cRup.getTotalNumJumps();
                    if (numJumps <= 0 || exclusionModel != null && !exclusionModel.isRupAllowed(cRup, false)) continue;
                    hasIncludedJump = true;
                    break;
                }
                if (!hasIncludedJump) {
                    return new AnalyticalSingleFaultInversionSolver(exclusionModel);
                }
            }
            System.err.println("WARNING: solving classic model via full system inversion");
            return new InversionSolver.Default();
        }
        if (this.isSolveClustersIndividually()) {
            return new ExclusionAwareClusterSpecificInversionSolver();
        }
        return new InversionSolver.Default();
    }

    private static IntegerSampler.ExclusionIntegerSampler getExcludeSampler(ClusterRuptures cRups, IntegerSampler.ExclusionIntegerSampler currentSampler, RuptureProbabilityCalc.BinaryRuptureProbabilityCalc excludeCalc) {
        HashSet<Integer> skips = new HashSet<Integer>();
        for (int r = 0; r < cRups.size(); ++r) {
            if (excludeCalc.isRupAllowed(cRups.get(r), false)) continue;
            skips.add(r);
        }
        System.out.println("\tSkipped " + skips.size() + " ruptures");
        if (skips.isEmpty()) {
            return currentSampler;
        }
        IntegerSampler.ExclusionIntegerSampler skipSampler = new IntegerSampler.ExclusionIntegerSampler(0, cRups.size(), skips);
        if (currentSampler == null) {
            return skipSampler;
        }
        return currentSampler.getCombinedWith(skipSampler);
    }

    public static void main(String[] args) throws IOException {
        NSHM23_LogicTreeBranch branch = NSHM23_LogicTreeBranch.DEFAULT_ON_FAULT;
        NSHM23_InvConfigFactory factory = new NSHM23_InvConfigFactory();
        FaultSystemRupSet rupSet = factory.buildRuptureSet(branch, 32);
        factory.buildInversionConfig(rupSet, branch, 32);
    }

    public static class NSHM23SolProcessor
    implements SolutionLogicTree.SolutionProcessor {
        private Table<RupSetFaultModel, RupturePlausibilityModels, PlausibilityConfiguration> configCache = HashBasedTable.create();

        @Override
        public synchronized FaultSystemRupSet processRupSet(final FaultSystemRupSet rupSet, final LogicTreeBranch<?> branch) {
            RupSetFaultModel fm;
            rupSet.addModule(branch);
            if (branch.hasValue(RupSetScalingRelationship.class)) {
                rupSet.offerAvailableModule(new Callable<AveSlipModule>(){
                    final /* synthetic */ NSHM23SolProcessor this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public AveSlipModule call() throws Exception {
                        return AveSlipModule.forModel(rupSet, branch.requireValue(RupSetScalingRelationship.class));
                    }
                }, AveSlipModule.class);
            }
            if (branch.hasValue(SlipAlongRuptureModelBranchNode.class)) {
                SlipAlongRuptureModel model = branch.getValue(SlipAlongRuptureModelBranchNode.class).getModel();
                if (rupSet.getModule(SlipAlongRuptureModel.class) != model) {
                    rupSet.addModule(model);
                }
            }
            if ((fm = branch.getValue(RupSetFaultModel.class)) != null) {
                fm.attachDefaultModules(rupSet);
            }
            if (fm == FaultModels.FM2_1 || fm == FaultModels.FM3_1 || fm == FaultModels.FM3_2) {
                rupSet.offerAvailableModule(new Callable<ModSectMinMags>(){
                    final /* synthetic */ NSHM23SolProcessor this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public ModSectMinMags call() throws Exception {
                        return ModSectMinMags.instance(rupSet, FaultSystemRupSetCalc.computeMinSeismoMagForSections(rupSet, 6.0));
                    }
                }, ModSectMinMags.class);
                rupSet.offerAvailableModule(new Callable<PolygonFaultGridAssociations>(){
                    final /* synthetic */ NSHM23SolProcessor this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public PolygonFaultGridAssociations call() throws Exception {
                        if (fm == FaultModels.FM3_1 || fm == FaultModels.FM3_2) {
                            try {
                                return FaultPolyMgr.loadSerializedUCERF3((FaultModels)fm);
                            }
                            catch (IOException e) {
                                throw ExceptionUtils.asRuntimeException(e);
                            }
                        }
                        return FaultPolyMgr.create(rupSet.getFaultSectionDataList(), 12.0);
                    }
                }, PolygonFaultGridAssociations.class);
                rupSet.offerAvailableModule(new Callable<PaleoseismicConstraintData>(){
                    final /* synthetic */ NSHM23SolProcessor this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public PaleoseismicConstraintData call() throws Exception {
                        PaleoseismicConstraintData data = PaleoseismicConstraintData.loadUCERF3(rupSet);
                        if (!NSHM23_PaleoDataLoader.INCLUDE_U3_PALEO_SLIP) {
                            data = new PaleoseismicConstraintData(rupSet, data.getPaleoRateConstraints(), data.getPaleoProbModel(), null, null);
                        }
                        return data;
                    }
                }, PaleoseismicConstraintData.class);
            } else {
                if (fm instanceof NSHM18_FaultModels) {
                    rupSet.offerAvailableModule(new Callable<PaleoseismicConstraintData>(){
                        final /* synthetic */ NSHM23SolProcessor this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public PaleoseismicConstraintData call() throws Exception {
                            PaleoseismicConstraintData ret;
                            if (NSHM18_FaultModels.USE_NEW_PALEO_DATA) {
                                double prevDistOtherContained = NSHM23_PaleoDataLoader.LOC_MAX_DIST_OTHER_CONTAINED;
                                NSHM23_PaleoDataLoader.LOC_MAX_DIST_OTHER_CONTAINED = 5.0;
                                ret = NSHM23_PaleoDataLoader.load(rupSet);
                                NSHM23_PaleoDataLoader.LOC_MAX_DIST_OTHER_CONTAINED = prevDistOtherContained;
                            } else {
                                ret = PaleoseismicConstraintData.loadUCERF3(rupSet);
                                if (!NSHM23_PaleoDataLoader.INCLUDE_U3_PALEO_SLIP) {
                                    ret = new PaleoseismicConstraintData(rupSet, ret.getPaleoRateConstraints(), ret.getPaleoProbModel(), null, null);
                                }
                            }
                            return ret;
                        }
                    }, PaleoseismicConstraintData.class);
                } else if (fm instanceof NSHM23_FaultModels) {
                    rupSet.offerAvailableModule(new Callable<PaleoseismicConstraintData>(){
                        final /* synthetic */ NSHM23SolProcessor this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public PaleoseismicConstraintData call() throws Exception {
                            return NSHM23_PaleoDataLoader.load(rupSet);
                        }
                    }, PaleoseismicConstraintData.class);
                }
                if (MIN_MAG_FOR_SEISMOGENIC_RUPS > 0.0) {
                    rupSet.offerAvailableModule(new Callable<ModSectMinMags>(){
                        final /* synthetic */ NSHM23SolProcessor this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public ModSectMinMags call() throws Exception {
                            ModSectMinMags minMags = ModSectMinMags.above(rupSet, MIN_MAG_FOR_SEISMOGENIC_RUPS, true);
                            List<Integer> parkRups = NSHM23_ConstraintBuilder.findParkfieldRups(rupSet, NSHM23_InvConfigFactory.getParkfieldSelectionCriteria(fm));
                            if (parkRups != null && !parkRups.isEmpty()) {
                                IncrementalMagFreqDist refMFD = FaultSysTools.initEmptyMFD(rupSet);
                                int minParkBin = -1;
                                double minParkMag = Double.POSITIVE_INFINITY;
                                for (int parkRup : parkRups) {
                                    if (!minMags.isRupBelowSectMinMag(parkRup, refMFD)) continue;
                                    double mag = rupSet.getMagForRup(parkRup);
                                    int bin = refMFD.getClosestXIndex(mag);
                                    minParkBin = minParkBin < 0 ? bin : Integer.min(minParkBin, bin);
                                    minParkMag = Math.min(minParkMag, mag);
                                }
                                if (minParkBin >= 0) {
                                    double[] array = Arrays.copyOf(minMags.getMinMagForSections(), rupSet.getNumSections());
                                    int parkfieldID = FaultSectionUtils.findParentSectionID(rupSet.getFaultSectionDataList(), "San", "Andreas", "Parkfield");
                                    Preconditions.checkState((parkfieldID >= 0 ? 1 : 0) != 0);
                                    double parkMinMag = Math.min(minParkMag, refMFD.getX(minParkBin));
                                    int numModified = 0;
                                    for (int s = 0; s < array.length; ++s) {
                                        if (rupSet.getFaultSectionData(s).getParentSectionId() != parkfieldID) continue;
                                        array[s] = parkMinMag;
                                        ++numModified;
                                    }
                                    System.out.println("Modified SectMinMag for " + numModified + " Parkfield sections to " + (float)parkMinMag);
                                    Preconditions.checkState((numModified > 0 ? 1 : 0) != 0, (Object)"Parkfield sections not found?");
                                    minMags = ModSectMinMags.instance(rupSet, array);
                                }
                            }
                            return minMags;
                        }
                    }, ModSectMinMags.class);
                }
            }
            rupSet.offerAvailableModule(new Callable<SupraSeisBValInversionTargetMFDs>(){
                final /* synthetic */ NSHM23SolProcessor this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public SupraSeisBValInversionTargetMFDs call() throws Exception {
                    return NSHM23_InvConfigFactory.getConstraintBuilder(rupSet, branch).getTargetMFDs();
                }
            }, SupraSeisBValInversionTargetMFDs.class);
            rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<SectSlipRates>(){
                final /* synthetic */ NSHM23SolProcessor this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public SectSlipRates call() throws Exception {
                    SupraSeisBValInversionTargetMFDs.Builder builder;
                    SupraSeisBValInversionTargetMFDs targetMFDs = rupSet.getModule(SupraSeisBValInversionTargetMFDs.class, false);
                    if (targetMFDs != null) {
                        return targetMFDs.getSectSlipRates();
                    }
                    SupraSeisBValInversionTargetMFDs.SubSeisMoRateReduction moRateRed = branch.hasValue(SubSeisMoRateReductions.class) ? branch.getValue(SubSeisMoRateReductions.class).getChoice() : SupraSeisBValInversionTargetMFDs.SUB_SEIS_MO_RATE_REDUCTION_DEFAULT;
                    RandomBValSampler.Node bValNode = branch.getValue(RandomBValSampler.Node.class);
                    if (bValNode != null) {
                        RandomBValSampler sampler = rupSet.requireModule(BranchSamplingManager.class).getSampler(bValNode);
                        builder = new SupraSeisBValInversionTargetMFDs.Builder(rupSet, sampler.getBValues());
                    } else {
                        builder = new SupraSeisBValInversionTargetMFDs.Builder(rupSet, branch.requireValue(SectionSupraSeisBValues.class));
                    }
                    return builder.subSeisMoRateReduction(moRateRed).buildSlipRatesOnly();
                }
            }, SectSlipRates.class);
            final List<? extends FaultSection> subSects = rupSet.getFaultSectionDataList();
            rupSet.offerAvailableModule(new Callable<PlausibilityConfiguration>(){
                final /* synthetic */ NSHM23SolProcessor this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public PlausibilityConfiguration call() throws Exception {
                    PlausibilityConfiguration config;
                    RupturePlausibilityModels model = branch.requireValue(RupturePlausibilityModels.class);
                    RupSetFaultModel fm = branch.requireValue(RupSetFaultModel.class);
                    Table<RupSetFaultModel, RupturePlausibilityModels, PlausibilityConfiguration> table = this.this$0.configCache;
                    synchronized (table) {
                        config = (PlausibilityConfiguration)this.this$0.configCache.get((Object)fm, (Object)model);
                        if (config == null) {
                            config = model.getConfig(subSects, branch.requireValue(RupSetScalingRelationship.class)).getPlausibilityConfig();
                            this.this$0.configCache.put((Object)fm, (Object)model, (Object)config);
                        }
                    }
                    return config;
                }
            }, PlausibilityConfiguration.class);
            rupSet.offerAvailableModule(new Callable<ClusterRuptures>(){
                final /* synthetic */ NSHM23SolProcessor this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public ClusterRuptures call() throws Exception {
                    return ClusterRuptures.singleStranged(rupSet);
                }
            }, ClusterRuptures.class);
            if (branch.hasValue(MaxMagOffFaultBranchNode.class) && branch.hasValue(NSHM23_DeclusteringAlgorithms.class) && branch.hasValue(NSHM23_SeisSmoothingAlgorithms.class) && branch.hasValue(NSHM23_RegionalSeismicity.class) && rupSet.hasAvailableModule(ModelRegion.class)) {
                rupSet.offerAvailableModule(new Callable<FaultGridAssociations>(){
                    final /* synthetic */ NSHM23SolProcessor this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public FaultGridAssociations call() throws Exception {
                        return NSHM23_InvConfigFactory.buildFaultCubeAssociations(rupSet, branch, rupSet.requireModule(ModelRegion.class).getRegion());
                    }
                }, FaultGridAssociations.class);
            } else if (branch.hasValue(MaxMagOffFaultBranchNode.class) && branch.hasValue(SpatialSeisPDF.class) && branch.hasValue(TotalMag5Rate.class)) {
                rupSet.offerAvailableModule(new Callable<FaultGridAssociations>(){
                    final /* synthetic */ NSHM23SolProcessor this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public FaultGridAssociations call() throws Exception {
                        return NSHM23_InvConfigFactory.buildU3IngredientsFaultCubeAssociations(rupSet);
                    }
                }, FaultGridAssociations.class);
            }
            if (BranchSamplingManager.hasSamplingNodes(branch)) {
                rupSet.offerAvailableModule(new Callable<BranchSamplingManager>(){
                    final /* synthetic */ NSHM23SolProcessor this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public BranchSamplingManager call() throws Exception {
                        return new BranchSamplingManager(rupSet, branch);
                    }
                }, BranchSamplingManager.class);
            }
            return rupSet;
        }

        @Override
        public FaultSystemSolution processSolution(final FaultSystemSolution sol, final LogicTreeBranch<?> branch) {
            final FaultSystemRupSet rupSet = sol.getRupSet();
            if (!sol.hasAvailableModule(SolutionSlipRates.class) && rupSet.hasAvailableModule(AveSlipModule.class) && rupSet.hasAvailableModule(SlipAlongRuptureModel.class)) {
                sol.addAvailableModule((Callable<OpenSHA_Module>)new Callable<SolutionSlipRates>(){
                    final /* synthetic */ NSHM23SolProcessor this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public SolutionSlipRates call() throws Exception {
                        return SolutionSlipRates.calc(sol, rupSet.requireModule(AveSlipModule.class), rupSet.requireModule(SlipAlongRuptureModel.class));
                    }
                }, SolutionSlipRates.class);
            }
            if (branch.hasValue(MaxMagOffFaultBranchNode.class) && branch.hasValue(NSHM23_DeclusteringAlgorithms.class) && branch.hasValue(NSHM23_SeisSmoothingAlgorithms.class) && branch.hasValue(NSHM23_RegionalSeismicity.class)) {
                sol.offerAvailableModule(new Callable<GridSourceProvider>(){
                    final /* synthetic */ NSHM23SolProcessor this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public NSHM23_AbstractGridSourceProvider call() throws Exception {
                        return NSHM23_InvConfigFactory.buildGridSourceProv(sol, branch);
                    }
                }, GridSourceProvider.class);
            } else if (branch.hasValue(MaxMagOffFaultBranchNode.class) && branch.hasValue(SpatialSeisPDF.class) && branch.hasValue(TotalMag5Rate.class)) {
                sol.offerAvailableModule(new Callable<GridSourceProvider>(){
                    final /* synthetic */ NSHM23SolProcessor this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public NSHM23_AbstractGridSourceProvider call() throws Exception {
                        double maxMagOff = branch.requireValue(MaxMagOffFaultBranchNode.class).getMaxMagOffFault();
                        IncrementalMagFreqDist refMFD = FaultSysTools.initEmptyMFD(Math.max(maxMagOff, sol.getRupSet().getMaxMag()));
                        NSHM23_FaultCubeAssociations cubeAssociations = NSHM23_InvConfigFactory.buildU3IngredientsFaultCubeAssociations(rupSet);
                        rupSet.addModule(cubeAssociations);
                        return NSHM23_InvConfigFactory.buildU3IngredientsGridSourceProv(sol, branch.requireValue(TotalMag5Rate.class).getRateMag5(), branch.requireValue(SpatialSeisPDF.class), maxMagOff, refMFD, cubeAssociations);
                    }
                }, GridSourceProvider.class);
            }
            if (!sol.hasModule(LogicTreeBranch.class) || !branch.equals(sol.getModule(LogicTreeBranch.class))) {
                sol.addModule(branch);
            }
            return sol;
        }
    }

    private static class SeismicityRegionsListModule
    implements OpenSHA_Module {
        public final List<NSHM23_RegionLoader.SeismicityRegions> seisRegions;

        public SeismicityRegionsListModule(List<NSHM23_RegionLoader.SeismicityRegions> seisRegions) {
            this.seisRegions = seisRegions;
        }

        @Override
        public String getName() {
            return "Seismicity Regions";
        }
    }

    public static class ExclusionAwareClusterSpecificInversionSolver
    extends ClusterSpecificInversionSolver {
        @Override
        protected RuptureProbabilityCalc.BinaryRuptureProbabilityCalc getRuptureExclusionModel(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
            return NSHM23_InvConfigFactory.getExclusionModel(rupSet, branch, rupSet.requireModule(ClusterRuptures.class));
        }
    }

    public static class ModPitasPointDDW
    extends NSHM23_InvConfigFactory {
        private ModDepthFM modFM(RupSetFaultModel fm) {
            return new ModDepthFM(fm, 333, 15.0);
        }

        @Override
        protected synchronized FaultSystemRupSet buildGenericRupSet(LogicTreeBranch<?> branch, int threads) {
            List<? extends FaultSection> subSects;
            FaultSystemRupSet rupSet;
            RupSetFaultModel fm = branch.requireValue(RupSetFaultModel.class);
            RupSetSubsectioningModel ssm = branch.requireValue(RupSetSubsectioningModel.class);
            RupturePlausibilityModels model = branch.getValue(RupturePlausibilityModels.class);
            if (model == null) {
                model = fm instanceof FaultModels ? RupturePlausibilityModels.UCERF3 : RupturePlausibilityModels.COULOMB;
            }
            if ((rupSet = this.rupSetCache.get(fm, ssm, model)) != null) {
                return rupSet;
            }
            RupSetScalingRelationship scale = branch.requireValue(RupSetScalingRelationship.class);
            RupSetDeformationModel dm = fm.getDefaultDeformationModel();
            try {
                subSects = dm.build(this.modFM(fm), (RupSetSubsectioningModel)((Object)fm), branch);
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            RuptureSets.RupSetConfig config = model.getConfig(subSects, scale);
            if (rupSet == null) {
                rupSet = config.build(threads);
            }
            this.rupSetCache.put(rupSet, fm, ssm, model);
            return rupSet;
        }

        @Override
        public FaultSystemRupSet updateRuptureSetForBranch(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) throws IOException {
            List<? extends FaultSection> subSects;
            RupSetFaultModel fm = branch.requireValue(RupSetFaultModel.class);
            RupSetDeformationModel dm = branch.requireValue(RupSetDeformationModel.class);
            Preconditions.checkState((boolean)dm.isApplicableTo(fm), (String)"Fault and deformation models are not compatible: %s, %s", (Object)fm.getName(), (Object)dm.getName());
            try {
                subSects = dm.build(this.modFM(fm), (RupSetSubsectioningModel)((Object)fm), branch);
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            RuptureSubSetMappings subsetMappings = rupSet.getModule(RuptureSubSetMappings.class);
            if (subsetMappings != null) {
                ArrayList<? extends FaultSection> subsetSects = new ArrayList<FaultSection>();
                for (int s = 0; s < rupSet.getNumSections(); ++s) {
                    FaultSection sect = subSects.get(subsetMappings.getOrigSectID(s)).clone();
                    sect.setSectionId(s);
                    subsetSects.add(sect);
                }
                subSects = subsetSects;
            }
            Preconditions.checkState((subSects.size() == rupSet.getNumSections() ? 1 : 0) != 0);
            ClusterRuptures cRups = rupSet.getModule(ClusterRuptures.class);
            PlausibilityConfiguration plausibility = rupSet.getModule(PlausibilityConfiguration.class);
            RupSetScalingRelationship scale = branch.requireValue(RupSetScalingRelationship.class);
            if (cRups == null) {
                rupSet = FaultSystemRupSet.builder(subSects, rupSet.getSectionIndicesForAllRups()).forScalingRelationship(scale).build();
                if (plausibility != null) {
                    rupSet.addModule(plausibility);
                }
                rupSet.addModule(ClusterRuptures.singleStranged(rupSet));
            } else {
                rupSet = ClusterRuptureBuilder.buildClusterRupSet(scale, subSects, plausibility, cRups.getAll());
            }
            if (subsetMappings != null) {
                rupSet.addModule(subsetMappings);
            }
            SlipAlongRuptureModelBranchNode slipAlong = branch.requireValue(SlipAlongRuptureModelBranchNode.class);
            rupSet.addModule(slipAlong.getModel());
            return this.getSolutionLogicTreeProcessor().processRupSet(rupSet, branch);
        }

        private class ModDepthFM
        implements RupSetFaultModel {
            private RupSetFaultModel fm;
            private int parentID;
            private double lowerDepth;

            public ModDepthFM(RupSetFaultModel fm, int parentID, double lowerDepth) {
                this.fm = fm;
                this.parentID = parentID;
                this.lowerDepth = lowerDepth;
            }

            @Override
            public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
                return this.fm.getNodeWeight(fullBranch);
            }

            @Override
            public String getFilePrefix() {
                return this.fm.getFilePrefix();
            }

            @Override
            public String getShortName() {
                return this.fm.getShortName();
            }

            @Override
            public String getName() {
                return this.fm.getName();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public List<? extends FaultSection> getFaultSections() throws IOException {
                ArrayList<void> ret = new ArrayList<void>();
                boolean found = false;
                for (FaultSection faultSection : this.fm.getFaultSections()) {
                    void var4_4;
                    if (faultSection.getSectionId() == this.parentID) {
                        found = true;
                        Preconditions.checkState((boolean)(faultSection instanceof GeoJSONFaultSection));
                        double origDepth = faultSection.getAveLowerDepth();
                        Feature feature = ((GeoJSONFaultSection)faultSection).toFeature();
                        feature.properties.set("LowDepth", this.lowerDepth);
                        GeoJSONFaultSection geoJSONFaultSection = GeoJSONFaultSection.fromFeature(feature);
                        System.out.println("Updated lowDepth for " + geoJSONFaultSection.getSectionId() + ". " + geoJSONFaultSection.getSectionName() + ": " + (float)origDepth + " -> " + (float)geoJSONFaultSection.getAveLowerDepth() + " km");
                    }
                    ret.add(var4_4);
                }
                Preconditions.checkState((boolean)found);
                return ret;
            }

            @Override
            public RupSetDeformationModel getDefaultDeformationModel() {
                return this.fm.getDefaultDeformationModel();
            }
        }
    }

    public static class NSHM23_V2
    extends NSHM23_InvConfigFactory {
        public NSHM23_V2() {
            NSHM23_ConstraintBuilder.MAX_NUM_ZERO_SLIP_SECTS_PER_RUP = 0;
            NSHM23_RegionalSeismicity.RATE_FILE_NAME = "rates_2023_03_30.csv";
            NSHM23_RegionalSeismicity.clearCache();
            NSHM23_SeisSmoothingAlgorithms.MODEL_DATE = "2023_03_30";
            NSHM23_SeisSmoothingAlgorithms.clearCache();
            NSHM23_RegionLoader.setSeismicityRegionVersion(2);
        }
    }

    public static class MatchFullBA
    extends NSHM23_InvConfigFactory {
        private double[] baNuclRates;

        public MatchFullBA() throws IOException {
            FaultSystemSolution sol = FaultSystemSolution.load(new File("/home/kevin/OpenSHA/nshm23/batch_inversions/2023_04_11-nshm23_branches-NSHM23_v2-CoulombRupSet-TotNuclRate-NoRed-ThreshAvgIterRelGR/results_NSHM23_v2_CoulombRupSet_branch_averaged_gridded.zip"));
            this.baNuclRates = sol.calcNucleationRateForAllSects(0.0, Double.POSITIVE_INFINITY);
        }

        @Override
        public InversionConfiguration buildInversionConfig(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch, int threads) {
            InversionConfiguration config = super.buildInversionConfig(rupSet, branch, threads);
            boolean found = false;
            for (InversionConstraint constr : config.getConstraints()) {
                if (!(constr instanceof SectionTotalRateConstraint)) continue;
                found = true;
                SectionTotalRateConstraint sectConstr = (SectionTotalRateConstraint)constr;
                RuptureSubSetMappings mappings = rupSet.getModule(RuptureSubSetMappings.class);
                double[] totRates = this.baNuclRates;
                double[] totRateStdDevs = sectConstr.getSectRateStdDevs();
                if (mappings != null) {
                    totRates = new double[mappings.getNumRetainedSects()];
                    for (int i = 0; i < totRates.length; ++i) {
                        totRates[i] = this.baNuclRates[mappings.getOrigSectID(i)];
                    }
                }
                Preconditions.checkState((totRates.length == totRateStdDevs.length ? 1 : 0) != 0);
                sectConstr.setSectRates(totRates, totRateStdDevs);
            }
            Preconditions.checkState((boolean)found);
            return config;
        }
    }

    public static class NSHM18_UseU3Paleo
    extends NSHM23_InvConfigFactory {
        public NSHM18_UseU3Paleo() {
            NSHM18_FaultModels.USE_NEW_PALEO_DATA = false;
        }
    }

    public static class ModScalingAdd4p3
    extends NSHM23_InvConfigFactory {
        public ModScalingAdd4p3() {
            NSHM23_ScalingRelationships.ORIGINAL_DRAFT_RELS = false;
        }
    }

    public static class OrigDraftScaling
    extends NSHM23_InvConfigFactory {
        public OrigDraftScaling() {
            NSHM23_ScalingRelationships.ORIGINAL_DRAFT_RELS = true;
        }
    }

    public static class ModDepthGV08
    extends NSHM23_InvConfigFactory {
        @Override
        protected synchronized FaultSystemRupSet buildGenericRupSet(LogicTreeBranch<?> branch, int threads) {
            List<? extends FaultSection> origSubSects;
            FaultSystemRupSet rupSet;
            RupSetFaultModel fm = branch.requireValue(RupSetFaultModel.class);
            RupSetSubsectioningModel ssm = branch.requireValue(RupSetSubsectioningModel.class);
            RupturePlausibilityModels model = branch.getValue(RupturePlausibilityModels.class);
            if (model == null) {
                model = fm instanceof FaultModels ? RupturePlausibilityModels.UCERF3 : RupturePlausibilityModels.COULOMB;
            }
            if ((rupSet = this.rupSetCache.get(fm, ssm, model)) != null) {
                return rupSet;
            }
            RupSetScalingRelationship scale = branch.requireValue(RupSetScalingRelationship.class);
            RupSetDeformationModel dm = fm.getDefaultDeformationModel();
            try {
                origSubSects = dm.build(fm, ssm, branch);
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            ArrayList<FaultSection> subSects = new ArrayList<FaultSection>();
            for (int s = 0; s < origSubSects.size(); ++s) {
                FaultSection sect = origSubSects.get(s);
                if (sect.getParentSectionId() == 106) {
                    double origUpper = sect.getOrigAveUpperDepth();
                    double origLower = sect.getAveLowerDepth();
                    double newUpper = 7.0;
                    double newLower = 7.0 + (origLower - origUpper);
                    GeoJSONFaultSection origSect = sect instanceof GeoJSONFaultSection ? (GeoJSONFaultSection)sect : new GeoJSONFaultSection(sect);
                    Feature feature = origSect.toFeature();
                    feature.properties.set("UpDepth", newUpper);
                    feature.properties.set("LowDepth", newLower);
                    GeoJSONFaultSection newSect = GeoJSONFaultSection.fromFeature(feature);
                    System.out.println("Moved DDW for " + sect.getSectionName() + " from " + origSect.getOrigAveUpperDepth() + " to " + newSect.getOrigAveUpperDepth());
                    sect = newSect;
                }
                subSects.add(sect);
            }
            RuptureSets.RupSetConfig config = model.getConfig(subSects, scale);
            if (rupSet == null) {
                rupSet = config.build(threads);
            }
            this.rupSetCache.put(rupSet, fm, ssm, model);
            return rupSet;
        }
    }

    public static class SparseGRNearest
    extends NSHM23_InvConfigFactory {
        public SparseGRNearest() {
            SparseGutenbergRichterSolver.METHOD_DEFAULT = SparseGutenbergRichterSolver.SpreadingMethod.NEAREST;
        }
    }

    public static class SparseGRDontSpreadSingleToMulti
    extends NSHM23_InvConfigFactory {
        public SparseGRDontSpreadSingleToMulti() {
            SupraSeisBValInversionTargetMFDs.SPARSE_GR_DONT_SPREAD_SINGLE_TO_MULTI = true;
        }
    }

    public static class SlipRateStdDevCeil0p1
    extends NSHM23_InvConfigFactory {
        public SlipRateStdDevCeil0p1() {
            NSHM23_DeformationModels.HARDCODED_FRACTIONAL_STD_DEV = 0.0;
            NSHM23_DeformationModels.HARDCODED_FRACTIONAL_STD_DEV_UPPER_BOUND = 0.1;
        }
    }

    public static class SegModelMaxLen600
    extends NSHM23_InvConfigFactory {
        public SegModelMaxLen600() {
            NSHM23_SegmentationModels.LIMIT_MAX_LENGTHS = true;
            NSHM23_SegmentationModels.SINGLE_MAX_LENGTH_LIMIT = 600.0;
        }
    }

    public static class SegModelLimitMaxLen
    extends NSHM23_InvConfigFactory {
        public SegModelLimitMaxLen() {
            NSHM23_SegmentationModels.LIMIT_MAX_LENGTHS = true;
        }
    }

    public static class DM_OutlierlMinimizationWeights
    extends NSHM23_InvConfigFactory {
        public DM_OutlierlMinimizationWeights() {
            NSHM23_DeformationModels.ORIGINAL_WEIGHTS = false;
        }
    }

    public static class DM_OriginalWeights
    extends NSHM23_InvConfigFactory {
        public DM_OriginalWeights() {
            NSHM23_DeformationModels.ORIGINAL_WEIGHTS = true;
        }
    }

    public static class DM_OutlierLogReplacementYc5p0
    extends NSHM23_InvConfigFactory {
        public DM_OutlierLogReplacementYc5p0() {
            NSHM23_DeformationModels.OUTLIER_SUB_YC = 5.0;
            NSHM23_DeformationModels.OUTLIER_SUB_LOG = true;
            NSHM23_DeformationModels.OUTLIER_SUB_USE_BOUND = false;
            NSHM23_DeformationModels.ORIGINAL_WEIGHTS = true;
        }
    }

    public static class DM_OutlierLogReplacementYc3p5
    extends NSHM23_InvConfigFactory {
        public DM_OutlierLogReplacementYc3p5() {
            NSHM23_DeformationModels.OUTLIER_SUB_YC = 3.5;
            NSHM23_DeformationModels.OUTLIER_SUB_LOG = true;
            NSHM23_DeformationModels.OUTLIER_SUB_USE_BOUND = false;
            NSHM23_DeformationModels.ORIGINAL_WEIGHTS = true;
        }
    }

    public static class DM_OutlierLogReplacementYc2p0
    extends NSHM23_InvConfigFactory {
        public DM_OutlierLogReplacementYc2p0() {
            NSHM23_DeformationModels.OUTLIER_SUB_YC = 2.0;
            NSHM23_DeformationModels.OUTLIER_SUB_LOG = true;
            NSHM23_DeformationModels.OUTLIER_SUB_USE_BOUND = false;
            NSHM23_DeformationModels.ORIGINAL_WEIGHTS = true;
        }
    }

    public static class DM_OutlierReplacementYc5p0
    extends NSHM23_InvConfigFactory {
        public DM_OutlierReplacementYc5p0() {
            NSHM23_DeformationModels.OUTLIER_SUB_YC = 5.0;
            NSHM23_DeformationModels.OUTLIER_SUB_LOG = false;
            NSHM23_DeformationModels.OUTLIER_SUB_USE_BOUND = false;
            NSHM23_DeformationModels.ORIGINAL_WEIGHTS = true;
        }
    }

    public static class DM_OutlierReplacementYc3p5
    extends NSHM23_InvConfigFactory {
        public DM_OutlierReplacementYc3p5() {
            NSHM23_DeformationModels.OUTLIER_SUB_YC = 3.5;
            NSHM23_DeformationModels.OUTLIER_SUB_LOG = false;
            NSHM23_DeformationModels.OUTLIER_SUB_USE_BOUND = false;
            NSHM23_DeformationModels.ORIGINAL_WEIGHTS = true;
        }
    }

    public static class DM_OutlierReplacementYc2p0
    extends NSHM23_InvConfigFactory {
        public DM_OutlierReplacementYc2p0() {
            NSHM23_DeformationModels.OUTLIER_SUB_YC = 2.0;
            NSHM23_DeformationModels.OUTLIER_SUB_LOG = false;
            NSHM23_DeformationModels.OUTLIER_SUB_USE_BOUND = false;
            NSHM23_DeformationModels.ORIGINAL_WEIGHTS = true;
        }
    }

    public static class TenThousandItersPerRup
    extends NSHM23_InvConfigFactory {
        public TenThousandItersPerRup() {
            this.numItersPerRup = 10000L;
        }
    }

    public static class PaleoSlipInequality
    extends NSHM23_InvConfigFactory {
        public PaleoSlipInequality() {
            NSHM23_PaleoDataLoader.INCLUDE_U3_PALEO_SLIP = true;
        }

        @Override
        public InversionConfiguration buildInversionConfig(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch, int threads) {
            InversionConfiguration config = super.buildInversionConfig(rupSet, branch, threads);
            if (config == null) {
                return null;
            }
            for (InversionConstraint constraint : config.getConstraints()) {
                if (!(constraint instanceof PaleoSlipInversionConstraint)) continue;
                ((PaleoSlipInversionConstraint)constraint).setInequality(true);
            }
            return config;
        }
    }

    public static class ForcePaleoSlip
    extends NSHM23_InvConfigFactory {
        public ForcePaleoSlip() {
            NSHM23_PaleoDataLoader.INCLUDE_U3_PALEO_SLIP = true;
        }
    }

    public static class NoPaleoSlip
    extends NSHM23_InvConfigFactory {
        public NoPaleoSlip() {
            NSHM23_PaleoDataLoader.INCLUDE_U3_PALEO_SLIP = false;
        }

        @Override
        public InversionConfiguration buildInversionConfig(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch, int threads) {
            InversionConfiguration config = super.buildInversionConfig(rupSet, branch, threads);
            if (config == null) {
                return null;
            }
            boolean hasSlip = false;
            for (InversionConstraint constraint : config.getConstraints()) {
                hasSlip = hasSlip || constraint instanceof PaleoSlipInversionConstraint;
            }
            if (hasSlip) {
                config = InversionConfiguration.builder(config).except(PaleoSlipInversionConstraint.class, false).build();
            }
            return config;
        }
    }

    public static class RemoveProxyFaults
    extends NSHM23_InvConfigFactory {
        @Override
        protected synchronized FaultSystemRupSet buildGenericRupSet(LogicTreeBranch<?> branch, int threads) {
            FaultSystemRupSet fullRupSet = super.buildGenericRupSet(branch, threads);
            HashSet<Integer> retained = new HashSet<Integer>();
            final ArrayList<GeoJSONFaultSection> excluded = new ArrayList<GeoJSONFaultSection>();
            for (int s = 0; s < fullRupSet.getNumSections(); ++s) {
                GeoJSONFaultSection sect = (GeoJSONFaultSection)fullRupSet.getFaultSectionData(s);
                String proxy = sect.getProperty("Proxy", null);
                if (proxy != null && proxy.equals("yes")) {
                    System.out.println("Skipping " + sect.getName() + " (proxy=" + proxy + ")");
                    excluded.add(sect);
                    continue;
                }
                retained.add(s);
            }
            System.out.println("Retaining " + retained.size() + "/" + fullRupSet.getNumSections() + " subsections");
            FaultSystemRupSet ret = fullRupSet.getForSectionSubSet(retained, new RuptureProbabilityCalc.BinaryRuptureProbabilityCalc(){
                final /* synthetic */ RemoveProxyFaults this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public String getName() {
                    return "No proxy faults";
                }

                @Override
                public boolean isDirectional(boolean splayed) {
                    return false;
                }

                @Override
                public boolean isRupAllowed(ClusterRupture fullRupture, boolean verbose) {
                    for (FaultSection sect : excluded) {
                        if (!fullRupture.contains(sect)) continue;
                        return false;
                    }
                    return true;
                }
            });
            ret.addModule(fullRupSet.getModule(PlausibilityConfiguration.class));
            return ret;
        }
    }

    public static class RemoveIsolatedFaults
    extends NSHM23_InvConfigFactory {
        @Override
        protected synchronized FaultSystemRupSet buildGenericRupSet(LogicTreeBranch<?> branch, int threads) {
            FaultSystemRupSet fullRupSet = super.buildGenericRupSet(branch, threads);
            List<ConnectivityCluster> clusters = ConnectivityCluster.build(fullRupSet);
            HashSet<Integer> retained = new HashSet<Integer>();
            for (ConnectivityCluster cluster : clusters) {
                if (cluster.getParentSectIDs().size() <= 1) continue;
                retained.addAll(cluster.getSectIDs());
            }
            System.out.println("Retaining " + retained.size() + "/" + fullRupSet.getNumSections() + " subsections");
            FaultSystemRupSet ret = fullRupSet.getForSectionSubSet(retained);
            ret.addModule(fullRupSet.getModule(PlausibilityConfiguration.class));
            return ret;
        }

        @Override
        public FaultSystemRupSet updateRuptureSetForBranch(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) throws IOException {
            List<? extends FaultSection> subSects = rupSet.getFaultSectionDataList();
            ClusterRuptures cRups = rupSet.getModule(ClusterRuptures.class);
            PlausibilityConfiguration plausibility = rupSet.getModule(PlausibilityConfiguration.class);
            RupSetScalingRelationship scale = branch.requireValue(RupSetScalingRelationship.class);
            if (cRups == null) {
                rupSet = FaultSystemRupSet.builder(subSects, rupSet.getSectionIndicesForAllRups()).forScalingRelationship(scale).build();
                if (plausibility != null) {
                    rupSet.addModule(plausibility);
                }
                rupSet.addModule(ClusterRuptures.singleStranged(rupSet));
            } else {
                rupSet = ClusterRuptureBuilder.buildClusterRupSet(scale, subSects, plausibility, cRups.getAll());
            }
            SlipAlongRuptureModelBranchNode slipAlong = branch.requireValue(SlipAlongRuptureModelBranchNode.class);
            rupSet.addModule(slipAlong.getModel());
            return this.getSolutionLogicTreeProcessor().processRupSet(rupSet, branch);
        }
    }

    public static class ForceNoGhostTransient
    extends NSHM23_InvConfigFactory {
        public ForceNoGhostTransient() {
            NSHM23_DeformationModels.GEODETIC_INCLUDE_GHOST_TRANSIENT = false;
        }
    }

    public static class ScaleSurfSlipUseActualWidths
    extends NSHM23_InvConfigFactory {
        public ScaleSurfSlipUseActualWidths() {
            NSHM23_ScalingRelationships.SURFACE_SLIP_HARDCODED_W = false;
        }
    }

    public static class ForceNewPaleo
    extends NSHM23_InvConfigFactory {
        @Override
        public SolutionLogicTree.SolutionProcessor getSolutionLogicTreeProcessor() {
            return new NSHM23SolProcessor(){

                @Override
                public synchronized FaultSystemRupSet processRupSet(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
                    rupSet = super.processRupSet(rupSet, branch);
                    rupSet.removeModuleInstances(PaleoseismicConstraintData.class);
                    try {
                        rupSet.addModule(NSHM23_PaleoDataLoader.load(rupSet));
                    }
                    catch (IOException e) {
                        throw ExceptionUtils.asRuntimeException(e);
                    }
                    return rupSet;
                }
            };
        }
    }

    public static class NoAvg
    extends NSHM23_InvConfigFactory {
        @Override
        public InversionConfiguration buildInversionConfig(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch, int threads) {
            InversionConfiguration config = super.buildInversionConfig(rupSet, branch, threads);
            config = InversionConfiguration.builder(config).avgThreads(1, config.getAvgCompletionCriteria()).build();
            return config;
        }
    }

    public static class ScaleLowerDepth1p3
    extends AbstractScaleLowerDepth {
        public ScaleLowerDepth1p3() {
            super(1.3);
        }
    }

    private static class AbstractScaleLowerDepth
    extends NSHM23_InvConfigFactory {
        private double scalar;

        private AbstractScaleLowerDepth(double scalar) {
            this.scalar = scalar;
        }

        @Override
        public FaultSystemRupSet buildRuptureSet(LogicTreeBranch<?> branch, int threads) throws IOException {
            FaultSystemRupSet rupSet = super.buildRuptureSet(branch, threads);
            ArrayList<GeoJSONFaultSection> modSects = new ArrayList<GeoJSONFaultSection>();
            for (FaultSection faultSection : rupSet.getFaultSectionDataList()) {
                GeoJSONFaultSection geoSect = faultSection instanceof GeoJSONFaultSection ? (GeoJSONFaultSection)faultSection : new GeoJSONFaultSection(faultSection);
                Feature feature = geoSect.toFeature();
                FeatureProperties props = feature.properties;
                double curLowDepth = props.getDouble("LowDepth", Double.NaN);
                Preconditions.checkState((curLowDepth > 0.0 ? 1 : 0) != 0);
                props.set("LowDepth", curLowDepth * this.scalar);
                GeoJSONFaultSection modSect = GeoJSONFaultSection.fromFeature(feature);
                modSects.add(modSect);
            }
            ClusterRuptures cRups = rupSet.requireModule(ClusterRuptures.class);
            PlausibilityConfiguration plausibilityConfiguration = rupSet.getModule(PlausibilityConfiguration.class);
            RupSetScalingRelationship scale = branch.requireValue(RupSetScalingRelationship.class);
            rupSet = ClusterRuptureBuilder.buildClusterRupSet(scale, modSects, plausibilityConfiguration, cRups.getAll());
            this.getSolutionLogicTreeProcessor().processRupSet(rupSet, branch);
            return rupSet;
        }
    }

    public static class ConstantSlipRateStdDev0p2
    extends NSHM23_InvConfigFactory {
        public ConstantSlipRateStdDev0p2() {
            NSHM23_DeformationModels.HARDCODED_FRACTIONAL_STD_DEV = 0.2;
        }
    }

    public static class ConstantSlipRateStdDev0p1
    extends NSHM23_InvConfigFactory {
        public ConstantSlipRateStdDev0p1() {
            NSHM23_DeformationModels.HARDCODED_FRACTIONAL_STD_DEV = 0.1;
        }
    }

    public static class MFDUncert0p1
    extends NSHM23_InvConfigFactory {
        public MFDUncert0p1() {
            MFD_MIN_FRACT_UNCERT = 0.1;
        }
    }

    public static class FullSysInv
    extends NSHM23_InvConfigFactory {
        public FullSysInv() {
            this.setSolveClustersIndividually(false);
        }
    }

    public static class SegWeight100000
    extends NSHM23_InvConfigFactory {
        @Override
        public InversionConfiguration buildInversionConfig(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch, int threads) {
            InversionConfiguration config = super.buildInversionConfig(rupSet, branch, threads);
            if (config == null) {
                return null;
            }
            for (InversionConstraint constraint : config.getConstraints()) {
                if (!(constraint instanceof JumpProbabilityConstraint)) continue;
                constraint.setWeight(100000.0);
            }
            return config;
        }
    }

    public static class SegWeight10000
    extends NSHM23_InvConfigFactory {
        @Override
        public InversionConfiguration buildInversionConfig(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch, int threads) {
            InversionConfiguration config = super.buildInversionConfig(rupSet, branch, threads);
            if (config == null) {
                return null;
            }
            for (InversionConstraint constraint : config.getConstraints()) {
                if (!(constraint instanceof JumpProbabilityConstraint)) continue;
                constraint.setWeight(10000.0);
            }
            return config;
        }
    }

    public static class SegWeight1000
    extends NSHM23_InvConfigFactory {
        @Override
        public InversionConfiguration buildInversionConfig(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch, int threads) {
            InversionConfiguration config = super.buildInversionConfig(rupSet, branch, threads);
            if (config == null) {
                return null;
            }
            for (InversionConstraint constraint : config.getConstraints()) {
                if (!(constraint instanceof JumpProbabilityConstraint)) continue;
                constraint.setWeight(1000.0);
            }
            return config;
        }
    }

    public static class SegWeight100
    extends NSHM23_InvConfigFactory {
        @Override
        public InversionConfiguration buildInversionConfig(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch, int threads) {
            InversionConfiguration config = super.buildInversionConfig(rupSet, branch, threads);
            if (config == null) {
                return null;
            }
            for (InversionConstraint constraint : config.getConstraints()) {
                if (!(constraint instanceof JumpProbabilityConstraint)) continue;
                constraint.setWeight(100.0);
            }
            return config;
        }
    }

    public static class HardcodedPrevAsInitial
    extends NSHM23_InvConfigFactory {
        private SolutionLogicTree slt;

        public HardcodedPrevAsInitial() {
            this(new File("/project/scec_608/kmilner/nshm23/batch_inversions/2022_06_10-nshm23_u3_hybrid_branches-FM3_1-CoulombRupSet-DsrUni-TotNuclRate-SubB1-Shift2km-ThreshAvgIterRelGR-IncludeThruCreep/results.zip"));
        }

        public HardcodedPrevAsInitial(File resultsFile) {
            try {
                this.slt = SolutionLogicTree.load(resultsFile);
            }
            catch (Exception e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }

        @Override
        protected synchronized FaultSystemRupSet buildGenericRupSet(LogicTreeBranch<?> branch, int threads) {
            FaultSystemRupSet rupSet;
            RupSetFaultModel fm = branch.requireValue(RupSetFaultModel.class);
            RupturePlausibilityModels model = branch.getValue(RupturePlausibilityModels.class);
            if (model == null) {
                model = fm instanceof FaultModels ? RupturePlausibilityModels.UCERF3 : RupturePlausibilityModels.COULOMB;
            }
            if ((rupSet = this.rupSetCache.get(fm, model)) != null) {
                return rupSet;
            }
            try {
                return this.slt.forBranch(branch, false).getRupSet();
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }

        @Override
        public InversionConfiguration buildInversionConfig(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch, int threads) {
            double[] prevRates;
            InversionConfiguration config = super.buildInversionConfig(rupSet, branch, threads);
            try {
                prevRates = this.slt.loadRatesForBranch(branch);
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            if (rupSet.hasModule(RuptureSubSetMappings.class)) {
                RuptureSubSetMappings mappings = rupSet.getModule(RuptureSubSetMappings.class);
                double[] modPrevRates = new double[mappings.getNumRetainedRuptures()];
                for (int r = 0; r < modPrevRates.length; ++r) {
                    modPrevRates[r] = prevRates[mappings.getOrigRupID(r)];
                }
                prevRates = modPrevRates;
            }
            config = InversionConfiguration.builder(config).initialSolution(prevRates).build();
            return config;
        }
    }

    public static class HardcodedPrevAvgWeightsFullSys
    extends HardcodedPrevAvgWeights {
        public HardcodedPrevAvgWeightsFullSys() {
            super(new File("/project/scec_608/kmilner/nshm23/batch_inversions/2022_12_09-nshm23_u3_hybrid_branches-full_sys_inv-FM3_1-CoulombRupSet-DsrUni-TotNuclRate-NoRed-ThreshAvgIterRelGR/results_FM3_1_CoulombRupSet_branch_averaged.zip"));
        }

        @Override
        public boolean isSolveClustersIndividually() {
            return false;
        }
    }

    public static class HardcodedPrevAvgWeights
    extends NSHM23_InvConfigFactory {
        private Map<String, Double> nameWeightMap;

        public HardcodedPrevAvgWeights() {
            this(new File("/project/scec_608/kmilner/nshm23/batch_inversions/2022_06_10-nshm23_u3_hybrid_branches-FM3_1-CoulombRupSet-DsrUni-TotNuclRate-SubB1-Shift2km-ThreshAvgIterRelGR-IncludeThruCreep/results_FM3_1_CoulombRupSet_branch_averaged.zip"));
        }

        public HardcodedPrevAvgWeights(File baFile) {
            try {
                FaultSystemSolution prevBA = FaultSystemSolution.load(baFile);
                InversionMisfitStats avgStats = prevBA.requireModule(InversionMisfitStats.class);
                this.nameWeightMap = new HashMap<String, Double>();
                for (InversionMisfitStats.MisfitStats stats : avgStats.getStats()) {
                    if (stats.range.weightingType != ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY) continue;
                    this.nameWeightMap.put(stats.range.name, stats.range.weight);
                }
            }
            catch (Exception e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }

        @Override
        public InversionConfiguration buildInversionConfig(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch, int threads) {
            InversionConfiguration config = super.buildInversionConfig(rupSet, branch, threads);
            config = InversionConfiguration.builder(config).reweight(null).build();
            for (InversionConstraint constraint : config.getConstraints()) {
                if (constraint.getWeightingType() != ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY) continue;
                Double prevWeight = this.nameWeightMap.get(constraint.getName());
                Preconditions.checkNotNull((Object)prevWeight, (String)"Previous weight not found for constraint %s, branch %s", (Object)constraint.getName(), branch);
                constraint.setWeight(prevWeight);
            }
            return config;
        }
    }

    public static class HardcodedOrigWeightsFullSys
    extends HardcodedOrigWeights {
        @Override
        public boolean isSolveClustersIndividually() {
            return false;
        }
    }

    public static class HardcodedOrigWeights
    extends NSHM23_InvConfigFactory {
        @Override
        public InversionConfiguration buildInversionConfig(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch, int threads) {
            InversionConfiguration config = super.buildInversionConfig(rupSet, branch, threads);
            config = InversionConfiguration.builder(config).reweight(null).build();
            return config;
        }
    }

    public static class HardcodedPrevWeightAdjustFullSys
    extends HardcodedPrevWeightAdjust {
        public HardcodedPrevWeightAdjustFullSys() {
            super(new File("/project/scec_608/kmilner/nshm23/batch_inversions/2022_12_20-nshm23_u3_hybrid_branches-full_sys_inv-FM3_1-CoulombRupSet-DsrUni-TotNuclRate-NoRed-ThreshAvgIterRelGR/results.zip"));
        }

        @Override
        public boolean isSolveClustersIndividually() {
            return false;
        }
    }

    public static class HardcodedPrevWeightAdjust
    extends NSHM23_InvConfigFactory {
        private ZipFile zip;

        public HardcodedPrevWeightAdjust() {
            this(new File("/project/scec_608/kmilner/nshm23/batch_inversions/2022_12_20-nshm23_u3_hybrid_branches-full_sys_inv-FM3_1-CoulombRupSet-DsrUni-TotNuclRate-NoRed-ThreshAvgIterRelGR/results.zip"));
        }

        public HardcodedPrevWeightAdjust(File resultsFile) {
            try {
                this.zip = new ZipFile(resultsFile);
            }
            catch (Exception e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }

        @Override
        public InversionConfiguration buildInversionConfig(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch, int threads) {
            CSVFile<String> csv;
            InversionConfiguration config = super.buildInversionConfig(rupSet, branch, threads);
            config = InversionConfiguration.builder(config).reweight(null).build();
            Object entryName = "solution_logic_tree/";
            for (int i = 0; i < branch.size(); ++i) {
                LogicTreeLevel<?> level = branch.getLevel(i);
                if (!level.affects("inversion_misfit_stats.csv", true)) continue;
                entryName = (String)entryName + branch.getValue(i).getFilePrefix() + "/";
            }
            entryName = (String)entryName + "inversion_misfit_stats.csv";
            System.out.println("Loading " + (String)entryName);
            ZipEntry entry = this.zip.getEntry((String)entryName);
            Preconditions.checkNotNull((Object)entry, (String)"Entry not found: %s", (Object)entryName);
            try {
                csv = CSVFile.readStream(this.zip.getInputStream(entry), true);
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            InversionMisfitStats stats = new InversionMisfitStats(null);
            stats.initFromCSV(csv);
            for (InversionConstraint constraint : config.getConstraints()) {
                if (constraint.getWeightingType() != ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY) continue;
                boolean found = false;
                for (InversionMisfitStats.MisfitStats misfits : stats.getStats()) {
                    if (!misfits.range.name.equals(constraint.getName())) continue;
                    constraint.setWeight(misfits.range.weight);
                    System.out.println(misfits.range.name + " prevWeight=" + misfits.range.weight);
                    found = true;
                }
                Preconditions.checkState((boolean)found, (String)"Previous weight not found for constraint %s, branch %s", (Object)constraint.getName(), branch);
            }
            return config;
        }
    }

    public static class MFDSlipAlongAdjust
    extends NSHM23_InvConfigFactory {
        public MFDSlipAlongAdjust() {
            this.adjustForActualRupSlips(true, true);
        }
    }

    public static class NoIncompatibleDataAdjust
    extends NSHM23_InvConfigFactory {
        public NoIncompatibleDataAdjust() {
            NSHM23_ConstraintBuilder.ADJ_FOR_INCOMPATIBLE_DATA_DEFAULT = false;
        }
    }

    public static class NoMFDScaleAdjust
    extends NSHM23_InvConfigFactory {
        public NoMFDScaleAdjust() {
            this.adjustForActualRupSlips(false, false);
        }
    }

    public static class NoPaleoParkfield
    extends NSHM23_InvConfigFactory {
        @Override
        public InversionConfiguration buildInversionConfig(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch, int threads) {
            InversionConfiguration config = super.buildInversionConfig(rupSet, branch, threads);
            return InversionConfiguration.builder(config).except(PaleoRateInversionConstraint.class, false).except(PaleoSlipInversionConstraint.class, false).except(ParkfieldInversionConstraint.class, false).except(LaplacianSmoothingInversionConstraint.class, false).build();
        }
    }
}

