/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.data;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.Region;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.ComparablePairing;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.IDPairing;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRuptureBuilder;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.JumpProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.Shaw07JumpDistProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ExhaustiveBilateralRuptureGrowingStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.PlausibleClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.ConnectivityCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupSetMapMaker;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_ScalingRelationships;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_SegmentationModels;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;

public class NSHM23_WasatchSegmentationData {
    private static final double MAX_MAP_DIST_1 = 5.0;
    private static final double MAX_MAP_DIST_2 = 10.0;
    private static final String MAP_SECT_NAME_REQUIREMENT = "wasatch";
    public static boolean APPLY_TO_ALL_JUMPS_FROM_LOC = true;
    private static final String DATA_PATH = "/data/erf/nshm23/constraints/segmentation/wasatch/NSHM_WFZ_segbdry_Jun3_2022.csv";

    private static List<WasatchSegLocation> load() throws IOException {
        CSVFile<String> csv = CSVFile.readStream(WasatchSegLocation.class.getResourceAsStream(DATA_PATH), true);
        ArrayList<WasatchSegLocation> ret = new ArrayList<WasatchSegLocation>();
        for (int row = 1; row < csv.getNumRows(); ++row) {
            int id = csv.getInt(row, 0);
            String name = csv.get(row, 1);
            String notes = csv.get(row, 2);
            double lat = csv.getDouble(row, 3);
            double lon = csv.getDouble(row, 4);
            Location loc = new Location(lat, lon);
            ret.add(new WasatchSegLocation(id, name, notes, loc));
        }
        return ret;
    }

    private static boolean isWasatchSection(FaultSection subSect) {
        Preconditions.checkState((subSect.getParentSectionId() >= 0 ? 1 : 0) != 0, (Object)"Must call this with subsections");
        return subSect.getParentSectionName().toLowerCase().contains(MAP_SECT_NAME_REQUIREMENT);
    }

    private static Map<WasatchSegLocation, Set<IDPairing>> mapToParentSects(List<WasatchSegLocation> datas, FaultSystemRupSet rupSet, boolean verbose) {
        List<? extends FaultSection> subSects = rupSet.getFaultSectionDataList();
        ArrayList<FaultSection> wasatchSects = new ArrayList<FaultSection>();
        for (FaultSection faultSection : subSects) {
            if (!NSHM23_WasatchSegmentationData.isWasatchSection(faultSection)) continue;
            wasatchSects.add(faultSection);
        }
        if (verbose) {
            System.out.println("Found " + wasatchSects.size() + " candidate Wasatch sections");
        }
        if (wasatchSects.isEmpty()) {
            return null;
        }
        HashMap<WasatchSegLocation, Set<IDPairing>> ret = new HashMap<WasatchSegLocation, Set<IDPairing>>();
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        ArrayList<FaultTrace> discrTraces = new ArrayList<FaultTrace>();
        for (FaultSection sect : wasatchSects) {
            discrTraces.add(sect.getFaultSurface(1.0).getEvenlyDiscritizedUpperEdge());
            hashMap.put(sect.getParentSectionId(), sect.getParentSectionName());
        }
        ClusterRuptures cRups = null;
        if (APPLY_TO_ALL_JUMPS_FROM_LOC) {
            cRups = rupSet.requireModule(ClusterRuptures.class);
        }
        if (verbose) {
            System.out.println("Mapping " + datas.size() + " Wasatch segmentation locations");
        }
        for (WasatchSegLocation data : datas) {
            if (verbose) {
                System.out.println("Mapping " + data.id + ". " + data.name);
            }
            HashMap<Integer, Double> parentDists = new HashMap<Integer, Double>();
            HashMap<Integer, Integer> parentClosestSects = new HashMap<Integer, Integer>();
            for (int i = 0; i < wasatchSects.size(); ++i) {
                boolean closest;
                FaultSection subSect = (FaultSection)wasatchSects.get(i);
                LocationList trace = (LocationList)discrTraces.get(i);
                double minDist = Double.POSITIVE_INFINITY;
                for (Location loc : trace) {
                    minDist = Math.min(minDist, LocationUtils.horzDistanceFast(loc, data.loc));
                }
                if ((float)minDist > 5.0f && (float)minDist > 10.0f) continue;
                Integer parentID = subSect.getParentSectionId();
                boolean bl = closest = !parentDists.containsKey(parentID) || minDist < (Double)parentDists.get(parentID);
                if (!closest) continue;
                parentDists.put(parentID, minDist);
                parentClosestSects.put(parentID, subSect.getSectionId());
            }
            if (verbose) {
                System.out.println("\tFound " + parentDists.size() + " candidate sections");
            }
            if (parentDists.size() < 2) continue;
            List sortedParentIDs = ComparablePairing.getSortedData(parentDists);
            int parentID1 = (Integer)sortedParentIDs.get(0);
            int sectID1 = (Integer)parentClosestSects.get(parentID1);
            double dist1 = (Double)parentDists.get(parentID1);
            String name1 = (String)hashMap.get(parentID1);
            int parentID2 = (Integer)sortedParentIDs.get(1);
            int sectID2 = (Integer)parentClosestSects.get(parentID2);
            double dist2 = (Double)parentDists.get(parentID2);
            String name2 = (String)hashMap.get(parentID2);
            if (dist1 < 5.0 && dist2 < 10.0) {
                if (verbose) {
                    System.out.println("\tMatch found between: " + parentID1 + ". " + name1 + " (" + (float)dist1 + " km) and " + parentID2 + ". " + name2 + " (" + (float)dist2 + " km)");
                }
                HashSet<IDPairing> pairings = new HashSet<IDPairing>();
                NSHM23_WasatchSegmentationData.addBetween(pairings, parentID1, parentID2);
                if (APPLY_TO_ALL_JUMPS_FROM_LOC) {
                    for (int segID : new int[]{sectID1, sectID2}) {
                        FaultSection sect = rupSet.getFaultSectionData(segID);
                        Iterator<Comparable<Integer>> iterator = rupSet.getRupturesForSection(segID).iterator();
                        while (iterator.hasNext()) {
                            int rupIndex = iterator.next();
                            ClusterRupture cRup = cRups.get(rupIndex);
                            RuptureTreeNavigator nav = cRup.getTreeNavigator();
                            FaultSection predecessor = nav.getPredecessor(sect);
                            if (predecessor != null && predecessor.getParentSectionId() != sect.getParentSectionId()) {
                                boolean isNew = NSHM23_WasatchSegmentationData.addBetween(pairings, sect.getParentSectionId(), predecessor.getParentSectionId());
                                if (verbose && isNew) {
                                    System.out.println("Also applying between " + sect.getParentSectionName() + " and " + predecessor.getParentSectionName());
                                }
                            }
                            for (FaultSection descendant : nav.getDescendants(sect)) {
                                if (descendant.getParentSectionId() == sect.getParentSectionId()) continue;
                                boolean isNew = NSHM23_WasatchSegmentationData.addBetween(pairings, sect.getParentSectionId(), descendant.getParentSectionId());
                                if (!verbose || !isNew) continue;
                                System.out.println("Also applying between " + sect.getParentSectionName() + " and " + descendant.getParentSectionName());
                            }
                        }
                    }
                    Object object = rupSet.getRupturesForParentSection(parentID1).iterator();
                    while (object.hasNext()) {
                        RuptureTreeNavigator nav;
                        int rupIndex = (Integer)object.next();
                        ClusterRupture cRup = cRups.get(rupIndex);
                        FaultSubsectionCluster cluster1 = null;
                        FaultSubsectionCluster cluster2 = null;
                        for (FaultSubsectionCluster cluster : cRup.getClustersIterable()) {
                            if (cluster.parentSectionID == parentID1) {
                                cluster1 = cluster;
                            }
                            if (cluster.parentSectionID != parentID2) continue;
                            cluster2 = cluster;
                        }
                        Preconditions.checkNotNull(cluster1);
                        if (cluster2 == null || (nav = cRup.getTreeNavigator()).hasJump(cluster1, cluster2)) continue;
                        List<FaultSubsectionCluster> linkingPath = NSHM23_WasatchSegmentationData.getPathLinking(cluster1, cluster2, nav);
                        Preconditions.checkState((linkingPath.size() >= 3 ? 1 : 0) != 0);
                        FaultSubsectionCluster link1 = linkingPath.get(1);
                        FaultSubsectionCluster link2 = linkingPath.get(linkingPath.size() - 2);
                        if (pairings.contains(new IDPairing(cluster1.parentSectionID, link1.parentSectionID)) || pairings.contains(new IDPairing(cluster1.parentSectionID, link2.parentSectionID))) continue;
                        boolean newBlock = false;
                        if (link1 == link2) {
                            if (NSHM23_WasatchSegmentationData.addBetween(pairings, cluster1.parentSectionID, link1.parentSectionID)) {
                                newBlock = true;
                            }
                            if (NSHM23_WasatchSegmentationData.addBetween(pairings, cluster2.parentSectionID, link1.parentSectionID)) {
                                newBlock = true;
                            }
                        } else {
                            double link1Dist = Double.POSITIVE_INFINITY;
                            for (FaultSection sect : link1.subSects) {
                                for (Location loc : sect.getFaultTrace()) {
                                    link1Dist = Math.min(link1Dist, LocationUtils.horzDistanceFast(loc, data.loc));
                                }
                            }
                            double link2Dist = Double.POSITIVE_INFINITY;
                            for (FaultSection sect : link2.subSects) {
                                for (Location loc : sect.getFaultTrace()) {
                                    link2Dist = Math.min(link2Dist, LocationUtils.horzDistanceFast(loc, data.loc));
                                }
                            }
                            if (link1Dist < link2Dist) {
                                if (NSHM23_WasatchSegmentationData.addBetween(pairings, cluster1.parentSectionID, link1.parentSectionID)) {
                                    newBlock = true;
                                }
                            } else if (NSHM23_WasatchSegmentationData.addBetween(pairings, cluster2.parentSectionID, link2.parentSectionID)) {
                                newBlock = true;
                            }
                        }
                        if (!verbose || !newBlock) continue;
                        Object linkStr = null;
                        for (FaultSubsectionCluster cluster : linkingPath) {
                            linkStr = linkStr == null ? "" : (String)linkStr + " -> ";
                            linkStr = (String)linkStr + cluster.parentSectionName;
                        }
                        System.out.println("Also applying to indirect connection: " + linkStr);
                    }
                }
                ret.put(data, pairings);
                continue;
            }
            if (!verbose || !verbose) continue;
            System.out.println("\tNo match found. Closest 2 were: " + parentID1 + ". " + name1 + " (" + (float)dist1 + " km) and " + parentID2 + ". " + name2 + " (" + (float)dist2 + " km)");
        }
        return ret;
    }

    private static boolean addBetween(HashSet<IDPairing> pairings, int parent1, int parent2) {
        IDPairing test12 = new IDPairing(parent1, parent2);
        IDPairing test21 = new IDPairing(parent2, parent1);
        if (pairings.contains(test12) || pairings.contains(test21)) {
            return false;
        }
        pairings.add(test12);
        pairings.add(test21);
        return true;
    }

    private static List<FaultSubsectionCluster> getPathLinking(FaultSubsectionCluster cluster1, FaultSubsectionCluster cluster2, RuptureTreeNavigator nav) {
        List<FaultSubsectionCluster> curPath = List.of(cluster1);
        List<FaultSubsectionCluster> linkingPath = NSHM23_WasatchSegmentationData.linkingPathSearch(curPath, cluster2, nav, true);
        if (linkingPath == null) {
            linkingPath = NSHM23_WasatchSegmentationData.linkingPathSearch(curPath, cluster2, nav, false);
        }
        Preconditions.checkNotNull(linkingPath, (String)"No path found linking %s with %s", (Object)cluster1, (Object)cluster2);
        Preconditions.checkState((linkingPath.get(0) == cluster1 ? 1 : 0) != 0);
        Preconditions.checkState((linkingPath.get(linkingPath.size() - 1) == cluster2 ? 1 : 0) != 0);
        return linkingPath;
    }

    private static List<FaultSubsectionCluster> linkingPathSearch(List<FaultSubsectionCluster> curPath, FaultSubsectionCluster dest, RuptureTreeNavigator nav, boolean direction) {
        Preconditions.checkState((!curPath.isEmpty() ? 1 : 0) != 0);
        FaultSubsectionCluster curLast = curPath.get(curPath.size() - 1);
        if (curLast == dest) {
            return curPath;
        }
        if (direction) {
            Collection<FaultSubsectionCluster> descendants = nav.getDescendants(curLast);
            if (descendants.isEmpty()) {
                return null;
            }
            for (FaultSubsectionCluster descendant : descendants) {
                ArrayList<FaultSubsectionCluster> newPath = new ArrayList<FaultSubsectionCluster>(curPath.size() + 1);
                newPath.addAll(curPath);
                newPath.add(descendant);
                List<FaultSubsectionCluster> finalPath = NSHM23_WasatchSegmentationData.linkingPathSearch(newPath, dest, nav, direction);
                if (finalPath == null) continue;
                return finalPath;
            }
            return null;
        }
        FaultSubsectionCluster predecessor = nav.getPredecessor(curLast);
        if (predecessor == null) {
            return null;
        }
        ArrayList<FaultSubsectionCluster> newPath = new ArrayList<FaultSubsectionCluster>(curPath.size() + 1);
        newPath.addAll(curPath);
        newPath.add(predecessor);
        return NSHM23_WasatchSegmentationData.linkingPathSearch(newPath, dest, nav, direction);
    }

    private static Set<IDPairing> allPairings(Map<WasatchSegLocation, Set<IDPairing>> mappings) {
        HashSet<IDPairing> pairings = new HashSet<IDPairing>();
        for (Set<IDPairing> subPairings : mappings.values()) {
            pairings.addAll(subPairings);
        }
        return pairings;
    }

    public static JumpProbabilityCalc.HardcodedJumpProb build(FaultSystemRupSet rupSet, double passthroughRate) {
        return NSHM23_WasatchSegmentationData.build(rupSet, passthroughRate, null);
    }

    public static JumpProbabilityCalc.HardcodedJumpProb build(FaultSystemRupSet rupSet, double passthroughRate, JumpProbabilityCalc fallback) {
        List<WasatchSegLocation> datas;
        try {
            datas = NSHM23_WasatchSegmentationData.load();
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
        Map<WasatchSegLocation, Set<IDPairing>> mappings = NSHM23_WasatchSegmentationData.mapToParentSects(datas, rupSet, false);
        if (mappings == null) {
            return null;
        }
        HashMap<IDPairing, Double> idsToProbs = new HashMap<IDPairing, Double>();
        for (IDPairing pair : NSHM23_WasatchSegmentationData.allPairings(mappings)) {
            idsToProbs.put(pair, passthroughRate);
        }
        String name = "Wasatch, P=" + (float)passthroughRate;
        if (fallback != null) {
            name = name + ", " + fallback.getName();
        }
        return new JumpProbabilityCalc.HardcodedJumpProb(name, idsToProbs, true, fallback);
    }

    public static JumpProbabilityCalc.BinaryJumpProbabilityCalc buildFullExclusion(FaultSystemRupSet rupSet, JumpProbabilityCalc.BinaryJumpProbabilityCalc fallback) {
        List<WasatchSegLocation> datas;
        try {
            datas = NSHM23_WasatchSegmentationData.load();
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
        Map<WasatchSegLocation, Set<IDPairing>> mappings = NSHM23_WasatchSegmentationData.mapToParentSects(datas, rupSet, false);
        if (mappings == null || mappings.isEmpty()) {
            return null;
        }
        Set<IDPairing> pairings = NSHM23_WasatchSegmentationData.allPairings(mappings);
        Object name = "Wastach Exclude";
        if (fallback != null) {
            name = (String)name + ", " + fallback.getName();
        }
        return new JumpProbabilityCalc.HardcodedBinaryJumpProb((String)name, true, pairings, true);
    }

    private static void printSegPaths(FaultSystemRupSet rupSet, List<JumpProbabilityCalc> segModels, int fromSectID, int toSectID) {
        ClusterRuptures cRups = rupSet.requireModule(ClusterRuptures.class);
        FaultSection sect1 = rupSet.getFaultSectionData(fromSectID);
        FaultSection sect2 = rupSet.getFaultSectionData(toSectID);
        HashSet<Integer> rupIndexes1 = new HashSet<Integer>(rupSet.getRupturesForSection(fromSectID));
        HashSet<Integer> rupIndexes2 = new HashSet<Integer>(rupSet.getRupturesForSection(toSectID));
        HashSet<Integer> bothRupIndexes = new HashSet<Integer>();
        for (int id1 : rupIndexes1) {
            if (!rupIndexes2.contains(id1)) continue;
            bothRupIndexes.add(id1);
        }
        HashMap<Object, ArrayList<ClusterRupture>> uniquePaths = new HashMap<Object, ArrayList<ClusterRupture>>();
        Iterator<Object> iterator = bothRupIndexes.iterator();
        while (iterator.hasNext()) {
            int rupIndex = (Integer)iterator.next();
            ClusterRupture rup = cRups.get(rupIndex);
            RuptureTreeNavigator nav = rup.getTreeNavigator();
            FaultSubsectionCluster cluster1 = nav.locateCluster(sect1);
            FaultSubsectionCluster cluster2 = nav.locateCluster(sect2);
            List<FaultSubsectionCluster> path = NSHM23_WasatchSegmentationData.getPathLinking(cluster1, cluster2, nav);
            Object pathStr = null;
            for (FaultSubsectionCluster cluster : path) {
                pathStr = pathStr == null ? "" : (String)pathStr + " -> ";
                pathStr = (String)pathStr + cluster.parentSectionName;
            }
            ArrayList<ClusterRupture> pathRups = (ArrayList<ClusterRupture>)uniquePaths.get(pathStr);
            if (pathRups == null) {
                pathRups = new ArrayList<ClusterRupture>();
                uniquePaths.put(pathStr, pathRups);
            }
            pathRups.add(rup);
        }
        System.out.println("Found " + uniquePaths.size() + " unique paths");
        for (String path : uniquePaths.keySet()) {
            List rups = (List)uniquePaths.get(path);
            System.out.println(path + "\t(" + rups.size() + " ruptures)");
            for (JumpProbabilityCalc segModel : segModels) {
                double maxRupProb = 0.0;
                double maxWorstJumpProb = 0.0;
                for (ClusterRupture rup : rups) {
                    maxRupProb = Math.max(maxRupProb, segModel.calcRuptureProb(rup, false));
                    double worstJumpProb = 1.0;
                    for (Jump jump : rup.getJumpsIterable()) {
                        worstJumpProb = Math.min(worstJumpProb, segModel.calcJumpProbability(rup, jump, false));
                    }
                    maxWorstJumpProb = Math.max(maxWorstJumpProb, worstJumpProb);
                }
                System.out.println("\t" + segModel.getName() + ":\trup=" + (float)maxRupProb + "\tjump=" + (float)maxWorstJumpProb);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        List<WasatchSegLocation> datas = NSHM23_WasatchSegmentationData.load();
        DataUtils.MinMaxAveTracker latTrack = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker lonTrack = new DataUtils.MinMaxAveTracker();
        ArrayList<Location> locs = new ArrayList<Location>();
        for (WasatchSegLocation data : datas) {
            latTrack.addValue(data.loc.getLatitude());
            lonTrack.addValue(data.loc.getLongitude());
            locs.add(data.loc);
        }
        Region region = new Region(new Location(latTrack.getMin() - 4.0, lonTrack.getMin() - 4.0), new Location(latTrack.getMax() + 4.0, lonTrack.getMax() + 4.0));
        FaultSystemRupSet rupSet = FaultSystemRupSet.load(new File("/home/kevin/OpenSHA/UCERF4/batch_inversions/2022_09_28-nshm23_branches-NSHM23_v2-CoulombRupSet-TotNuclRate-NoRed-ThreshAvgIterRelGR/results_NSHM23_v2_CoulombRupSet_branch_averaged_gridded.zip"));
        final List<? extends FaultSection> subSects = rupSet.getFaultSectionDataList();
        Map<WasatchSegLocation, Set<IDPairing>> mappings = NSHM23_WasatchSegmentationData.mapToParentSects(datas, rupSet, true);
        SectionDistanceAzimuthCalculator distAzCalc = new SectionDistanceAzimuthCalculator(subSects);
        ArrayList<PlausibilityFilter> filters = new ArrayList<PlausibilityFilter>();
        filters.add(new PlausibilityFilter(){

            @Override
            public String getName() {
                return "Wasatch Only";
            }

            @Override
            public String getShortName() {
                return this.getName();
            }

            @Override
            public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
                for (FaultSubsectionCluster cluster : rupture.getClustersIterable()) {
                    for (FaultSection sect : cluster.subSects) {
                        if (NSHM23_WasatchSegmentationData.isWasatchSection(sect)) continue;
                        return PlausibilityResult.FAIL_HARD_STOP;
                    }
                }
                return PlausibilityResult.PASS;
            }
        });
        final JumpProbabilityCalc.BinaryJumpProbabilityCalc fullExclusion = NSHM23_WasatchSegmentationData.buildFullExclusion(rupSet, null);
        filters.add(new PlausibilityFilter(){

            @Override
            public String getName() {
                return "Wasatch Seg";
            }

            @Override
            public String getShortName() {
                return this.getName();
            }

            @Override
            public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
                if (fullExclusion.isRupAllowed(rupture, verbose)) {
                    return PlausibilityResult.PASS;
                }
                return PlausibilityResult.FAIL_HARD_STOP;
            }
        });
        PlausibleClusterConnectionStrategy connStrat = new PlausibleClusterConnectionStrategy(subSects, distAzCalc, 5.0, PlausibleClusterConnectionStrategy.JUMP_SELECTOR_DEFAULT, List.of((PlausibilityFilter)filters.get(0)));
        int threads = FaultSysTools.defaultNumThreads();
        System.out.println("Caching connections");
        connStrat.checkBuildThreaded(threads);
        PlausibilityConfiguration plausConfig = new PlausibilityConfiguration(filters, 0, connStrat, distAzCalc);
        System.out.println("Building ruptures");
        ClusterRuptureBuilder builder = new ClusterRuptureBuilder(plausConfig);
        List<ClusterRupture> rups = builder.build(new ExhaustiveBilateralRuptureGrowingStrategy(ExhaustiveBilateralRuptureGrowingStrategy.SecondaryVariations.ALL, false), threads);
        HashMap<FaultSection, ClusterRupture> rupLargestSect = new HashMap<FaultSection, ClusterRupture>();
        for (ClusterRupture clusterRupture : rups) {
            for (FaultSubsectionCluster cluster : clusterRupture.getClustersIterable()) {
                for (FaultSection sect : cluster.subSects) {
                    ClusterRupture largest = (ClusterRupture)rupLargestSect.get(sect);
                    if (largest != null && largest.getTotalNumSects() >= clusterRupture.getTotalNumSects()) continue;
                    rupLargestSect.put(sect, clusterRupture);
                }
            }
        }
        ArrayList largestRups = new ArrayList(new HashSet(rupLargestSect.values()));
        largestRups.sort(new Comparator<ClusterRupture>(){

            @Override
            public int compare(ClusterRupture rup1, ClusterRupture rup2) {
                return Double.compare(this.aveLat(rup1), this.aveLat(rup2));
            }

            private double aveLat(ClusterRupture rup) {
                double avg = 0.0;
                int num = 0;
                for (FaultSubsectionCluster cluster : rup.clusters) {
                    for (FaultSection sect : cluster.subSects) {
                        ++num;
                        avg += 0.5 * (sect.getFaultTrace().first().getLatitude() + sect.getFaultTrace().last().getLatitude());
                    }
                }
                return avg / (double)num;
            }
        });
        for (ClusterRupture rup : largestRups) {
            System.out.println(rup);
        }
        List<ConnectivityCluster> list = ConnectivityCluster.build(ClusterRuptureBuilder.buildClusterRupSet(NSHM23_ScalingRelationships.AVERAGE, subSects, plausConfig, rups));
        System.out.println("Found " + list.size() + " clusters");
        list.sort(new Comparator<ConnectivityCluster>(){

            @Override
            public int compare(ConnectivityCluster arg0, ConnectivityCluster arg1) {
                return Double.compare(this.aveLat(arg0), this.aveLat(arg1));
            }

            private double aveLat(ConnectivityCluster cluster) {
                double avg = 0.0;
                int num = 0;
                for (int s : cluster.getSectIDs()) {
                    FaultSection sect = (FaultSection)subSects.get(s);
                    ++num;
                    avg += 0.5 * (sect.getFaultTrace().first().getLatitude() + sect.getFaultTrace().last().getLatitude());
                }
                return avg / (double)num;
            }
        });
        System.out.println("Found " + largestRups.size() + " largest segmented rups");
        RupSetMapMaker mapMaker = new RupSetMapMaker(subSects, region);
        mapMaker.setWriteGeoJSON(true);
        mapMaker.plotScatters(locs, Color.GRAY);
        ArrayList<Color> sectColors = new ArrayList<Color>();
        for (int s = 0; s < subSects.size(); ++s) {
            sectColors.add(Color.LIGHT_GRAY);
        }
        mapMaker.plotSectColors(sectColors);
        int maxColors = 5;
        CPT cpt = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(0.0, Double.min(maxColors, list.size() - 1));
        for (int i = 0; i < list.size(); ++i) {
            int colorIndex = i % maxColors;
            Color color = cpt.getColor(colorIndex);
            for (int sectID : list.get(i).getSectIDs()) {
                sectColors.set(sectID, color);
            }
        }
        HashSet<Integer> wasatchRupIndexes = new HashSet<Integer>();
        HashSet<Integer> wasatchSectIndexes = new HashSet<Integer>();
        for (FaultSection sect : subSects) {
            if (!NSHM23_WasatchSegmentationData.isWasatchSection(sect)) continue;
            wasatchSectIndexes.add(sect.getSectionId());
            wasatchRupIndexes.addAll(rupSet.getRupturesForSection(sect.getSectionId()));
        }
        ClusterRuptures cRups = rupSet.requireModule(ClusterRuptures.class);
        HashSet<Jump> allowedJumps = new HashSet<Jump>();
        HashSet<Jump> disallowedJumps = new HashSet<Jump>();
        HashSet<Jump> otherJumps = new HashSet<Jump>();
        Set<IDPairing> allMappings = NSHM23_WasatchSegmentationData.allPairings(mappings);
        Iterator iterator = wasatchRupIndexes.iterator();
        while (iterator.hasNext()) {
            int rupIndex = (Integer)iterator.next();
            ClusterRupture cRup = cRups.get(rupIndex);
            for (Jump jump : cRup.getJumpsIterable()) {
                if (wasatchSectIndexes.contains(jump.fromSection.getSectionId()) || wasatchSectIndexes.contains(jump.toSection.getSectionId())) {
                    boolean disallowed;
                    IDPairing parents = new IDPairing(jump.fromCluster.parentSectionID, jump.toCluster.parentSectionID);
                    boolean bl = disallowed = allMappings.contains(parents) || allMappings.contains(parents.getReversed());
                    if (disallowed) {
                        disallowedJumps.add(jump);
                        continue;
                    }
                    allowedJumps.add(jump);
                    continue;
                }
                otherJumps.add(jump);
            }
        }
        for (int s = 0; s < subSects.size(); ++s) {
            if (sectColors.get(s) != null || !NSHM23_WasatchSegmentationData.isWasatchSection(subSects.get(s))) continue;
            System.err.println("WARNING: missed subsection: " + subSects.get(s).getName());
            sectColors.set(s, Color.BLACK);
        }
        mapMaker.plot(new File("/tmp"), "wasatch_seg_data", "Wasatch Segmentation Locations");
        mapMaker.plotJumps(NSHM23_WasatchSegmentationData.removeDuplicates(disallowedJumps), NSHM23_WasatchSegmentationData.alpha(Color.RED.darker(), 127), "Affected Jumps");
        mapMaker.plotJumps(NSHM23_WasatchSegmentationData.removeDuplicates(allowedJumps), NSHM23_WasatchSegmentationData.alpha(Color.GREEN.darker(), 127), "Unaffected Jumps");
        mapMaker.plotJumps(NSHM23_WasatchSegmentationData.removeDuplicates(otherJumps), NSHM23_WasatchSegmentationData.alpha(Color.GRAY, 127), "Other Jumps");
        mapMaker.plot(new File("/tmp"), "wasatch_seg_data_with_jumps", "Wasatch Segmentation Locations");
        ArrayList<JumpProbabilityCalc> segModels = new ArrayList<JumpProbabilityCalc>();
        ArrayList<Shaw07JumpDistProb> distModels = new ArrayList<Shaw07JumpDistProb>();
        for (final NSHM23_SegmentationModels segModel : NSHM23_SegmentationModels.values()) {
            if (segModel.getNodeWeight(null) == 0.0 && segModel != NSHM23_SegmentationModels.AVERAGE) continue;
            final JumpProbabilityCalc model = segModel.getModel(rupSet, null);
            JumpProbabilityCalc namedModel = new JumpProbabilityCalc(){

                @Override
                public String getName() {
                    return segModel.getShortName();
                }

                @Override
                public boolean isDirectional(boolean splayed) {
                    return model == null ? false : model.isDirectional(splayed);
                }

                @Override
                public double calcJumpProbability(ClusterRupture fullRupture, Jump jump, boolean verbose) {
                    if (model == null) {
                        return 1.0;
                    }
                    return model.calcJumpProbability(fullRupture, jump, verbose);
                }
            };
            segModels.add(namedModel);
            if (!(segModel.getShawR0() > 0.0)) continue;
            double shawR0 = segModel.getShawR0();
            double shawShift = segModel.getShawShift();
            Shaw07JumpDistProb shawModel = shawShift > 0.0 ? Shaw07JumpDistProb.forHorzOffset(1.0, shawR0, shawShift) : new Shaw07JumpDistProb(1.0, shawR0);
            boolean duplicate = false;
            for (JumpProbabilityCalc o : distModels) {
                if (!o.getName().equals(shawModel.getName())) continue;
                duplicate = true;
            }
            if (duplicate) continue;
            distModels.add(shawModel);
        }
        segModels.addAll(distModels);
        NSHM23_WasatchSegmentationData.printSegPaths(rupSet, segModels, 5295, 5316);
    }

    private static Color alpha(Color c, int alpha) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    private static HashSet<Jump> removeDuplicates(HashSet<Jump> jumps) {
        HashSet<Jump> ret = new HashSet<Jump>();
        for (Jump jump : jumps) {
            if (ret.contains(jump) || ret.contains(jump.reverse())) continue;
            ret.add(jump);
        }
        return ret;
    }

    private static class WasatchSegLocation {
        private final int id;
        private final String name;
        private final String notes;
        private final Location loc;

        public WasatchSegLocation(int id, String name, String notes, Location loc) {
            this.id = id;
            this.name = name;
            this.notes = notes;
            this.loc = loc;
        }
    }
}

