/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.erf;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.erf.BaseFaultSystemSolutionERF;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.util.NSHM23_Downloader;

public class NSHM23_WUS_BranchAveragedERF
extends BaseFaultSystemSolutionERF {
    private static final long serialVersionUID = 277613161331416141L;
    private static final String MODEL = "WUS_branch_averaged_gridded_simplified";
    public static final String NAME = "NSHM23-WUS (crustal only, excl. Cascadia) Branch Avg ERF";
    private static final boolean D = false;
    private NSHM23_Downloader downloader;

    public NSHM23_WUS_BranchAveragedERF() {
        this(null);
    }

    public NSHM23_WUS_BranchAveragedERF(File storeDir) {
        this.downloader = storeDir == null ? new NSHM23_Downloader() : new NSHM23_Downloader(storeDir);
        this.setName(NAME);
    }

    @Override
    protected void createParamList() {
        super.createParamList();
        if (this.adjustableParams.containsParameter("Solution Input File")) {
            this.adjustableParams.removeParameter(this.fileParam);
        }
    }

    private void fetchSolution() {
        ((CompletableFuture)this.downloader.updateFile(MODEL).thenAccept(solFile -> {
            try {
                if (solFile == null || !solFile.exists()) {
                    JOptionPane.showMessageDialog(null, "Failed to download WUS_branch_averaged_gridded_simplified. Verify internet connection and restart. Server may be down.", "NSHM23_WUS_BranchAveragedERF", 0);
                } else {
                    FaultSystemSolution sol = FaultSystemSolution.load(solFile);
                    this.setSolution(sol);
                }
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException((Throwable)e);
            }
        })).join();
    }

    @Override
    public void updateForecast() {
        if (this.getSolution() == null) {
            this.fetchSolution();
        }
        super.updateForecast();
    }

    public static void main(String[] args) {
        new NSHM23_WUS_BranchAveragedERF().updateForecast();
    }
}

