/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.gridded;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.geo.CubedGriddedRegion;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.FaultCubeAssociations;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.MFDGridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportPageGen;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.NucleationRatePlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.SolMFDPlot;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.NSHM23_InvConfigFactory;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.gridded.NSHM23_AbstractGridSourceProvider;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.gridded.NSHM23_SingleRegionGridSourceProvider;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_LogicTreeBranch;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_SeisSmoothingAlgorithms;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.util.TectonicRegionType;

public class NSHM23_CombinedRegionGridSourceProvider
extends NSHM23_AbstractGridSourceProvider {
    private GriddedRegion gridReg;
    private List<? extends GridSourceProvider> regionalProviders;
    private FaultCubeAssociations combinedFaultCubeAssociations;
    private MFDGridSourceProvider[] nodeGridProvs;
    private int[] nodeGridIndexes;

    public NSHM23_CombinedRegionGridSourceProvider(FaultSystemSolution sol, GriddedRegion gridReg, List<NSHM23_SingleRegionGridSourceProvider> regionalProviders) {
        this(sol, NSHM23_CombinedRegionGridSourceProvider.buildCombinedFaultCubeAssociations(sol.getRupSet(), gridReg, regionalProviders), regionalProviders);
    }

    private static FaultCubeAssociations buildCombinedFaultCubeAssociations(FaultSystemRupSet rupSet, GriddedRegion gridReg, List<NSHM23_SingleRegionGridSourceProvider> regionalProviders) {
        ArrayList<FaultCubeAssociations> regionalAssociations = new ArrayList<FaultCubeAssociations>();
        for (NSHM23_SingleRegionGridSourceProvider prov : regionalProviders) {
            regionalAssociations.add(prov.getFaultCubeassociations());
        }
        return FaultCubeAssociations.stitch(new CubedGriddedRegion(gridReg), regionalAssociations);
    }

    public NSHM23_CombinedRegionGridSourceProvider(FaultSystemSolution sol, FaultCubeAssociations combinedFaultCubeAssociations, List<? extends MFDGridSourceProvider> regionalProviders) {
        this.combinedFaultCubeAssociations = combinedFaultCubeAssociations;
        this.gridReg = combinedFaultCubeAssociations.getRegion();
        this.regionalProviders = regionalProviders;
        this.nodeGridProvs = new MFDGridSourceProvider[this.gridReg.getNodeCount()];
        this.nodeGridIndexes = new int[this.nodeGridProvs.length];
        int numMapped = 0;
        for (int gridIndex = 0; gridIndex < this.nodeGridProvs.length; ++gridIndex) {
            Location loc = this.gridReg.locationForIndex(gridIndex);
            MFDGridSourceProvider match = null;
            int matchIndex = -1;
            for (MFDGridSourceProvider mFDGridSourceProvider : regionalProviders) {
                int myIndex = mFDGridSourceProvider.getGriddedRegion().indexForLocation(loc);
                if (myIndex < 0) continue;
                Preconditions.checkState((match == null ? 1 : 0) != 0, (Object)"TODO: don't yet support grid locations that map to multiple sub-regions");
                match = mFDGridSourceProvider;
                matchIndex = myIndex;
            }
            if (match != null) {
                ++numMapped;
                this.nodeGridProvs[gridIndex] = match;
                this.nodeGridIndexes[gridIndex] = matchIndex;
                continue;
            }
            this.nodeGridIndexes[gridIndex] = -1;
        }
        System.out.println("Mapped " + numMapped + "/" + this.nodeGridIndexes.length + " model region grid locations to sub-region grid locations");
    }

    public List<? extends GridSourceProvider> getRegionalProviders() {
        return ImmutableList.copyOf(this.regionalProviders);
    }

    @Override
    public FaultCubeAssociations getFaultCubeassociations() {
        return this.combinedFaultCubeAssociations;
    }

    @Override
    public IncrementalMagFreqDist getMFD_Unassociated(int gridIndex) {
        if (this.nodeGridProvs[gridIndex] != null) {
            return this.nodeGridProvs[gridIndex].getMFD_Unassociated(this.nodeGridIndexes[gridIndex]);
        }
        return null;
    }

    @Override
    public IncrementalMagFreqDist getMFD_SubSeisOnFault(int gridIndex) {
        if (this.nodeGridProvs[gridIndex] != null) {
            return this.nodeGridProvs[gridIndex].getMFD_SubSeisOnFault(this.nodeGridIndexes[gridIndex]);
        }
        return null;
    }

    @Override
    public GriddedRegion getGriddedRegion() {
        return this.gridReg;
    }

    @Override
    public double getFracStrikeSlip(int gridIndex) {
        if (this.nodeGridProvs[gridIndex] != null) {
            return this.nodeGridProvs[gridIndex].getFracStrikeSlip(this.nodeGridIndexes[gridIndex]);
        }
        return 0.0;
    }

    @Override
    public double getFracReverse(int gridIndex) {
        if (this.nodeGridProvs[gridIndex] != null) {
            return this.nodeGridProvs[gridIndex].getFracReverse(this.nodeGridIndexes[gridIndex]);
        }
        return 0.0;
    }

    @Override
    public double getFracNormal(int gridIndex) {
        if (this.nodeGridProvs[gridIndex] != null) {
            return this.nodeGridProvs[gridIndex].getFracNormal(this.nodeGridIndexes[gridIndex]);
        }
        return 0.0;
    }

    @Override
    public TectonicRegionType getTectonicRegionType(int gridIndex) {
        if (this.nodeGridProvs[gridIndex] != null) {
            return this.nodeGridProvs[gridIndex].getTectonicRegionType(this.nodeGridIndexes[gridIndex]);
        }
        return TectonicRegionType.ACTIVE_SHALLOW;
    }

    @Override
    public void scaleAll(double[] valuesArray) {
        Preconditions.checkState((valuesArray.length == this.getNumLocations() ? 1 : 0) != 0);
        for (GridSourceProvider gridSourceProvider : this.regionalProviders) {
            GriddedRegion provReg = gridSourceProvider.getGriddedRegion();
            double[] scalars = new double[provReg.getNumLocations()];
            for (int i = 0; i < scalars.length; ++i) {
                scalars[i] = 1.0;
            }
            boolean anyMapped = false;
            for (int gridIndex = 0; gridIndex < valuesArray.length; ++gridIndex) {
                if (valuesArray[gridIndex] == 1.0 || this.nodeGridProvs[gridIndex] != gridSourceProvider) continue;
                anyMapped = true;
                scalars[this.nodeGridIndexes[gridIndex]] = scalars[gridIndex];
            }
            if (!anyMapped) continue;
            gridSourceProvider.scaleAll(scalars);
        }
    }

    public static void main(String[] args) throws IOException {
        FaultSystemSolution sol = FaultSystemSolution.load(new File("/home/kevin/OpenSHA/UCERF4/batch_inversions/2022_08_22-nshm23_branches-NSHM23_v2-CoulombRupSet-TotNuclRate-NoRed-ThreshAvgIterRelGR/results_NSHM23_v2_CoulombRupSet_branch_averaged.zip"));
        LogicTreeBranch<NSHM23_SeisSmoothingAlgorithms> offFaultBranch = NSHM23_LogicTreeBranch.DEFAULT_COMBINED.copy();
        offFaultBranch.setValue(NSHM23_SeisSmoothingAlgorithms.AVERAGE);
        NSHM23_AbstractGridSourceProvider gridProv = NSHM23_InvConfigFactory.buildGridSourceProv(sol, offFaultBranch);
        sol.addModule(gridProv);
        sol.getRupSet().addModule(gridProv.getFaultCubeassociations());
        sol.write(new File("/tmp/ba_with_grid_seis.zip"));
        sol.addModule(gridProv);
        ReportPageGen pageGen = new ReportPageGen(sol.getRupSet(), sol, "Solution", new File("/tmp/report"), List.of(new SolMFDPlot(), new NucleationRatePlot()));
        pageGen.setReplot(true);
        pageGen.generatePage();
    }
}

