/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.gridded;

import com.google.common.base.Preconditions;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.Precision;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.RegionUtils;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;

class NSHM23_FaultPolygonBuilder {
    private static final double TOL = 1.0E-9;

    NSHM23_FaultPolygonBuilder() {
    }

    public static Region buildPoly(FaultSection sect, RuptureSurface surf, boolean aseisReducesArea, double distance) {
        List<LocationList> locLists = RegionUtils.areaToLocLists(NSHM23_FaultPolygonBuilder.buildPolyArea(sect, surf, aseisReducesArea, distance));
        return new Region(locLists.get(0), null);
    }

    public static Area buildPolyArea(FaultSection sect, RuptureSurface surf, boolean aseisReducesArea, double distance) {
        LocationList trace = sect.getFaultTrace();
        boolean needToUseUpper = false;
        if (sect.getAveDip() < 90.0) {
            double upper = aseisReducesArea ? sect.getReducedAveUpperDepth() : sect.getOrigAveUpperDepth();
            for (Location loc : trace) {
                if (loc.getDepth() == upper) continue;
                needToUseUpper = true;
                break;
            }
        }
        if (needToUseUpper) {
            trace = surf.getEvenlyDiscritizedUpperEdge();
        }
        trace = NSHM23_FaultPolygonBuilder.removeDupes(trace);
        double dip = sect.getAveDip();
        double dipDir = sect.getDipDirection();
        double ddw = aseisReducesArea ? sect.getReducedDownDipWidth() : sect.getOrigDownDipWidth();
        double distPlusDip = distance + ddw * Math.cos(dip * Math.PI / 180.0);
        Area downDipArea = NSHM23_FaultPolygonBuilder.buildBufferPoly(trace, dipDir, distPlusDip);
        Area upDipArea = NSHM23_FaultPolygonBuilder.buildBufferPoly(trace, dipDir + 180.0, distance);
        Area area = NSHM23_FaultPolygonBuilder.merge(downDipArea, upDipArea);
        if (!(area = NSHM23_FaultPolygonBuilder.cleanBorder(area)).isSingular()) {
            area = NSHM23_FaultPolygonBuilder.removeNests(area);
        }
        Preconditions.checkState((boolean)area.isSingular(), (String)"Failed to clean area, still singular for section %s. %s", (int)sect.getSectionId(), (Object)sect.getSectionName());
        return area;
    }

    public static Area buildBufferPoly(LocationList trace, double dipDir, double buf) {
        Preconditions.checkArgument((trace.size() > 1 ? 1 : 0) != 0);
        Area buffer = null;
        for (int i = 1; i < trace.size(); ++i) {
            Location a = (Location)trace.get(i - 1);
            Location b = (Location)trace.get(i);
            LocationList points = new LocationList();
            LocationVector v = new LocationVector(dipDir, buf, 0.0);
            points.add(a);
            points.add(LocationUtils.location(a, v));
            points.add(LocationUtils.location(b, v));
            points.add(b);
            v.reverse();
            points.add(LocationUtils.location(b, v));
            points.add(LocationUtils.location(a, v));
            buffer = NSHM23_FaultPolygonBuilder.merge(buffer, new Area(points.toPath()));
        }
        return buffer;
    }

    private static Area merge(Area zone, Area dd) {
        Area area = new Area();
        if (zone != null) {
            area.add(zone);
        }
        if (dd != null) {
            area.add(dd);
        }
        return area.isEmpty() ? null : area;
    }

    private static List<LocationList> removeDupes(List<LocationList> locLists) {
        ArrayList<LocationList> newLocLists = new ArrayList<LocationList>();
        for (LocationList locs : locLists) {
            newLocLists.add(NSHM23_FaultPolygonBuilder.removeDupes(locs));
        }
        return newLocLists;
    }

    private static LocationList removeDupes(LocationList locs) {
        LocationList newLocs = new LocationList();
        for (Location loc : locs) {
            NSHM23_FaultPolygonBuilder.validateLoc(newLocs, loc);
        }
        return newLocs;
    }

    private static void validateLoc(LocationList locs, Location loc) {
        for (Location p : locs) {
            if (!NSHM23_FaultPolygonBuilder.areSimilar(p, loc)) continue;
            return;
        }
        locs.add(loc);
    }

    static Area cleanBorder(Area area) {
        List<LocationList> locLists = RegionUtils.areaToLocLists(area);
        locLists = NSHM23_FaultPolygonBuilder.pruneEmpties(locLists);
        locLists = NSHM23_FaultPolygonBuilder.removeDupes(locLists);
        Area areaOut = new Area();
        for (LocationList areaLocs : locLists) {
            areaOut.add(new Area(areaLocs.toPath()));
        }
        return areaOut;
    }

    private static List<LocationList> pruneEmpties(List<LocationList> locLists) {
        ArrayList<LocationList> newLocLists = new ArrayList<LocationList>();
        for (LocationList locs : locLists) {
            if (NSHM23_FaultPolygonBuilder.isEmptyPoly(locs)) continue;
            newLocLists.add(locs);
        }
        return newLocLists;
    }

    private static boolean isEmptyPoly(LocationList locs) {
        Location start = (Location)locs.get(0);
        for (Location loc : locs) {
            if (NSHM23_FaultPolygonBuilder.areSimilar(start, loc)) continue;
            return false;
        }
        return true;
    }

    private static boolean areSimilar(Location p1, Location p2) {
        if (!Precision.equals((double)p1.getLatitude(), (double)p2.getLatitude(), (double)1.0E-9)) {
            return false;
        }
        if (!Precision.equals((double)p1.getLongitude(), (double)p2.getLongitude(), (double)1.0E-9)) {
            return false;
        }
        return Precision.equals((double)p1.getDepth(), (double)p2.getDepth(), (double)1.0E-9);
    }

    private static Area removeNests(Area area) {
        if (area == null) {
            return null;
        }
        if (area.isSingular()) {
            return area;
        }
        List<LocationList> locLists = RegionUtils.areaToLocLists(area);
        Preconditions.checkArgument((locLists.size() > 1 ? 1 : 0) != 0);
        Area a = new Area();
        for (LocationList locs : locLists) {
            Area toAdd = new Area(locs.toPath());
            a.add(toAdd);
        }
        a = NSHM23_FaultPolygonBuilder.cleanBorder(a);
        return a;
    }
}

