/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree;

import java.text.DecimalFormat;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;

@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="fault_sections.geojson"), @DoesNotAffect(value="indices.csv"), @DoesNotAffect(value="properties.csv")})
@Affects(value="rates.csv")
public enum DistDependSegShift implements LogicTreeNode
{
    NONE(0.0, 1.0),
    ONE_KM(1.0, 1.0),
    TWO_KM(2.0, 1.0),
    THREE_KM(3.0, 1.0);

    private double shiftKM;
    private double weight;
    private static final DecimalFormat oDF;

    private DistDependSegShift(double shiftKM, double weight) {
        this.shiftKM = shiftKM;
        this.weight = weight;
    }

    @Override
    public String getShortName() {
        return this.getName().replaceAll(" ", "");
    }

    @Override
    public String getName() {
        if (this.shiftKM != 0.0) {
            return "Shift " + oDF.format(this.shiftKM) + "km";
        }
        return "No Shift";
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return this.getShortName().replace(".", "p");
    }

    public double getShiftKM() {
        return this.shiftKM;
    }

    static {
        oDF = new DecimalFormat("0.##");
    }
}

