/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.MaxJumpDistModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_DeclusteringAlgorithms;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_DeformationModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_FaultModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_MaxMagOffFault;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_PaleoUncertainties;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_RegionalSeismicity;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_ScalingRelationships;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_SegmentationModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_SeisSmoothingAlgorithms;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_SingleStates;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_SlipAlongRuptureModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.RupsThroughCreepingSect;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.RupturePlausibilityModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SegmentationMFD_Adjustment;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SubSectConstraintModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SubSeisMoRateReductions;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SupraSeisBValues;

public class NSHM23_LogicTreeBranch
extends LogicTreeBranch<LogicTreeNode> {
    public static List<LogicTreeLevel<? extends LogicTreeNode>> levelsOnFault;
    public static List<LogicTreeLevel<? extends LogicTreeNode>> levelsOffFault;
    public static List<LogicTreeLevel<? extends LogicTreeNode>> levelsCombined;
    public static List<LogicTreeLevel<? extends LogicTreeNode>> levelsMaxDist;
    public static LogicTreeLevel<NSHM23_FaultModels> FM;
    public static LogicTreeLevel<NSHM23_DeformationModels> DM;
    public static LogicTreeLevel<NSHM23_ScalingRelationships> SCALE;
    public static LogicTreeLevel<SupraSeisBValues> SUPRA_B;
    public static LogicTreeLevel<NSHM23_SegmentationModels> SEG;
    public static LogicTreeLevel<NSHM23_PaleoUncertainties> PALEO_UNCERT;
    public static LogicTreeLevel<NSHM23_RegionalSeismicity> SEIS_RATE;
    public static LogicTreeLevel<NSHM23_DeclusteringAlgorithms> SEIS_DECLUSTER;
    public static LogicTreeLevel<NSHM23_SeisSmoothingAlgorithms> SEIS_SMOOTH;
    public static LogicTreeLevel<NSHM23_MaxMagOffFault> MMAX_OFF;
    public static LogicTreeLevel<RupturePlausibilityModels> PLAUSIBILITY;
    public static LogicTreeLevel<NSHM23_SlipAlongRuptureModels> SLIP_ALONG;
    public static LogicTreeLevel<SubSectConstraintModels> SUB_SECT_CONSTR;
    public static LogicTreeLevel<SubSeisMoRateReductions> SUB_SEIS_MO;
    public static LogicTreeLevel<SegmentationMFD_Adjustment> SEG_ADJ;
    public static LogicTreeLevel<MaxJumpDistModels> MAX_DIST;
    public static LogicTreeLevel<RupsThroughCreepingSect> RUPS_THROUGH_CREEPING;
    public static LogicTreeLevel<NSHM23_SingleStates> SINGLE_STATES;
    public static final NSHM23_LogicTreeBranch DEFAULT_ON_FAULT;
    public static final NSHM23_LogicTreeBranch AVERAGE_ON_FAULT;
    public static final NSHM23_LogicTreeBranch DEFAULT_OFF_FAULT;
    public static final NSHM23_LogicTreeBranch AVERAGE_OFF_FAULT;
    public static final NSHM23_LogicTreeBranch DEFAULT_COMBINED;
    public static final NSHM23_LogicTreeBranch AVERAGE_COMBINED;

    public static NSHM23_LogicTreeBranch fromValues(List<LogicTreeLevel<?>> levels, List<LogicTreeNode> vals) {
        LogicTreeNode[] valsArray = new LogicTreeNode[vals.size()];
        for (int i = 0; i < vals.size(); ++i) {
            valsArray[i] = vals.get(i);
        }
        return NSHM23_LogicTreeBranch.fromValues(levels, valsArray);
    }

    public static NSHM23_LogicTreeBranch fromValues(List<LogicTreeLevel<?>> levels, LogicTreeNode ... vals) {
        return NSHM23_LogicTreeBranch.fromValues(levels, null, vals);
    }

    public static NSHM23_LogicTreeBranch fromValues(List<LogicTreeLevel<?>> levels, LogicTreeBranch<?> defaultValues, LogicTreeNode ... vals) {
        ArrayList<LogicTreeNode> values = new ArrayList<LogicTreeNode>();
        for (int i = 0; i < levels.size(); ++i) {
            values.add(null);
        }
        for (LogicTreeNode val : vals) {
            if (val == null) continue;
            int ind = -1;
            for (int i = 0; i < levelsOnFault.size(); ++i) {
                LogicTreeLevel<?> level = levels.get(i);
                if (!level.isMember(val)) continue;
                ind = i;
                break;
            }
            Preconditions.checkArgument((ind >= 0 ? 1 : 0) != 0, (Object)("Value of class '" + String.valueOf(val.getClass()) + "' does not match any known branch level"));
            values.set(ind, val);
        }
        NSHM23_LogicTreeBranch branch = new NSHM23_LogicTreeBranch(levels, (List<LogicTreeNode>)values);
        if (defaultValues != null) {
            Preconditions.checkState((defaultValues.size() == branch.size() ? 1 : 0) != 0);
            for (int i = 0; i < levels.size(); ++i) {
                if (branch.getValue(i) != null) continue;
                branch.setValue(i, defaultValues.getValue(i));
            }
        }
        return branch;
    }

    public NSHM23_LogicTreeBranch() {
        super(levelsOnFault);
    }

    public NSHM23_LogicTreeBranch(List<LogicTreeNode> values) {
        super(levelsOnFault, values);
    }

    public NSHM23_LogicTreeBranch(List<LogicTreeLevel<?>> levels, List<LogicTreeNode> values) {
        super(levels, values);
    }

    static {
        FM = LogicTreeLevel.forEnum(NSHM23_FaultModels.class, "Fault Model", "FM");
        DM = LogicTreeLevel.forEnum(NSHM23_DeformationModels.class, "Deformation Model", "DM");
        SCALE = LogicTreeLevel.forEnum(NSHM23_ScalingRelationships.class, "Scaling Relationship", "Scale");
        SUPRA_B = LogicTreeLevel.forEnum(SupraSeisBValues.class, "Supra-Seismogenic b-value", "SupraB");
        SEG = LogicTreeLevel.forEnum(NSHM23_SegmentationModels.class, "Segmentation Model", "SegModel");
        PALEO_UNCERT = LogicTreeLevel.forEnum(NSHM23_PaleoUncertainties.class, "Paleoseismic Data Uncertainties", "PaleoUncert");
        SEIS_RATE = LogicTreeLevel.forEnum(NSHM23_RegionalSeismicity.class, "Regional Seismicity Rate", "SeisRate");
        SEIS_DECLUSTER = LogicTreeLevel.forEnum(NSHM23_DeclusteringAlgorithms.class, "Seismicity Declustering Algorithm", "SeisDecluster");
        SEIS_SMOOTH = LogicTreeLevel.forEnum(NSHM23_SeisSmoothingAlgorithms.class, "Seismicity Smoothing Kernel", "SeisSmooth");
        MMAX_OFF = LogicTreeLevel.forEnum(NSHM23_MaxMagOffFault.class, "Off Fault Mmax", "MmaxOff");
        PLAUSIBILITY = LogicTreeLevel.forEnum(RupturePlausibilityModels.class, "Rupture Plausibility Model", "RupSet");
        SLIP_ALONG = LogicTreeLevel.forEnum(NSHM23_SlipAlongRuptureModels.class, "Slip Along Rupture", "SlipAlong");
        SUB_SECT_CONSTR = LogicTreeLevel.forEnum(SubSectConstraintModels.class, "Sub-Sect Constraint Model", "SectConstr");
        SUB_SEIS_MO = LogicTreeLevel.forEnum(SubSeisMoRateReductions.class, "Sub-Sect Moment Rate Reduction", "SectMoRed");
        SEG_ADJ = LogicTreeLevel.forEnum(SegmentationMFD_Adjustment.class, "Segmentation MFD Adjustment", "SegAdj");
        MAX_DIST = LogicTreeLevel.forEnum(MaxJumpDistModels.class, "Maximum Jump Distance", "MaxJumpDist");
        RUPS_THROUGH_CREEPING = LogicTreeLevel.forEnum(RupsThroughCreepingSect.class, "Ruptures Through Creeping Section", "RupsThruCreep");
        SINGLE_STATES = LogicTreeLevel.forEnum(NSHM23_SingleStates.class, "Single State Inversion", "SingleState");
        levelsOnFault = List.of(FM, DM, SCALE, SUPRA_B, PALEO_UNCERT, SEG);
        levelsOffFault = List.of(SEIS_RATE, SEIS_DECLUSTER, SEIS_SMOOTH, MMAX_OFF);
        ImmutableList.Builder combLevelBuilder = ImmutableList.builder();
        combLevelBuilder.addAll(levelsOnFault);
        combLevelBuilder.addAll(levelsOffFault);
        levelsCombined = combLevelBuilder.build();
        levelsMaxDist = List.of(FM, PLAUSIBILITY, DM, SCALE, SLIP_ALONG, SUPRA_B, SUB_SECT_CONSTR, SUB_SEIS_MO, PALEO_UNCERT, MAX_DIST, RUPS_THROUGH_CREEPING);
        DEFAULT_ON_FAULT = NSHM23_LogicTreeBranch.fromValues(levelsOnFault, NSHM23_FaultModels.WUS_FM_v3, NSHM23_DeformationModels.GEOLOGIC, NSHM23_ScalingRelationships.LOGA_C4p2, SupraSeisBValues.B_0p5, NSHM23_PaleoUncertainties.EVEN_FIT, NSHM23_SegmentationModels.MID);
        AVERAGE_ON_FAULT = NSHM23_LogicTreeBranch.fromValues(levelsOnFault, NSHM23_FaultModels.WUS_FM_v3, NSHM23_DeformationModels.AVERAGE, NSHM23_ScalingRelationships.AVERAGE, SupraSeisBValues.AVERAGE, NSHM23_PaleoUncertainties.AVERAGE, NSHM23_SegmentationModels.AVERAGE);
        DEFAULT_OFF_FAULT = NSHM23_LogicTreeBranch.fromValues(levelsOffFault, NSHM23_RegionalSeismicity.PREFFERRED, NSHM23_DeclusteringAlgorithms.GK, NSHM23_SeisSmoothingAlgorithms.ADAPTIVE, NSHM23_MaxMagOffFault.MAG_7p6);
        AVERAGE_OFF_FAULT = NSHM23_LogicTreeBranch.fromValues(levelsOffFault, NSHM23_RegionalSeismicity.PREFFERRED, NSHM23_DeclusteringAlgorithms.AVERAGE, NSHM23_SeisSmoothingAlgorithms.AVERAGE, NSHM23_MaxMagOffFault.MAG_7p6);
        DEFAULT_COMBINED = new NSHM23_LogicTreeBranch(levelsCombined, null);
        for (LogicTreeNode node : DEFAULT_ON_FAULT) {
            DEFAULT_COMBINED.setValue(node);
        }
        for (LogicTreeNode node : DEFAULT_OFF_FAULT) {
            DEFAULT_COMBINED.setValue(node);
        }
        AVERAGE_COMBINED = new NSHM23_LogicTreeBranch(levelsCombined, null);
        for (LogicTreeNode node : AVERAGE_ON_FAULT) {
            AVERAGE_COMBINED.setValue(node);
        }
        for (LogicTreeNode node : AVERAGE_OFF_FAULT) {
            AVERAGE_COMBINED.setValue(node);
        }
    }
}

