/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.xyz.AbstractXYZ_DataSet;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_DeclusteringAlgorithms;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.util.NSHM23_RegionLoader;

@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="fault_sections.geojson"), @DoesNotAffect(value="indices.csv"), @DoesNotAffect(value="properties.csv"), @DoesNotAffect(value="rates.csv"), @DoesNotAffect(value="grid_region.geojson"), @DoesNotAffect(value="grid_mech_weights.csv"), @DoesNotAffect(value="grid_source_locations.csv")})
@Affects.Affected(value={@Affects(value="grid_sub_seis_mfds.csv"), @Affects(value="grid_unassociated_mfds.csv"), @Affects(value="grid_sources.csv")})
public enum NSHM23_SeisSmoothingAlgorithms implements LogicTreeNode
{
    ADAPTIVE("Adaptive Kernel", "Adaptive", 0.6),
    FIXED("Fixed Kernel", "Fixed", 0.4),
    AVERAGE("Average", "Average", 0.0){

        @Override
        public GriddedGeoDataSet loadXYZ(NSHM23_RegionLoader.SeismicityRegions region, NSHM23_DeclusteringAlgorithms declusteringAlg) throws IOException {
            ArrayList<GriddedGeoDataSet> xyzs = new ArrayList<GriddedGeoDataSet>();
            ArrayList<Double> weights = new ArrayList<Double>();
            for (NSHM23_SeisSmoothingAlgorithms smooth : 1.values()) {
                if (smooth.weight == 0.0 || smooth == this) continue;
                xyzs.add(smooth.loadXYZ(region, declusteringAlg));
                weights.add(smooth.weight);
            }
            return NSHM23_SeisSmoothingAlgorithms.average(xyzs, weights);
        }
    };

    private String name;
    private String shortName;
    private double weight;
    private static final String NSHM23_SS_PATH_PREFIX = "/data/erf/nshm23/seismicity/spatial_seis_pdfs/";
    public static String MODEL_DATE;
    private Table<NSHM23_RegionLoader.SeismicityRegions, NSHM23_DeclusteringAlgorithms, GriddedGeoDataSet> xyzCache;
    private static final DecimalFormat pDF;

    private NSHM23_SeisSmoothingAlgorithms(String name, String shortName, double weight) {
        this.name = name;
        this.shortName = shortName;
        this.weight = weight;
    }

    private String getResourceName(NSHM23_RegionLoader.SeismicityRegions region, NSHM23_DeclusteringAlgorithms declusteringAlg) {
        return NSHM23_SS_PATH_PREFIX + MODEL_DATE + "/" + region.name() + "/" + declusteringAlg.name() + "_" + this.name() + ".csv";
    }

    private static GriddedGeoDataSet average(List<GriddedGeoDataSet> xyzs, List<Double> weights) {
        AbstractXYZ_DataSet avg = null;
        double sumWeight = 0.0;
        for (int i = 0; i < xyzs.size(); ++i) {
            GriddedGeoDataSet xyz = xyzs.get(i);
            double weight = weights.get(i);
            if (avg == null) {
                avg = new GriddedGeoDataSet(xyz.getRegion(), false);
            } else {
                Preconditions.checkState((boolean)((GriddedGeoDataSet)avg).getRegion().equalsRegion(xyz.getRegion()));
            }
            for (int j = 0; j < xyz.size(); ++j) {
                ((GriddedGeoDataSet)avg).set(j, ((GriddedGeoDataSet)avg).get(j) + xyz.get(j) * weight);
            }
            sumWeight += weight;
        }
        if (xyzs.size() == 1) {
            return xyzs.get(0);
        }
        avg.scale(1.0 / sumWeight);
        return avg;
    }

    public double[] load(NSHM23_RegionLoader.SeismicityRegions region, NSHM23_DeclusteringAlgorithms declusteringAlg) throws IOException {
        return this.loadXYZ(region, declusteringAlg).getValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        NSHM23_SeisSmoothingAlgorithms[] nSHM23_SeisSmoothingAlgorithmsArray = NSHM23_SeisSmoothingAlgorithms.values();
        int n = nSHM23_SeisSmoothingAlgorithmsArray.length;
        for (int i = 0; i < n; ++i) {
            NSHM23_SeisSmoothingAlgorithms smooth;
            NSHM23_SeisSmoothingAlgorithms nSHM23_SeisSmoothingAlgorithms = smooth = nSHM23_SeisSmoothingAlgorithmsArray[i];
            synchronized (nSHM23_SeisSmoothingAlgorithms) {
                smooth.xyzCache = null;
                continue;
            }
        }
    }

    public synchronized GriddedGeoDataSet loadXYZ(NSHM23_RegionLoader.SeismicityRegions region, NSHM23_DeclusteringAlgorithms declusteringAlg) throws IOException {
        GriddedGeoDataSet cached;
        if (this.xyzCache == null) {
            this.xyzCache = HashBasedTable.create();
        }
        if ((cached = (GriddedGeoDataSet)this.xyzCache.get((Object)region, (Object)declusteringAlg)) != null) {
            return cached;
        }
        if (declusteringAlg == NSHM23_DeclusteringAlgorithms.AVERAGE) {
            ArrayList<GriddedGeoDataSet> xyzs = new ArrayList<GriddedGeoDataSet>();
            ArrayList<Double> weights = new ArrayList<Double>();
            for (NSHM23_DeclusteringAlgorithms alg : NSHM23_DeclusteringAlgorithms.values()) {
                double weight = alg.getNodeWeight(null);
                if (weight == 0.0 || alg == NSHM23_DeclusteringAlgorithms.AVERAGE) continue;
                xyzs.add(this.loadXYZ(region, alg));
                weights.add(weight);
            }
            GriddedGeoDataSet average = NSHM23_SeisSmoothingAlgorithms.average(xyzs, weights);
            this.xyzCache.put((Object)region, (Object)declusteringAlg, (Object)average);
            return average;
        }
        String resource = this.getResourceName(region, declusteringAlg);
        System.out.println("Loading spatial seismicity PDF from: " + resource);
        InputStream is = NSHM23_SeisSmoothingAlgorithms.class.getResourceAsStream(resource);
        Preconditions.checkNotNull((Object)is, (String)"Spatial seismicity PDF not found: %s", (Object)resource);
        CSVFile<String> csv = CSVFile.readStream(is, true);
        GriddedRegion gridReg = new GriddedRegion(region.load(), 0.1, GriddedRegion.ANCHOR_0_0);
        GriddedGeoDataSet xyz = new GriddedGeoDataSet(gridReg, false);
        double sum = 0.0;
        int numMapped = 0;
        for (int row = 0; row < csv.getNumRows(); ++row) {
            double lon = csv.getDouble(row, 0);
            double lat = csv.getDouble(row, 1);
            double val = csv.getDouble(row, 2);
            sum += val;
            Location loc = new Location(lat, lon);
            int gridIndex = gridReg.indexForLocation(loc);
            if (gridIndex < 0) continue;
            ++numMapped;
            Preconditions.checkState((xyz.get(gridIndex) == 0.0 ? 1 : 0) != 0);
            xyz.set(gridIndex, val);
        }
        double sumMapped = xyz.getSumZ();
        System.out.println("totWeight=" + (float)sum + ";\tmappedWeight=" + (float)sumMapped + "; mapping results:");
        System.out.println("\t" + numMapped + "/" + csv.getNumRows() + " (" + pDF.format((double)numMapped / (double)csv.getNumRows()) + ") of locations from input CSV mapped");
        System.out.println("\t" + numMapped + "/" + gridReg.getNodeCount() + " (" + pDF.format((double)numMapped / (double)gridReg.getNodeCount()) + ") of gridded region mapped");
        xyz.scale(1.0 / sumMapped);
        this.xyzCache.put((Object)region, (Object)declusteringAlg, (Object)xyz);
        return xyz;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return this.name();
    }

    public static void main(String[] args) throws IOException {
        for (NSHM23_RegionLoader.SeismicityRegions region : NSHM23_RegionLoader.SeismicityRegions.values()) {
            for (NSHM23_DeclusteringAlgorithms alg : NSHM23_DeclusteringAlgorithms.values()) {
                if (alg == NSHM23_DeclusteringAlgorithms.AVERAGE) continue;
                for (NSHM23_SeisSmoothingAlgorithms smooth : NSHM23_SeisSmoothingAlgorithms.values()) {
                    if (smooth == AVERAGE) continue;
                    System.out.println(region.name() + ",\t" + alg.name() + ",\t" + smooth.name());
                    smooth.load(region, alg);
                }
            }
        }
    }

    static {
        MODEL_DATE = "2023_06_19";
        pDF = new DecimalFormat("0.00%");
    }
}

