/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_LogicTreeBranch;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_PaleoUncertainties;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_SegmentationModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.RupturePlausibilityModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SegmentationMFD_Adjustment;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SubSectConstraintModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SubSeisMoRateReductions;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SupraSeisBValues;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.U3_UncertAddDeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.MaxMagOffFault;
import scratch.UCERF3.enumTreeBranches.ScalingRelationships;
import scratch.UCERF3.enumTreeBranches.SlipAlongRuptureModels;
import scratch.UCERF3.enumTreeBranches.SpatialSeisPDF;
import scratch.UCERF3.enumTreeBranches.TotalMag5Rate;

public class NSHM23_U3_HybridLogicTreeBranch
extends LogicTreeBranch<LogicTreeNode> {
    public static List<LogicTreeLevel<? extends LogicTreeNode>> levels;
    public static List<LogicTreeLevel<? extends LogicTreeNode>> levelsMaxDist;
    public static List<LogicTreeLevel<? extends LogicTreeNode>> levelsOffFault;
    public static LogicTreeLevel<FaultModels> U3_FM;
    public static LogicTreeLevel<U3_UncertAddDeformationModels> U3_WRAPPED_DM;
    public static LogicTreeLevel<ScalingRelationships> SCALE;
    public static LogicTreeLevel<SlipAlongRuptureModels> SLIP_ALONG;
    public static LogicTreeLevel.EnumBackedLevel<TotalMag5Rate> SEIS_RATE;
    public static LogicTreeLevel.EnumBackedLevel<SpatialSeisPDF> SEIS_PDF;
    public static LogicTreeLevel.EnumBackedLevel<MaxMagOffFault> MMAX_OFF;
    public static final NSHM23_U3_HybridLogicTreeBranch DEFAULT;

    public static NSHM23_U3_HybridLogicTreeBranch fromValues(List<LogicTreeNode> vals) {
        LogicTreeNode[] valsArray = new LogicTreeNode[vals.size()];
        for (int i = 0; i < vals.size(); ++i) {
            valsArray[i] = vals.get(i);
        }
        return NSHM23_U3_HybridLogicTreeBranch.fromValues(valsArray);
    }

    public static NSHM23_U3_HybridLogicTreeBranch fromValues(LogicTreeNode ... vals) {
        return NSHM23_U3_HybridLogicTreeBranch.fromValues(true, vals);
    }

    public static NSHM23_U3_HybridLogicTreeBranch fromValues(boolean setNullToDefault, LogicTreeNode ... vals) {
        ArrayList<LogicTreeNode> values = new ArrayList<LogicTreeNode>();
        for (int i = 0; i < levels.size(); ++i) {
            values.add(null);
        }
        for (LogicTreeNode val : vals) {
            if (val == null) continue;
            int ind = -1;
            for (int i = 0; i < levels.size(); ++i) {
                LogicTreeLevel<? extends LogicTreeNode> level = levels.get(i);
                if (!level.isMember(val)) continue;
                ind = i;
                break;
            }
            Preconditions.checkArgument((ind >= 0 ? 1 : 0) != 0, (Object)("Value of class '" + String.valueOf(val.getClass()) + "' does not match any known branch level"));
            values.set(ind, val);
        }
        NSHM23_U3_HybridLogicTreeBranch branch = new NSHM23_U3_HybridLogicTreeBranch((List<LogicTreeNode>)values);
        if (setNullToDefault) {
            for (int i = 0; i < levels.size(); ++i) {
                if (branch.getValue(i) != null) continue;
                branch.setValue(i, DEFAULT.getValue(i));
            }
        }
        return branch;
    }

    public NSHM23_U3_HybridLogicTreeBranch() {
        super(levels);
    }

    public NSHM23_U3_HybridLogicTreeBranch(List<LogicTreeNode> values) {
        super(levels, values);
    }

    static {
        U3_FM = LogicTreeLevel.forEnum(FaultModels.class, "UCERF3 Fault Model", "FM");
        U3_WRAPPED_DM = LogicTreeLevel.forEnum(U3_UncertAddDeformationModels.class, "UCERF3 Deformation Model", "DM");
        SCALE = LogicTreeLevel.forEnum(ScalingRelationships.class, "Scaling Relationship", "Scale");
        SLIP_ALONG = LogicTreeLevel.forEnum(SlipAlongRuptureModels.class, "Slip Along Rupture", "SlipAlong");
        SEIS_RATE = LogicTreeLevel.forEnum(TotalMag5Rate.class, "U3 Regional Seismicity Rate", "SeisRate");
        SEIS_PDF = LogicTreeLevel.forEnum(SpatialSeisPDF.class, "U3 Spatial Seismicity PDF", "SpatSeisPDF");
        MMAX_OFF = LogicTreeLevel.forEnum(MaxMagOffFault.class, "U3 Off Fault Mmax", "MmaxOff");
        levels = List.of(U3_FM, NSHM23_LogicTreeBranch.PLAUSIBILITY, U3_WRAPPED_DM, SCALE, SLIP_ALONG, NSHM23_LogicTreeBranch.SUPRA_B, NSHM23_LogicTreeBranch.SUB_SECT_CONSTR, NSHM23_LogicTreeBranch.SUB_SEIS_MO, NSHM23_LogicTreeBranch.PALEO_UNCERT, NSHM23_LogicTreeBranch.SEG, NSHM23_LogicTreeBranch.SEG_ADJ);
        levelsMaxDist = List.of(U3_FM, NSHM23_LogicTreeBranch.PLAUSIBILITY, U3_WRAPPED_DM, SCALE, SLIP_ALONG, NSHM23_LogicTreeBranch.SUPRA_B, NSHM23_LogicTreeBranch.SUB_SECT_CONSTR, NSHM23_LogicTreeBranch.SUB_SEIS_MO, NSHM23_LogicTreeBranch.PALEO_UNCERT, NSHM23_LogicTreeBranch.MAX_DIST, NSHM23_LogicTreeBranch.RUPS_THROUGH_CREEPING);
        levelsOffFault = List.of(SEIS_RATE, SEIS_PDF, MMAX_OFF);
        Collection<String> gridSeisAffected = NSHM23_LogicTreeBranch.SEIS_RATE.getAffected();
        Collection<String> gridSeisUnaffected = NSHM23_LogicTreeBranch.SEIS_RATE.getNotAffected();
        SEIS_RATE.setAffected(gridSeisAffected, gridSeisUnaffected, false);
        SEIS_PDF.setAffected(gridSeisAffected, gridSeisUnaffected, false);
        MMAX_OFF.setAffected(gridSeisAffected, gridSeisUnaffected, false);
        DEFAULT = NSHM23_U3_HybridLogicTreeBranch.fromValues(FaultModels.FM3_1, RupturePlausibilityModels.COULOMB, U3_UncertAddDeformationModels.U3_ZENG, ScalingRelationships.SHAW_2009_MOD, SlipAlongRuptureModels.UNIFORM, SupraSeisBValues.B_0p5, SubSectConstraintModels.TOT_NUCL_RATE, SubSeisMoRateReductions.SUB_B_1, NSHM23_PaleoUncertainties.EVEN_FIT, NSHM23_SegmentationModels.MID, SegmentationMFD_Adjustment.REL_GR_THRESHOLD_AVG);
    }
}

