/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.JumpProbabilityCalc;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.MaxJumpDistModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators.ImprobModelRupMultiplyingSectNuclMFD_Estimator;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators.SectNucleationMFD_Estimator;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators.SegmentationImpliedSectNuclMFD_Estimator;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators.ThresholdAveragingSectNuclMFD_Estimator;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.util.StrictSegReproductionMFDAdjustment;

@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="fault_sections.geojson"), @DoesNotAffect(value="indices.csv"), @DoesNotAffect(value="properties.csv")})
@Affects(value="rates.csv")
public enum SegmentationMFD_Adjustment implements LogicTreeNode
{
    JUMP_PROB_THRESHOLD_AVG("Threshold Averaging", "ThreshAvg", 0.0){

        @Override
        public SectNucleationMFD_Estimator getAdjustment(JumpProbabilityCalc segModel) {
            return new ThresholdAveragingSectNuclMFD_Estimator.WorstAvgJumpProb(segModel);
        }
    }
    ,
    REL_GR_THRESHOLD_AVG_SINGLE_ITER("Threshold Averaging, Single-Iter Rel G-R", "ThreshAvgSingleIterRelGR", 0.0){

        @Override
        public SectNucleationMFD_Estimator getAdjustment(JumpProbabilityCalc segModel) {
            return new ThresholdAveragingSectNuclMFD_Estimator.RelGRWorstJumpProb(segModel, 1, true);
        }
    }
    ,
    REL_GR_THRESHOLD_AVG("Threshold Averaging, Rel G-R", "ThreshAvgIterRelGR", 1.0){

        @Override
        public SectNucleationMFD_Estimator getAdjustment(JumpProbabilityCalc segModel) {
            return new ThresholdAveragingSectNuclMFD_Estimator.RelGRWorstJumpProb(segModel, 100, true);
        }
    }
    ,
    JUMP_PROB_THRESHOLD_AVG_MATCH_STRICT("Strict-Seg Equiv Threshold Averaging", "StrictEquivThreshAvg", 0.0){

        @Override
        public SectNucleationMFD_Estimator getAdjustment(JumpProbabilityCalc segModel) {
            Preconditions.checkState((boolean)(segModel instanceof JumpProbabilityCalc.DistDependentJumpProbabilityCalc), (Object)"Only works with dist-dependent models");
            JumpProbabilityCalc.DistDependentJumpProbabilityCalc distModel = (JumpProbabilityCalc.DistDependentJumpProbabilityCalc)segModel;
            ArrayList<Double> probs = new ArrayList<Double>();
            for (MaxJumpDistModels model : MaxJumpDistModels.values()) {
                probs.add(distModel.calcJumpProbability(model.getMaxDist()));
            }
            return new ThresholdAveragingSectNuclMFD_Estimator.WorstJumpProb(segModel, probs);
        }
    }
    ,
    JUMP_PROB_THRESHOLD_AVG_ABOVE_1KM("Threshold Averaging >1km", "JumpProbGt1km", 0.0){

        @Override
        public SectNucleationMFD_Estimator getAdjustment(JumpProbabilityCalc segModel) {
            Preconditions.checkState((boolean)(segModel instanceof JumpProbabilityCalc.DistDependentJumpProbabilityCalc), (Object)"Only works with dist-dependent models");
            JumpProbabilityCalc.DistDependentJumpProbabilityCalc distModel = (JumpProbabilityCalc.DistDependentJumpProbabilityCalc)segModel;
            double maxProb = distModel.calcJumpProbability(1.0);
            double minProb = distModel.calcJumpProbability(20.0);
            EvenlyDiscretizedFunc lnProbFunc = new EvenlyDiscretizedFunc(Math.log(minProb), Math.log(maxProb), 100);
            ArrayList<Double> probs = new ArrayList<Double>();
            probs.add(1.0);
            int i = lnProbFunc.size();
            while (--i >= 0) {
                probs.add(Math.exp(lnProbFunc.getX(i)));
            }
            return new ThresholdAveragingSectNuclMFD_Estimator.WorstJumpProb(segModel, probs);
        }
    }
    ,
    RUP_PROB_THRESHOLD_AVG("Rup Prob Threshold Averaging", "RupProb", 0.0){

        @Override
        public SectNucleationMFD_Estimator getAdjustment(JumpProbabilityCalc segModel) {
            return new ThresholdAveragingSectNuclMFD_Estimator.WorstJumpProb(segModel);
        }
    }
    ,
    RUP_MULTIPLY_WORST_JUMP_PROB("Rup Multyplied By Worst Jump Prob", "RupMultiplyWorstJumpProb", 0.0){

        @Override
        public SectNucleationMFD_Estimator getAdjustment(JumpProbabilityCalc segModel) {
            return new ImprobModelRupMultiplyingSectNuclMFD_Estimator.WorstJumpProb(segModel);
        }
    }
    ,
    GREEDY("Greedy", "Greedy", 0.0){

        @Override
        public SectNucleationMFD_Estimator getAdjustment(JumpProbabilityCalc segModel) {
            return new SegmentationImpliedSectNuclMFD_Estimator(segModel, SegmentationImpliedSectNuclMFD_Estimator.MultiBinDistributionMethod.GREEDY, false);
        }
    }
    ,
    GREEDY_SELF_CONTAINED("Greedy Self-Contained", "GreedySlfCont", 0.0){

        @Override
        public SectNucleationMFD_Estimator getAdjustment(JumpProbabilityCalc segModel) {
            return new SegmentationImpliedSectNuclMFD_Estimator(segModel, SegmentationImpliedSectNuclMFD_Estimator.MultiBinDistributionMethod.GREEDY, true);
        }
    }
    ,
    CAPPED_REDIST("Capped Redistributed", "CappedRdst", 0.0){

        @Override
        public SectNucleationMFD_Estimator getAdjustment(JumpProbabilityCalc segModel) {
            return new SegmentationImpliedSectNuclMFD_Estimator(segModel, SegmentationImpliedSectNuclMFD_Estimator.MultiBinDistributionMethod.CAPPED_DISTRIBUTED, false);
        }
    }
    ,
    CAPPED_REDIST_SELF_CONTAINED("Capped Redistributed Self-Contained", "CappedRdstSlfCont", 0.0){

        @Override
        public SectNucleationMFD_Estimator getAdjustment(JumpProbabilityCalc segModel) {
            return new SegmentationImpliedSectNuclMFD_Estimator(segModel, SegmentationImpliedSectNuclMFD_Estimator.MultiBinDistributionMethod.CAPPED_DISTRIBUTED, true);
        }
    }
    ,
    NONE("No Adjustment", "NoAdj", 0.0){

        @Override
        public SectNucleationMFD_Estimator getAdjustment(JumpProbabilityCalc segModel) {
            return null;
        }
    }
    ,
    STRICT_SEG_REPRODUCE_THROUGH_INVERSION("Strict-Segmentation", "StrictSeg", 0.0){

        @Override
        public SectNucleationMFD_Estimator getAdjustment(JumpProbabilityCalc segModel) {
            System.err.println("WARNING: using strict-seg reproduction, will be slow and do inversions, only use for small test cases");
            return new StrictSegReproductionMFDAdjustment(segModel);
        }
    };

    private String name;
    private String shortName;
    private double weight;

    private SegmentationMFD_Adjustment(String name, String shortName, double weight) {
        this.name = name;
        this.shortName = shortName;
        this.weight = weight;
    }

    public abstract SectNucleationMFD_Estimator getAdjustment(JumpProbabilityCalc var1);

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return this.shortName.replace("R\u2080=", "R0_");
    }
}

