/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree;

import java.util.HashSet;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.JumpProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RuptureProbabilityCalc;

public interface SegmentationModelBranchNode
extends LogicTreeNode {
    public JumpProbabilityCalc getModel(FaultSystemRupSet var1, LogicTreeBranch<?> var2);

    default public RuptureProbabilityCalc.BinaryRuptureProbabilityCalc getExclusionModel(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
        JumpProbabilityCalc segModel = this.getModel(rupSet, branch);
        return SegmentationModelBranchNode.buildJumpExclusionModel(rupSet, segModel);
    }

    public static JumpProbabilityCalc.BinaryJumpProbabilityCalc buildJumpExclusionModel(FaultSystemRupSet rupSet, JumpProbabilityCalc segModel) {
        if (segModel instanceof JumpProbabilityCalc.BinaryJumpProbabilityCalc) {
            return (JumpProbabilityCalc.BinaryJumpProbabilityCalc)segModel;
        }
        if (segModel != null && rupSet.hasModule(ClusterRuptures.class)) {
            ClusterRuptures cRups = rupSet.getModule(ClusterRuptures.class);
            HashSet<IDPairing> excluded = new HashSet<IDPairing>();
            for (int rupIndex = 0; rupIndex < rupSet.getNumRuptures(); ++rupIndex) {
                ClusterRupture rup = cRups.get(rupIndex);
                for (Jump jump : rup.getJumpsIterable()) {
                    if (segModel.calcJumpProbability(rup, jump, false) != 0.0) continue;
                    IDPairing pair = new IDPairing(jump.fromSection.getSectionId(), jump.toSection.getSectionId());
                    excluded.add(pair);
                    excluded.add(pair.getReversed());
                }
            }
            if (!excluded.isEmpty()) {
                return new JumpProbabilityCalc.HardcodedBinaryJumpProb(segModel.getName(), true, excluded, false);
            }
        }
        return null;
    }
}

