/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree;

import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.JumpProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.Shaw07JumpDistProb;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.DistDependSegShift;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SegmentationModelBranchNode;

@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="fault_sections.geojson"), @DoesNotAffect(value="indices.csv"), @DoesNotAffect(value="properties.csv")})
@Affects(value="rates.csv")
public enum ShawSegmentationModels implements SegmentationModelBranchNode
{
    SHAW_R0_1("Shaw & Dieterich (2007) R\u2080=1", "ShawR\u2080=1", 1.0, 0.0),
    SHAW_R0_2("Shaw & Dieterich (2007) R\u2080=2", "ShawR\u2080=2", 2.0, 0.25),
    SHAW_R0_3("Shaw & Dieterich (2007) R\u2080=3", "ShawR\u2080=3", 3.0, 0.6),
    SHAW_R0_4("Shaw & Dieterich (2007) R\u2080=4", "ShawR\u2080=4", 4.0, 0.15),
    SHAW_R0_5("Shaw & Dieterich (2007) R\u2080=5", "ShawR\u2080=5", 5.0, 0.0),
    SHAW_R0_6("Shaw & Dieterich (2007) R\u2080=6", "ShawR\u2080=6", 6.0, 0.0),
    NONE("None", "None", Double.NaN, 0.0);

    private String name;
    private String shortName;
    private double weight;
    private double r0;

    private ShawSegmentationModels(String name, String shortName, double r0, double weight) {
        this.name = name;
        this.shortName = shortName;
        this.r0 = r0;
        this.weight = weight;
    }

    @Override
    public JumpProbabilityCalc getModel(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
        return ShawSegmentationModels.buildShaw(1.0, this.r0, branch);
    }

    private static Shaw07JumpDistProb buildShaw(double a, double r0, LogicTreeBranch<?> branch) {
        DistDependSegShift shift;
        DistDependSegShift distDependSegShift = shift = branch == null ? null : branch.getValue(DistDependSegShift.class);
        if (shift != null) {
            return Shaw07JumpDistProb.forHorzOffset(a, r0, shift.getShiftKM());
        }
        return new Shaw07JumpDistProb(a, r0);
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return this.shortName.replace("R\u2080=", "R0_");
    }

    public double getR0() {
        return this.r0;
    }
}

