/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.random;

import java.util.HashMap;
import java.util.Random;
import org.opensha.commons.calc.WeightedSampler;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.NamedFaults;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSubSetMappings;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SupraSeisBValues;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.random.AbstractSamplingNode;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.random.BranchDependentSampler;
import org.opensha.sha.faultSurface.FaultSection;

public class RandomBValSampler
implements BranchDependentSampler<RandomBValSampler> {
    private double[] bValues;

    public RandomBValSampler(FaultSystemRupSet rupSet, WeightedSampler<SupraSeisBValues> enumSampler) {
        this.bValues = new double[rupSet.getNumSections()];
        NamedFaults named = rupSet.getModule(NamedFaults.class);
        HashMap<String, Double> namedFaultBs = named == null ? null : new HashMap<String, Double>(named.get().size());
        HashMap<Integer, Double> parentBs = new HashMap<Integer, Double>();
        for (int s = 0; s < this.bValues.length; ++s) {
            String name;
            FaultSection sect = rupSet.getFaultSectionData(s);
            int parentID = sect.getParentSectionId();
            String string = name = named == null ? null : named.getFaultName(parentID);
            if (name != null) {
                if (namedFaultBs.containsKey(name)) {
                    this.bValues[s] = (Double)namedFaultBs.get(name);
                    continue;
                }
                this.bValues[s] = enumSampler.nextItem().bValue;
                namedFaultBs.put(name, this.bValues[s]);
                continue;
            }
            if (parentBs.containsKey(parentID)) {
                this.bValues[s] = (Double)parentBs.get(parentID);
                continue;
            }
            this.bValues[s] = enumSampler.nextItem().bValue;
            parentBs.put(parentID, this.bValues[s]);
        }
    }

    private RandomBValSampler(double[] bValues) {
        this.bValues = bValues;
    }

    @Override
    public RandomBValSampler getForRuptureSubSet(FaultSystemRupSet rupSubSet, RuptureSubSetMappings mappings) {
        double[] subsetBValues = new double[rupSubSet.getNumSections()];
        for (int s = 0; s < subsetBValues.length; ++s) {
            subsetBValues[s] = this.bValues[mappings.getOrigSectID(s)];
        }
        return new RandomBValSampler(subsetBValues);
    }

    public double[] getBValues() {
        return this.bValues;
    }

    public static class Level
    extends LogicTreeLevel.RandomlySampledLevel<Node> {
        public Level() {
        }

        public Level(int numSamples) {
            this(numSamples, new Random());
        }

        public Level(int numSamples, Random rand) {
            this.buildNodes(rand, numSamples);
        }

        @Override
        public String getShortName() {
            return "b Samples";
        }

        @Override
        public String getName() {
            return "Section b-value Samples";
        }

        @Override
        public Node buildNodeInstance(int index, long seed, double weight) {
            return new Node(index, seed, weight);
        }

        @Override
        public Class<? extends Node> getType() {
            return Node.class;
        }
    }

    @DoesNotAffect.NotAffected(value={@DoesNotAffect(value="fault_sections.geojson"), @DoesNotAffect(value="indices.csv"), @DoesNotAffect(value="properties.csv")})
    @Affects(value="rates.csv")
    public static class Node
    extends AbstractSamplingNode<RandomBValSampler> {
        private Node() {
        }

        public Node(int index, long seed, double weight) {
            super("Section b-value Sample " + index, "bSample" + index, "bSample" + index, weight, seed);
        }

        @Override
        public RandomBValSampler buildSampler(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch, long branchNodeSamplingSeed) {
            System.out.println("Building b-value sampler for " + this.getShortName() + " with seed: " + branchNodeSamplingSeed);
            WeightedSampler<SupraSeisBValues> enumSampler = Node.weightedNodeValueSampler(new Random(branchNodeSamplingSeed), SupraSeisBValues.class);
            return new RandomBValSampler(rupSet, enumSampler);
        }
    }
}

