/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators;

import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.UncertainDataConstraint;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.JumpProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RuptureProbabilityCalc;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators.SectNucleationMFD_Estimator;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class ImprobModelRupMultiplyingSectNuclMFD_Estimator
extends SectNucleationMFD_Estimator {
    private RuptureProbabilityCalc improbModel;
    private HashSet<Integer> affectedSects;
    private double[] rupProbs;
    private int[] rupMagIndexes;

    public ImprobModelRupMultiplyingSectNuclMFD_Estimator(RuptureProbabilityCalc improbModel) {
        this.improbModel = improbModel;
    }

    @Override
    public void init(FaultSystemRupSet rupSet, List<IncrementalMagFreqDist> origSectSupraSeisMFDs, double[] targetSectSupraMoRates, double[] targetSectSupraSlipRates, double[] sectSupraSlipRateStdDevs, List<BitSet> sectRupUtilizations, int[] sectMinMagIndexes, int[] sectMaxMagIndexes, int[][] sectRupInBinCounts, EvenlyDiscretizedFunc refMFD) {
        super.init(rupSet, origSectSupraSeisMFDs, targetSectSupraMoRates, targetSectSupraSlipRates, sectSupraSlipRateStdDevs, sectRupUtilizations, sectMinMagIndexes, sectMaxMagIndexes, sectRupInBinCounts, refMFD);
        this.affectedSects = new HashSet();
        this.rupProbs = new double[rupSet.getNumRuptures()];
        this.rupMagIndexes = new int[rupSet.getNumRuptures()];
        ClusterRuptures cRups = rupSet.requireModule(ClusterRuptures.class);
        for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
            ClusterRupture rup = cRups.get(r);
            this.rupProbs[r] = this.calcRupProb(rup);
            this.rupMagIndexes[r] = refMFD.getClosestXIndex(rupSet.getMagForRup(r));
            if (!(this.rupProbs[r] < 1.0)) continue;
            for (int sectIndex : rupSet.getSectionsIndicesForRup(r)) {
                this.affectedSects.add(sectIndex);
            }
        }
    }

    protected double calcRupProb(ClusterRupture rup) {
        return this.improbModel.calcRuptureProb(rup, false);
    }

    @Override
    public boolean appliesTo(FaultSection sect) {
        return this.affectedSects.contains(sect.getSectionId());
    }

    @Override
    public IncrementalMagFreqDist estimateNuclMFD(FaultSection sect, IncrementalMagFreqDist curSectSupraSeisMFD, List<Integer> availableRupIndexes, List<Double> availableRupMags, UncertainDataConstraint sectMomentRate, boolean sparseGR) {
        if (sectMomentRate.bestEstimate == 0.0 || availableRupIndexes.isEmpty() || curSectSupraSeisMFD.calcSumOfY_Vals() == 0.0) {
            return curSectSupraSeisMFD;
        }
        int[] binCounts = new int[curSectSupraSeisMFD.size()];
        for (int rupIndex : availableRupIndexes) {
            if (!((float)this.rupProbs[rupIndex] > 0.0f)) continue;
            int n = this.rupMagIndexes[rupIndex];
            binCounts[n] = binCounts[n] + 1;
        }
        IncrementalMagFreqDist ret = new IncrementalMagFreqDist(curSectSupraSeisMFD.getMinX(), curSectSupraSeisMFD.size(), curSectSupraSeisMFD.getDelta());
        for (int rupIndex : availableRupIndexes) {
            if (!((float)this.rupProbs[rupIndex] > 0.0f)) continue;
            double rupNuclProb = curSectSupraSeisMFD.getY(this.rupMagIndexes[rupIndex]) / (double)binCounts[this.rupMagIndexes[rupIndex]];
            ret.add(this.rupMagIndexes[rupIndex], rupNuclProb *= this.rupProbs[rupIndex]);
        }
        ret.scaleToTotalMomentRate(curSectSupraSeisMFD.getTotalMomentRate());
        return ret;
    }

    public static class WorstJumpProb
    extends ImprobModelRupMultiplyingSectNuclMFD_Estimator {
        private JumpProbabilityCalc jumpModel;

        public WorstJumpProb(JumpProbabilityCalc improbModel) {
            super(improbModel);
            this.jumpModel = improbModel;
        }

        @Override
        protected double calcRupProb(ClusterRupture rup) {
            double worstProb = 1.0;
            for (Jump jump : rup.getJumpsIterable()) {
                worstProb = Math.min(worstProb, this.jumpModel.calcJumpProbability(rup, jump, false));
            }
            return worstProb;
        }
    }
}

