/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.inversion.InversionConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.inversion.InversionInputGenerator;
import org.opensha.sha.earthquake.faultSysSolution.inversion.InversionSolver;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.SerialSimulatedAnnealing;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.modules.InfoModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.InitialSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionMisfits;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionTargetMFDs;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModSectMinMags;
import org.opensha.sha.earthquake.faultSysSolution.modules.WaterLevelRates;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RuptureProbabilityCalc;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.SupraSeisBValInversionTargetMFDs;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class AnalyticalSingleFaultInversionSolver
extends InversionSolver.Default {
    private double forcedBVal;
    private RuptureProbabilityCalc.BinaryRuptureProbabilityCalc rupExclusionModel;

    public AnalyticalSingleFaultInversionSolver() {
        this(Double.NaN, null);
    }

    public AnalyticalSingleFaultInversionSolver(double bVal) {
        this(bVal, null);
    }

    public AnalyticalSingleFaultInversionSolver(RuptureProbabilityCalc.BinaryRuptureProbabilityCalc rupExclusionModel) {
        this(Double.NaN, rupExclusionModel);
    }

    public AnalyticalSingleFaultInversionSolver(double bVal, RuptureProbabilityCalc.BinaryRuptureProbabilityCalc rupExclusionModel) {
        this.forcedBVal = bVal;
        this.rupExclusionModel = rupExclusionModel;
    }

    @Override
    public FaultSystemSolution run(FaultSystemRupSet rupSet, InversionConfiguration config, String info) {
        ModSectMinMags minMags = rupSet.getModule(ModSectMinMags.class);
        InversionTargetMFDs targets = rupSet.requireModule(InversionTargetMFDs.class);
        List<? extends IncrementalMagFreqDist> supraNuclMFDs = targets.getOnFaultSupraSeisNucleationMFDs();
        Preconditions.checkNotNull(supraNuclMFDs, (Object)"Must have section supra-seis nucleation MFDs to solve classic model analytically");
        BitSet excludeRuptures = null;
        if (this.rupExclusionModel != null) {
            excludeRuptures = new BitSet(rupSet.getNumRuptures());
            ClusterRuptures cRups = rupSet.requireModule(ClusterRuptures.class);
            for (int rupIndex = 0; rupIndex < rupSet.getNumRuptures(); ++rupIndex) {
                if (this.rupExclusionModel.isRupAllowed(cRups.get(rupIndex), false)) continue;
                excludeRuptures.set(rupIndex);
            }
        }
        double[] waterLevel = config.getWaterLevel();
        double[] bVals = null;
        if (Double.isFinite(this.forcedBVal)) {
            bVals = new double[rupSet.getNumSections()];
            for (int s = 0; s < bVals.length; ++s) {
                bVals[s] = this.forcedBVal;
            }
        } else if (targets instanceof SupraSeisBValInversionTargetMFDs) {
            SupraSeisBValInversionTargetMFDs bTargets = (SupraSeisBValInversionTargetMFDs)targets;
            bVals = bTargets.getSectSpecificBValues();
            if (bVals == null) {
                double b = bTargets.getSupraSeisBValue();
                bVals = new double[rupSet.getNumSections()];
                for (int s = 0; s < bVals.length; ++s) {
                    bVals[s] = b;
                }
            } else {
                Preconditions.checkState((bVals.length == rupSet.getNumSections() ? 1 : 0) != 0);
            }
        }
        double[] rates = new double[rupSet.getNumRuptures()];
        for (int s = 0; s < rupSet.getNumSections(); ++s) {
            int i;
            IncrementalMagFreqDist sectMFD = supraNuclMFDs.get(s);
            Preconditions.checkNotNull((Object)sectMFD, (Object)"Must have section supra-seis nucleation MFDs to solve classic model analytically");
            if (sectMFD.calcSumOfY_Vals() == 0.0) continue;
            ArrayList<ArrayList<Integer>> rupsInBins = new ArrayList<ArrayList<Integer>>(sectMFD.size());
            for (i = 0; i < sectMFD.size(); ++i) {
                rupsInBins.add(null);
            }
            if (waterLevel != null) {
                sectMFD = sectMFD.deepClone();
            }
            for (int rupIndex : rupSet.getRupturesForSection(s)) {
                if (excludeRuptures != null && excludeRuptures.get(rupIndex)) continue;
                double mag = rupSet.getMagForRup(rupIndex);
                int magIndex = sectMFD.getClosestXIndex(mag);
                if (waterLevel != null && waterLevel[rupIndex] > 0.0) {
                    double waterLevelNuclRate = waterLevel[rupIndex] * rupSet.getAreaForSection(s) / rupSet.getAreaForRup(rupIndex);
                    sectMFD.set(magIndex, Math.max(0.0, sectMFD.getY(magIndex) - waterLevelNuclRate));
                }
                if (minMags != null && minMags.isBelowSectMinMag(s, mag, sectMFD)) continue;
                ArrayList<Integer> binRups = (ArrayList<Integer>)rupsInBins.get(magIndex);
                if (binRups == null) {
                    binRups = new ArrayList<Integer>();
                    rupsInBins.set(magIndex, binRups);
                }
                binRups.add(rupIndex);
            }
            for (i = 0; i < sectMFD.size(); ++i) {
                int r;
                List rups = (List)rupsInBins.get(i);
                double binRate = sectMFD.getY(i);
                if (rups == null || binRate == 0.0) continue;
                if (bVals == null || bVals[s] == 0.0 || AnalyticalSingleFaultInversionSolver.allMagsSame(rupSet, rups)) {
                    double rateEach = binRate / (double)rups.size();
                    Iterator iterator = rups.iterator();
                    while (iterator.hasNext()) {
                        int rupIndex;
                        int n = rupIndex = ((Integer)iterator.next()).intValue();
                        rates[n] = rates[n] + rateEach;
                    }
                    continue;
                }
                double binCenter = sectMFD.getX(i);
                double centerGR = AnalyticalSingleFaultInversionSolver.calcGR(bVals[s], binCenter);
                double[] weights = new double[rups.size()];
                double sumWeight = 0.0;
                for (r = 0; r < weights.length; ++r) {
                    double mag = rupSet.getMagForRup((Integer)rups.get(r));
                    double myGR = AnalyticalSingleFaultInversionSolver.calcGR(bVals[s], mag);
                    double weight = myGR / centerGR;
                    sumWeight += weight;
                    weights[r] = weight;
                }
                for (r = 0; r < weights.length; ++r) {
                    int n = (Integer)rups.get(r);
                    rates[n] = rates[n] + binRate * weights[r] / sumWeight;
                }
            }
        }
        FaultSystemSolution sol = new FaultSystemSolution(rupSet, rates);
        sol.addModule(new InitialSolution(rates));
        if (waterLevel != null) {
            sol.addModule(new WaterLevelRates(waterLevel));
        }
        if (config != null) {
            sol.addModule(config);
            ImmutableList<InversionConstraint> constraints = config.getConstraints();
            if (constraints != null && !constraints.isEmpty()) {
                InversionInputGenerator inputGen = new InversionInputGenerator(rupSet, config);
                inputGen.generateInputs(false);
                double[] data_eq = inputGen.getD();
                double[] misfits_eq = new double[data_eq.length];
                SerialSimulatedAnnealing.calculateMisfit(inputGen.getA(), data_eq, rates, misfits_eq);
                double[] data_ineq = null;
                double[] misfits_ineq = null;
                if (inputGen.getA_ineq() != null) {
                    data_ineq = inputGen.getD_ineq();
                    misfits_ineq = new double[data_ineq.length];
                    SerialSimulatedAnnealing.calculateMisfit(inputGen.getA_ineq(), data_ineq, rates, misfits_ineq);
                }
                InversionMisfits misfits = new InversionMisfits(inputGen.getConstraintRowRanges(), misfits_eq, data_eq, misfits_ineq, data_ineq);
                sol.addModule(misfits);
                sol.addModule(misfits.getMisfitStats());
            }
        }
        if (info != null) {
            sol.addModule(new InfoModule(info));
        }
        return sol;
    }

    private static boolean allMagsSame(FaultSystemRupSet rupSet, List<Integer> binRups) {
        if (binRups.size() == 1) {
            return true;
        }
        Double mag = null;
        for (int rupIndex : binRups) {
            double myMag = rupSet.getMagForRup(rupIndex);
            if (mag == null) {
                mag = myMag;
                continue;
            }
            if (mag == myMag) continue;
            return false;
        }
        return true;
    }

    private static double calcGR(double bVal, double mag) {
        return Math.pow(10.0, -bVal * mag);
    }
}

