/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.gridded.SeismicityRateFileLoader;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.gridded.SeismicityRateModel;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SeismicityRateEpoch;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.util.PRVI25_RegionLoader;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="fault_sections.geojson"), @DoesNotAffect(value="indices.csv"), @DoesNotAffect(value="properties.csv"), @DoesNotAffect(value="rates.csv"), @DoesNotAffect(value="grid_region.geojson"), @DoesNotAffect(value="grid_mech_weights.csv"), @DoesNotAffect(value="grid_source_locations.csv")})
@Affects.Affected(value={@Affects(value="grid_sub_seis_mfds.csv"), @Affects(value="grid_unassociated_mfds.csv"), @Affects(value="grid_sources.csv")})
public enum PRVI25_CrustalSeismicityRate implements LogicTreeNode
{
    LOW("Lower Seismicity Bound (p2.5)", "Low", 0.13){

        @Override
        public IncrementalMagFreqDist build(PRVI25_SeismicityRateEpoch epoch, EvenlyDiscretizedFunc refMFD, double mMax) throws IOException {
            return 1.loadRateModel(epoch, TYPE).buildLower(refMFD, mMax);
        }
    }
    ,
    PREFFERRED("Preffered Seismicity Rate", "Preferred", 0.74){

        @Override
        public IncrementalMagFreqDist build(PRVI25_SeismicityRateEpoch epoch, EvenlyDiscretizedFunc refMFD, double mMax) throws IOException {
            return 2.loadRateModel(epoch, TYPE).buildPreferred(refMFD, mMax);
        }
    }
    ,
    HIGH("Upper Seismicity Bound (p97.5)", "High", 0.13){

        @Override
        public IncrementalMagFreqDist build(PRVI25_SeismicityRateEpoch epoch, EvenlyDiscretizedFunc refMFD, double mMax) throws IOException {
            return 3.loadRateModel(epoch, TYPE).buildUpper(refMFD, mMax);
        }
    }
    ,
    AVERAGE("Average Seismicity Rate", "Average", 0.0){

        @Override
        public IncrementalMagFreqDist build(PRVI25_SeismicityRateEpoch epoch, EvenlyDiscretizedFunc refMFD, double mMax) throws IOException {
            AbstractDiscretizedFunc ret = null;
            double weightSum = 0.0;
            for (PRVI25_CrustalSeismicityRate seis : 4.values()) {
                if (seis == this || seis.weight == 0.0) continue;
                weightSum += seis.weight;
                IncrementalMagFreqDist mfd = seis.build(epoch, refMFD, mMax);
                if (ret == null) {
                    ret = new IncrementalMagFreqDist(mfd.getMinX(), mfd.getMaxX(), mfd.size());
                } else {
                    Preconditions.checkState((mfd.size() == ((EvenlyDiscretizedFunc)ret).size() ? 1 : 0) != 0);
                }
                for (int i = 0; i < ((EvenlyDiscretizedFunc)ret).size(); ++i) {
                    ((EvenlyDiscretizedFunc)ret).add(i, mfd.getY(i) * seis.weight);
                }
            }
            if ((float)weightSum != 1.0f) {
                ret.scale(1.0 / weightSum);
            }
            return ret;
        }
    };

    public static String RATE_DATE;
    private static final String RATES_PATH_PREFIX = "/data/erf/prvi25/seismicity/rates/";
    public static SeismicityRateFileLoader.RateType TYPE;
    private static final UncertaintyBoundType BOUND_TYPE;
    private static Table<PRVI25_SeismicityRateEpoch, SeismicityRateFileLoader.RateType, SeismicityRateModel> rateModels;
    private static Map<PRVI25_SeismicityRateEpoch, CSVFile<String>> csvs;
    private static Double RECENT_TO_FULL_SCALAR;
    private String name;
    private String shortName;
    private double weight;

    public static String getDirectRateFileName(PRVI25_RegionLoader.PRVI25_SeismicityRegions seisReg, PRVI25_SeismicityRateEpoch epoch) {
        String vStr;
        String yearStr;
        switch (epoch) {
            case FULL: {
                yearStr = "1900";
                vStr = "-v9";
                break;
            }
            case RECENT: {
                yearStr = "1973";
                vStr = "-v10";
                break;
            }
            default: {
                throw new IllegalStateException("Can't load direct rates for epoch: " + String.valueOf(epoch));
            }
        }
        if (seisReg == null) {
            return "directrates-PRVI Union-Full-" + yearStr + "-2024" + vStr + ".csv";
        }
        return "directrates-PRVI " + seisReg.getShortName() + "-Prob-" + yearStr + "-2024" + vStr + ".csv";
    }

    public static synchronized void clearCache() {
        rateModels = null;
        csvs = null;
    }

    public abstract IncrementalMagFreqDist build(PRVI25_SeismicityRateEpoch var1, EvenlyDiscretizedFunc var2, double var3) throws IOException;

    public static List<? extends SeismicityRateFileLoader.RateRecord> loadRates(PRVI25_SeismicityRateEpoch epoch, SeismicityRateFileLoader.RateType type) throws IOException {
        if (epoch == PRVI25_SeismicityRateEpoch.RECENT_SCALED) {
            return PRVI25_CrustalSeismicityRate.getScaledToFull(PRVI25_CrustalSeismicityRate.loadRates(PRVI25_SeismicityRateEpoch.RECENT, type));
        }
        CSVFile<String> csv = PRVI25_CrustalSeismicityRate.loadCSV(epoch);
        return SeismicityRateFileLoader.loadRecords(csv, type);
    }

    public static SeismicityRateModel loadRateModel(PRVI25_SeismicityRateEpoch epoch) throws IOException {
        return PRVI25_CrustalSeismicityRate.loadRateModel(epoch, TYPE);
    }

    public static synchronized SeismicityRateModel loadRateModel(PRVI25_SeismicityRateEpoch epoch, SeismicityRateFileLoader.RateType type) throws IOException {
        SeismicityRateModel rateModel;
        if (rateModels == null) {
            rateModels = HashBasedTable.create();
        }
        if ((rateModel = (SeismicityRateModel)rateModels.get((Object)epoch, (Object)type)) != null) {
            return rateModel;
        }
        if (epoch == PRVI25_SeismicityRateEpoch.RECENT_SCALED) {
            rateModel = PRVI25_CrustalSeismicityRate.getScaledToFull(PRVI25_CrustalSeismicityRate.loadRateModel(PRVI25_SeismicityRateEpoch.RECENT, type), type);
        } else {
            CSVFile<String> csv = PRVI25_CrustalSeismicityRate.loadCSV(epoch);
            rateModel = new SeismicityRateModel(csv, type, BOUND_TYPE);
        }
        rateModels.put((Object)epoch, (Object)type, (Object)rateModel);
        return rateModel;
    }

    public static SeismicityRateModel getScaledToFull(SeismicityRateModel recentModel, SeismicityRateFileLoader.RateType type) throws IOException {
        PRVI25_CrustalSeismicityRate.checkLoadRecentToFullScalar();
        return new SeismicityRateModel(recentModel.getMeanRecord().getScaled(RECENT_TO_FULL_SCALAR), recentModel.getLowerRecord().getScaled(RECENT_TO_FULL_SCALAR), recentModel.getUpperRecord().getScaled(RECENT_TO_FULL_SCALAR), BOUND_TYPE);
    }

    public static List<? extends SeismicityRateFileLoader.RateRecord> getScaledToFull(List<? extends SeismicityRateFileLoader.RateRecord> rates) throws IOException {
        PRVI25_CrustalSeismicityRate.checkLoadRecentToFullScalar();
        ArrayList<SeismicityRateFileLoader.RateRecord> ret = new ArrayList<SeismicityRateFileLoader.RateRecord>();
        for (SeismicityRateFileLoader.RateRecord rateRecord : rates) {
            ret.add(rateRecord.getScaled(RECENT_TO_FULL_SCALAR));
        }
        return ret;
    }

    private static synchronized void checkLoadRecentToFullScalar() throws IOException {
        if (RECENT_TO_FULL_SCALAR == null) {
            double sumRecent = 0.0;
            double sumFull = 0.0;
            String commonPrefix = RATES_PATH_PREFIX + RATE_DATE + "/";
            for (PRVI25_RegionLoader.PRVI25_SeismicityRegions region : PRVI25_RegionLoader.PRVI25_SeismicityRegions.values()) {
                String recentCSVname = commonPrefix + PRVI25_SeismicityRateEpoch.RECENT.getRateSubDirName() + "/" + region.name() + ".csv";
                InputStream recentStream = PRVI25_CrustalSeismicityRate.class.getResourceAsStream(recentCSVname);
                Preconditions.checkNotNull((Object)recentStream, (String)"Error loading stream for '%s'", (Object)recentCSVname);
                CSVFile<String> recentCSV = CSVFile.readStream(recentStream, false);
                recentStream.close();
                String fullCSVname = commonPrefix + PRVI25_SeismicityRateEpoch.FULL.getRateSubDirName() + "/" + region.name() + ".csv";
                InputStream fullStream = PRVI25_CrustalSeismicityRate.class.getResourceAsStream(fullCSVname);
                Preconditions.checkNotNull((Object)fullStream, (String)"Error loading stream for '%s'", (Object)fullCSVname);
                CSVFile<String> fullCSV = CSVFile.readStream(fullStream, false);
                fullStream.close();
                SeismicityRateModel recentRegionalModel = new SeismicityRateModel(recentCSV, TYPE, BOUND_TYPE);
                SeismicityRateModel fullRegionalModel = new SeismicityRateModel(fullCSV, TYPE, BOUND_TYPE);
                SeismicityRateFileLoader.RateRecord recentMean = recentRegionalModel.getMeanRecord();
                SeismicityRateFileLoader.RateRecord fullMean = fullRegionalModel.getMeanRecord();
                Preconditions.checkState((recentMean.M1 == fullMean.M1 ? 1 : 0) != 0);
                sumRecent += recentMean.rateAboveM1;
                sumFull += fullMean.rateAboveM1;
            }
            double rateScalar = sumFull / sumRecent;
            System.out.println("Recent-to-full seismicity rate scalar:\t" + (float)sumFull + " / " + (float)sumRecent + " = " + (float)rateScalar);
            RECENT_TO_FULL_SCALAR = rateScalar;
        }
    }

    private static synchronized CSVFile<String> loadCSV(PRVI25_SeismicityRateEpoch epoch) throws IOException {
        CSVFile<String> csv;
        if (csvs == null) {
            csvs = new HashMap<PRVI25_SeismicityRateEpoch, CSVFile<String>>();
        }
        if ((csv = csvs.get(epoch)) == null) {
            String resourceName = RATES_PATH_PREFIX + RATE_DATE + "/" + epoch.getRateSubDirName() + "/" + PRVI25_RegionLoader.PRVI25_SeismicityRegions.CRUSTAL.name() + ".csv";
            InputStream stream = PRVI25_CrustalSeismicityRate.class.getResourceAsStream(resourceName);
            Preconditions.checkNotNull((Object)stream, (String)"Error loading stream for '%s'", (Object)resourceName);
            csv = CSVFile.readStream(stream, false);
            stream.close();
            csvs.put(epoch, csv);
        }
        return csv;
    }

    private PRVI25_CrustalSeismicityRate(String name, String shortName, double weight) {
        this.name = name;
        this.shortName = shortName;
        this.weight = weight;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return this.getShortName();
    }

    public static void main(String[] args) throws IOException {
        double mMax = 7.6;
        IncrementalMagFreqDist refMFD = FaultSysTools.initEmptyMFD(2.55, mMax);
        for (PRVI25_SeismicityRateEpoch epoch : PRVI25_SeismicityRateEpoch.values()) {
            float x;
            System.out.println("Epoch: " + String.valueOf(epoch));
            IncrementalMagFreqDist pref = PREFFERRED.build(epoch, refMFD, mMax);
            IncrementalMagFreqDist low = LOW.build(epoch, refMFD, mMax);
            IncrementalMagFreqDist high = HIGH.build(epoch, refMFD, mMax);
            for (int i = 0; i < refMFD.size() && !((x = (float)refMFD.getX(i)) > (float)refMFD.getClosestXIndex(mMax)); ++i) {
                if (x != 5.05f && x != 6.05f && x != 7.05f) continue;
                System.out.println(x + "\t" + (float)pref.getY(i) + "\t[" + (float)low.getY(i) + "," + (float)high.getY(i) + "]");
            }
            System.out.println();
        }
    }

    static {
        RATE_DATE = "2025_08_13";
        TYPE = SeismicityRateFileLoader.RateType.M1_TO_MMAX;
        BOUND_TYPE = UncertaintyBoundType.CONF_95;
        RECENT_TO_FULL_SCALAR = null;
    }
}

