/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.util.Precision;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.xyz.AbstractXYZ_DataSet;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.GeographicMapMaker;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_DeclusteringAlgorithms;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.util.PRVI25_RegionLoader;

@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="fault_sections.geojson"), @DoesNotAffect(value="indices.csv"), @DoesNotAffect(value="properties.csv"), @DoesNotAffect(value="rates.csv"), @DoesNotAffect(value="grid_region.geojson"), @DoesNotAffect(value="grid_mech_weights.csv"), @DoesNotAffect(value="grid_source_locations.csv")})
@Affects.Affected(value={@Affects(value="grid_sub_seis_mfds.csv"), @Affects(value="grid_unassociated_mfds.csv"), @Affects(value="grid_sources.csv")})
public enum PRVI25_SeisSmoothingAlgorithms implements LogicTreeNode
{
    ADAPTIVE("Adaptive Kernel", "Adaptive", 0.5),
    FIXED("Fixed Kernel", "Fixed", 0.5),
    AVERAGE("Average", "Average", 0.0){

        @Override
        public GriddedGeoDataSet loadXYZ(PRVI25_RegionLoader.PRVI25_SeismicityRegions region, PRVI25_DeclusteringAlgorithms declusteringAlg) throws IOException {
            ArrayList<GriddedGeoDataSet> xyzs = new ArrayList<GriddedGeoDataSet>();
            ArrayList<Double> weights = new ArrayList<Double>();
            for (PRVI25_SeisSmoothingAlgorithms smooth : 1.values()) {
                if (smooth.weight == 0.0 || smooth == this) continue;
                xyzs.add(smooth.loadXYZ(region, declusteringAlg));
                weights.add(smooth.weight);
            }
            return PRVI25_SeisSmoothingAlgorithms.average(xyzs, weights);
        }
    };

    private String name;
    private String shortName;
    private double weight;
    private static final String NSHM23_SS_PATH_PREFIX = "/data/erf/prvi25/seismicity/spatial_seis_pdfs/";
    public static String MODEL_DATE;
    private Table<PRVI25_RegionLoader.PRVI25_SeismicityRegions, PRVI25_DeclusteringAlgorithms, GriddedGeoDataSet> xyzCache;
    private boolean PRINT_UNMAPPED_GRIDS = false;
    private boolean WRITE_UNMAPPED_GRIDS = false;
    private boolean WRITE_UNMAPPED_ALWAYS = false;
    private static final DecimalFormat pDF;

    private PRVI25_SeisSmoothingAlgorithms(String name, String shortName, double weight) {
        this.name = name;
        this.shortName = shortName;
        this.weight = weight;
    }

    private String getResourceName(PRVI25_RegionLoader.PRVI25_SeismicityRegions region, PRVI25_DeclusteringAlgorithms declusteringAlg) {
        return NSHM23_SS_PATH_PREFIX + MODEL_DATE + "/" + region.name() + "/" + declusteringAlg.name() + "_" + this.name() + ".csv";
    }

    private static GriddedGeoDataSet average(List<GriddedGeoDataSet> xyzs, List<Double> weights) {
        AbstractXYZ_DataSet avg = null;
        double sumWeight = 0.0;
        for (int i = 0; i < xyzs.size(); ++i) {
            GriddedGeoDataSet xyz = xyzs.get(i);
            double weight = weights.get(i);
            if (avg == null) {
                avg = new GriddedGeoDataSet(xyz.getRegion(), false);
            } else {
                Preconditions.checkState((boolean)((GriddedGeoDataSet)avg).getRegion().equalsRegion(xyz.getRegion()));
            }
            for (int j = 0; j < xyz.size(); ++j) {
                ((GriddedGeoDataSet)avg).set(j, ((GriddedGeoDataSet)avg).get(j) + xyz.get(j) * weight);
            }
            sumWeight += weight;
        }
        if (xyzs.size() == 1) {
            return xyzs.get(0);
        }
        avg.scale(1.0 / sumWeight);
        return avg;
    }

    public double[] load(PRVI25_RegionLoader.PRVI25_SeismicityRegions region, PRVI25_DeclusteringAlgorithms declusteringAlg) throws IOException {
        return this.loadXYZ(region, declusteringAlg).getValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        PRVI25_SeisSmoothingAlgorithms[] pRVI25_SeisSmoothingAlgorithmsArray = PRVI25_SeisSmoothingAlgorithms.values();
        int n = pRVI25_SeisSmoothingAlgorithmsArray.length;
        for (int i = 0; i < n; ++i) {
            PRVI25_SeisSmoothingAlgorithms smooth;
            PRVI25_SeisSmoothingAlgorithms pRVI25_SeisSmoothingAlgorithms = smooth = pRVI25_SeisSmoothingAlgorithmsArray[i];
            synchronized (pRVI25_SeisSmoothingAlgorithms) {
                smooth.xyzCache = null;
                continue;
            }
        }
    }

    public synchronized GriddedGeoDataSet loadXYZ(PRVI25_RegionLoader.PRVI25_SeismicityRegions region, PRVI25_DeclusteringAlgorithms declusteringAlg) throws IOException {
        GriddedGeoDataSet cached;
        if (this.xyzCache == null) {
            this.xyzCache = HashBasedTable.create();
        }
        if ((cached = (GriddedGeoDataSet)this.xyzCache.get((Object)region, (Object)declusteringAlg)) != null) {
            return cached;
        }
        if (declusteringAlg == PRVI25_DeclusteringAlgorithms.AVERAGE) {
            ArrayList<GriddedGeoDataSet> xyzs = new ArrayList<GriddedGeoDataSet>();
            ArrayList<Double> weights = new ArrayList<Double>();
            for (PRVI25_DeclusteringAlgorithms alg : PRVI25_DeclusteringAlgorithms.values()) {
                double weight = alg.getNodeWeight(null);
                if (weight == 0.0 || alg == PRVI25_DeclusteringAlgorithms.AVERAGE) continue;
                xyzs.add(this.loadXYZ(region, alg));
                weights.add(weight);
            }
            GriddedGeoDataSet average = PRVI25_SeisSmoothingAlgorithms.average(xyzs, weights);
            this.xyzCache.put((Object)region, (Object)declusteringAlg, (Object)average);
            return average;
        }
        String resource = this.getResourceName(region, declusteringAlg);
        System.out.println("Loading spatial seismicity PDF from: " + resource);
        InputStream is = PRVI25_SeisSmoothingAlgorithms.class.getResourceAsStream(resource);
        Preconditions.checkNotNull((Object)is, (String)"Spatial seismicity PDF not found: %s", (Object)resource);
        CSVFile<String> csv = CSVFile.readStream(is, true);
        Region reg = region.load();
        GriddedRegion gridReg = new GriddedRegion(reg, 0.1, GriddedRegion.ANCHOR_0_0);
        GriddedGeoDataSet xyz = new GriddedGeoDataSet(gridReg, false);
        double sum = 0.0;
        int numMapped = 0;
        ArrayList<Location> mappedLocs = new ArrayList<Location>();
        ArrayList<Location> unmappedLocs = new ArrayList<Location>();
        for (int row = 0; row < csv.getNumRows(); ++row) {
            double lon = csv.getDouble(row, 0);
            double lat = csv.getDouble(row, 1);
            double val = csv.getDouble(row, 2);
            sum += val;
            Location loc = new Location(lat, lon);
            int gridIndex = gridReg.indexForLocation(loc);
            if (gridIndex >= 0) {
                ++numMapped;
                Preconditions.checkState((xyz.get(gridIndex) == 0.0 ? 1 : 0) != 0);
                xyz.set(gridIndex, val);
                mappedLocs.add(loc);
                continue;
            }
            if (!(val > 0.0)) continue;
            unmappedLocs.add(loc);
            if (!this.PRINT_UNMAPPED_GRIDS) continue;
            System.out.println("Unmapped: " + String.valueOf(loc) + " = " + val);
        }
        double sumMapped = xyz.getSumZ();
        System.out.println("totWeight=" + (float)sum + ";\tmappedWeight=" + (float)sumMapped + "; mapping results:");
        System.out.println("\t" + numMapped + "/" + csv.getNumRows() + " (" + pDF.format((double)numMapped / (double)csv.getNumRows()) + ") of locations from input CSV mapped");
        System.out.println("\t" + numMapped + "/" + gridReg.getNodeCount() + " (" + pDF.format((double)numMapped / (double)gridReg.getNodeCount()) + ") of gridded region mapped");
        Preconditions.checkState((boolean)Precision.equals((double)sumMapped, (double)1.0, (double)0.01), (String)"PDF (%s) doesn't sum to 1 when mapped to region: sum=%s, sumMapped=%s", (Object)resource, (Object)Float.valueOf((float)sum), (Object)Float.valueOf((float)sumMapped));
        xyz.scale(1.0 / sumMapped);
        this.xyzCache.put((Object)region, (Object)declusteringAlg, (Object)xyz);
        if (this.WRITE_UNMAPPED_ALWAYS || this.WRITE_UNMAPPED_GRIDS && !unmappedLocs.isEmpty()) {
            File outputDir = new File("/tmp");
            String prefix = "UNMAPPED_DEBUG_" + region.name() + "_" + declusteringAlg.name() + "_" + this.name();
            System.out.println("Writing unmapped location map to: " + new File(outputDir, prefix).getAbsolutePath());
            GeographicMapMaker mapMaker = new GeographicMapMaker(reg);
            mapMaker.setRegionOutlineChar(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK), true);
            ArrayList<Location> combLocs = new ArrayList<Location>();
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
            combLocs.addAll(mappedLocs);
            PlotCurveCharacterstics mappedChar = new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 3.0f, Color.GREEN.darker());
            while (chars.size() < combLocs.size()) {
                chars.add(mappedChar);
            }
            combLocs.addAll(unmappedLocs);
            PlotCurveCharacterstics unmappedChar = new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 3.0f, Color.RED.darker());
            while (chars.size() < combLocs.size()) {
                chars.add(unmappedChar);
            }
            mapMaker.plotScatters(combLocs, chars, null);
            mapMaker.plot(outputDir, prefix, reg.getName() + ", " + declusteringAlg.getShortName() + ", " + this.getShortName() + " Mappings");
        }
        return xyz;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return this.name();
    }

    public static void main(String[] args) throws IOException {
        HashMap<PRVI25_RegionLoader.PRVI25_SeismicityRegions, Double> fracts = new HashMap<PRVI25_RegionLoader.PRVI25_SeismicityRegions, Double>();
        for (PRVI25_RegionLoader.PRVI25_SeismicityRegions region : PRVI25_RegionLoader.PRVI25_SeismicityRegions.values()) {
            for (PRVI25_DeclusteringAlgorithms alg : PRVI25_DeclusteringAlgorithms.values()) {
                if (alg != PRVI25_DeclusteringAlgorithms.AVERAGE) continue;
                for (PRVI25_SeisSmoothingAlgorithms smooth : PRVI25_SeisSmoothingAlgorithms.values()) {
                    if (smooth != AVERAGE) continue;
                    System.out.println(region.name() + ",\t" + alg.name() + ",\t" + smooth.name());
                    double[] xyz = smooth.load(region, alg);
                    fracts.put(region, StatUtils.sum((double[])xyz));
                }
            }
        }
        for (PRVI25_RegionLoader.PRVI25_SeismicityRegions region : PRVI25_RegionLoader.PRVI25_SeismicityRegions.values()) {
            System.out.println(String.valueOf(region) + ":\t" + ((Double)fracts.get(region)).floatValue());
        }
    }

    static {
        MODEL_DATE = "2025_08_01";
        pDF = new DecimalFormat("0.00%");
    }
}

