/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.opensha.commons.data.uncertainty.UncertainBoundedIncrMagFreqDist;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.RupSetDeformationModel;
import org.opensha.sha.earthquake.faultSysSolution.RupSetFaultModel;
import org.opensha.sha.earthquake.faultSysSolution.RupSetSubsectioningModel;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModelRegion;
import org.opensha.sha.earthquake.faultSysSolution.modules.RegionsOfInterest;
import org.opensha.sha.earthquake.faultSysSolution.modules.RupSetTectonicRegimes;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.GeoJSONFaultReader;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.faultSysSolution.util.SubSectionBuilder;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.gridded.PRVI25_GridSourceBuilder;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SeismicityRateEpoch;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SubductionCaribbeanSeismicityRate;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SubductionDeformationModels;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SubductionMuertosSeismicityRate;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SubductionSlabMMax;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.util.PRVI25_RegionLoader;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.util.TectonicRegionType;

@Affects.Affected(value={@Affects(value="fault_sections.geojson"), @Affects(value="indices.csv"), @Affects(value="properties.csv"), @Affects(value="rates.csv"), @Affects(value="grid_sources.csv")})
@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="grid_region.geojson"), @DoesNotAffect(value="grid_source_locations.csv")})
public enum PRVI25_SubductionFaultModels implements RupSetFaultModel,
RupSetSubsectioningModel
{
    PRVI_SUB_FM_LARGE("Subduction FM, Large", "Large", 0.5),
    PRVI_SUB_FM_SMALL("Subduction FM, Small", "Small", 0.5);

    private static final String VERSION = "v5";
    private static final String PREFIX = "/data/erf/prvi25/fault_models/subduction/v5/";
    private String name;
    private String shortName;
    private String jsonPath;
    private double weight;

    private PRVI25_SubductionFaultModels(String name, String shortName, double weight) {
        this.name = name;
        this.shortName = shortName;
        this.jsonPath = "/data/erf/prvi25/fault_models/subduction/v5/PRVI_sub_v5_fault_model_" + this.name() + ".geojson";
        this.weight = weight;
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return this.name();
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<? extends FaultSection> getFaultSections() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(PRVI25_SubductionFaultModels.class.getResourceAsStream(this.jsonPath)));
        return GeoJSONFaultReader.readFaultSections(reader);
    }

    public static ModelRegion getDefaultRegion(LogicTreeBranch<?> branch) throws IOException {
        return new ModelRegion(PRVI25_RegionLoader.loadPRVI_ModelBroad());
    }

    @Override
    public void attachDefaultModules(final FaultSystemRupSet rupSet) {
        final LogicTreeBranch branch = rupSet.getModule(LogicTreeBranch.class);
        rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<ModelRegion>(){
            final /* synthetic */ PRVI25_SubductionFaultModels this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ModelRegion call() throws Exception {
                return PRVI25_SubductionFaultModels.getDefaultRegion(branch);
            }
        }, ModelRegion.class);
        rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<RupSetTectonicRegimes>(){
            final /* synthetic */ PRVI25_SubductionFaultModels this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public RupSetTectonicRegimes call() throws Exception {
                TectonicRegionType[] regimes = new TectonicRegionType[rupSet.getNumRuptures()];
                for (int r = 0; r < regimes.length; ++r) {
                    regimes[r] = TectonicRegionType.SUBDUCTION_INTERFACE;
                }
                return new RupSetTectonicRegimes(rupSet, regimes);
            }
        }, RupSetTectonicRegimes.class);
        rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<RegionsOfInterest>(){
            final /* synthetic */ PRVI25_SubductionFaultModels this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public RegionsOfInterest call() throws Exception {
                UncertainBoundedIncrMagFreqDist mfd;
                double weight;
                ArrayList<Double> weights;
                ArrayList<UncertainBoundedIncrMagFreqDist> mfds;
                ArrayList<Region> regions = new ArrayList<Region>();
                ArrayList<IncrementalMagFreqDist> regionMFDs = new ArrayList<IncrementalMagFreqDist>();
                ArrayList<TectonicRegionType> regionTRTs = new ArrayList<TectonicRegionType>();
                regions.add(PRVI25_RegionLoader.loadPRVI_ModelBroad());
                regionMFDs.add(null);
                regionTRTs.add(null);
                Region mapRegion = PRVI25_RegionLoader.loadPRVI_MapExtents();
                mapRegion.setName("PRVI - NSHMP Map Region");
                regions.add(mapRegion);
                regionMFDs.add(null);
                regionTRTs.add(null);
                PRVI25_RegionLoader.PRVI25_SeismicityRegions[] interfaceRegions = new PRVI25_RegionLoader.PRVI25_SeismicityRegions[]{PRVI25_RegionLoader.PRVI25_SeismicityRegions.CAR_INTERFACE, PRVI25_RegionLoader.PRVI25_SeismicityRegions.MUE_INTERFACE};
                double mMax = 0.0;
                for (int s = 0; s < rupSet.getNumSections(); ++s) {
                    mMax = Math.max(mMax, rupSet.getMaxMagForSection(s));
                }
                IncrementalMagFreqDist interfaceRefMFD = FaultSysTools.initEmptyMFD(2.55, mMax + 0.1);
                for (PRVI25_RegionLoader.PRVI25_SeismicityRegions seisReg : interfaceRegions) {
                    if (seisReg == PRVI25_RegionLoader.PRVI25_SeismicityRegions.MUE_INTERFACE && PRVI25_GridSourceBuilder.MUERTOS_AS_CRUSTAL) continue;
                    ArrayList<Double> minMags = new ArrayList<Double>();
                    ArrayList<Double> maxMags = new ArrayList<Double>();
                    Region reg = seisReg.load();
                    for (FaultSection faultSection : rupSet.getFaultSectionDataList()) {
                        boolean contained = false;
                        for (Location loc : faultSection.getFaultSurface(10.0).getPerimeter()) {
                            if (!reg.contains(loc)) continue;
                            contained = true;
                            break;
                        }
                        if (!contained) continue;
                        minMags.add(rupSet.getMinMagForSection(faultSection.getSectionId()));
                        maxMags.add(rupSet.getMaxMagForSection(faultSection.getSectionId()));
                    }
                    Preconditions.checkState((!minMags.isEmpty() ? 1 : 0) != 0);
                    double dataMmax = maxMags.stream().mapToDouble(D -> D).max().getAsDouble();
                    dataMmax = interfaceRefMFD.getX(interfaceRefMFD.getClosestXIndex(dataMmax));
                    regions.add(reg);
                    mfds = new ArrayList<UncertainBoundedIncrMagFreqDist>();
                    weights = new ArrayList<Double>();
                    for (PRVI25_SeismicityRateEpoch epoch : PRVI25_SeismicityRateEpoch.values()) {
                        weight = epoch.getNodeWeight(branch);
                        if (weight == 0.0) continue;
                        mfd = seisReg == PRVI25_RegionLoader.PRVI25_SeismicityRegions.CAR_INTERFACE ? PRVI25_SubductionCaribbeanSeismicityRate.loadRateModel(epoch, false).getBounded(interfaceRefMFD, dataMmax) : PRVI25_SubductionMuertosSeismicityRate.loadRateModel(epoch, false).getBounded(interfaceRefMFD, dataMmax);
                        mfds.add(mfd);
                        weights.add(weight);
                    }
                    regionMFDs.add(PRVI25_SeismicityRateEpoch.averageUncert(mfds, weights));
                    regionTRTs.add(TectonicRegionType.SUBDUCTION_INTERFACE);
                }
                PRVI25_RegionLoader.PRVI25_SeismicityRegions[] slabRegions = new PRVI25_RegionLoader.PRVI25_SeismicityRegions[]{PRVI25_RegionLoader.PRVI25_SeismicityRegions.CAR_INTRASLAB, PRVI25_RegionLoader.PRVI25_SeismicityRegions.MUE_INTRASLAB};
                PRVI25_SubductionSlabMMax slabMmaxBranch = PRVI25_SubductionSlabMMax.DEFAULT;
                double slabMmaxOff = slabMmaxBranch.getMmax();
                IncrementalMagFreqDist slabRefMFD = FaultSysTools.initEmptyMFD(2.55, slabMmaxOff);
                Preconditions.checkState(((slabMmaxOff = slabRefMFD.getX(slabRefMFD.getClosestXIndex(slabMmaxOff - 0.01))) <= slabMmaxBranch.getMmax() ? 1 : 0) != 0);
                for (PRVI25_RegionLoader.PRVI25_SeismicityRegions pRVI25_SeismicityRegions : slabRegions) {
                    regions.add(pRVI25_SeismicityRegions.load());
                    mfds = new ArrayList();
                    weights = new ArrayList();
                    for (PRVI25_SeismicityRateEpoch epoch : PRVI25_SeismicityRateEpoch.values()) {
                        weight = epoch.getNodeWeight(branch);
                        if (weight == 0.0) continue;
                        mfd = pRVI25_SeismicityRegions == PRVI25_RegionLoader.PRVI25_SeismicityRegions.CAR_INTRASLAB ? PRVI25_SubductionCaribbeanSeismicityRate.loadRateModel(epoch, true).getBounded(slabRefMFD, slabMmaxOff) : PRVI25_SubductionMuertosSeismicityRate.loadRateModel(epoch, true).getBounded(slabRefMFD, slabMmaxOff);
                        mfds.add(mfd);
                        weights.add(weight);
                    }
                    regionMFDs.add(PRVI25_SeismicityRateEpoch.averageUncert(mfds, weights));
                    regionTRTs.add(TectonicRegionType.SUBDUCTION_SLAB);
                }
                return new RegionsOfInterest(regions, regionMFDs, regionTRTs);
            }
        }, RegionsOfInterest.class);
    }

    @Override
    public RupSetDeformationModel getDefaultDeformationModel() {
        return PRVI25_SubductionDeformationModels.FULL;
    }

    @Override
    public List<? extends FaultSection> buildSubSects(RupSetFaultModel faultModel, List<? extends FaultSection> fullSections) {
        return SubSectionBuilder.buildSubSects(fullSections, 2, 0.5, 30.0);
    }
}

