/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.util;

import com.google.common.base.Preconditions;
import java.util.List;
import org.opensha.commons.data.Site;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.sha.earthquake.PointSource;
import org.opensha.sha.faultSurface.RuptureSurface;

public class SiteDistanceDependentPoissonPointSourceData
implements PointSource.SiteAdaptivePointSourceData<PointSource.PoissonPointSourceData>,
PointSource.PoissonPointSourceData {
    protected Location centerLoc;
    protected List<PointSource.PoissonPointSourceData> datas;
    protected List<Double> cutoffDistances;
    protected PointSource.PoissonPointSourceData fallbackData;
    protected double maxCutoffDist;

    public SiteDistanceDependentPoissonPointSourceData(Location centerLoc, PointSource.PoissonPointSourceData nearbyData, double cutoffDistance, PointSource.PoissonPointSourceData fallbackData) {
        this(centerLoc, List.of(nearbyData), List.of(Double.valueOf(cutoffDistance)), fallbackData);
    }

    public SiteDistanceDependentPoissonPointSourceData(Location centerLoc, List<PointSource.PoissonPointSourceData> datas, List<Double> cutoffDistances, PointSource.PoissonPointSourceData fallbackData) {
        this.init(centerLoc, datas, cutoffDistances, fallbackData);
    }

    protected SiteDistanceDependentPoissonPointSourceData() {
    }

    protected void init(Location centerLoc, List<PointSource.PoissonPointSourceData> datas, List<Double> cutoffDistances, PointSource.PoissonPointSourceData fallbackData) {
        this.centerLoc = centerLoc;
        this.datas = datas;
        this.cutoffDistances = cutoffDistances;
        this.fallbackData = fallbackData;
        Preconditions.checkArgument((datas.size() == cutoffDistances.size() ? 1 : 0) != 0);
        for (int i = 1; i < cutoffDistances.size(); ++i) {
            double dist0 = cutoffDistances.get(i - 1);
            double dist1 = cutoffDistances.get(i);
            Preconditions.checkState((dist1 > dist0 ? 1 : 0) != 0, (String)"Distances must monotonically increasing; cutoffDistances[%s]=%s, cutoffDistances[%s]=%s", (Object)(i - 1), (Object)dist0, (Object)i, (Object)dist1);
        }
        this.maxCutoffDist = cutoffDistances.get(cutoffDistances.size() - 1);
    }

    @Override
    public int getNumRuptures() {
        return this.fallbackData.getNumRuptures();
    }

    @Override
    public double getMagnitude(int rupIndex) {
        return this.fallbackData.getMagnitude(rupIndex);
    }

    @Override
    public double getAveRake(int rupIndex) {
        return this.fallbackData.getAveRake(rupIndex);
    }

    @Override
    public double getRate(int rupIndex) {
        return this.fallbackData.getRate(rupIndex);
    }

    @Override
    public RuptureSurface getSurface(int rupIndex) {
        return this.fallbackData.getSurface(rupIndex);
    }

    @Override
    public boolean isFinite(int rupIndex) {
        return this.fallbackData.isFinite(rupIndex);
    }

    @Override
    public Location getHypocenter(Location sourceLoc, RuptureSurface rupSurface, int rupIndex) {
        return this.fallbackData.getHypocenter(sourceLoc, rupSurface, rupIndex);
    }

    @Override
    public PointSource.PoissonPointSourceData getForSite(Site site) {
        double dist = LocationUtils.horzDistanceFast(this.centerLoc, site.getLocation());
        return this.getForDistance(dist);
    }

    public PointSource.PoissonPointSourceData getForDistance(double dist) {
        if ((float)dist > (float)this.maxCutoffDist) {
            return this;
        }
        for (int i = 0; i < this.datas.size(); ++i) {
            if (!((float)dist <= this.cutoffDistances.get(i).floatValue())) continue;
            return this.datas.get(i);
        }
        throw new IllegalStateException("Distance (" + (float)dist + ") not found and < maxCutoffDistance (" + (float)this.maxCutoffDist + ")?");
    }

    @Override
    public boolean isDiscrete() {
        return true;
    }
}

