/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.examples;

import java.awt.geom.Point2D;
import java.util.Iterator;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.Parameter;
import org.opensha.sha.calc.HazardCurveCalculator;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.MeanUCERF2.MeanUCERF2;
import org.opensha.sha.gui.infoTools.IMT_Info;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.attenRelImpl.ngaw2.NGAW2_Wrappers;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;

public class HazardCurveCalcExample {
    public static void main(String[] args) {
        Location loc = new Location(34.0, -118.0);
        Site site = new Site(loc);
        MeanUCERF2 erf = new MeanUCERF2();
        System.out.println(erf.getName() + " adjustable parameters and current values:");
        for (Parameter<?> param : erf.getAdjustableParameterList()) {
            Iterator<Parameter<?>> name = param.getName();
            Object value = param.getValue();
            System.out.println("\t" + (String)((Object)name) + ": " + String.valueOf(value));
        }
        erf.setParameter("Probability Model", "Poisson");
        TimeSpan timeSpan = erf.getTimeSpan();
        timeSpan.setDuration(30.0);
        System.out.println("Updating forecast...");
        erf.updateForecast();
        System.out.println("DONE updating forecast");
        NGAW2_Wrappers.ASK_2014_Wrapper gmpe = new NGAW2_Wrappers.ASK_2014_Wrapper();
        gmpe.setParamDefaults();
        System.out.println(gmpe.getShortName() + " site paramters and default values:");
        for (Parameter<?> param : gmpe.getSiteParams()) {
            String name = param.getName();
            Object value = param.getValue();
            System.out.println("\t" + (String)name + ": " + String.valueOf(value));
            site.addParameter((Parameter)param.clone());
        }
        site.getParameter(Double.class, "Vs30").setValue(500.0);
        System.out.println(gmpe.getShortName() + " supported intensity measures:");
        for (Parameter<?> param : gmpe.getSupportedIntensityMeasures()) {
            System.out.println("\t" + param.getName());
        }
        gmpe.setIntensityMeasure("PGA");
        ArbitrarilyDiscretizedFunc linearXVals = new IMT_Info().getDefaultHazardCurve(gmpe.getIntensityMeasure());
        ArbitrarilyDiscretizedFunc hazardCurve = new ArbitrarilyDiscretizedFunc();
        for (Point2D pt : linearXVals) {
            hazardCurve.set(Math.log(pt.getX()), 0.0);
        }
        HazardCurveCalculator curveCalc = new HazardCurveCalculator();
        System.out.println("Calculating hazard curve...");
        curveCalc.getHazardCurve((DiscretizedFunc)hazardCurve, site, (ScalarIMR)gmpe, (ERF)erf);
        System.out.println("DONE calculating hazard curve");
        System.out.println("Hazard curve (with log x-values):\n" + String.valueOf(hazardCurve));
        gmpe.setIntensityMeasure("SA");
        SA_Param.setPeriodInSA_Param(gmpe.getIntensityMeasure(), 1.0);
        curveCalc.getHazardCurve((DiscretizedFunc)hazardCurve, site, (ScalarIMR)gmpe, (ERF)erf);
        System.out.println("SA hazard curve:\n" + String.valueOf(hazardCurve));
    }
}

