/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.Region;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.cache.CacheEnabledSurface;
import org.opensha.sha.faultSurface.cache.SurfaceCachingPolicy;
import org.opensha.sha.faultSurface.cache.SurfaceDistanceCache;
import org.opensha.sha.faultSurface.cache.SurfaceDistances;
import org.opensha.sha.faultSurface.utils.GriddedSurfaceUtils;

public class CompoundSurface
implements RuptureSurface,
CacheEnabledSurface {
    List<? extends RuptureSurface> surfaces;
    static final boolean D = false;
    boolean[] reverseSurfTrace;
    boolean reverseOrderOfSurfaces = false;
    double aveDip;
    double totArea;
    double aveLength = -1.0;
    double aveRupTopDepth = -1.0;
    double aveWidth = -1.0;
    double aveGridSpacing = -1.0;
    FaultTrace upperEdge = null;
    private SurfaceDistanceCache cache = SurfaceCachingPolicy.build(this);

    public CompoundSurface(List<? extends RuptureSurface> surfaces) {
        this.surfaces = surfaces;
        this.computeInitialStuff();
    }

    public List<? extends RuptureSurface> getSurfaceList() {
        return this.surfaces;
    }

    public boolean isSubSurfaceReversed(int index) {
        return this.reverseSurfTrace[index];
    }

    private void computeInitialStuff() {
        int i;
        this.reverseSurfTrace = new boolean[this.surfaces.size()];
        RuptureSurface surf1 = this.surfaces.get(0);
        RuptureSurface surf2 = this.surfaces.get(1);
        double[] dist = new double[]{LocationUtils.horzDistanceFast(surf1.getFirstLocOnUpperEdge(), surf2.getFirstLocOnUpperEdge()), LocationUtils.horzDistanceFast(surf1.getFirstLocOnUpperEdge(), surf2.getLastLocOnUpperEdge()), LocationUtils.horzDistanceFast(surf1.getLastLocOnUpperEdge(), surf2.getFirstLocOnUpperEdge()), LocationUtils.horzDistanceFast(surf1.getLastLocOnUpperEdge(), surf2.getLastLocOnUpperEdge())};
        double min = dist[0];
        int minIndex = 0;
        for (i = 1; i < 4; ++i) {
            if (!(dist[i] < min)) continue;
            minIndex = i;
            min = dist[i];
        }
        if (minIndex == 0) {
            this.reverseSurfTrace[0] = true;
            this.reverseSurfTrace[1] = false;
        } else if (minIndex == 1) {
            this.reverseSurfTrace[0] = true;
            this.reverseSurfTrace[1] = true;
        } else if (minIndex == 2) {
            this.reverseSurfTrace[0] = false;
            this.reverseSurfTrace[1] = false;
        } else {
            this.reverseSurfTrace[0] = false;
            this.reverseSurfTrace[1] = true;
        }
        for (i = 1; i < this.surfaces.size() - 1; ++i) {
            double d2;
            surf1 = this.surfaces.get(i);
            surf2 = this.surfaces.get(i + 1);
            double d1 = LocationUtils.horzDistanceFast(surf1.getLastLocOnUpperEdge(), surf2.getFirstLocOnUpperEdge());
            this.reverseSurfTrace[i + 1] = !(d1 < (d2 = LocationUtils.horzDistanceFast(surf1.getLastLocOnUpperEdge(), surf2.getLastLocOnUpperEdge())));
        }
        this.aveDip = 0.0;
        this.totArea = 0.0;
        for (int s = 0; s < this.surfaces.size(); ++s) {
            double dip;
            RuptureSurface surf = this.surfaces.get(s);
            double area = surf.getArea();
            try {
                dip = surf.getAveDip();
            }
            catch (Exception e) {
                dip = Double.NaN;
            }
            this.totArea += area;
            if (this.reverseSurfTrace[s]) {
                this.aveDip += (180.0 - dip) * area;
                continue;
            }
            this.aveDip += dip * area;
        }
        this.aveDip /= this.totArea;
        if (this.aveDip > 90.0) {
            this.aveDip = 180.0 - this.aveDip;
            this.reverseOrderOfSurfaces = true;
        }
    }

    @Override
    public double getArea() {
        return this.totArea;
    }

    @Override
    public double getAveDip() {
        return this.aveDip;
    }

    @Override
    public double getAveDipDirection() {
        return this.getUpperEdge().getDipDirection();
    }

    @Override
    public synchronized double getAveGridSpacing() {
        if (this.aveGridSpacing == -1.0) {
            this.aveGridSpacing = 0.0;
            for (RuptureSurface ruptureSurface : this.surfaces) {
                this.aveGridSpacing += ruptureSurface.getAveGridSpacing() * ruptureSurface.getArea();
            }
            this.aveGridSpacing /= this.getArea();
        }
        return this.aveGridSpacing;
    }

    @Override
    public synchronized double getAveLength() {
        if (this.aveLength == -1.0) {
            this.aveLength = 0.0;
            for (RuptureSurface ruptureSurface : this.surfaces) {
                this.aveLength += ruptureSurface.getAveLength();
            }
        }
        return this.aveLength;
    }

    @Override
    public synchronized double getAveRupTopDepth() {
        if (this.aveRupTopDepth == -1.0) {
            this.aveRupTopDepth = 0.0;
            for (RuptureSurface ruptureSurface : this.surfaces) {
                this.aveRupTopDepth += ruptureSurface.getAveRupTopDepth() * ruptureSurface.getArea();
            }
            this.aveRupTopDepth /= this.getArea();
        }
        return this.aveRupTopDepth;
    }

    @Override
    public double getAveStrike() {
        return this.getUpperEdge().getAveStrike();
    }

    @Override
    public synchronized double getAveWidth() {
        if (this.aveWidth == -1.0) {
            this.aveWidth = 0.0;
            for (RuptureSurface ruptureSurface : this.surfaces) {
                this.aveWidth += ruptureSurface.getAveWidth() * ruptureSurface.getArea();
            }
            this.aveWidth /= this.getArea();
        }
        return this.aveWidth;
    }

    @Override
    public CompoundSurfaceDistances calcDistances(Location loc) {
        double distanceJB = Double.MAX_VALUE;
        double distanceSeis = Double.MAX_VALUE;
        double distanceRup = Double.MAX_VALUE;
        int distXidx = -1;
        for (int i = 0; i < this.surfaces.size(); ++i) {
            RuptureSurface surf = this.surfaces.get(i);
            double dist = surf.getDistanceJB(loc);
            if (dist < distanceJB) {
                distanceJB = dist;
            }
            if ((dist = surf.getDistanceRup(loc)) < distanceRup) {
                distanceRup = dist;
                distXidx = i;
            }
            if (!((dist = surf.getDistanceSeis(loc)) < distanceSeis)) continue;
            distanceSeis = dist;
        }
        return new CompoundSurfaceDistances(distanceRup, distanceJB, distanceSeis, distXidx);
    }

    @Override
    public double calcDistanceX(Location loc) {
        CompoundSurfaceDistances distances = (CompoundSurfaceDistances)this.cache.getSurfaceDistances(loc);
        return this.surfaces.get(distances.distXIndex).getDistanceX(loc);
    }

    @Override
    public double getDistanceJB(Location siteLoc) {
        return this.cache.getSurfaceDistances(siteLoc).getDistanceJB();
    }

    @Override
    public double getDistanceRup(Location siteLoc) {
        return this.cache.getSurfaceDistances(siteLoc).getDistanceRup();
    }

    @Override
    public double getQuickDistance(Location siteLoc) {
        return this.cache.getQuickDistance(siteLoc);
    }

    @Override
    public double calcQuickDistance(Location siteLoc) {
        double minDist = Double.POSITIVE_INFINITY;
        for (RuptureSurface ruptureSurface : this.surfaces) {
            minDist = Math.min(minDist, ruptureSurface.getQuickDistance(siteLoc));
        }
        return minDist;
    }

    @Override
    public double getDistanceSeis(Location siteLoc) {
        return this.cache.getSurfaceDistances(siteLoc).getDistanceSeis();
    }

    @Override
    public double getDistanceX(Location siteLoc) {
        return this.cache.getDistanceX(siteLoc);
    }

    @Override
    public int getEvenlyDiscretizedNumLocs() {
        int numLocs = 0;
        for (RuptureSurface ruptureSurface : this.surfaces) {
            numLocs += ruptureSurface.getEvenlyDiscretizedNumLocs();
        }
        return numLocs;
    }

    @Override
    public Location getEvenlyDiscretizedLocation(int index) {
        int prevNum = 0;
        for (RuptureSurface ruptureSurface : this.surfaces) {
            int myNum = ruptureSurface.getEvenlyDiscretizedNumLocs();
            if (index < prevNum + myNum) {
                return ruptureSurface.getEvenlyDiscretizedLocation(index - prevNum);
            }
            prevNum += myNum;
        }
        throw new IllegalStateException("No point at index " + index + ", have " + this.getEvenlyDiscretizedNumLocs());
    }

    @Override
    public LocationList getEvenlyDiscritizedListOfLocsOnSurface() {
        int count = 0;
        ArrayList<LocationList> surfLists = new ArrayList<LocationList>(this.surfaces.size());
        for (RuptureSurface ruptureSurface : this.surfaces) {
            LocationList surfList = ruptureSurface.getEvenlyDiscritizedListOfLocsOnSurface();
            count += surfList.size();
            surfLists.add(surfList);
        }
        LocationList locs = new LocationList(count);
        for (LocationList surfList : surfLists) {
            locs.addAll(surfList);
        }
        return locs;
    }

    @Override
    public LocationList getEvenlyDiscritizedPerimeter() {
        LocationList perimeter = new LocationList();
        FaultTrace upper = this.getEvenlyDiscritizedUpperEdge();
        FaultTrace lower = this.getEvenlyDiscritizedLowerEdge();
        LocationList right = GriddedSurfaceUtils.getEvenlyDiscretizedLine(upper.last(), lower.last(), this.getAveGridSpacing());
        LocationList left = GriddedSurfaceUtils.getEvenlyDiscretizedLine(lower.first(), upper.first(), this.getAveGridSpacing());
        perimeter.addAll(upper);
        perimeter.addAll(right);
        int i = lower.size();
        while (--i >= 0) {
            perimeter.add((Location)lower.get(i));
        }
        perimeter.addAll(left);
        return perimeter;
    }

    @Override
    public FaultTrace getEvenlyDiscritizedUpperEdge() {
        return this.getEvenlyDiscretizedEdge(true);
    }

    @Override
    public FaultTrace getEvenlyDiscritizedLowerEdge() {
        return this.getEvenlyDiscretizedEdge(false);
    }

    private FaultTrace getEvenlyDiscretizedEdge(boolean upper) {
        FaultTrace evenUpperEdge = new FaultTrace(null);
        if (this.reverseOrderOfSurfaces) {
            for (int s = this.surfaces.size() - 1; s >= 0; --s) {
                int i;
                LocationList trace = upper ? this.surfaces.get(s).getEvenlyDiscritizedUpperEdge() : this.surfaces.get(s).getEvenlyDiscritizedLowerEdge();
                if (this.reverseSurfTrace[s]) {
                    for (i = 0; i < trace.size(); ++i) {
                        evenUpperEdge.add((Location)trace.get(i));
                    }
                    continue;
                }
                for (i = trace.size() - 1; i >= 0; --i) {
                    evenUpperEdge.add((Location)trace.get(i));
                }
            }
        } else {
            for (int s = 0; s < this.surfaces.size(); ++s) {
                int i;
                LocationList trace = upper ? this.surfaces.get(s).getEvenlyDiscritizedUpperEdge() : this.surfaces.get(s).getEvenlyDiscritizedLowerEdge();
                if (this.reverseSurfTrace[s]) {
                    for (i = trace.size() - 1; i >= 0; --i) {
                        evenUpperEdge.add((Location)trace.get(i));
                    }
                    continue;
                }
                for (i = 0; i < trace.size(); ++i) {
                    evenUpperEdge.add((Location)trace.get(i));
                }
            }
        }
        return evenUpperEdge;
    }

    @Override
    public Location getFirstLocOnUpperEdge() {
        return (Location)this.getUpperEdge().get(0);
    }

    @Override
    public Location getLastLocOnUpperEdge() {
        return (Location)this.getUpperEdge().get(this.getUpperEdge().size() - 1);
    }

    @Override
    public double getFractionOfSurfaceInRegion(Region region) {
        LocationList locList = this.getEvenlyDiscritizedListOfLocsOnSurface();
        double numInside = 0.0;
        for (Location loc : locList) {
            if (!region.contains(loc)) continue;
            numInside += 1.0;
        }
        return numInside / (double)locList.size();
    }

    @Override
    public String getInfo() {
        return "";
    }

    @Override
    public ListIterator<Location> getLocationsIterator() {
        return this.getEvenlyDiscritizedListOfLocsOnSurface().listIterator();
    }

    @Override
    public LocationList getPerimeter() {
        return this.getEvenlyDiscritizedPerimeter();
    }

    @Override
    public synchronized FaultTrace getUpperEdge() {
        block14: {
            if (this.upperEdge != null) break block14;
            this.upperEdge = new FaultTrace(null);
            if (this.reverseOrderOfSurfaces) {
                for (int s = this.surfaces.size() - 1; s >= 0; --s) {
                    int i;
                    FaultTrace trace;
                    try {
                        trace = this.surfaces.get(s).getUpperEdge();
                    }
                    catch (RuntimeException e) {
                        trace = this.surfaces.get(s).getEvenlyDiscritizedUpperEdge();
                    }
                    if (this.reverseSurfTrace[s]) {
                        for (i = 0; i < trace.size(); ++i) {
                            this.upperEdge.add((Location)trace.get(i));
                        }
                        continue;
                    }
                    for (i = trace.size() - 1; i >= 0; --i) {
                        this.upperEdge.add((Location)trace.get(i));
                    }
                }
            } else {
                for (int s = 0; s < this.surfaces.size(); ++s) {
                    int i;
                    FaultTrace trace;
                    try {
                        trace = this.surfaces.get(s).getUpperEdge();
                    }
                    catch (RuntimeException e) {
                        trace = this.surfaces.get(s).getEvenlyDiscritizedUpperEdge();
                    }
                    if (this.reverseSurfTrace[s]) {
                        for (i = trace.size() - 1; i >= 0; --i) {
                            this.upperEdge.add((Location)trace.get(i));
                        }
                        continue;
                    }
                    for (i = 0; i < trace.size(); ++i) {
                        this.upperEdge.add((Location)trace.get(i));
                    }
                }
            }
        }
        return this.upperEdge;
    }

    @Override
    public boolean isPointSurface() {
        return false;
    }

    @Override
    public double getMinDistance(RuptureSurface surface) {
        return GriddedSurfaceUtils.getMinDistanceBetweenSurfaces(surface, this);
    }

    public static void main(String[] args) {
    }

    @Override
    public RuptureSurface getMoved(LocationVector v) {
        ArrayList movedSurfs = Lists.newArrayList();
        for (RuptureSurface ruptureSurface : this.surfaces) {
            movedSurfs.add(ruptureSurface.getMoved(v));
        }
        return new CompoundSurface(movedSurfs);
    }

    @Override
    public CompoundSurface copyShallow() {
        return new CompoundSurface(this.surfaces);
    }

    @Override
    public void clearCache() {
        this.cache.clearCache();
    }

    @Override
    public double getAreaInsideRegion(Region region) {
        double area = 0.0;
        for (RuptureSurface ruptureSurface : this.surfaces) {
            area += ruptureSurface.getAreaInsideRegion(region);
        }
        return area;
    }

    protected static class CompoundSurfaceDistances
    extends SurfaceDistances {
        public final int distXIndex;

        public CompoundSurfaceDistances(double distanceRup, double distanceJB, double distanceSeis, int distXIndex) {
            super(distanceRup, distanceJB, distanceSeis);
            this.distXIndex = distXIndex;
        }
    }
}

