/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.Region;
import org.opensha.sha.faultSurface.PointSurface;

public class FiniteApproxPointSurface
extends PointSurface {
    private double zTop;
    private double zBot;
    private boolean footwall;
    private double length;
    private double dipRad;
    private double horzWidth;

    public FiniteApproxPointSurface(Location loc, double dip, double zTop, double zBot, boolean footwall, double length) {
        super(loc);
        this.aveDip = dip;
        this.zTop = zTop;
        this.zBot = zBot;
        this.footwall = footwall;
        this.length = length;
        this.dipRad = Math.toRadians(dip);
        this.calcWidths();
    }

    private void calcWidths() {
        if (this.aveDip == 90.0 || this.zBot == this.zTop) {
            this.aveWidth = this.zBot - this.zTop;
            this.horzWidth = 0.0;
        } else {
            this.aveWidth = (this.zBot - this.zTop) / Math.sin(this.dipRad);
            this.horzWidth = this.aveWidth * Math.cos(this.dipRad);
        }
    }

    @Override
    public double getAveRupTopDepth() {
        return this.getDepth();
    }

    @Override
    public double getDepth() {
        return this.zTop;
    }

    public double getLowerDepth() {
        return this.zBot;
    }

    @Override
    public void setDepth(double depth) {
        this.zTop = depth;
        this.calcWidths();
    }

    @Override
    public void setAveDip(double aveDip) throws InvalidRangeException {
        super.setAveDip(aveDip);
        this.calcWidths();
    }

    @Override
    public void setAveWidth(double aveWidth) {
        throw new UnsupportedOperationException("Width is calculated, cannot be set");
    }

    @Override
    public double getAveLength() {
        return this.length;
    }

    @Override
    public double getArea() {
        return this.getAveLength() * this.getAveWidth();
    }

    @Override
    public double getAreaInsideRegion(Region region) {
        if (region.contains(this.getLocation())) {
            return this.getArea();
        }
        return 0.0;
    }

    @Override
    public double getDistanceX(Location loc) {
        double rJB = this.getDistanceJB(loc);
        return this.footwall ? -rJB : rJB + this.horzWidth;
    }

    @Override
    public double getDistanceJB(Location siteLoc) {
        if ((float)this.length == 0.0f) {
            return LocationUtils.horzDistanceFast(this.getLocation(), siteLoc);
        }
        return super.getDistanceJB(siteLoc);
    }

    @Override
    public double getDistanceRup(Location loc) {
        double rJB = this.getDistanceJB(loc);
        return this.getDistanceRup(rJB);
    }

    public double getDistanceRup(double rJB) {
        return FiniteApproxPointSurface.getCorrDistRup(rJB, this.zTop, this.zBot, this.dipRad, this.horzWidth, this.footwall);
    }

    @Override
    public double getDistanceSeis(Location loc) {
        double rJB = this.getDistanceJB(loc);
        return FiniteApproxPointSurface.getCorrDistRup(rJB, Math.max(3.0, this.zTop), Math.max(3.0, this.zBot), this.dipRad, this.horzWidth, this.footwall);
    }

    public static double getCorrDistRup(double rJB, double zTop, double zBot, double dipRad, double horzWidth, boolean footwall) {
        if (footwall) {
            return FiniteApproxPointSurface.hypot2(rJB, zTop);
        }
        double rCut = zBot * Math.tan(dipRad);
        if (rJB > rCut) {
            return FiniteApproxPointSurface.hypot2(rJB, zBot);
        }
        double rRup0 = Math.min(FiniteApproxPointSurface.hypot2(horzWidth, zTop), zBot * Math.cos(dipRad));
        double rRupC = zBot / Math.cos(dipRad);
        return (rRupC - rRup0) * rJB / rCut + rRup0;
    }

    public boolean isOnFootwall() {
        return this.footwall;
    }

    private static final double hypot2(double v1, double v2) {
        return Math.sqrt(v1 * v1 + v2 * v2);
    }

    @Override
    public FiniteApproxPointSurface copyShallow() {
        FiniteApproxPointSurface copy = new FiniteApproxPointSurface(this.getLocation(), this.getAveDip(), this.zTop, this.zBot, this.footwall, this.length);
        return copy;
    }
}

