/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurface;

public class FourPointEvenlyGriddedSurface
extends AbstractEvenlyGriddedSurface {
    private static final boolean D = false;
    private static final long serialVersionUID = 1L;

    public FourPointEvenlyGriddedSurface(Location upperLeft, Location lowerLeft, Location lowerRight, Location upperRight) {
        this.setNumRowsAndNumCols(2, 2);
        this.set(0, 0, upperLeft);
        this.set(0, 1, upperRight);
        this.set(1, 0, lowerLeft);
        this.set(1, 1, lowerRight);
        this.gridSpacingAlong = (LocationUtils.linearDistanceFast(this.getLocation(0, 0), this.getLocation(0, 1)) + LocationUtils.linearDistanceFast(this.getLocation(1, 0), this.getLocation(1, 1))) / 2.0;
        this.gridSpacingDown = (LocationUtils.linearDistanceFast(this.getLocation(0, 0), this.getLocation(1, 0)) + LocationUtils.linearDistanceFast(this.getLocation(0, 1), this.getLocation(1, 1))) / 2.0;
        this.sameGridSpacing = this.gridSpacingAlong == this.gridSpacingDown ? Boolean.valueOf(true) : Boolean.valueOf(false);
    }

    private FourPointEvenlyGriddedSurface(int numRows, int numCols, double gridSpacingAlong, double gridSpacingDown) {
        this.setNumRowsAndNumCols(numRows, numCols);
        this.gridSpacingAlong = gridSpacingAlong;
        this.gridSpacingDown = gridSpacingDown;
        this.sameGridSpacing = gridSpacingAlong == gridSpacingDown ? Boolean.valueOf(true) : Boolean.valueOf(false);
    }

    @Override
    public double getAveDip() {
        double dip2;
        double dip1 = LocationUtils.plunge((Location)this.get(0, 0), (Location)this.get(1, 0));
        double aveDip = (dip1 + (dip2 = LocationUtils.plunge((Location)this.get(0, 1), (Location)this.get(1, 1)))) / 2.0;
        if (aveDip < 0.0) {
            throw new RuntimeException("aveDip must be positive; the value = " + aveDip);
        }
        return aveDip;
    }

    @Override
    public double getAveDipDirection() {
        double az1 = LocationUtils.azimuth((Location)this.get(0, 0), (Location)this.get(1, 0));
        double az2 = LocationUtils.azimuth((Location)this.get(0, 1), (Location)this.get(1, 1));
        return (az1 + az2) / 2.0;
    }

    @Override
    public double getAveRupTopDepth() {
        return (((Location)this.get(0, 0)).getDepth() + ((Location)this.get(0, 1)).getDepth()) / 2.0;
    }

    @Override
    public double getAveStrike() {
        return this.getUpperEdge().getAveStrike();
    }

    @Override
    protected AbstractEvenlyGriddedSurface getNewInstance() {
        return new FourPointEvenlyGriddedSurface(this.numRows, this.numCols, this.gridSpacingAlong, this.gridSpacingDown);
    }
}

