/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.opensha.commons.exceptions.FaultException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.EvenlyGriddedSurfFromSimpleFaultData;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.SimpleFaultData;

public class FrankelGriddedSurface
extends EvenlyGriddedSurfFromSimpleFaultData {
    private static final long serialVersionUID = 1L;
    protected static final String C = "FrankelGriddedSurface";
    protected static final boolean D = false;
    protected static final double PI_RADIANS = Math.PI / 180;
    protected static final String ERR = " is null, unable to process.";

    public FrankelGriddedSurface(SimpleFaultData simpleFaultData, double gridSpacing) throws FaultException {
        super(simpleFaultData, gridSpacing);
        this.createEvenlyGriddedSurface();
    }

    public FrankelGriddedSurface(FaultTrace faultTrace, double aveDip, double upperSeismogenicDepth, double lowerSeismogenicDepth, double gridSpacing) throws FaultException {
        super(faultTrace, aveDip, upperSeismogenicDepth, lowerSeismogenicDepth, gridSpacing);
        this.createEvenlyGriddedSurface();
    }

    public FrankelGriddedSurface(ArrayList<SimpleFaultData> simpleFaultData, double gridSpacing) throws FaultException {
        super(simpleFaultData, gridSpacing);
        this.createEvenlyGriddedSurface();
    }

    public FrankelGriddedSurface(SimpleFaultData simpleFaultData, double maxGridSpacingAlong, double maxGridSpacingDown) throws FaultException {
        super(simpleFaultData, maxGridSpacingAlong, maxGridSpacingDown);
        this.createEvenlyGriddedSurface();
    }

    private FrankelGriddedSurface() {
    }

    private void createEvenlyGriddedSurface() throws FaultException {
        Location firstLoc;
        String S = "FrankelGriddedSurface: createEvenlyGriddedSurface():";
        this.assertValidData();
        int numSegments = this.faultTrace.getNumLocations() - 1;
        double avDipRadians = this.aveDip * (Math.PI / 180);
        double gridSpacingCosAveDipRadians = this.gridSpacingDown * Math.cos(avDipRadians);
        double gridSpacingSinAveDipRadians = this.gridSpacingDown * Math.sin(avDipRadians);
        double[] segmentLenth = new double[numSegments];
        double[] segmentAzimuth = new double[numSegments];
        double[] segmentCumLenth = new double[numSegments];
        double cumDistance = 0.0;
        int i = 0;
        Iterator it = this.faultTrace.iterator();
        Location lastLoc = firstLoc = (Location)it.next();
        Location loc = null;
        LocationVector dir = null;
        while (it.hasNext()) {
            loc = (Location)it.next();
            dir = LocationUtils.vector(lastLoc, loc);
            double azimuth = dir.getAzimuth();
            double distance = dir.getHorzDistance();
            segmentLenth[i] = distance;
            segmentAzimuth[i] = azimuth;
            segmentCumLenth[i] = cumDistance += distance;
            ++i;
            lastLoc = loc;
        }
        double downDipWidth = (this.lowerSeismogenicDepth - this.upperSeismogenicDepth) / Math.sin(avDipRadians);
        int rows = 1 + Math.round((float)(downDipWidth / this.gridSpacingDown));
        int cols = 1 + Math.round((float)(segmentCumLenth[numSegments - 1] / this.gridSpacingAlong));
        this.setNumRowsAndNumCols(rows, cols);
        for (int ith_col = 0; ith_col < cols; ++ith_col) {
            Location topLocation;
            double hDistance;
            double vDistance;
            int segmentNumber;
            double distanceAlong = (double)ith_col * this.gridSpacingAlong;
            for (segmentNumber = 1; segmentNumber <= numSegments && distanceAlong > segmentCumLenth[segmentNumber - 1]; ++segmentNumber) {
            }
            if (segmentNumber == numSegments + 1) {
                --segmentNumber;
            }
            double distance = segmentNumber > 1 ? distanceAlong - segmentCumLenth[segmentNumber - 2] : distanceAlong;
            Location location1 = (Location)this.faultTrace.get(segmentNumber - 1);
            Location traceLocation = LocationUtils.location(location1, dir = new LocationVector(segmentAzimuth[segmentNumber - 1], distance, 0.0));
            if (traceLocation.getDepth() < this.upperSeismogenicDepth) {
                vDistance = this.upperSeismogenicDepth - traceLocation.getDepth();
                hDistance = vDistance / Math.tan(avDipRadians);
                dir = new LocationVector(segmentAzimuth[segmentNumber - 1] + 90.0, hDistance, vDistance);
                topLocation = LocationUtils.location(traceLocation, dir);
            } else {
                topLocation = traceLocation;
            }
            this.set(0, ith_col, topLocation.clone());
            for (int ith_row = 1; ith_row < rows; ++ith_row) {
                hDistance = (double)ith_row * gridSpacingCosAveDipRadians;
                vDistance = (double)ith_row * gridSpacingSinAveDipRadians;
                dir = new LocationVector(segmentAzimuth[segmentNumber - 1] + 90.0, hDistance, vDistance);
                Location depthLocation = LocationUtils.location(topLocation, dir);
                this.set(ith_row, ith_col, depthLocation.clone());
            }
        }
    }

    @Override
    public double getAveDipDirection() {
        return this.faultTrace.getDipDirection();
    }

    public FrankelGriddedSurface deepCopy() {
        return this.deepCopyOverrideDepth(Double.NaN);
    }

    public FrankelGriddedSurface deepCopyOverrideDepth(double depth) {
        FrankelGriddedSurface surf = new FrankelGriddedSurface();
        surf.set(this.faultTrace.clone(), this.aveDip, this.upperSeismogenicDepth, this.lowerSeismogenicDepth, this.gridSpacingAlong, this.gridSpacingDown);
        surf.setName(this.getName());
        surf.setNumRowsAndNumCols(this.getNumRows(), this.getNumCols());
        for (int row = 0; row < this.getNumRows(); ++row) {
            for (int col = 0; col < this.getNumCols(); ++col) {
                Location loc = (Location)this.get(row, col);
                if (Double.isNaN(depth)) {
                    surf.set(row, col, loc);
                    continue;
                }
                surf.set(row, col, new Location(loc.getLatitude(), loc.getLongitude(), depth));
            }
        }
        return surf;
    }

    public static void main(String[] args) {
        double aveDip = 30.0;
        double upperSeismogenicDepth = 5.0;
        double lowerSeismogenicDepth = 15.0;
        double gridSpacing = 5.0;
        FaultTrace faultTrace = new FaultTrace("Test");
        faultTrace.add(new Location(20.0, -120.0, 0.0));
        faultTrace.add(new Location(20.2, -120.0, 0.0));
        FrankelGriddedSurface griddedSurface = new FrankelGriddedSurface(faultTrace, aveDip, upperSeismogenicDepth, lowerSeismogenicDepth, gridSpacing);
        System.out.println("******Fault Trace*********");
        System.out.println(faultTrace);
        ListIterator<Location> it = griddedSurface.getLocationsIterator();
        System.out.println("*******Evenly Gridded Surface************");
        while (it.hasNext()) {
            Location loc = (Location)it.next();
            System.out.println(loc.getLatitude() + "," + loc.getLongitude() + "," + loc.getDepth());
        }
    }

    @Override
    protected AbstractEvenlyGriddedSurface getNewInstance() {
        FrankelGriddedSurface surf = new FrankelGriddedSurface();
        surf.setNumRowsAndNumCols(this.numRows, this.numCols);
        surf.gridSpacingDown = this.gridSpacingDown;
        surf.gridSpacingAlong = this.gridSpacingAlong;
        surf.sameGridSpacing = this.sameGridSpacing;
        surf.faultTrace = this.faultTrace;
        surf.aveDip = this.aveDip;
        surf.lowerSeismogenicDepth = this.lowerSeismogenicDepth;
        surf.name = this.name;
        surf.upperSeismogenicDepth = this.upperSeismogenicDepth;
        surf.sameGridSpacing = this.sameGridSpacing;
        return surf;
    }
}

