/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.RotationOrder;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.dom4j.DocumentException;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.geo.GeoTools;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FaultUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.opensha.sha.faultSurface.cache.CacheEnabledSurface;
import org.opensha.sha.faultSurface.cache.SurfaceCachingPolicy;
import org.opensha.sha.faultSurface.cache.SurfaceDistanceCache;
import org.opensha.sha.faultSurface.cache.SurfaceDistances;
import org.opensha.sha.faultSurface.utils.GriddedSurfaceUtils;

public class QuadSurface
implements RuptureSurface,
CacheEnabledSurface {
    static final boolean D = false;
    private double dipDeg;
    private double dipRad;
    private double width;
    private double avgUpperDepth;
    private double avgDipDirRad;
    private double avgDipDirDeg;
    private boolean traceBelowSeis;
    private FaultTrace trace;
    private List<Rotation> rots;
    private List<Path2D> surfs;
    private FaultTrace proj_trace;
    private List<Path2D> proj_surfs;
    private FaultTrace seis_trace;
    private List<Rotation> seis_rots;
    private List<Path2D> seis_surfs;
    private FaultTrace x_trace;
    private List<Rotation> x_rots;
    private List<Path2D> x_surfs;
    private List<Vector3D> x_trace_vects;
    private double discr_km = 1.0;
    private FaultTrace[] horzSpans;
    private FaultTrace[] horzSpansDiscr;
    private final SurfaceDistanceCache cache;
    private boolean distX_useAvgStrike = true;
    private LocationList surfLocs;

    private static double calcWidth(FaultSection sect, boolean aseisReducesArea) {
        double upperDepth = aseisReducesArea ? sect.getReducedAveUpperDepth() : sect.getOrigAveUpperDepth();
        double lowerDepth = sect.getAveLowerDepth();
        return (lowerDepth - upperDepth) / Math.sin(Math.toRadians(sect.getAveDip()));
    }

    private static FaultTrace getTraceBelowSeismogenic(FaultSection sect, boolean aseisReducesArea) {
        double upperSeismogenicDepth = aseisReducesArea ? sect.getReducedAveUpperDepth() : sect.getOrigAveUpperDepth();
        double aveDipRadians = Math.toRadians(sect.getAveDip());
        double aveDipDirection = sect.getDipDirection();
        return QuadSurface.getTraceBelowDepth(sect.getFaultTrace(), upperSeismogenicDepth, aveDipRadians, aveDipDirection);
    }

    private static FaultTrace getTraceBelowDepth(FaultTrace trace, double depth, double avgDipRad, double dipDirDeg) {
        FaultTrace belowTrace = new FaultTrace("");
        for (Location loc : trace) {
            belowTrace.add(StirlingGriddedSurface.getTopLocation(loc, depth, avgDipRad, dipDirDeg));
        }
        return belowTrace;
    }

    public QuadSurface(FaultSection sect, boolean aseisReducesArea) {
        this(QuadSurface.getTraceBelowSeismogenic(sect, aseisReducesArea), sect.getAveDip(), sect.getDipDirection(), QuadSurface.calcWidth(sect, aseisReducesArea), null);
    }

    public QuadSurface(FaultTrace trace, double dip, double width) {
        this(trace, dip, width, null);
    }

    public QuadSurface(FaultTrace trace, double dip, double width, SurfaceCachingPolicy.CacheTypes cacheType) {
        this(trace, dip, trace.getStrikeDirection() + 90.0, width, cacheType);
    }

    private QuadSurface(FaultTrace trace, double dip, double dipDir, double width, SurfaceCachingPolicy.CacheTypes cacheType) {
        Preconditions.checkState((width > 0.0 ? 1 : 0) != 0, (Object)"Width must be >0 (distance calculations fail otherwise)");
        this.cache = cacheType == null ? SurfaceCachingPolicy.build(this) : SurfaceCachingPolicy.build(this, cacheType);
        this.trace = trace;
        this.dipDeg = dip;
        this.dipRad = dip * GeoTools.TO_RAD;
        this.width = width;
        this.rots = new ArrayList<Rotation>();
        this.surfs = new ArrayList<Path2D>();
        this.avgDipDirRad = dipDir * GeoTools.TO_RAD;
        this.avgDipDirDeg = dipDir;
        QuadSurface.initSegments(this.dipRad, this.avgDipDirRad, width, trace, this.rots, this.surfs);
        this.traceBelowSeis = true;
        this.avgUpperDepth = 0.0;
        for (Location loc : trace) {
            if (loc.getDepth() <= 3.0) {
                this.traceBelowSeis = false;
            }
            this.avgUpperDepth += loc.getDepth();
        }
        this.avgUpperDepth /= (double)trace.size();
    }

    private static void initSegments(double dipRad, double avgDipDirRad, double width, FaultTrace trace, List<Rotation> rots, List<Path2D> surfs) {
        Preconditions.checkState((!Double.isNaN(dipRad) ? 1 : 0) != 0, (Object)"dip cannot be NaN!");
        Preconditions.checkState((dipRad > 0.0 && dipRad <= 1.5707963267948966 ? 1 : 0) != 0, (Object)"dip must be > 0 and <= 90");
        Preconditions.checkState((!Double.isNaN(avgDipDirRad) ? 1 : 0) != 0, (Object)"dip direction cannot be NaN!");
        Preconditions.checkState((!Double.isNaN(width) ? 1 : 0) != 0, (Object)"width cannot be NaN!");
        for (int i = 0; i < trace.size() - 1; ++i) {
            Location p1 = (Location)trace.get(i);
            Location p2 = (Location)trace.get(i + 1);
            LocationVector vec = LocationUtils.vector(p1, p2);
            double surfStrk = vec.getAzimuthRad();
            double p1p2Dist = vec.getHorzDistance();
            Vector3D vt1 = Vector3D.ZERO;
            Vector3D vt2 = new Vector3D(p1p2Dist, new Vector3D(surfStrk, 0.0));
            Vector3D vb1 = new Vector3D(width, new Vector3D(avgDipDirRad, dipRad));
            Vector3D vb2 = new Vector3D(1.0, vt2, 1.0, vb1);
            Rotation dRot = new Rotation(Vector3D.PLUS_K, -surfStrk);
            Vector3D dVec = dRot.applyTo(vb1);
            dVec = new Vector3D(0.0, dVec.getY(), dVec.getZ());
            double surfDip = dVec.getDelta();
            Rotation rot = new Rotation(RotationOrder.XYZ, -surfDip, 0.0, -surfStrk);
            rots.add(rot);
            vt2 = rot.applyTo(vt2);
            vb1 = rot.applyTo(vb1);
            vb2 = rot.applyTo(vb2);
            Path2D.Double surface = new Path2D.Double();
            ((Path2D)surface).moveTo(vt1.getX(), vt1.getY());
            ((Path2D)surface).lineTo(vt2.getX(), vt2.getY());
            ((Path2D)surface).lineTo(vb2.getX(), vb2.getY());
            ((Path2D)surface).lineTo(vb1.getX(), vb1.getY());
            ((Path2D)surface).lineTo(vt1.getX(), vt1.getY());
            surfs.add(surface);
        }
    }

    private static void initSegmentsJB(double dipRad, double avgDipDirRad, double width, FaultTrace trace, List<Path2D> surfs) {
        Preconditions.checkState((!Double.isNaN(dipRad) ? 1 : 0) != 0, (Object)"dip cannot be NaN!");
        Preconditions.checkState((dipRad > 0.0 && dipRad <= 1.5707963267948966 ? 1 : 0) != 0, (Object)"dip must be > 0 and <= 90");
        Preconditions.checkState((!Double.isNaN(avgDipDirRad) ? 1 : 0) != 0, (Object)"dip direction cannot be NaN!");
        Preconditions.checkState((!Double.isNaN(width) ? 1 : 0) != 0, (Object)"width cannot be NaN!");
        width *= Math.cos(dipRad);
        dipRad = 0.0;
        for (int i = 0; i < trace.size() - 1; ++i) {
            Location p1 = (Location)trace.get(i);
            Location p2 = (Location)trace.get(i + 1);
            LocationVector vec = LocationUtils.vector(p1, p2);
            double surfStrk = vec.getAzimuthRad();
            double p1p2Dist = vec.getHorzDistance();
            Vector3D vt1 = Vector3D.ZERO;
            Vector3D vt2 = new Vector3D(p1p2Dist, new Vector3D(surfStrk, 0.0));
            Vector3D vb1 = new Vector3D(width, new Vector3D(avgDipDirRad, dipRad));
            Vector3D vb2 = new Vector3D(1.0, vt2, 1.0, vb1);
            Preconditions.checkState((vt2.getZ() == 0.0 && vb1.getZ() == 0.0 && vb2.getZ() == 0.0 ? 1 : 0) != 0);
            Path2D.Double surface = new Path2D.Double();
            ((Path2D)surface).moveTo(vt1.getX(), vt1.getY());
            ((Path2D)surface).lineTo(vt2.getX(), vt2.getY());
            if (dipRad < 1.5707963267948966) {
                ((Path2D)surface).lineTo(vb2.getX(), vb2.getY());
                ((Path2D)surface).lineTo(vb1.getX(), vb1.getY());
                ((Path2D)surface).lineTo(vt1.getX(), vt1.getY());
            }
            surfs.add(surface);
        }
    }

    @Override
    public SurfaceDistances calcDistances(Location loc) {
        double distRup = this.calcDistanceRup(loc);
        double distJB = this.calcDistanceJB(loc);
        double distSeis = this.traceBelowSeis ? distRup : this.calcDistanceSeis(loc);
        return new SurfaceDistances(distRup, distJB, distSeis);
    }

    private double calcDistanceRup(Location loc) {
        return QuadSurface.distance3D(this.trace, this.rots, this.surfs, loc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double calcDistanceJB(Location loc) {
        if (this.proj_trace == null) {
            QuadSurface quadSurface = this;
            synchronized (quadSurface) {
                if (this.proj_trace == null) {
                    FaultTrace proj_trace = new FaultTrace("surface projection");
                    for (Location traceLoc : this.trace) {
                        proj_trace.add(new Location(traceLoc.getLatitude(), traceLoc.getLongitude()));
                    }
                    this.proj_surfs = new ArrayList<Path2D>();
                    QuadSurface.initSegmentsJB(this.dipRad, this.avgDipDirRad, this.width, this.trace, this.proj_surfs);
                    this.proj_trace = proj_trace;
                }
            }
        }
        return QuadSurface.distance3D(this.proj_trace, null, this.proj_surfs, new Location(loc.getLatitude(), loc.getLongitude()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double calcDistanceSeis(Location loc) {
        if (this.seis_trace == null) {
            QuadSurface quadSurface = this;
            synchronized (quadSurface) {
                if (this.seis_trace == null) {
                    FaultTrace seis_trace;
                    if (this.traceBelowSeis) {
                        seis_trace = this.trace;
                        this.seis_rots = this.rots;
                        this.seis_surfs = this.surfs;
                    } else {
                        seis_trace = QuadSurface.getTraceBelowDepth(this.trace, 3.0, this.dipRad, this.avgDipDirDeg);
                        this.seis_rots = new ArrayList<Rotation>();
                        this.seis_surfs = new ArrayList<Path2D>();
                        double widthBelowSeis = this.avgUpperDepth < 3.0 ? this.width - (3.0 - this.avgUpperDepth) : this.width;
                        QuadSurface.initSegments(this.dipRad, this.avgDipDirRad, widthBelowSeis, seis_trace, this.seis_rots, this.seis_surfs);
                    }
                    this.seis_trace = seis_trace;
                }
            }
        }
        return QuadSurface.distance3D(this.seis_trace, this.seis_rots, this.seis_surfs, new Location(loc.getLatitude(), loc.getLongitude()));
    }

    @Override
    public double getDistanceRup(Location loc) {
        return this.cache.getSurfaceDistances(loc).getDistanceRup();
    }

    @Override
    public double getDistanceJB(Location loc) {
        return this.cache.getSurfaceDistances(loc).getDistanceJB();
    }

    @Override
    public double getDistanceSeis(Location loc) {
        return this.cache.getSurfaceDistances(loc).getDistanceSeis();
    }

    Vector3D getRupProjectedPoint(int traceIndex, Location loc) {
        return QuadSurface.getProjectedPoint(this.trace, this.rots, traceIndex, loc);
    }

    private static Vector3D getProjectedPoint(FaultTrace trace, List<Rotation> rots, int traceIndex, Location loc) {
        LocationVector vec = LocationUtils.vector((Location)trace.get(traceIndex), loc);
        Vector3D vp = new Vector3D(vec.getHorzDistance(), new Vector3D(vec.getAzimuthRad(), 0.0), vec.getVertDistance(), Vector3D.PLUS_K);
        if (rots != null) {
            vp = rots.get(traceIndex).applyTo(vp);
        }
        return vp;
    }

    private static double distance3D(FaultTrace trace, List<Rotation> rots, List<Path2D> surfs, Location loc) {
        double distance = Double.MAX_VALUE;
        for (int i = 0; i < trace.size() - 1; ++i) {
            Vector3D vp = QuadSurface.getProjectedPoint(trace, rots, i, loc);
            Path2D surf = surfs.get(i);
            distance = surf.contains(vp.getX(), vp.getY()) ? Math.min(distance, Math.abs(vp.getZ())) : Math.min(distance, QuadSurface.distanceToSurface(vp, surf));
            if (distance != 0.0) continue;
            return 0.0;
        }
        Preconditions.checkState((!Double.isNaN(distance) ? 1 : 0) != 0);
        return distance;
    }

    private static void showDebugGraphIgnoreError(Path2D surf, Vector3D vp, boolean waitForClose) {
        try {
            QuadSurface.showDebugGraph(surf, vp, waitForClose, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void showDebugGraph(Path2D surf, Vector3D vp, boolean waitForClose, List<Vector3D> otherVects) {
        ArrayList funcs = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        PathIterator pit = surf.getPathIterator(null);
        double[] c = new double[6];
        double[] prev_pt = new double[2];
        while (!pit.isDone()) {
            int type = pit.currentSegment(c);
            switch (type) {
                case 0: {
                    break;
                }
                case 1: {
                    DefaultXY_DataSet xy = new DefaultXY_DataSet();
                    xy.set(prev_pt[0], prev_pt[1]);
                    xy.set(c[0], c[1]);
                    funcs.add(xy);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
                    break;
                }
                default: {
                    throw new IllegalStateException("unkown path operation: " + type);
                }
            }
            prev_pt[0] = c[0];
            prev_pt[1] = c[1];
            pit.next();
        }
        if (vp != null) {
            DefaultXY_DataSet xy = new DefaultXY_DataSet();
            xy.set(vp.getX(), vp.getY());
            funcs.add(xy);
            Color col = surf.contains(vp.getX(), vp.getY()) ? Color.GREEN : Color.RED;
            chars.add(new PlotCurveCharacterstics(PlotSymbol.X, 6.0f, col));
        }
        if (otherVects != null) {
            CPT cpt;
            DataUtils.MinMaxAveTracker zTrack = new DataUtils.MinMaxAveTracker();
            for (Vector3D v : otherVects) {
                zTrack.addValue(Math.abs(v.getZ()));
            }
            try {
                cpt = GMT_CPT_Files.MAX_SPECTRUM.instance().rescale(0.0, zTrack.getMax());
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            System.out.println("Plot Z range: " + String.valueOf(zTrack));
            for (Vector3D v : otherVects) {
                DefaultXY_DataSet xy = new DefaultXY_DataSet();
                xy.set(v.getX(), v.getY());
                funcs.add(xy);
                Color col = cpt.getColor((float)Math.abs(v.getZ()));
                PlotSymbol sym = surf.contains(v.getX(), v.getY()) ? PlotSymbol.FILLED_CIRCLE : PlotSymbol.CIRCLE;
                chars.add(new PlotCurveCharacterstics(sym, 3.0f, col));
            }
        }
        GraphWindow gw = new GraphWindow(funcs, "Surface Debug", chars);
        while (waitForClose && gw.isVisible()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static double distanceToSurface(Vector3D p, Path2D border) {
        PathIterator pit = border.getPathIterator(null);
        double[] c = new double[6];
        double[] prev_pt = new double[2];
        double minDistSq = Double.MAX_VALUE;
        while (!pit.isDone()) {
            int type = pit.currentSegment(c);
            switch (type) {
                case 0: {
                    break;
                }
                case 1: {
                    double distSq = Line2D.ptSegDistSq(prev_pt[0], prev_pt[1], c[0], c[1], p.getX(), p.getY());
                    minDistSq = Math.min(minDistSq, distSq);
                    break;
                }
                default: {
                    throw new IllegalStateException("unkown path operation: " + type);
                }
            }
            prev_pt[0] = c[0];
            prev_pt[1] = c[1];
            pit.next();
        }
        return Math.sqrt(p.getZ() * p.getZ() + minDistSq);
    }

    @Override
    public double getQuickDistance(Location siteLoc) {
        return this.cache.getQuickDistance(siteLoc);
    }

    @Override
    public double calcQuickDistance(Location siteLoc) {
        return this.cache.getSurfaceDistances(siteLoc).getDistanceRup();
    }

    @Override
    public synchronized double calcDistanceX(Location siteLoc) {
        if (this.x_trace_vects == null) {
            this.x_rots = Lists.newArrayList();
            this.x_surfs = Lists.newArrayList();
            if (this.distX_useAvgStrike) {
                this.x_trace = new FaultTrace("dist x");
                Location startPt = this.trace.first();
                Location endPt = this.trace.last();
                double strikeDirRad = LocationUtils.azimuthRad(startPt, endPt);
                double reverseStrikeDirRad = LocationUtils.azimuthRad(endPt, startPt);
                double dist_x_pad_dist = 1.0E-6;
                this.x_trace.add(LocationUtils.location(startPt, reverseStrikeDirRad, dist_x_pad_dist));
                this.x_trace.addAll(this.trace);
                this.x_trace.add(LocationUtils.location(endPt, strikeDirRad, dist_x_pad_dist));
            } else {
                this.x_trace = this.trace;
            }
            QuadSurface.initSegments(1.5707963267948966, this.avgDipDirRad, this.width, this.x_trace, this.x_rots, this.x_surfs);
            this.x_trace_vects = Lists.newArrayList();
            for (int i = 0; i < this.x_trace.size() - 1; ++i) {
                double[] c;
                Path2D surf = this.x_surfs.get(i);
                PathIterator pit = surf.getPathIterator(null);
                Preconditions.checkState((pit.currentSegment(c = new double[6]) == 0 ? 1 : 0) != 0);
                pit.next();
                Preconditions.checkState(((float)c[0] == 0.0f ? 1 : 0) != 0);
                Preconditions.checkState(((float)c[1] == 0.0f ? 1 : 0) != 0);
                Preconditions.checkState((pit.currentSegment(c) == 1 ? 1 : 0) != 0);
                Preconditions.checkState((Math.abs(c[1]) < 1.0E-10 ? 1 : 0) != 0);
                this.x_trace_vects.add(new Vector3D(c[0], c[1], 0.0));
            }
        }
        double distanceSq = Double.MAX_VALUE;
        double distance = Double.MAX_VALUE;
        for (int i = 0; i < this.x_trace.size() - 1; ++i) {
            LocationVector vec = LocationUtils.vector((Location)this.x_trace.get(i), siteLoc);
            Vector3D vp = new Vector3D(vec.getHorzDistance(), new Vector3D(vec.getAzimuthRad(), 0.0), vec.getVertDistance(), Vector3D.PLUS_K);
            vp = this.x_rots.get(i).applyTo(vp);
            double siteX = vp.getX();
            double siteY = vp.getY();
            double siteZ = vp.getZ();
            Vector3D traceVect = this.x_trace_vects.get(i);
            double traceX = traceVect.getX();
            double traceY = traceVect.getY();
            boolean trueDist = siteX < 0.0 ? i > 0 : (siteX > traceX ? i < this.x_trace.size() - 2 : false);
            double myDistSq = trueDist ? Line2D.ptSegDistSq(0.0, 0.0, traceX, 0.0, siteX, siteZ) : siteZ * siteZ;
            if (!(myDistSq < distanceSq)) continue;
            distanceSq = myDistSq;
            distance = Math.sqrt(myDistSq);
            if (!(siteZ > 0.0)) continue;
            distance = -distance;
        }
        return distance;
    }

    @Override
    public double getDistanceX(Location siteLoc) {
        return this.cache.getDistanceX(siteLoc);
    }

    @Override
    public double getAveDip() {
        return this.dipDeg;
    }

    @Override
    public double getAveStrike() {
        return this.trace.getAveStrike();
    }

    @Override
    public double getAveLength() {
        return this.trace.getTraceLength();
    }

    @Override
    public double getAveWidth() {
        return this.width;
    }

    @Override
    public double getArea() {
        return this.getAveLength() * this.getAveWidth();
    }

    @Override
    public double getAreaInsideRegion(Region region) {
        int numRows = this.getNumDiscrDownDip();
        int numCols = this.getNumDiscrAlongStrike();
        double gridSpacingDown = this.getAveWidth() / (double)(numRows - 1);
        double gridSpacingAlong = this.getAveLength() / (double)(numCols - 1);
        double areaInside = 0.0;
        for (int row = 0; row < numRows; ++row) {
            double myWidth = row == 0 || row == numRows - 1 ? 0.5 * gridSpacingDown : gridSpacingDown;
            FaultTrace span = this.getEvenlyDiscretizedHorizontalSpan(row);
            Preconditions.checkState((span.size() == numCols ? 1 : 0) != 0);
            for (int col = 0; col < numCols; ++col) {
                double myLen;
                double d = myLen = col == 0 || col == numCols - 1 ? 0.5 * gridSpacingAlong : gridSpacingAlong;
                if (!region.contains((Location)span.get(col))) continue;
                areaInside += myWidth * myLen;
            }
        }
        return areaInside;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocationList getEvenlyDiscritizedListOfLocsOnSurface() {
        if (this.surfLocs == null) {
            QuadSurface quadSurface = this;
            synchronized (quadSurface) {
                if (this.surfLocs == null) {
                    int numDDW = this.getNumDiscrDownDip();
                    int size = this.getNumDiscrAlongStrike() * numDDW;
                    LocationList locList = new LocationList(size);
                    for (int i = 0; i < numDDW; ++i) {
                        locList.addAll(this.getEvenlyDiscretizedHorizontalSpan(i));
                    }
                    this.surfLocs = locList.unmodifiableList();
                }
            }
        }
        return this.surfLocs;
    }

    @Override
    public ListIterator<Location> getLocationsIterator() {
        return this.getEvenlyDiscritizedListOfLocsOnSurface().listIterator();
    }

    @Override
    public LocationList getEvenlyDiscritizedPerimeter() {
        LocationList perim = new LocationList();
        FaultTrace upper = this.getEvenlyDiscritizedUpperEdge();
        LocationList lower = this.getEvenlyDiscritizedLowerEdge();
        LocationList right = GriddedSurfaceUtils.getEvenlyDiscretizedLine(upper.last(), lower.last(), this.discr_km);
        LocationList left = GriddedSurfaceUtils.getEvenlyDiscretizedLine(lower.first(), upper.first(), this.discr_km);
        perim.addAll(upper);
        perim.addAll(right.subList(1, right.size()));
        perim.addAll(QuadSurface.getReversed(lower).subList(1, lower.size()));
        perim.addAll(left.subList(1, left.size()));
        return perim;
    }

    @Override
    public FaultTrace getEvenlyDiscritizedUpperEdge() {
        return this.getEvenlyDiscretizedHorizontalSpan(0);
    }

    @Override
    public LocationList getEvenlyDiscritizedLowerEdge() {
        return this.getEvenlyDiscretizedHorizontalSpan(this.getNumDiscrDownDip() - 1);
    }

    @Override
    public double getAveGridSpacing() {
        return this.discr_km;
    }

    public synchronized void setAveGridSpacing(double gridSpacing) {
        this.discr_km = gridSpacing;
        this.horzSpans = null;
        this.horzSpansDiscr = null;
        this.surfLocs = null;
    }

    @Override
    public double getAveRupTopDepth() {
        return this.avgUpperDepth;
    }

    @Override
    public double getAveDipDirection() {
        return Math.toDegrees(this.avgDipDirRad);
    }

    @Override
    public FaultTrace getUpperEdge() {
        return this.trace;
    }

    @Override
    public LocationList getPerimeter() {
        LocationList perim = new LocationList();
        for (Location loc : this.trace) {
            perim.add(loc);
        }
        perim.addAll(QuadSurface.getReversed(this.getHorizontalPoints(this.width)));
        perim.add((Location)perim.get(0));
        return perim;
    }

    private static LocationList getReversed(LocationList locs) {
        LocationList reversed = new LocationList();
        int i = locs.size();
        while (--i >= 0) {
            reversed.add((Location)locs.get(i));
        }
        return reversed;
    }

    private int getNumDiscrAlongStrike() {
        int val = (int)Math.ceil((1.0E-5 + this.getAveLength()) / this.discr_km);
        return val > 2 ? val : 2;
    }

    private int getNumDiscrDownDip() {
        int val = (int)Math.ceil((1.0E-5 + this.width) / this.discr_km);
        return val > 2 ? val : 2;
    }

    private synchronized FaultTrace getHorizontalSpan(int index) {
        if (this.horzSpans != null) {
            Preconditions.checkState((index <= this.horzSpans.length ? 1 : 0) != 0);
            if (this.horzSpans[index] != null) {
                return this.horzSpans[index];
            }
        } else {
            this.horzSpans = new FaultTrace[this.getNumDiscrDownDip()];
        }
        if (index == 0) {
            this.horzSpans[index] = this.trace;
        } else {
            FaultTrace locs = new FaultTrace("SubTrace " + index);
            double widthDownDip = (double)index * this.width / ((double)this.horzSpans.length - 1.0);
            double hDistance = widthDownDip * Math.cos(this.dipRad);
            double vDistance = widthDownDip * Math.sin(this.dipRad);
            LocationVector dir = new LocationVector(this.avgDipDirDeg, hDistance, vDistance);
            for (Location traceLoc : this.trace) {
                locs.add(LocationUtils.location(traceLoc, dir));
            }
            this.horzSpans[index] = locs;
        }
        return this.horzSpans[index];
    }

    private synchronized FaultTrace getEvenlyDiscretizedHorizontalSpan(int index) {
        if (this.horzSpansDiscr != null) {
            Preconditions.checkState((index <= this.horzSpansDiscr.length ? 1 : 0) != 0);
            if (this.horzSpansDiscr[index] != null) {
                return this.horzSpansDiscr[index];
            }
        } else {
            this.horzSpansDiscr = new FaultTrace[this.getNumDiscrDownDip()];
        }
        FaultTrace subTrace = this.getHorizontalSpan(index);
        this.horzSpansDiscr[index] = FaultUtils.resampleTrace(subTrace, this.getNumDiscrAlongStrike());
        return this.horzSpansDiscr[index];
    }

    private LocationList getHorizontalPoints(double widthDownDip) {
        LocationList locs = new LocationList();
        double hDistance = widthDownDip * Math.cos(this.dipRad);
        double vDistance = widthDownDip * Math.sin(this.dipRad);
        LocationVector dir = new LocationVector(this.avgDipDirDeg, hDistance, vDistance);
        for (Location traceLoc : this.trace) {
            locs.add(LocationUtils.location(traceLoc, dir));
        }
        return locs;
    }

    @Override
    public Location getFirstLocOnUpperEdge() {
        return (Location)this.trace.get(0);
    }

    @Override
    public Location getLastLocOnUpperEdge() {
        return this.trace.last();
    }

    @Override
    public double getFractionOfSurfaceInRegion(Region region) {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public String getInfo() {
        return null;
    }

    @Override
    public boolean isPointSurface() {
        return false;
    }

    @Override
    public double getMinDistance(RuptureSurface surface) {
        throw new RuntimeException("not yet implemented");
    }

    private static Location getTestLoc(boolean randomize) {
        if (randomize) {
            return new Location(34.0 + Math.random(), -120.0 + Math.random());
        }
        return new Location(34.0, -120.0);
    }

    public static void main(String[] args) throws IOException, DocumentException {
        double topDepth = 0.0;
        double width = 10.0;
        double dip = 45.0;
        Location l1 = new Location(34.0, -118.0, topDepth);
        Location l2 = new Location(36.1, -118.0, topDepth);
        Location distXDebug = new Location(35.0, -119.0);
        FaultTrace ft = new FaultTrace("Test");
        ft.add(l1);
        ft.add(l2);
        FaultSectionPrefData prefData = new FaultSectionPrefData();
        prefData.setFaultTrace(ft);
        prefData.setAveDip(dip);
        prefData.setDipDirection((float)ft.getDipDirection());
        prefData.setAveUpperDepth(topDepth);
        double lowerDepth = topDepth + width * Math.sin(Math.toRadians(dip));
        prefData.setAveLowerDepth(lowerDepth);
        QuadSurface q = prefData.getQuadSurface(false);
        q.getDistanceX(distXDebug);
        QuadSurface.showDebugGraph(q.x_surfs.get(0), QuadSurface.getProjectedPoint(q.trace, q.x_rots, 0, distXDebug), true, null);
        StirlingGriddedSurface gridded = prefData.getStirlingGriddedSurface(1.0, false, false);
        ArrayList pts = Lists.newArrayList();
        for (Object loc : q.getEvenlyDiscritizedListOfLocsOnSurface()) {
            pts.add(QuadSurface.getProjectedPoint(q.trace, q.rots, 0, (Location)loc));
        }
        DataUtils.MinMaxAveTracker zTrack = new DataUtils.MinMaxAveTracker();
        for (Vector3D pt : pts) {
            zTrack.addValue(pt.getZ());
        }
        System.out.println("Ztrack: " + String.valueOf(zTrack));
        QuadSurface.showDebugGraph(q.surfs.get(0), null, true, pts);
        double d12 = LocationUtils.horzDistanceFast(l1, l2);
        LocationVector v12 = LocationUtils.vector(l1, l2);
        Location middle12 = LocationUtils.location(l1, v12.getAzimuthRad(), 0.5 * d12);
        double dipDirRad = ft.getDipDirection() * GeoTools.TO_RAD;
        Location onDipOffMiddle = LocationUtils.location(middle12, dipDirRad, 0.1 * d12);
        System.out.println("Dip dir: " + ft.getDipDirection());
        q.getDistanceJB(onDipOffMiddle);
    }

    private static void testPlanar() throws IOException {
        Location startLoc = new Location(34.0, -120.0);
        int num_calcs = 100000;
        double[] test_lengths = new double[]{10.0, 50.0, 100.0, 200.0, 500.0, 1000.0};
        long[] point_counts = new long[test_lengths.length];
        ArbitrarilyDiscretizedFunc[] quadFuncs = new ArbitrarilyDiscretizedFunc[5];
        ArbitrarilyDiscretizedFunc[] griddedFuncs = new ArbitrarilyDiscretizedFunc[5];
        for (int i = 0; i < quadFuncs.length; ++i) {
            quadFuncs[i] = new ArbitrarilyDiscretizedFunc();
            griddedFuncs[i] = new ArbitrarilyDiscretizedFunc();
        }
        String[] dist_labels = new String[]{"Rup", "JB", "Seis", "X", "Combined"};
        for (int l = 0; l < test_lengths.length; ++l) {
            int i;
            double length = test_lengths[l];
            Location endLoc = LocationUtils.location(startLoc, 1.5707963267948966, length);
            FaultTrace trace = new FaultTrace("trace");
            trace.add(startLoc);
            trace.add(endLoc);
            FaultSectionPrefData prefData = new FaultSectionPrefData();
            prefData.setAveDip(80.0);
            prefData.setAveLowerDepth(10.0);
            prefData.setAveUpperDepth(0.0);
            prefData.setAseismicSlipFactor(0.0);
            prefData.setFaultTrace(trace);
            StirlingGriddedSurface gridded = prefData.getStirlingGriddedSurface(1.0, false, false);
            point_counts[l] = ((EvenlyGriddedSurface)gridded).size();
            QuadSurface quad = prefData.getQuadSurface(false);
            QuadSurface.runTest(1, quad);
            QuadSurface.runTest(1, gridded);
            System.out.println("Calculating for length " + length + " (" + point_counts[l] + " pts)");
            long[] quad_times = QuadSurface.runTest(100000, quad);
            long[] gridded_times = QuadSurface.runTest(100000, gridded);
            for (i = 0; i < quad_times.length; ++i) {
                quadFuncs[i].set(length, (double)quad_times[i] / 1000.0);
            }
            for (i = 0; i < gridded_times.length; ++i) {
                griddedFuncs[i].set(length, (double)gridded_times[i] / 1000.0);
            }
        }
        ArrayList chars = Lists.newArrayList();
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        ArrayList specs = Lists.newArrayList();
        for (int i = 0; i < dist_labels.length; ++i) {
            ArrayList funcs = Lists.newArrayList();
            funcs.add(quadFuncs[i]);
            funcs.add(griddedFuncs[i]);
            PlotSpec spec = new PlotSpec(funcs, chars, "Distance Calculation Speed", "Fault Length (km)", "Time for 100000 Distance " + dist_labels[i] + " calcs");
            specs.add(spec);
        }
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.drawGraphPanel((List<? extends PlotSpec>)specs, false, false, null, null);
        gp.getChartPanel().setSize(1000, 1500);
        gp.setBackground(Color.WHITE);
        gp.saveAsPNG("/tmp/dist_benchmarks_by_length.png");
        specs = Lists.newArrayList();
        for (int i = 0; i < dist_labels.length; ++i) {
            ArbitrarilyDiscretizedFunc quadFunc = new ArbitrarilyDiscretizedFunc();
            ArbitrarilyDiscretizedFunc griddedFunc = new ArbitrarilyDiscretizedFunc();
            for (int j = 0; j < point_counts.length; ++j) {
                quadFunc.set(point_counts[j], quadFuncs[i].getY(j));
                griddedFunc.set(point_counts[j], griddedFuncs[i].getY(j));
            }
            ArrayList funcs = Lists.newArrayList();
            funcs.add(quadFunc);
            funcs.add(griddedFunc);
            PlotSpec spec = new PlotSpec(funcs, chars, "Distance Calculation Speed", "# Gridded Points", "Time for 100000 Distance " + dist_labels[i] + " calcs");
            specs.add(spec);
        }
        gp = new HeadlessGraphPanel();
        gp.drawGraphPanel((List<? extends PlotSpec>)specs, false, false, null, null);
        gp.getChartPanel().setSize(1000, 1500);
        gp.setBackground(Color.WHITE);
        gp.saveAsPNG("/tmp/dist_benchmarks_by_pts.png");
    }

    private static long[] runTest(int num_calcs, RuptureSurface surf) {
        Location loc;
        int i;
        long[] ret = new long[5];
        Stopwatch watch = Stopwatch.createStarted();
        for (i = 0; i < num_calcs; ++i) {
            loc = QuadSurface.getTestLoc(true);
            surf.getDistanceRup(loc);
        }
        watch.stop();
        ret[0] = watch.elapsed(TimeUnit.MILLISECONDS);
        watch = Stopwatch.createStarted();
        for (i = 0; i < num_calcs; ++i) {
            loc = QuadSurface.getTestLoc(true);
            surf.getDistanceJB(loc);
        }
        watch.stop();
        ret[1] = watch.elapsed(TimeUnit.MILLISECONDS);
        watch = Stopwatch.createStarted();
        for (i = 0; i < num_calcs; ++i) {
            loc = QuadSurface.getTestLoc(true);
            surf.getDistanceSeis(loc);
        }
        watch.stop();
        ret[2] = watch.elapsed(TimeUnit.MILLISECONDS);
        watch = Stopwatch.createStarted();
        for (i = 0; i < num_calcs; ++i) {
            loc = QuadSurface.getTestLoc(true);
            surf.getDistanceX(loc);
        }
        watch.stop();
        ret[3] = watch.elapsed(TimeUnit.MILLISECONDS);
        watch = Stopwatch.createStarted();
        for (i = 0; i < num_calcs; ++i) {
            loc = QuadSurface.getTestLoc(true);
            surf.getDistanceRup(loc);
            surf.getDistanceJB(loc);
            surf.getDistanceSeis(loc);
            surf.getDistanceX(loc);
        }
        watch.stop();
        ret[4] = watch.elapsed(TimeUnit.MILLISECONDS);
        return ret;
    }

    @Override
    public RuptureSurface getMoved(LocationVector v) {
        FaultTrace traceMoved = new FaultTrace(this.trace.getName());
        for (Location loc : this.trace) {
            traceMoved.add(LocationUtils.location(loc, v));
        }
        return new QuadSurface(traceMoved, this.dipDeg, this.width);
    }

    @Override
    public QuadSurface copyShallow() {
        return new QuadSurface(this.trace, this.dipDeg, this.width);
    }

    @Override
    public void clearCache() {
        this.cache.clearCache();
    }
}

