/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.opensha.commons.geo.Location;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.faultSurface.cache.CacheEnabledSurface;
import org.opensha.sha.faultSurface.cache.SurfaceDistanceCache;
import org.opensha.sha.faultSurface.cache.SurfaceDistances;

public class MultiDistanceCache
implements SurfaceDistanceCache {
    private CacheEnabledSurface surf;
    private LoadingCache<Location, SurfaceDistances> distCache;
    private LoadingCache<Location, Double> quickDistCache;
    private LoadingCache<Location, Double> distXCache;
    private static final boolean ENABLE_DEBUG = false;
    private static List<MultiDistanceCache> cachesForDebug;

    public MultiDistanceCache(CacheEnabledSurface surf) {
        this(surf, Runtime.getRuntime().availableProcessors() + 5);
    }

    public MultiDistanceCache(CacheEnabledSurface surf, int maxSize) {
        this(surf, maxSize, 0L, TimeUnit.HOURS);
    }

    public MultiDistanceCache(CacheEnabledSurface surf, int maxSize, long expirationTime, TimeUnit expirationUnit) {
        this.surf = surf;
        this.distCache = MultiDistanceCache.buildCache(new DistCacheLoader(), maxSize, expirationTime, expirationUnit);
        this.quickDistCache = MultiDistanceCache.buildCache(new QuickDistCacheLoader(), maxSize, expirationTime, expirationUnit);
        this.distXCache = MultiDistanceCache.buildCache(new DistXCacheLoader(), maxSize, expirationTime, expirationUnit);
    }

    private static <E> LoadingCache<Location, E> buildCache(CacheLoader<Location, E> loader, int maxSize, long expirationTime, TimeUnit expirationUnit) {
        int concurrencyLevel = maxSize;
        if (concurrencyLevel < 4) {
            concurrencyLevel = 4;
        }
        CacheBuilder build = CacheBuilder.newBuilder();
        build.maximumSize((long)maxSize);
        build.concurrencyLevel(concurrencyLevel);
        if (expirationTime > 0L && expirationUnit != null) {
            build.expireAfterAccess(expirationTime, expirationUnit);
        }
        return build.build(loader);
    }

    @Override
    public SurfaceDistances getSurfaceDistances(Location loc) {
        try {
            return (SurfaceDistances)this.distCache.get((Object)loc);
        }
        catch (ExecutionException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
    }

    @Override
    public double getDistanceX(Location loc) {
        try {
            return (Double)this.distXCache.get((Object)loc);
        }
        catch (ExecutionException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
    }

    public static void printDebugStats() {
    }

    @Override
    public double getQuickDistance(Location loc) {
        try {
            return (Double)this.quickDistCache.get((Object)loc);
        }
        catch (ExecutionException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
    }

    @Override
    public void clearCache() {
        this.distCache.invalidateAll();
        this.quickDistCache.invalidateAll();
        this.distXCache.invalidateAll();
    }

    private final class DistCacheLoader
    extends CacheLoader<Location, SurfaceDistances> {
        private DistCacheLoader() {
        }

        public SurfaceDistances load(Location loc) throws Exception {
            return MultiDistanceCache.this.surf.calcDistances(loc);
        }
    }

    private final class QuickDistCacheLoader
    extends CacheLoader<Location, Double> {
        private QuickDistCacheLoader() {
        }

        public Double load(Location loc) throws Exception {
            return MultiDistanceCache.this.surf.calcQuickDistance(loc);
        }
    }

    private final class DistXCacheLoader
    extends CacheLoader<Location, Double> {
        private DistXCacheLoader() {
        }

        public Double load(Location loc) throws Exception {
            return MultiDistanceCache.this.surf.calcDistanceX(loc);
        }
    }
}

