/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface.cache;

import org.opensha.commons.geo.Location;
import org.opensha.sha.faultSurface.cache.CacheEnabledSurface;
import org.opensha.sha.faultSurface.cache.SurfaceDistanceCache;
import org.opensha.sha.faultSurface.cache.SurfaceDistances;

public class SingleLocDistanceCache
implements SurfaceDistanceCache {
    private CacheEnabledSurface surf;
    private LocDistCache<SurfaceDistances> surfDists;
    private LocDistCache<Double> quickDist;
    private LocDistCache<Double> distX;

    public SingleLocDistanceCache(CacheEnabledSurface surf) {
        this.surf = surf;
    }

    @Override
    public SurfaceDistances getSurfaceDistances(Location loc) {
        LocDistCache<SurfaceDistances> cached = this.surfDists;
        if (cached == null || !cached.loc.equals(loc)) {
            this.surfDists = cached = new LocDistCache<SurfaceDistances>(loc, this.surf.calcDistances(loc));
        }
        return (SurfaceDistances)cached.value;
    }

    @Override
    public double getQuickDistance(Location loc) {
        LocDistCache<Double> cached = this.quickDist;
        if (cached == null || !cached.loc.equals(loc)) {
            this.quickDist = cached = new LocDistCache<Double>(loc, this.surf.calcQuickDistance(loc));
        }
        return (Double)cached.value;
    }

    @Override
    public double getDistanceX(Location loc) {
        LocDistCache<Double> cached = this.distX;
        if (cached == null || !cached.loc.equals(loc)) {
            this.distX = cached = new LocDistCache<Double>(loc, this.surf.calcDistanceX(loc));
        }
        return (Double)cached.value;
    }

    SurfaceDistances getSurfaceDistancesIfPresent(Location loc) {
        LocDistCache<SurfaceDistances> cached = this.surfDists;
        if (cached != null && cached.loc.equals(loc)) {
            return (SurfaceDistances)cached.value;
        }
        return null;
    }

    Double getQuickDistanceIfPresent(Location loc) {
        LocDistCache<Double> cached = this.quickDist;
        if (cached != null && cached.loc.equals(loc)) {
            return (Double)cached.value;
        }
        return null;
    }

    Double getDistanceXIfPresent(Location loc) {
        LocDistCache<Double> cached = this.distX;
        if (cached != null && cached.loc.equals(loc)) {
            return (Double)cached.value;
        }
        return null;
    }

    void putSurfaceDistances(Location loc, SurfaceDistances dists) {
        this.surfDists = new LocDistCache<SurfaceDistances>(loc, dists);
    }

    void putQuickDistance(Location loc, double quickDistance) {
        this.quickDist = new LocDistCache<Double>(loc, quickDistance);
    }

    void putDistanceX(Location loc, double distX) {
        this.distX = new LocDistCache<Double>(loc, distX);
    }

    @Override
    public void clearCache() {
        this.surfDists = null;
        this.quickDist = null;
        this.distX = null;
    }

    private static class LocDistCache<E> {
        final Location loc;
        final E value;

        private LocDistCache(Location loc, E value) {
            this.loc = loc;
            this.value = value;
        }
    }
}

