/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface.utils;

import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.function.Supplier;
import org.opensha.commons.data.WeightedList;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.sha.earthquake.rupForecastImpl.PointSourceNshm;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.faultSurface.utils.PointSourceDistanceCorrection;
import org.opensha.sha.util.NSHMP_Util;

public enum PointSourceDistanceCorrections implements Supplier<WeightedList<PointSourceDistanceCorrection>>
{
    NONE("None"),
    FIELD("Field", new PointSourceDistanceCorrection(){

        @Override
        public double getCorrectedDistanceJB(double mag, PointSurface surf, double horzDist) {
            double rupLen = Math.pow(10.0, -3.22 + 0.69 * mag);
            double corrFactor = 0.7071 + 0.29290000000000005 / (1.0 + Math.pow(rupLen / (horzDist * 0.87), 1.1));
            return horzDist * corrFactor;
        }

        public String toString() {
            return PointSourceDistanceCorrections.FIELD.name;
        }
    }),
    NSHM_2008("USGS NSHM (2008)", new PointSourceDistanceCorrection(){
        private EvenlyDiscretizedFunc magBinFunc = new EvenlyDiscretizedFunc(6.05, 26, 0.1);

        @Override
        public double getCorrectedDistanceJB(double mag, PointSurface surf, double horzDist) {
            if (mag <= 6.0) {
                return horzDist;
            }
            if (horzDist == 0.0) {
                return 0.0;
            }
            double nearestTenth = (double)Math.round(mag * 10.0) / 10.0;
            if ((float)nearestTenth > 6.0f && (float)nearestTenth == (float)mag) {
                mag = nearestTenth - 1.0E-4;
            }
            double adjMag = this.magBinFunc.getX(this.magBinFunc.getClosestXIndex(mag));
            return NSHMP_Util.getMeanRJB(adjMag, horzDist);
        }

        public String toString() {
            return PointSourceDistanceCorrections.NSHM_2008.name;
        }
    }),
    NSHM_2013("USGS NSHM (2013)", new PointSourceNshm.DistanceCorrection2013());

    public static final PointSourceDistanceCorrections DEFAULT;
    public static final EnumSet<PointSourceDistanceCorrections> SINGLE_CORRS;
    private String name;
    private WeightedList<PointSourceDistanceCorrection> corrs;

    private PointSourceDistanceCorrections(String name) {
        this.name = name;
    }

    private PointSourceDistanceCorrections(String name, PointSourceDistanceCorrection corr) {
        this(name, WeightedList.evenlyWeighted(corr));
    }

    private PointSourceDistanceCorrections(String name, WeightedList<PointSourceDistanceCorrection> corrs) {
        this.name = name;
        Preconditions.checkState((boolean)corrs.isNormalized(), (String)"Weights not normalized for %s", (Object)name);
        if (!(corrs instanceof WeightedList.Unmodifiable)) {
            corrs = new WeightedList.Unmodifiable<PointSourceDistanceCorrection>(corrs);
        }
        this.corrs = corrs;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public WeightedList<PointSourceDistanceCorrection> get() {
        return this.corrs;
    }

    public static PointSourceDistanceCorrections forCorrections(WeightedList<PointSourceDistanceCorrection> corrs) {
        if (corrs == null || corrs.isEmpty()) {
            return NONE;
        }
        for (PointSourceDistanceCorrections corr : PointSourceDistanceCorrections.values()) {
            if (corr.corrs != corrs) continue;
            return corr;
        }
        return null;
    }

    static {
        DEFAULT = NSHM_2013;
        SINGLE_CORRS = EnumSet.noneOf(PointSourceDistanceCorrections.class);
        for (PointSourceDistanceCorrections corr : PointSourceDistanceCorrections.values()) {
            if (corr.corrs != null && corr.corrs.size() != 1) continue;
            SINGLE_CORRS.add(corr);
        }
    }
}

